DROP ROLE CONNECT;

CREATE ROLE CONNECT NOT IDENTIFIED;

-- System privileges granted to CONNECT
GRANT CREATE SESSION TO CONNECT;

-- Grantees of CONNECT
GRANT "CONNECT" TO DBINSIGHT;
GRANT "CONNECT" TO ESIJRULEUSR;
GRANT "CONNECT" TO ESRJRULEUSR;
GRANT "CONNECT" TO EXFSYS;
GRANT "CONNECT" TO JRULE;
GRANT "CONNECT" TO KAAJEE;
GRANT "CONNECT" TO ODM;
GRANT "CONNECT" TO ODMUSR;
GRANT "CONNECT" TO PATS;
GRANT "CONNECT" TO PATSROLLUP;
GRANT "CONNECT" TO PATSRPTS;
GRANT "CONNECT" TO PATSUSER;
GRANT "CONNECT" TO SYS WITH ADMIN OPTION;
DROP ROLE RESOURCE;

CREATE ROLE RESOURCE NOT IDENTIFIED;

-- System privileges granted to RESOURCE
GRANT CREATE CLUSTER TO RESOURCE;
GRANT CREATE INDEXTYPE TO RESOURCE;
GRANT CREATE OPERATOR TO RESOURCE;
GRANT CREATE PROCEDURE TO RESOURCE;
GRANT CREATE SEQUENCE TO RESOURCE;
GRANT CREATE TABLE TO RESOURCE;
GRANT CREATE TRIGGER TO RESOURCE;
GRANT CREATE TYPE TO RESOURCE;

-- Grantees of RESOURCE
GRANT "RESOURCE" TO ACA;
GRANT "RESOURCE" TO BENS_ADMIN;
GRANT "RESOURCE" TO CIS_ADMIN;
GRANT "RESOURCE" TO EXFSYS;
GRANT "RESOURCE" TO KAAJEE;
GRANT "RESOURCE" TO LOGSTDBY_ADMINISTRATOR;
GRANT "RESOURCE" TO OUTLN;
GRANT "RESOURCE" TO PATS;
GRANT "RESOURCE" TO PATSROLLUP;
GRANT "RESOURCE" TO PATSRPTS;
GRANT "RESOURCE" TO PATSUSER;
GRANT "RESOURCE" TO PATS_ADMIN;
GRANT "RESOURCE" TO SYS WITH ADMIN OPTION;
GRANT "RESOURCE" TO VOA;
GRANT "RESOURCE" TO XDB;
DROP ROLE DBA;

CREATE ROLE DBA NOT IDENTIFIED;

-- Object privileges granted to DBA
GRANT SELECT ON ADRMGT.TOP10TBL TO DBA;
GRANT EXECUTE ON SYS.AS_REPLAY TO DBA;
GRANT SELECT, DEBUG ON SYS.AW$ TO DBA;
GRANT ALTER, SELECT ON SYS.AWSEQ$ TO DBA;
GRANT SELECT, DEBUG ON SYS.AW_OBJ$ TO DBA;
GRANT SELECT, DEBUG ON SYS.AW_PROP$ TO DBA;
GRANT SELECT, DEBUG ON SYS.AW_TRACK$ TO DBA;
GRANT EXECUTE ON SYS.DBMS_ADR TO DBA;
GRANT EXECUTE ON SYS.DBMS_AUTO_SQLTUNE TO DBA;
GRANT EXECUTE ON SYS.DBMS_AUTO_TASK_ADMIN TO DBA;
GRANT EXECUTE ON SYS.DBMS_AUTO_TASK_IMMEDIATE TO DBA;
GRANT EXECUTE ON SYS.DBMS_CACHEUTIL TO DBA;
GRANT EXECUTE ON SYS.DBMS_DEFER_QUERY TO DBA;
GRANT EXECUTE ON SYS.DBMS_DEFER_SYS TO DBA;
GRANT EXECUTE ON SYS.DBMS_DNFS TO DBA;
GRANT EXECUTE ON SYS.DBMS_FEATURE_USAGE_REPORT TO DBA;
GRANT EXECUTE ON SYS.DBMS_FLASHBACK TO DBA;
GRANT EXECUTE ON SYS.DBMS_FLASHBACK_ARCHIVE TO DBA;
GRANT EXECUTE ON SYS.DBMS_HM TO DBA;
GRANT EXECUTE ON SYS.DBMS_IR TO DBA;
GRANT EXECUTE ON SYS.DBMS_LOGSTDBY TO DBA;
GRANT EXECUTE ON SYS.DBMS_MONITOR TO DBA;
GRANT EXECUTE ON SYS.DBMS_NETWORK_ACL_ADMIN TO DBA;
GRANT EXECUTE ON SYS.DBMS_RAT_MASK TO DBA;
GRANT EXECUTE ON SYS.DBMS_RESULT_CACHE TO DBA;
GRANT EXECUTE ON SYS.DBMS_RESUMABLE TO DBA;
GRANT EXECUTE ON SYS.DBMS_SERVER_ALERT TO DBA;
GRANT EXECUTE ON SYS.DBMS_SERVER_TRACE TO DBA;
GRANT EXECUTE ON SYS.DBMS_SERVICE TO DBA;
GRANT EXECUTE ON SYS.DBMS_STORAGE_MAP TO DBA;
GRANT EXECUTE ON SYS.DBMS_TDB TO DBA;
GRANT EXECUTE ON SYS.DBMS_UADV_ARR TO DBA;
GRANT EXECUTE ON SYS.DBMS_UNDO_ADV TO DBA;
GRANT EXECUTE ON SYS.DBMS_WLM TO DBA;
GRANT EXECUTE ON SYS.DBMS_WORKLOAD_CAPTURE TO DBA;
GRANT EXECUTE ON SYS.DBMS_WORKLOAD_REPLAY TO DBA;
GRANT EXECUTE ON SYS.DBMS_WORKLOAD_REPOSITORY TO DBA;
GRANT EXECUTE ON SYS.DBMS_XS_PRINCIPALS TO DBA;
GRANT EXECUTE ON SYS.DBMS_XS_PRINCIPALS_INT TO DBA;
GRANT EXECUTE ON SYS.HM_SQLTK_INTERNAL TO DBA;
GRANT EXECUTE ON SYS.LOAD_UNDO_STAT TO DBA;
GRANT ALTER, DELETE, INSERT, SELECT, UPDATE, ON COMMIT REFRESH, QUERY REWRITE, DEBUG, FLASHBACK ON SYS.MAP_OBJECT TO DBA;
GRANT SELECT, DEBUG ON SYS.OLAP_TAB$ TO DBA;
GRANT SELECT, DEBUG ON SYS.OLAP_TAB_COL$ TO DBA;
GRANT SELECT, DEBUG ON SYS.OLAP_TAB_HIER$ TO DBA;
GRANT EXECUTE ON SYS.OUTLN_EDIT_PKG TO DBA;
GRANT EXECUTE ON SYS.OUTLN_PKG TO DBA;
GRANT SELECT, DEBUG ON SYS.PS$ TO DBA;
GRANT EXECUTE ON SYS.RESET_UNDO_STAT TO DBA;
GRANT SELECT ON SYS.V$XS_SESSION TO DBA;
GRANT SELECT ON SYS.V$XS_SESSION_ATTRIBUTE TO DBA;
GRANT SELECT ON SYS.V$XS_SESSION_ROLE TO DBA;
GRANT SELECT ON SYS.V_$DIAG_ADR_CONTROL TO DBA;
GRANT SELECT ON SYS.V_$DIAG_ADR_INVALIDATION TO DBA;
GRANT SELECT ON SYS.V_$DIAG_ALERT_EXT TO DBA;
GRANT SELECT ON SYS.V_$DIAG_AMS_XACTION TO DBA;
GRANT SELECT ON SYS.V_$DIAG_DDE_USER_ACTION TO DBA;
GRANT SELECT ON SYS.V_$DIAG_DDE_USER_ACTION_DEF TO DBA;
GRANT SELECT ON SYS.V_$DIAG_DDE_USR_ACT_PARAM TO DBA;
GRANT SELECT ON SYS.V_$DIAG_DDE_USR_ACT_PARAM_DEF TO DBA;
GRANT SELECT ON SYS.V_$DIAG_DDE_USR_INC_ACT_MAP TO DBA;
GRANT SELECT ON SYS.V_$DIAG_DDE_USR_INC_TYPE TO DBA;
GRANT SELECT ON SYS.V_$DIAG_DFW_CONFIG_CAPTURE TO DBA;
GRANT SELECT ON SYS.V_$DIAG_DFW_CONFIG_ITEM TO DBA;
GRANT SELECT ON SYS.V_$DIAG_DIAGV_INCIDENT TO DBA;
GRANT SELECT ON SYS.V_$DIAG_DIR_EXT TO DBA;
GRANT SELECT ON SYS.V_$DIAG_EM_DIAG_JOB TO DBA;
GRANT SELECT ON SYS.V_$DIAG_EM_TARGET_INFO TO DBA;
GRANT SELECT ON SYS.V_$DIAG_EM_USER_ACTIVITY TO DBA;
GRANT SELECT ON SYS.V_$DIAG_HM_FDG_SET TO DBA;
GRANT SELECT ON SYS.V_$DIAG_HM_FINDING TO DBA;
GRANT SELECT ON SYS.V_$DIAG_HM_INFO TO DBA;
GRANT SELECT ON SYS.V_$DIAG_HM_MESSAGE TO DBA;
GRANT SELECT ON SYS.V_$DIAG_HM_RECOMMENDATION TO DBA;
GRANT SELECT ON SYS.V_$DIAG_HM_RUN TO DBA;
GRANT SELECT ON SYS.V_$DIAG_INCCKEY TO DBA;
GRANT SELECT ON SYS.V_$DIAG_INCIDENT TO DBA;
GRANT SELECT ON SYS.V_$DIAG_INCIDENT_FILE TO DBA;
GRANT SELECT ON SYS.V_$DIAG_INC_METER_CONFIG TO DBA;
GRANT SELECT ON SYS.V_$DIAG_INC_METER_IMPT_DEF TO DBA;
GRANT SELECT ON SYS.V_$DIAG_INC_METER_INFO TO DBA;
GRANT SELECT ON SYS.V_$DIAG_INC_METER_PK_IMPTS TO DBA;
GRANT SELECT ON SYS.V_$DIAG_INC_METER_SUMMARY TO DBA;
GRANT SELECT ON SYS.V_$DIAG_IPS_CONFIGURATION TO DBA;
GRANT SELECT ON SYS.V_$DIAG_IPS_FILE_COPY_LOG TO DBA;
GRANT SELECT ON SYS.V_$DIAG_IPS_FILE_METADATA TO DBA;
GRANT SELECT ON SYS.V_$DIAG_IPS_PACKAGE TO DBA;
GRANT SELECT ON SYS.V_$DIAG_IPS_PACKAGE_FILE TO DBA;
GRANT SELECT ON SYS.V_$DIAG_IPS_PACKAGE_HISTORY TO DBA;
GRANT SELECT ON SYS.V_$DIAG_IPS_PACKAGE_INCIDENT TO DBA;
GRANT SELECT ON SYS.V_$DIAG_IPS_PKG_UNPACK_HIST TO DBA;
GRANT SELECT ON SYS.V_$DIAG_IPS_PROGRESS_LOG TO DBA;
GRANT SELECT ON SYS.V_$DIAG_IPS_REMOTE_PACKAGE TO DBA;
GRANT SELECT ON SYS.V_$DIAG_PICKLEERR TO DBA;
GRANT SELECT ON SYS.V_$DIAG_PROBLEM TO DBA;
GRANT SELECT ON SYS.V_$DIAG_RELMD_EXT TO DBA;
GRANT SELECT ON SYS.V_$DIAG_SWEEPERR TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VEM_USER_ACTLOG TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VEM_USER_ACTLOG1 TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VHM_RUN TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VIEW TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VIEWCOL TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VINCIDENT TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VINCIDENT_FILE TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VINC_METER_INFO TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VIPS_FILE_COPY_LOG TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VIPS_FILE_METADATA TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VIPS_PACKAGE_FILE TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VIPS_PACKAGE_HISTORY TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VIPS_PACKAGE_MAIN_INT TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VIPS_PACKAGE_SIZE TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VIPS_PKG_FILE TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VIPS_PKG_INC_CAND TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VIPS_PKG_INC_DTL TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VIPS_PKG_INC_DTL1 TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VIPS_PKG_MAIN_PROBLEM TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VNOT_EXIST_INCIDENT TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VPROBLEM TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VPROBLEM1 TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VPROBLEM2 TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VPROBLEM_BUCKET TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VPROBLEM_BUCKET1 TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VPROBLEM_BUCKET_COUNT TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VPROBLEM_INT TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VPROBLEM_LASTINC TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VSHOWCATVIEW TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VSHOWINCB TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VSHOWINCB_I TO DBA;
GRANT SELECT ON SYS.V_$DIAG_VTEST_EXISTS TO DBA;
GRANT SELECT ON SYS.V_$DIAG_V_ACTINC TO DBA;
GRANT SELECT ON SYS.V_$DIAG_V_ACTPROB TO DBA;
GRANT SELECT ON SYS.V_$DIAG_V_INCCOUNT TO DBA;
GRANT SELECT ON SYS.V_$DIAG_V_INCFCOUNT TO DBA;
GRANT SELECT ON SYS.V_$DIAG_V_INC_METER_INFO_PROB TO DBA;
GRANT SELECT ON SYS.V_$DIAG_V_IPSPRBCNT TO DBA;
GRANT SELECT ON SYS.V_$DIAG_V_IPSPRBCNT1 TO DBA;
GRANT SELECT ON SYS.V_$DIAG_V_NFCINC TO DBA;
GRANT SELECT ON SYS.V_$DIAG_V_SWPERRCOUNT TO DBA;
GRANT EXECUTE ON XDB.DBMS_CSX_ADMIN TO DBA;
GRANT EXECUTE ON XDB.DBMS_XDB_ADMIN TO DBA;
GRANT ALTER, DELETE, INSERT, SELECT, UPDATE, ON COMMIT REFRESH, QUERY REWRITE, DEBUG, FLASHBACK ON XDB.X$PT6AT2A976LF979E0H003DT7INJ0 TO DBA;
GRANT ALTER, DELETE, INSERT, SELECT, UPDATE, ON COMMIT REFRESH, QUERY REWRITE, DEBUG, FLASHBACK ON XDB.XDB$ACL TO DBA;
GRANT ALTER, DELETE, INSERT, SELECT, UPDATE, ON COMMIT REFRESH, QUERY REWRITE, DEBUG, FLASHBACK ON XDB.XDB$CONFIG TO DBA;
GRANT ALTER, DELETE, INSERT, SELECT, UPDATE, ON COMMIT REFRESH, QUERY REWRITE, DEBUG, FLASHBACK ON XDB.XDB$D_LINK TO DBA;
GRANT ALTER, DELETE, INSERT, SELECT, UPDATE, ON COMMIT REFRESH, QUERY REWRITE, DEBUG, FLASHBACK ON XDB.XDB$H_INDEX TO DBA;
GRANT ALTER, DELETE, INSERT, SELECT, UPDATE, ON COMMIT REFRESH, QUERY REWRITE, DEBUG, FLASHBACK ON XDB.XDB$H_LINK TO DBA;
GRANT ALTER, DELETE, INSERT, SELECT, UPDATE, ON COMMIT REFRESH, QUERY REWRITE, DEBUG, FLASHBACK ON XDB.XDB$NLOCKS TO DBA;
GRANT ALTER, DELETE, INSERT, SELECT, UPDATE, ON COMMIT REFRESH, QUERY REWRITE, DEBUG, FLASHBACK ON XDB.XDB$RESCONFIG TO DBA;
GRANT ALTER, DELETE, INSERT, SELECT, UPDATE, ON COMMIT REFRESH, QUERY REWRITE, DEBUG, FLASHBACK ON XDB.XDB$RESOURCE TO DBA;
GRANT ALTER, DELETE, INSERT, SELECT, UPDATE, ON COMMIT REFRESH, QUERY REWRITE, DEBUG, FLASHBACK ON XDB.XS$DATA_SECURITY TO DBA;
GRANT ALTER, DELETE, INSERT, SELECT, UPDATE, ON COMMIT REFRESH, QUERY REWRITE, DEBUG, FLASHBACK ON XDB.XS$PRINCIPALS TO DBA;
GRANT ALTER, DELETE, INSERT, SELECT, UPDATE, ON COMMIT REFRESH, QUERY REWRITE, DEBUG, FLASHBACK ON XDB.XS$ROLESETS TO DBA;
GRANT ALTER, DELETE, INSERT, SELECT, UPDATE, ON COMMIT REFRESH, QUERY REWRITE, DEBUG, FLASHBACK ON XDB.XS$SECURITYCLASS TO DBA;

-- System privileges granted to DBA
GRANT ADMINISTER ANY SQL TUNING SET TO DBA WITH ADMIN OPTION;
GRANT ADMINISTER DATABASE TRIGGER TO DBA WITH ADMIN OPTION;
BEGIN
SYS.DBMS_RESOURCE_MANAGER_PRIVS.GRANT_SYSTEM_PRIVILEGE
  (GRANTEE_NAME   => 'DBA', 
   PRIVILEGE_NAME => 'ADMINISTER_RESOURCE_MANAGER',
   ADMIN_OPTION   => TRUE);
END;
/
GRANT ADMINISTER SQL MANAGEMENT OBJECT TO DBA WITH ADMIN OPTION;
GRANT ADMINISTER SQL TUNING SET TO DBA WITH ADMIN OPTION;
GRANT ADVISOR TO DBA WITH ADMIN OPTION;
GRANT ALTER ANY ASSEMBLY TO DBA WITH ADMIN OPTION;
GRANT ALTER ANY CLUSTER TO DBA WITH ADMIN OPTION;
GRANT ALTER ANY CUBE TO DBA WITH ADMIN OPTION;
GRANT ALTER ANY CUBE DIMENSION TO DBA WITH ADMIN OPTION;
GRANT ALTER ANY DIMENSION TO DBA WITH ADMIN OPTION;
GRANT ALTER ANY EDITION TO DBA WITH ADMIN OPTION;
BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.ALTER_ANY_EVALUATION_CONTEXT,
  GRANTEE      => 'DBA',
  GRANT_OPTION => TRUE);
END;
/
GRANT ALTER ANY INDEX TO DBA WITH ADMIN OPTION;
GRANT ALTER ANY INDEXTYPE TO DBA WITH ADMIN OPTION;
GRANT ALTER ANY LIBRARY TO DBA WITH ADMIN OPTION;
GRANT ALTER ANY MATERIALIZED VIEW TO DBA WITH ADMIN OPTION;
GRANT ALTER ANY MINING MODEL TO DBA WITH ADMIN OPTION;
GRANT ALTER ANY OPERATOR TO DBA WITH ADMIN OPTION;
GRANT ALTER ANY OUTLINE TO DBA WITH ADMIN OPTION;
GRANT ALTER ANY PROCEDURE TO DBA WITH ADMIN OPTION;
GRANT ALTER ANY ROLE TO DBA WITH ADMIN OPTION;
BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.ALTER_ANY_RULE,
  GRANTEE      => 'DBA',
  GRANT_OPTION => TRUE);
END;
/
BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.ALTER_ANY_RULE_SET,
  GRANTEE      => 'DBA',
  GRANT_OPTION => TRUE);
END;
/
GRANT ALTER ANY SEQUENCE TO DBA WITH ADMIN OPTION;
GRANT ALTER ANY SQL PROFILE TO DBA WITH ADMIN OPTION;
GRANT ALTER ANY TABLE TO DBA WITH ADMIN OPTION;
GRANT ALTER ANY TRIGGER TO DBA WITH ADMIN OPTION;
GRANT ALTER ANY TYPE TO DBA WITH ADMIN OPTION;
GRANT ALTER DATABASE TO DBA WITH ADMIN OPTION;
GRANT ALTER PROFILE TO DBA WITH ADMIN OPTION;
GRANT ALTER RESOURCE COST TO DBA WITH ADMIN OPTION;
GRANT ALTER ROLLBACK SEGMENT TO DBA WITH ADMIN OPTION;
GRANT ALTER SESSION TO DBA WITH ADMIN OPTION;
GRANT ALTER SYSTEM TO DBA WITH ADMIN OPTION;
GRANT ALTER TABLESPACE TO DBA WITH ADMIN OPTION;
GRANT ALTER USER TO DBA WITH ADMIN OPTION;
GRANT ANALYZE ANY TO DBA WITH ADMIN OPTION;
GRANT ANALYZE ANY DICTIONARY TO DBA WITH ADMIN OPTION;
GRANT AUDIT ANY TO DBA WITH ADMIN OPTION;
GRANT AUDIT SYSTEM TO DBA WITH ADMIN OPTION;
GRANT BACKUP ANY TABLE TO DBA WITH ADMIN OPTION;
GRANT BECOME USER TO DBA WITH ADMIN OPTION;
GRANT CHANGE NOTIFICATION TO DBA WITH ADMIN OPTION;
GRANT COMMENT ANY MINING MODEL TO DBA WITH ADMIN OPTION;
GRANT COMMENT ANY TABLE TO DBA WITH ADMIN OPTION;
GRANT CREATE ANY ASSEMBLY TO DBA WITH ADMIN OPTION;
GRANT CREATE ANY CLUSTER TO DBA WITH ADMIN OPTION;
GRANT CREATE ANY CONTEXT TO DBA WITH ADMIN OPTION;
GRANT CREATE ANY CUBE TO DBA WITH ADMIN OPTION;
GRANT CREATE ANY CUBE BUILD PROCESS TO DBA WITH ADMIN OPTION;
GRANT CREATE ANY CUBE DIMENSION TO DBA WITH ADMIN OPTION;
GRANT CREATE ANY DIMENSION TO DBA WITH ADMIN OPTION;
GRANT CREATE ANY DIRECTORY TO DBA WITH ADMIN OPTION;
GRANT CREATE ANY EDITION TO DBA WITH ADMIN OPTION;
BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.CREATE_ANY_EVALUATION_CONTEXT,
  GRANTEE      => 'DBA',
  GRANT_OPTION => TRUE);
END;
/
GRANT CREATE ANY INDEX TO DBA WITH ADMIN OPTION;
GRANT CREATE ANY INDEXTYPE TO DBA WITH ADMIN OPTION;
GRANT CREATE ANY JOB TO DBA WITH ADMIN OPTION;
GRANT CREATE ANY LIBRARY TO DBA WITH ADMIN OPTION;
GRANT CREATE ANY MATERIALIZED VIEW TO DBA WITH ADMIN OPTION;
GRANT CREATE ANY MEASURE FOLDER TO DBA WITH ADMIN OPTION;
GRANT CREATE ANY MINING MODEL TO DBA WITH ADMIN OPTION;
GRANT CREATE ANY OPERATOR TO DBA WITH ADMIN OPTION;
GRANT CREATE ANY OUTLINE TO DBA WITH ADMIN OPTION;
GRANT CREATE ANY PROCEDURE TO DBA WITH ADMIN OPTION;
BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.CREATE_ANY_RULE,
  GRANTEE      => 'DBA',
  GRANT_OPTION => TRUE);
END;
/
BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.CREATE_ANY_RULE_SET,
  GRANTEE      => 'DBA',
  GRANT_OPTION => TRUE);
END;
/
GRANT CREATE ANY SEQUENCE TO DBA WITH ADMIN OPTION;
GRANT CREATE ANY SQL PROFILE TO DBA WITH ADMIN OPTION;
GRANT CREATE ANY SYNONYM TO DBA WITH ADMIN OPTION;
GRANT CREATE ANY TABLE TO DBA WITH ADMIN OPTION;
GRANT CREATE ANY TRIGGER TO DBA WITH ADMIN OPTION;
GRANT CREATE ANY TYPE TO DBA WITH ADMIN OPTION;
GRANT CREATE ANY VIEW TO DBA WITH ADMIN OPTION;
GRANT CREATE ASSEMBLY TO DBA WITH ADMIN OPTION;
GRANT CREATE CLUSTER TO DBA WITH ADMIN OPTION;
GRANT CREATE CUBE TO DBA WITH ADMIN OPTION;
GRANT CREATE CUBE BUILD PROCESS TO DBA WITH ADMIN OPTION;
GRANT CREATE CUBE DIMENSION TO DBA WITH ADMIN OPTION;
GRANT CREATE DATABASE LINK TO DBA WITH ADMIN OPTION;
GRANT CREATE DIMENSION TO DBA WITH ADMIN OPTION;
BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.CREATE_EVALUATION_CONTEXT_OBJ,
  GRANTEE      => 'DBA',
  GRANT_OPTION => TRUE);
END;
/
GRANT CREATE EXTERNAL JOB TO DBA WITH ADMIN OPTION;
GRANT CREATE INDEXTYPE TO DBA WITH ADMIN OPTION;
GRANT CREATE JOB TO DBA WITH ADMIN OPTION;
GRANT CREATE LIBRARY TO DBA WITH ADMIN OPTION;
GRANT CREATE MATERIALIZED VIEW TO DBA WITH ADMIN OPTION;
GRANT CREATE MEASURE FOLDER TO DBA WITH ADMIN OPTION;
GRANT CREATE MINING MODEL TO DBA WITH ADMIN OPTION;
GRANT CREATE OPERATOR TO DBA WITH ADMIN OPTION;
GRANT CREATE PROCEDURE TO DBA WITH ADMIN OPTION;
GRANT CREATE PROFILE TO DBA WITH ADMIN OPTION;
GRANT CREATE PUBLIC DATABASE LINK TO DBA WITH ADMIN OPTION;
GRANT CREATE PUBLIC SYNONYM TO DBA WITH ADMIN OPTION;
GRANT CREATE ROLE TO DBA WITH ADMIN OPTION;
GRANT CREATE ROLLBACK SEGMENT TO DBA WITH ADMIN OPTION;
BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.CREATE_RULE_OBJ,
  GRANTEE      => 'DBA',
  GRANT_OPTION => TRUE);
END;
/
BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.CREATE_RULE_SET_OBJ,
  GRANTEE      => 'DBA',
  GRANT_OPTION => TRUE);
END;
/
GRANT CREATE SEQUENCE TO DBA WITH ADMIN OPTION;
GRANT CREATE SESSION TO DBA WITH ADMIN OPTION;
GRANT CREATE SYNONYM TO DBA WITH ADMIN OPTION;
GRANT CREATE TABLE TO DBA WITH ADMIN OPTION;
GRANT CREATE TABLESPACE TO DBA WITH ADMIN OPTION;
GRANT CREATE TRIGGER TO DBA WITH ADMIN OPTION;
GRANT CREATE TYPE TO DBA WITH ADMIN OPTION;
GRANT CREATE USER TO DBA WITH ADMIN OPTION;
GRANT CREATE VIEW TO DBA WITH ADMIN OPTION;
GRANT DEBUG ANY PROCEDURE TO DBA WITH ADMIN OPTION;
GRANT DEBUG CONNECT SESSION TO DBA WITH ADMIN OPTION;
GRANT DELETE ANY CUBE DIMENSION TO DBA WITH ADMIN OPTION;
GRANT DELETE ANY MEASURE FOLDER TO DBA WITH ADMIN OPTION;
GRANT DELETE ANY TABLE TO DBA WITH ADMIN OPTION;
BEGIN
SYS.DBMS_AQADM.GRANT_SYSTEM_PRIVILEGE (
  PRIVILEGE    => 'DEQUEUE_ANY',
  GRANTEE      => 'DBA',
  ADMIN_OPTION => TRUE);
END;
/
GRANT DROP ANY ASSEMBLY TO DBA WITH ADMIN OPTION;
GRANT DROP ANY CLUSTER TO DBA WITH ADMIN OPTION;
GRANT DROP ANY CONTEXT TO DBA WITH ADMIN OPTION;
GRANT DROP ANY CUBE TO DBA WITH ADMIN OPTION;
GRANT DROP ANY CUBE BUILD PROCESS TO DBA WITH ADMIN OPTION;
GRANT DROP ANY CUBE DIMENSION TO DBA WITH ADMIN OPTION;
GRANT DROP ANY DIMENSION TO DBA WITH ADMIN OPTION;
GRANT DROP ANY DIRECTORY TO DBA WITH ADMIN OPTION;
GRANT DROP ANY EDITION TO DBA WITH ADMIN OPTION;
BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.DROP_ANY_EVALUATION_CONTEXT,
  GRANTEE      => 'DBA',
  GRANT_OPTION => TRUE);
END;
/
GRANT DROP ANY INDEX TO DBA WITH ADMIN OPTION;
GRANT DROP ANY INDEXTYPE TO DBA WITH ADMIN OPTION;
GRANT DROP ANY LIBRARY TO DBA WITH ADMIN OPTION;
GRANT DROP ANY MATERIALIZED VIEW TO DBA WITH ADMIN OPTION;
GRANT DROP ANY MEASURE FOLDER TO DBA WITH ADMIN OPTION;
GRANT DROP ANY MINING MODEL TO DBA WITH ADMIN OPTION;
GRANT DROP ANY OPERATOR TO DBA WITH ADMIN OPTION;
GRANT DROP ANY OUTLINE TO DBA WITH ADMIN OPTION;
GRANT DROP ANY PROCEDURE TO DBA WITH ADMIN OPTION;
GRANT DROP ANY ROLE TO DBA WITH ADMIN OPTION;
BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.DROP_ANY_RULE,
  GRANTEE      => 'DBA',
  GRANT_OPTION => TRUE);
END;
/
BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.DROP_ANY_RULE_SET,
  GRANTEE      => 'DBA',
  GRANT_OPTION => TRUE);
END;
/
GRANT DROP ANY SEQUENCE TO DBA WITH ADMIN OPTION;
GRANT DROP ANY SQL PROFILE TO DBA WITH ADMIN OPTION;
GRANT DROP ANY SYNONYM TO DBA WITH ADMIN OPTION;
GRANT DROP ANY TABLE TO DBA WITH ADMIN OPTION;
GRANT DROP ANY TRIGGER TO DBA WITH ADMIN OPTION;
GRANT DROP ANY TYPE TO DBA WITH ADMIN OPTION;
GRANT DROP ANY VIEW TO DBA WITH ADMIN OPTION;
GRANT DROP PROFILE TO DBA WITH ADMIN OPTION;
GRANT DROP PUBLIC DATABASE LINK TO DBA WITH ADMIN OPTION;
GRANT DROP PUBLIC SYNONYM TO DBA WITH ADMIN OPTION;
GRANT DROP ROLLBACK SEGMENT TO DBA WITH ADMIN OPTION;
GRANT DROP TABLESPACE TO DBA WITH ADMIN OPTION;
GRANT DROP USER TO DBA WITH ADMIN OPTION;
BEGIN
SYS.DBMS_AQADM.GRANT_SYSTEM_PRIVILEGE (
  PRIVILEGE    => 'ENQUEUE_ANY',
  GRANTEE      => 'DBA',
  ADMIN_OPTION => TRUE);
END;
/
GRANT EXECUTE ANY ASSEMBLY TO DBA WITH ADMIN OPTION;
GRANT EXECUTE ANY CLASS TO DBA WITH ADMIN OPTION;
BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.EXECUTE_ANY_EVALUATION_CONTEXT,
  GRANTEE      => 'DBA',
  GRANT_OPTION => TRUE);
END;
/
GRANT EXECUTE ANY INDEXTYPE TO DBA WITH ADMIN OPTION;
GRANT EXECUTE ANY LIBRARY TO DBA WITH ADMIN OPTION;
GRANT EXECUTE ANY OPERATOR TO DBA WITH ADMIN OPTION;
GRANT EXECUTE ANY PROCEDURE TO DBA WITH ADMIN OPTION;
GRANT EXECUTE ANY PROGRAM TO DBA WITH ADMIN OPTION;
BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.EXECUTE_ANY_RULE,
  GRANTEE      => 'DBA',
  GRANT_OPTION => TRUE);
END;
/
BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.EXECUTE_ANY_RULE_SET,
  GRANTEE      => 'DBA',
  GRANT_OPTION => TRUE);
END;
/
GRANT EXECUTE ANY TYPE TO DBA WITH ADMIN OPTION;
GRANT EXECUTE ASSEMBLY TO DBA WITH ADMIN OPTION;
GRANT EXPORT FULL DATABASE TO DBA WITH ADMIN OPTION;
GRANT FLASHBACK ANY TABLE TO DBA WITH ADMIN OPTION;
GRANT FLASHBACK ARCHIVE ADMINISTER TO DBA WITH ADMIN OPTION;
GRANT FORCE ANY TRANSACTION TO DBA WITH ADMIN OPTION;
GRANT FORCE TRANSACTION TO DBA WITH ADMIN OPTION;
GRANT GLOBAL QUERY REWRITE TO DBA WITH ADMIN OPTION;
GRANT GRANT ANY OBJECT PRIVILEGE TO DBA WITH ADMIN OPTION;
GRANT GRANT ANY PRIVILEGE TO DBA WITH ADMIN OPTION;
GRANT GRANT ANY ROLE TO DBA WITH ADMIN OPTION;
GRANT IMPORT FULL DATABASE TO DBA WITH ADMIN OPTION;
GRANT INSERT ANY CUBE DIMENSION TO DBA WITH ADMIN OPTION;
GRANT INSERT ANY MEASURE FOLDER TO DBA WITH ADMIN OPTION;
GRANT INSERT ANY TABLE TO DBA WITH ADMIN OPTION;
GRANT LOCK ANY TABLE TO DBA WITH ADMIN OPTION;
GRANT MANAGE ANY FILE GROUP TO DBA WITH ADMIN OPTION;
BEGIN
SYS.DBMS_AQADM.GRANT_SYSTEM_PRIVILEGE (
  PRIVILEGE    => 'MANAGE_ANY',
  GRANTEE      => 'DBA',
  ADMIN_OPTION => TRUE);
END;
/
GRANT MANAGE FILE GROUP TO DBA WITH ADMIN OPTION;
GRANT MANAGE SCHEDULER TO DBA WITH ADMIN OPTION;
GRANT MANAGE TABLESPACE TO DBA WITH ADMIN OPTION;
GRANT MERGE ANY VIEW TO DBA WITH ADMIN OPTION;
GRANT ON COMMIT REFRESH TO DBA WITH ADMIN OPTION;
GRANT QUERY REWRITE TO DBA WITH ADMIN OPTION;
GRANT READ ANY FILE GROUP TO DBA WITH ADMIN OPTION;
GRANT RESTRICTED SESSION TO DBA WITH ADMIN OPTION;
GRANT RESUMABLE TO DBA WITH ADMIN OPTION;
GRANT SELECT ANY CUBE TO DBA WITH ADMIN OPTION;
GRANT SELECT ANY CUBE DIMENSION TO DBA WITH ADMIN OPTION;
GRANT SELECT ANY DICTIONARY TO DBA WITH ADMIN OPTION;
GRANT SELECT ANY MINING MODEL TO DBA WITH ADMIN OPTION;
GRANT SELECT ANY SEQUENCE TO DBA WITH ADMIN OPTION;
GRANT SELECT ANY TABLE TO DBA WITH ADMIN OPTION;
GRANT SELECT ANY TRANSACTION TO DBA WITH ADMIN OPTION;
GRANT UNDER ANY TABLE TO DBA WITH ADMIN OPTION;
GRANT UNDER ANY TYPE TO DBA WITH ADMIN OPTION;
GRANT UNDER ANY VIEW TO DBA WITH ADMIN OPTION;
GRANT UNLIMITED TABLESPACE TO DBA WITH ADMIN OPTION;
GRANT UPDATE ANY CUBE TO DBA WITH ADMIN OPTION;
GRANT UPDATE ANY CUBE BUILD PROCESS TO DBA WITH ADMIN OPTION;
GRANT UPDATE ANY CUBE DIMENSION TO DBA WITH ADMIN OPTION;
GRANT UPDATE ANY TABLE TO DBA WITH ADMIN OPTION;

-- Roles granted to DBA
GRANT SELECT_CATALOG_ROLE TO DBA WITH ADMIN OPTION;
GRANT GATHER_SYSTEM_STATISTICS TO DBA;
GRANT EXECUTE_CATALOG_ROLE TO DBA WITH ADMIN OPTION;
GRANT JAVA_ADMIN TO DBA;
GRANT PLUSTRACE TO DBA WITH ADMIN OPTION;
GRANT DATAPUMP_EXP_FULL_DATABASE TO DBA;
GRANT DELETE_CATALOG_ROLE TO DBA WITH ADMIN OPTION;
GRANT XDBADMIN TO DBA;
GRANT SCHEDULER_ADMIN TO DBA WITH ADMIN OPTION;
GRANT IMP_FULL_DATABASE TO DBA;
GRANT XDB_SET_INVOKER TO DBA;
GRANT EXP_FULL_DATABASE TO DBA;
GRANT JAVA_DEPLOY TO DBA;
GRANT DATAPUMP_IMP_FULL_DATABASE TO DBA;

-- Grantees of DBA
GRANT DBA TO AACDBA WITH ADMIN OPTION;
GRANT DBA TO SYS WITH ADMIN OPTION;
GRANT DBA TO SYSTEM WITH ADMIN OPTION;
DROP ROLE SELECT_CATALOG_ROLE;

CREATE ROLE SELECT_CATALOG_ROLE NOT IDENTIFIED;

-- Object privileges granted to SELECT_CATALOG_ROLE
GRANT SELECT ON OUTLN.OL$ TO SELECT_CATALOG_ROLE;
GRANT SELECT ON OUTLN.OL$HINTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON OUTLN.OL$NODES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_APPLY_CHANGE_HANDLERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_APPLY_INSTANTIATED_GLOBAL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_APPLY_INSTANTIATED_OBJECTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_APPLY_INSTANTIATED_SCHEMAS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_APPLY_SPILL_TXN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_AUDIT_POLICIES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_AUDIT_POLICY_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_CHANGE_PROPAGATIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_CHANGE_PROPAGATION_SETS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_CHANGE_SETS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_CHANGE_SOURCES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_CHANGE_TABLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_COMPARISON_SCAN_SUMMARY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_GG_INBOUND_PROGRESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_GOLDENGATE_INBOUND TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_GOLDENGATE_PRIVILEGES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_SERVICES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_STREAMS_KEEP_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_STREAMS_TRANSFORMATIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_SYNC_CAPTURE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_SYNC_CAPTURE_TABLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_XSC_AGGREGATE_PRIVILEGE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_XSC_PRIVILEGE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_XSC_SECURITY_CLASS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_XSC_SECURITY_CLASS_DEP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_XSC_SECURITY_CLASS_STATUS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_XSTREAM_ADMINISTRATOR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_XSTREAM_INBOUND TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_XSTREAM_INBOUND_PROGRESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_XSTREAM_OUTBOUND TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_XSTREAM_OUTBOUND_PROGRESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_XSTREAM_OUT_SUPPORT_MODE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ALL_XSTREAM_RULES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.AUDTAB$TBS$FOR_EXPORT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.AUDTAB$TBS$FOR_EXPORT_TBL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.CODE_PIECES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.CODE_SIZE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.CRCSTATS_$ TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_2PC_NEIGHBORS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_2PC_PENDING TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADDM_FDG_BREAKDOWN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADDM_FINDINGS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADDM_INSTANCES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADDM_SYSTEM_DIRECTIVES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADDM_TASKS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADDM_TASK_DIRECTIVES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_ACTIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_COMMANDS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_DEFINITIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_DEF_PARAMETERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_DIRECTIVES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_DIR_DEFINITIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_DIR_INSTANCES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_DIR_TASK_INST TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_EXECUTIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_EXECUTION_TYPES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_EXEC_PARAMETERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_FDG_BREAKDOWN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_FINDINGS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_FINDING_NAMES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_JOURNAL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_LOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_OBJECTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_PARAMETERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_PARAMETERS_PROJ TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_RATIONALE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_RECOMMENDATIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_SQLA_COLVOL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_SQLA_REC_SUM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_SQLA_TABLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_SQLA_TABVOL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_SQLA_WK_MAP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_SQLA_WK_STMTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_SQLA_WK_SUM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_SQLPLANS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_SQLSTATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_SQLW_COLVOL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_SQLW_JOURNAL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_SQLW_PARAMETERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_SQLW_STMTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_SQLW_SUM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_SQLW_TABLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_SQLW_TABVOL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_SQLW_TEMPLATES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_TASKS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_TEMPLATES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ADVISOR_USAGE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ALERT_ARGUMENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ALERT_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ALL_TABLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_APPLICATION_ROLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_APPLY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_APPLY_CHANGE_HANDLERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_APPLY_CONFLICT_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_APPLY_DML_CONF_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_APPLY_DML_CONF_HANDLERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_APPLY_DML_HANDLERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_APPLY_ENQUEUE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_APPLY_ERROR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_APPLY_ERROR_MESSAGES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_APPLY_EXECUTE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_APPLY_HANDLE_COLLISIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_APPLY_INSTANTIATED_GLOBAL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_APPLY_INSTANTIATED_OBJECTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_APPLY_INSTANTIATED_SCHEMAS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_APPLY_KEY_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_APPLY_PARAMETERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_APPLY_PROGRESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_APPLY_REPERROR_HANDLERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_APPLY_SPILL_TXN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_APPLY_TABLE_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_AQ_AGENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_AQ_AGENT_PRIVS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ARGUMENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ASSEMBLIES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ASSOCIATIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ATTRIBUTE_TRANSFORMATIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_AUDIT_EXISTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_AUDIT_OBJECT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_AUDIT_POLICIES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_AUDIT_POLICY_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_AUDIT_SESSION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_AUDIT_STATEMENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_AUDIT_TRAIL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_AUTOTASK_CLIENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_AUTOTASK_CLIENT_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_AUTOTASK_CLIENT_JOB TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_AUTOTASK_JOB_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_AUTOTASK_OPERATION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_AUTOTASK_SCHEDULE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_AUTOTASK_TASK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_AUTOTASK_WINDOW_CLIENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_AUTOTASK_WINDOW_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_AUTO_SEGADV_CTL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_AUTO_SEGADV_SUMMARY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_AWS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_AW_PS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_BASE_TABLE_MVIEWS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_BLOCKERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CAPTURE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CAPTURE_EXTRA_ATTRIBUTES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CAPTURE_PARAMETERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CAPTURE_PREPARED_DATABASE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CAPTURE_PREPARED_SCHEMAS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CAPTURE_PREPARED_TABLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CATALOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CHANGE_NOTIFICATION_REGS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CLUSTERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CLUSTER_HASH_EXPRESSIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CLU_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_COLL_TYPES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_COL_COMMENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_COL_PRIVS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_COMMON_AUDIT_TRAIL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_COMPARISON TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_COMPARISON_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_COMPARISON_ROW_DIF TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_COMPARISON_SCAN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_COMPARISON_SCAN_SUMMARY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_COMPARISON_SCAN_VALUES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CONNECT_ROLE_GRANTEES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CONSTRAINTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CONS_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CONS_OBJ_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CONTEXT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CPOOL_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CPU_USAGE_STATISTICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CQ_NOTIFICATION_QUERIES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CUBES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CUBE_ATTRIBUTES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CUBE_ATTR_VISIBILITY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CUBE_BUILD_PROCESSES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CUBE_CALCULATED_MEMBERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CUBE_DIMENSIONALITY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CUBE_DIMENSIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CUBE_DIM_LEVELS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CUBE_DIM_MODELS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CUBE_DIM_VIEWS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CUBE_DIM_VIEW_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CUBE_HIERARCHIES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CUBE_HIER_LEVELS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CUBE_HIER_VIEWS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CUBE_HIER_VIEW_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CUBE_MEASURES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CUBE_VIEWS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_CUBE_VIEW_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_DATAPUMP_JOBS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_DATAPUMP_SESSIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_DATA_FILES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_DBFS_HS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_DBFS_HS_COMMANDS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_DBFS_HS_PROPERTIES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_DB_LINKS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_DDL_LOCKS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_DEPENDENCIES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_DIMENSIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_DIM_ATTRIBUTES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_DIM_CHILD_OF TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_DIM_HIERARCHIES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_DIM_JOIN_KEY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_DIM_LEVELS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_DIM_LEVEL_KEY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_DIRECTORIES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_DML_LOCKS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_DMT_FREE_SPACE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_DMT_USED_EXTENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_EDITIONING_VIEWS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_EDITIONING_VIEWS_AE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_EDITIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_EDITION_COMMENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ENABLED_AGGREGATIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ENABLED_TRACES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ENCRYPTED_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_EPG_DAD_AUTHORIZATION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ERRORS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ERRORS_AE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_EVALUATION_CONTEXTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_EVALUATION_CONTEXT_TABLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_EVALUATION_CONTEXT_VARS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_EXPORT_OBJECTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_EXPORT_PATHS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_EXP_FILES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_EXP_OBJECTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_EXP_VERSION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_EXTENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_EXTERNAL_LOCATIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_EXTERNAL_TABLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_FEATURE_USAGE_STATISTICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_FGA_AUDIT_TRAIL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_FILE_GROUPS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_FILE_GROUP_EXPORT_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_FILE_GROUP_FILES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_FILE_GROUP_TABLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_FILE_GROUP_TABLESPACES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_FILE_GROUP_VERSIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_FREE_SPACE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_FREE_SPACE_COALESCED TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_FREE_SPACE_COALESCED_TMP1 TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_FREE_SPACE_COALESCED_TMP2 TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_FREE_SPACE_COALESCED_TMP3 TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_FREE_SPACE_COALESCED_TMP4 TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_FREE_SPACE_COALESCED_TMP5 TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_FREE_SPACE_COALESCED_TMP6 TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_GG_INBOUND_PROGRESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_GLOBAL_CONTEXT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_GOLDENGATE_INBOUND TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_GOLDENGATE_PRIVILEGES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_GOLDENGATE_SUPPORT_MODE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIGH_WATER_MARK_STATISTICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_ACTIVE_SESS_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_ASH_SNAPSHOT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_BASELINE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_BASELINE_DETAILS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_BASELINE_METADATA TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_BASELINE_TEMPLATE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_BG_EVENT_SUMMARY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_BUFFERED_QUEUES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_BUFFERED_SUBSCRIBERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_BUFFER_POOL_STAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_CLUSTER_INTERCON TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_COLORED_SQL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_COMP_IOSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_CR_BLOCK_SERVER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_CURRENT_BLOCK_SERVER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_DATABASE_INSTANCE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_DATAFILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_DB_CACHE_ADVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_DISPATCHER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_DLM_MISC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_DYN_REMASTER_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_ENQUEUE_STAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_EVENT_HISTOGRAM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_EVENT_NAME TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_FILEMETRIC_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_FILESTATXS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_IC_CLIENT_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_IC_DEVICE_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_INSTANCE_RECOVERY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_INST_CACHE_TRANSFER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_INTERCONNECT_PINGS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_IOSTAT_DETAIL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_IOSTAT_FILETYPE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_IOSTAT_FILETYPE_NAME TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_IOSTAT_FUNCTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_IOSTAT_FUNCTION_NAME TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_JAVA_POOL_ADVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_LATCH TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_LATCH_CHILDREN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_LATCH_MISSES_SUMMARY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_LATCH_NAME TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_LATCH_PARENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_LIBRARYCACHE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_LOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_MEMORY_RESIZE_OPS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_MEMORY_TARGET_ADVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_MEM_DYNAMIC_COMP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_METRIC_NAME TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_MTTR_TARGET_ADVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_MUTEX_SLEEP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_MVPARAMETER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_OPTIMIZER_ENV TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_OSSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_OSSTAT_NAME TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_PARAMETER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_PARAMETER_NAME TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_PERSISTENT_QMN_CACHE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_PERSISTENT_QUEUES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_PERSISTENT_SUBS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_PGASTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_PGA_TARGET_ADVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_PLAN_OPERATION_NAME TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_PLAN_OPTION_NAME TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_PROCESS_MEM_SUMMARY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_RESOURCE_LIMIT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_ROWCACHE_SUMMARY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_RSRC_CONSUMER_GROUP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_RSRC_PLAN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_RULE_SET TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_SEG_STAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_SEG_STAT_OBJ TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_SERVICE_NAME TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_SERVICE_STAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_SERVICE_WAIT_CLASS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_SESSMETRIC_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_SESS_TIME_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_SGA TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_SGASTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_SGA_TARGET_ADVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_SHARED_POOL_ADVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_SHARED_SERVER_SUMMARY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_SNAPSHOT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_SNAP_ERROR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_SQLBIND TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_SQLCOMMAND_NAME TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_SQLSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_SQLTEXT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_SQL_BIND_METADATA TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_SQL_PLAN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_SQL_SUMMARY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_SQL_WORKAREA_HSTGRM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_STAT_NAME TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_STREAMS_APPLY_SUM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_STREAMS_CAPTURE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_STREAMS_POOL_ADVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_SYSMETRIC_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_SYSMETRIC_SUMMARY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_SYSSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_SYSTEM_EVENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_SYS_TIME_MODEL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_TABLESPACE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_TABLESPACE_STAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_TBSPC_SPACE_USAGE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_TEMPFILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_TEMPSTATXS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_THREAD TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_TOPLEVELCALL_NAME TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_UNDOSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_WAITCLASSMET_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_WAITSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_HIST_WR_CONTROL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_IAS_CONSTRAINT_EXP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_IAS_GEN_STMTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_IAS_GEN_STMTS_EXP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_IAS_OBJECTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_IAS_OBJECTS_BASE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_IAS_OBJECTS_EXP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_IAS_POSTGEN_STMTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_IAS_PREGEN_STMTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_IAS_SITES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_IAS_TEMPLATES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_IDENTIFIERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_INDEXES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_INDEXTYPES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_INDEXTYPE_ARRAYTYPES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_INDEXTYPE_COMMENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_INDEXTYPE_OPERATORS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_IND_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_IND_EXPRESSIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_IND_PARTITIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_IND_STATISTICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_IND_SUBPARTITIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_INTERNAL_TRIGGERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_INVALID_OBJECTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_JAVA_ARGUMENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_JAVA_CLASSES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_JAVA_COMPILER_OPTIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_JAVA_DERIVATIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_JAVA_FIELDS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_JAVA_IMPLEMENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_JAVA_INNERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_JAVA_LAYOUTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_JAVA_METHODS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_JAVA_NCOMPS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_JAVA_POLICY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_JAVA_RESOLVERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_JAVA_THROWS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_JOBS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_JOBS_RUNNING TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_JOIN_IND_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_KGLLOCK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_LIBRARIES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_LMT_FREE_SPACE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_LMT_USED_EXTENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_LOBS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_LOB_PARTITIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_LOB_SUBPARTITIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_LOB_TEMPLATES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_LOCK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_LOCK_INTERNAL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_LOGMNR_LOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_LOGMNR_PURGED_LOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_LOGMNR_SESSION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_LOGSTDBY_EDS_SUPPORTED TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_LOGSTDBY_EDS_TABLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_LOGSTDBY_EVENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_LOGSTDBY_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_LOGSTDBY_LOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_LOGSTDBY_NOT_UNIQUE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_LOGSTDBY_PARAMETERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_LOGSTDBY_PROGRESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_LOGSTDBY_SKIP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_LOGSTDBY_SKIP_TRANSACTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_LOGSTDBY_UNSUPPORTED TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_LOGSTDBY_UNSUPPORTED_TABLE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_LOG_GROUPS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_LOG_GROUP_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_MEASURE_FOLDERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_MEASURE_FOLDER_CONTENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_METHOD_PARAMS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_METHOD_RESULTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_MINING_MODELS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_MINING_MODEL_ATTRIBUTES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_MINING_MODEL_SETTINGS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_MINING_MODEL_TABLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_MVIEWS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_MVIEW_AGGREGATES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_MVIEW_ANALYSIS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_MVIEW_COMMENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_MVIEW_DETAIL_PARTITION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_MVIEW_DETAIL_RELATIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_MVIEW_DETAIL_SUBPARTITION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_MVIEW_JOINS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_MVIEW_KEYS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_MVIEW_LOGS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_MVIEW_LOG_FILTER_COLS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_MVIEW_REFRESH_TIMES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_NESTED_TABLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_NESTED_TABLE_COLS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_NETWORK_ACLS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_NETWORK_ACL_PRIVILEGES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_OBJECTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_OBJECTS_AE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_OBJECT_SIZE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_OBJECT_TABLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_OBJ_AUDIT_OPTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_OBJ_COLATTRS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_OLDIMAGE_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_OPANCILLARY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_OPARGUMENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_OPBINDINGS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_OPERATORS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_OPERATOR_COMMENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_OPTSTAT_OPERATIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_OUTLINES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_OUTLINE_HINTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_OUTSTANDING_ALERTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_PARALLEL_EXECUTE_CHUNKS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_PARALLEL_EXECUTE_TASKS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_PARTIAL_DROP_TABS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_PART_COL_STATISTICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_PART_HISTOGRAMS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_PART_INDEXES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_PART_KEY_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_PART_LOBS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_PART_TABLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_PENDING_CONV_TABLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_PENDING_TRANSACTIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_PLSQL_OBJECT_SETTINGS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_POLICIES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_POLICY_CONTEXTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_POLICY_GROUPS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_PRIV_AUDIT_OPTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_PROCEDURES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_PROFILES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_PROPAGATION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_PROXIES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_PUBLISHED_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_QUEUES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_QUEUE_PUBLISHERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_QUEUE_SCHEDULES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_QUEUE_SUBSCRIBERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_QUEUE_TABLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_RCHILD TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_RECOVERABLE_SCRIPT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_RECOVERABLE_SCRIPT_BLOCKS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_RECOVERABLE_SCRIPT_ERRORS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_RECOVERABLE_SCRIPT_HIST TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_RECOVERABLE_SCRIPT_PARAMS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_RECYCLEBIN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REDEFINITION_ERRORS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REDEFINITION_OBJECTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REFRESH TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REFRESH_CHILDREN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REFS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REGISTERED_ARCHIVED_LOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REGISTERED_MVIEWS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REGISTERED_MVIEW_GROUPS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REGISTERED_SNAPSHOTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REGISTERED_SNAPSHOT_GROUPS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REGISTRY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REGISTRY_DATABASE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REGISTRY_DEPENDENCIES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REGISTRY_HIERARCHY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REGISTRY_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REGISTRY_LOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REGISTRY_PROGRESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPAUDIT_ATTRIBUTE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPAUDIT_COLUMN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPCAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPCATLOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPCAT_EXCEPTIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPCAT_REFRESH_TEMPLATES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPCAT_TEMPLATE_OBJECTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPCAT_TEMPLATE_PARMS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPCAT_TEMPLATE_SITES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPCAT_USER_AUTHORIZATIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPCAT_USER_PARM_VALUES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPCOLUMN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPCOLUMN_GROUP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPCONFLICT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPDDL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPEXTENSIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPFLAVORS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPFLAVOR_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPFLAVOR_OBJECTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPGENERATED TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPGENOBJECTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPGROUP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPGROUPED_COLUMN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPGROUP_PRIVILEGES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPKEY_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPOBJECT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPPARAMETER_COLUMN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPPRIORITY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPPRIORITY_GROUP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPPROP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPRESOLUTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPRESOLUTION_METHOD TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPRESOLUTION_STATISTICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPRESOL_STATS_CONTROL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPSCHEMA TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPSITES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REPSITES_NEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_RESOURCE_INCARNATIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_RESUMABLE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_REWRITE_EQUIVALENCES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_RGROUP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ROLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ROLE_PRIVS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_ROLLBACK_SEGS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_RSRC_CAPABILITY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_RSRC_CATEGORIES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_RSRC_CONSUMER_GROUPS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_RSRC_CONSUMER_GROUP_PRIVS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_RSRC_GROUP_MAPPINGS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_RSRC_INSTANCE_CAPABILITY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_RSRC_IO_CALIBRATE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_RSRC_MANAGER_SYSTEM_PRIVS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_RSRC_MAPPING_PRIORITY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_RSRC_PLANS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_RSRC_PLAN_DIRECTIVES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_RSRC_STORAGE_POOL_MAPPING TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_RULES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_RULESETS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_RULE_SETS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_RULE_SET_RULES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_CHAINS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_CHAIN_RULES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_CHAIN_STEPS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_CREDENTIALS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_DB_DESTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_DESTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_EXTERNAL_DESTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_FILE_WATCHERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_GLOBAL_ATTRIBUTE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_GROUPS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_GROUP_MEMBERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_JOBS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_JOB_ARGS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_JOB_CLASSES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_JOB_DESTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_JOB_LOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_JOB_ROLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_JOB_RUN_DETAILS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_NOTIFICATIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_PROGRAMS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_PROGRAM_ARGS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_REMOTE_JOBSTATE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_RUNNING_CHAINS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_RUNNING_JOBS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_SCHEDULES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_WINDOWS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_WINDOW_DETAILS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_WINDOW_GROUPS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_WINDOW_LOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SCHEDULER_WINGROUP_MEMBERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SECONDARY_OBJECTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SEC_RELEVANT_COLS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SEGMENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SEGMENTS_OLD TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SEQUENCES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SERVER_REGISTRY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SERVICES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SNAPSHOTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SNAPSHOT_LOGS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SOURCE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SOURCE_AE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SOURCE_TABLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SQLJ_TYPES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SQLJ_TYPE_ATTRS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SQLJ_TYPE_METHODS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SQLSET TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SQLSET_BINDS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SQLSET_PLANS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SQLSET_REFERENCES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SQLSET_STATEMENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SQLTUNE_BINDS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SQLTUNE_PLANS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SQLTUNE_RATIONALE_PLAN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SQLTUNE_STATISTICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SQL_MANAGEMENT_CONFIG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SQL_MONITOR_USAGE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SQL_PATCHES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SQL_PLAN_BASELINES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SQL_PROFILES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SSCR_CAPTURE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SSCR_RESTORE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STAT_EXTENSIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STMT_AUDIT_OPTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STORED_SETTINGS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_ADD_COLUMN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_ADMINISTRATOR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_DELETE_COLUMN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_GLOBAL_RULES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_KEEP_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_MESSAGE_CONSUMERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_MESSAGE_RULES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_NEWLY_SUPPORTED TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_RENAME_COLUMN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_RENAME_SCHEMA TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_RENAME_TABLE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_RULES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_SCHEMA_RULES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_SPLIT_MERGE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_SPLIT_MERGE_HIST TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_STMTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_STMT_HANDLERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_TABLE_RULES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_TP_COMPONENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_TP_COMPONENT_LINK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_TP_COMPONENT_STAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_TP_DATABASE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_TP_PATH_BOTTLENECK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_TP_PATH_STAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_TRANSFORMATIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_TRANSFORM_FUNCTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_STREAMS_UNSUPPORTED TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SUBPARTITION_TEMPLATES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SUBPART_COL_STATISTICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SUBPART_HISTOGRAMS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SUBPART_KEY_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SUBSCRIBED_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SUBSCRIBED_TABLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SUBSCRIPTIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SUBSCR_REGISTRATIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SUMMARIES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SUMMARY_AGGREGATES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SUMMARY_DETAIL_TABLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SUMMARY_JOINS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SUMMARY_KEYS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SYNC_CAPTURE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SYNC_CAPTURE_PREPARED_TABS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SYNONYMS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_SYS_PRIVS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TABLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TABLESPACES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TABLESPACE_GROUPS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TABLESPACE_THRESHOLDS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TABLESPACE_USAGE_METRICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TAB_COLS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TAB_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TAB_COL_STATISTICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TAB_COMMENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TAB_HISTOGRAMS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TAB_MODIFICATIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TAB_PARTITIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TAB_PRIVS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TAB_STATISTICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TAB_STATS_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TAB_SUBPARTITIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TEMPLATE_REFGROUPS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TEMPLATE_TARGETS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TEMP_FILES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TEMP_FREE_SPACE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_THRESHOLDS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TRANSFORMATIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TRIGGERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TRIGGER_COLS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TRIGGER_ORDERING TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TSM_DESTINATION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TSM_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TSM_SOURCE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TSTZ_TAB_COLS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TS_QUOTAS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TUNE_MVIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TYPES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TYPE_ATTRS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TYPE_METHODS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_TYPE_VERSIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_UNDO_EXTENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_UNUSED_COL_TABS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_UPDATABLE_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_USERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_USTATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_VARRAYS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_VIEWS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_VIEWS_AE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_WAITERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_WALLET_ACLS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_WARNING_SETTINGS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_WORKLOAD_ACTIVE_USER_MAP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_WORKLOAD_CAPTURES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_WORKLOAD_CONNECTION_MAP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_WORKLOAD_FILTERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_WORKLOAD_REPLAYS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_WORKLOAD_REPLAY_DIVERGENCE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_WORKLOAD_REPLAY_FILTER_SET TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_WORKLOAD_REPLAY_SCHEDULES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_WORKLOAD_SCHEDULE_CAPTURES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_WORKLOAD_SCHEDULE_ORDERING TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_WORKLOAD_USER_MAP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_XDS_ATTRIBUTE_SECS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_XDS_INSTANCE_SETS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_XDS_OBJECTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_XMLSCHEMA_LEVEL_VIEW_DUP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_XML_INDEXES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_XML_SCHEMAS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_XML_SCHEMA_DEPENDENCY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_XML_SCHEMA_IMPORTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_XML_SCHEMA_INCLUDES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_XML_TABLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_XML_TAB_COLS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_XML_VIEWS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_XML_VIEW_COLS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_XSTREAM_ADMINISTRATOR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_XSTREAM_INBOUND TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_XSTREAM_INBOUND_PROGRESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_XSTREAM_OUTBOUND TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_XSTREAM_OUTBOUND_PROGRESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_XSTREAM_OUT_SUPPORT_MODE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBA_XSTREAM_RULES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DBMSHSXP_SQL_PROFILE_ATTR TO SELECT_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_RCVMAN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DEFCALL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DEFCALLDEST TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DEFDEFAULTDEST TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DEFERRCOUNT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DEFERROR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DEFLOB TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DEFPROPAGATOR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DEFSCHEDULE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DEFTRAN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.DEFTRANDEST TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ERROR_SIZE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXT_TO_OBJ_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU102XTYP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU10ASC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU10CCL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU10COE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU10NTA TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU10NTAROLE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU10SNAP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU10SNAPI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU10SNAPL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU10SNAPLC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU10SNAPLI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU10TAB TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU10TABS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU10USCI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU112DLOB TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU11SNAP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU11SNAPI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU816CTX TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU816SQV TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU816TCTX TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU816TGR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU816TGRC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU816TGRI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU816TGRIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81APPROLE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81CTX TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81DOI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81FIL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81INDC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81INDI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81INDIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81ITY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81ITYC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81ITYI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81IXCP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81IXSP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81JAVC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81JAVI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81LBCP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81LBP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81LBSP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81OBJ TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81OPR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81OPRC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81OPRI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81PLB TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81PSTC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81PSTI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81REFC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81REFI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81RGC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81RGS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81SCM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81SLFC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81SNAP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81SNAPC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81SNAPI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81SNAPL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81SNAPLC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81SNAPLI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81SPOK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81SPOKI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81SRT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81TAB TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81TABC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81TABI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81TABS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81TBCP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81TBS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81TBSP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81TGR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81TGRC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81TGRI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81TGRIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81TNTC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81TNTI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81TTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81TYP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU81USCI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8ANAL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8ASC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8AUD TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8CCL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8CCO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8CGR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8CLU TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8CLUC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8CLUI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8CMT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8COE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8COL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8COLNN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8COL_TEMP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8COL_TEMP_TTS_UNUSED_COL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8COL_TTS_UNUSED_COL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8CON TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8COO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8CSN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8DEL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8DELSNAP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8DELSNAPL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8DFR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8DIMC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8DIMI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8DIR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8ERC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8FIL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8FPT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8GRN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8GRS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8HST TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8IND TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8INDC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8INDI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8INDIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8INK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8IOV TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8IXP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8JBQ TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8LIB TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8LOB TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8NTB TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8NXP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8OID TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8PDS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8PHS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8PNT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8POK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8POKI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8PRF TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8PRR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8PST TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8PSTC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8PSTI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8PSTIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8PVF TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8REF TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8REFC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8REFI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8REFIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8RFS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8RGC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8RGS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8RIF TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8RLG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8ROL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8RSG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8SCM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8SEQ TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8SLFC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8SLOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8SNAP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8SNAPC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8SNAPI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8SNAPL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8SNAPLC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8SNAPLI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8SPR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8SPRC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8SPRI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8SPS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8SPV TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8SRT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8STO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8SYN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8SYNC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8SYNI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8TAB TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8TABC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8TABI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8TBP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8TBS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8TGR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8TGRC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8TGRI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8TGRIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8TNTC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8TNTI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8TNTIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8TSL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8TSN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8TSQ TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8TYP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8TYPB TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8TYPT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8USR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8VDPT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8VEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8VEWC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8VEWI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8VINF TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8VINFC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8VINFI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8VNC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8VNCC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU8VNCI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU92FPT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU92FPTP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU92ITGR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU92TGR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU92TGRC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU92TGRI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU92TGRIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9CCL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9COE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9COO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9COO_TTS_UNUSED_COL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9DOI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9FIL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9INDC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9INDI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9INDIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9IXCP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9LBCP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9LBP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9LOB TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9LTTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9NTA TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9NTAROLE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9PDS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9PLB TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9PSTC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9PSTI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9REFC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9REFI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9SNAP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9SNAPC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9SNAPI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9SNAPL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9SNAPLC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9SNAPLI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9STO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9SYN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9TAB TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9TABC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9TABI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9TABS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9TBCP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9TBS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9TGRC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9TGRI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9TNTC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9TNTI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9TSQ TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9TYP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9TYPT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9TYPT2 TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.EXU9UTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.FGA_LOG$FOR_EXPORT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.FGA_LOG$FOR_EXPORT_TBL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.FILEXT$ TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.FILE_LOCK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.FILE_PING TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GLOBAL_CONTEXT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ACCESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ACTIVE_SERVICES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ACTIVE_SESSION_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ADVISOR_PROGRESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ALERT_TYPES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$AQ TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$AQ1 TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ARCHIVE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ARCHIVED_LOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ARCHIVE_DEST TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ARCHIVE_DEST_STATUS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ARCHIVE_GAP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ARCHIVE_PROCESSES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ASH_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ASM_ACFSSNAPSHOTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ASM_ACFSVOLUMES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ASM_ACFS_ENCRYPTION_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ASM_ACFS_SECURITY_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ASM_ALIAS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ASM_ATTRIBUTE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ASM_CLIENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ASM_DISK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ASM_DISKGROUP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ASM_DISKGROUP_STAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ASM_DISK_IOSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ASM_DISK_STAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ASM_FILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ASM_FILESYSTEM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ASM_OPERATION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ASM_TEMPLATE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ASM_USER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ASM_USERGROUP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ASM_USERGROUP_MEMBER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ASM_VOLUME TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ASM_VOLUME_STAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$AUTO_BMR_STATISTICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$AW_AGGREGATE_OP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$AW_ALLOCATE_OP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$AW_CALC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$AW_OLAP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$AW_SESSION_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$BACKUP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$BACKUP_ASYNC_IO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$BACKUP_CORRUPTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$BACKUP_DATAFILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$BACKUP_DEVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$BACKUP_PIECE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$BACKUP_REDOLOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$BACKUP_SET TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$BACKUP_SPFILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$BACKUP_SYNC_IO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$BGPROCESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$BSP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$BUFFERED_PUBLISHERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$BUFFERED_QUEUES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$BUFFERED_SUBSCRIBERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$BUFFER_POOL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$BUFFER_POOL_STATISTICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$CALLTAG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$CELL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$CELL_CONFIG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$CELL_OFL_THREAD_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$CELL_REQUEST_TOTALS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$CELL_STATE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$CELL_THREAD_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$CHANNEL_WAITS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$CIRCUIT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$CLASS_CACHE_TRANSFER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$CLASS_PING TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$CLIENT_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$CLONEDFILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$CLUSTER_INTERCONNECTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$CONFIGURED_INTERCONNECTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$CONTEXT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$CONTROLFILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$CONTROLFILE_RECORD_SECTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$COPY_CORRUPTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$CORRUPT_XID_LIST TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$CPOOL_CC_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$CPOOL_CC_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$CPOOL_CONN_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$CPOOL_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$CR_BLOCK_SERVER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$CURRENT_BLOCK_SERVER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DATABASE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DATABASE_BLOCK_CORRUPTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DATABASE_INCARNATION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DATABASE_KEY_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DATAFILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DATAFILE_COPY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DATAFILE_HEADER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DATAGUARD_CONFIG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DATAGUARD_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DATAGUARD_STATUS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DATAPUMP_JOB TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DATAPUMP_SESSION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DBFILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DBLINK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DB_CACHE_ADVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DB_OBJECT_CACHE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DB_PIPES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DB_TRANSPORTABLE_PLATFORM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DEAD_CLEANUP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DELETED_OBJECT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DETACHED_SESSION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DISPATCHER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DISPATCHER_CONFIG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DISPATCHER_RATE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DLM_ALL_LOCKS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DLM_CONVERT_LOCAL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DLM_CONVERT_REMOTE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DLM_LATCH TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DLM_LOCKS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DLM_MISC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DLM_RESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DLM_TRAFFIC_CONTROLLER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DNFS_CHANNELS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DNFS_FILES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DNFS_SERVERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DNFS_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$DYNAMIC_REMASTER_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$EMON TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ENABLEDPRIVS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ENCRYPTED_TABLESPACES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ENCRYPTION_WALLET TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ENQUEUE_LOCK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ENQUEUE_STAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ENQUEUE_STATISTICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$EVENTMETRIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$EVENT_HISTOGRAM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$EVENT_NAME TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$EXECUTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$FAST_START_SERVERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$FAST_START_TRANSACTIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$FILEMETRIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$FILEMETRIC_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$FILESPACE_USAGE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$FILESTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$FILE_CACHE_TRANSFER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$FILE_HISTOGRAM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$FILE_OPTIMIZED_HISTOGRAM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$FILE_PING TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$FIXED_TABLE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$FIXED_VIEW_DEFINITION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$FLASHBACK_DATABASE_LOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$FLASHBACK_DATABASE_LOGFILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$FLASHBACK_DATABASE_STAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$FOREIGN_ARCHIVED_LOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$FS_FAILOVER_HISTOGRAM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$FS_FAILOVER_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$FS_OBSERVER_HISTOGRAM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$GCSHVMASTER_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$GCSPFMASTER_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$GC_ELEMENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$GC_ELEMENTS_W_COLLISIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$GES_BLOCKING_ENQUEUE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$GES_ENQUEUE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$GG_APPLY_COORDINATOR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$GG_APPLY_READER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$GG_APPLY_RECEIVER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$GG_APPLY_SERVER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$GLOBALCONTEXT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$GLOBAL_BLOCKED_LOCKS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$GLOBAL_TRANSACTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$GOLDENGATE_CAPABILITIES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$GOLDENGATE_CAPTURE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$GOLDENGATE_MESSAGETRACKING TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$GOLDENGATE_TABLE_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$GOLDENGATE_TRANSACTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$HANG_STATISTICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$HM_CHECK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$HM_CHECK_PARAM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$HM_FINDING TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$HM_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$HM_RECOMMENDATION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$HM_RUN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$HS_AGENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$HS_PARAMETER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$HS_SESSION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$HVMASTER_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$INCMETER_CONFIG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$INCMETER_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$INCMETER_SUMMARY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$INDEXED_FIXED_COLUMN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$INSTANCE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$INSTANCE_CACHE_TRANSFER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$INSTANCE_LOG_GROUP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$INSTANCE_RECOVERY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$IOFUNCMETRIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$IOFUNCMETRIC_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$IOSTAT_CONSUMER_GROUP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$IOSTAT_FILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$IOSTAT_FUNCTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$IOSTAT_FUNCTION_DETAIL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$IOSTAT_NETWORK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$IO_CALIBRATION_STATUS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$IR_FAILURE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$IR_FAILURE_SET TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$IR_MANUAL_CHECKLIST TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$IR_REPAIR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$JAVAPOOL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$JAVA_LIBRARY_CACHE_MEMORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$JAVA_POOL_ADVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LATCH TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LATCHHOLDER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LATCHNAME TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LATCH_CHILDREN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LATCH_MISSES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LATCH_PARENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LIBCACHE_LOCKS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LIBRARYCACHE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LIBRARY_CACHE_MEMORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LICENSE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LISTENER_NETWORK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOBSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOCK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOCKED_OBJECT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOCKS_WITH_COLLISIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOCK_ELEMENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOCK_TYPE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOGFILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOGHIST TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOGMNR_CALLBACK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOGMNR_CONTENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOGMNR_DICTIONARY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOGMNR_DICTIONARY_LOAD TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOGMNR_LATCH TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOGMNR_LOGFILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOGMNR_LOGS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOGMNR_PARAMETERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOGMNR_PROCESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOGMNR_REGION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOGMNR_SESSION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOGMNR_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOGMNR_TRANSACTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOGSTDBY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOGSTDBY_PROCESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOGSTDBY_PROGRESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOGSTDBY_STATE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOGSTDBY_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOGSTDBY_TRANSACTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$LOG_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$MANAGED_STANDBY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$MAP_COMP_LIST TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$MAP_ELEMENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$MAP_EXT_ELEMENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$MAP_FILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$MAP_FILE_EXTENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$MAP_FILE_IO_STACK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$MAP_LIBRARY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$MAP_SUBELEMENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$MEMORY_CURRENT_RESIZE_OPS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$MEMORY_DYNAMIC_COMPONENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$MEMORY_RESIZE_OPS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$MEMORY_TARGET_ADVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$METRIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$METRICGROUP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$METRICNAME TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$METRIC_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$MTTR_TARGET_ADVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$MUTEX_SLEEP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$MUTEX_SLEEP_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$MVREFRESH TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$MYSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$NFS_CLIENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$NFS_LOCKS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$NFS_OPEN_FILES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$OBJECT_DEPENDENCY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$OBJECT_DML_FREQUENCIES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$OBSOLETE_PARAMETER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$OFFLINE_RANGE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$OPEN_CURSOR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$OSSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PARAMETER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PARAMETER2 TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PARAMETER_VALID_VALUES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PERSISTENT_PUBLISHERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PERSISTENT_QMN_CACHE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PERSISTENT_QUEUES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PERSISTENT_SUBSCRIBERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PGASTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PGATARGET_ADVICE_HISTOGRAM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PGA_TARGET_ADVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$POLICY_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PQ_SLAVE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PQ_SYSSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PROCESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PROCESS_GROUP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PROCESS_MEMORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PROCESS_MEMORY_DETAIL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PROCESS_MEMORY_DETAIL_PROG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PROPAGATION_RECEIVER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PROPAGATION_SENDER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PROXY_ARCHIVEDLOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PROXY_DATAFILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PWFILE_USERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PX_BUFFER_ADVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PX_INSTANCE_GROUP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PX_PROCESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PX_PROCESS_SYSSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PX_SESSION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$PX_SESSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$QMON_COORDINATOR_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$QMON_SERVER_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$QMON_TASKS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$QMON_TASK_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$QUEUE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$RECOVERY_FILE_STATUS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$RECOVERY_LOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$RECOVERY_PROGRESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$RECOVERY_STATUS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$RECOVER_FILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$REDO_DEST_RESP_HISTOGRAM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$REPLPROP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$REPLQUEUE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$REQDIST TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$RESERVED_WORDS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$RESOURCE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$RESOURCE_LIMIT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$RESULT_CACHE_DEPENDENCY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$RESULT_CACHE_MEMORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$RESULT_CACHE_OBJECTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$RESULT_CACHE_STATISTICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$RESUMABLE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$RFS_THREAD TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$RMAN_COMPRESSION_ALGORITHM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$RMAN_CONFIGURATION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$RMAN_OUTPUT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ROLLSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ROWCACHE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ROWCACHE_PARENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$ROWCACHE_SUBORDINATE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$RO_USER_ACCOUNT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$RSRCMGRMETRIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$RSRCMGRMETRIC_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$RULE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$RULE_SET TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$RULE_SET_AGGREGATE_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SCHEDULER_RUNNING_JOBS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SECUREFILE_TIMER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SEGMENT_STATISTICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SEGSPACE_USAGE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SEGSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SEGSTAT_NAME TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SERVICEMETRIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SERVICEMETRIC_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SERVICES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SERVICE_EVENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SERVICE_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SERVICE_WAIT_CLASS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SERV_MOD_ACT_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SESSION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SESSION_BLOCKERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SESSION_CONNECT_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SESSION_CURSOR_CACHE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SESSION_EVENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SESSION_FIX_CONTROL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SESSION_OBJECT_CACHE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SESSION_WAIT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SESSION_WAIT_CLASS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SESSION_WAIT_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SESSMETRIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SESSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SESS_IO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SESS_TIME_MODEL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SES_OPTIMIZER_ENV TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SGA TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SGAINFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SGASTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SGA_CURRENT_RESIZE_OPS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SGA_DYNAMIC_COMPONENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SGA_DYNAMIC_FREE_MEMORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SGA_RESIZE_OPS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SGA_TARGET_ADVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SHARED_POOL_ADVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SHARED_POOL_RESERVED TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SHARED_SERVER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SHARED_SERVER_MONITOR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SORT_SEGMENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SORT_USAGE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SPPARAMETER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQLAREA TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQLAREA_PLAN_HASH TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQLCOMMAND TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQLPA_METRIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQLSTATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQLSTATS_PLAN_HASH TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQLTEXT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQLTEXT_WITH_NEWLINES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQL_BIND_CAPTURE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQL_BIND_DATA TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQL_BIND_METADATA TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQL_CS_HISTOGRAM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQL_CS_SELECTIVITY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQL_CS_STATISTICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQL_CURSOR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQL_FEATURE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQL_FEATURE_DEPENDENCY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQL_FEATURE_HIERARCHY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQL_HINT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQL_JOIN_FILTER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQL_MONITOR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQL_OPTIMIZER_ENV TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQL_PLAN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQL_PLAN_MONITOR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQL_PLAN_STATISTICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQL_PLAN_STATISTICS_ALL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQL_REDIRECTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQL_SHARED_CURSOR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQL_SHARED_MEMORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQL_WORKAREA TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQL_WORKAREA_ACTIVE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SQL_WORKAREA_HISTOGRAM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SSCR_SESSIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$STANDBY_LOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$STATISTICS_LEVEL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$STATNAME TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$STREAMS_APPLY_COORDINATOR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$STREAMS_APPLY_READER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$STREAMS_APPLY_SERVER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$STREAMS_CAPTURE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$STREAMS_MESSAGE_TRACKING TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$STREAMS_POOL_ADVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$STREAMS_POOL_STATISTICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$STREAMS_TRANSACTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SUBCACHE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SUBSCR_REGISTRATION_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SYSAUX_OCCUPANTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SYSMETRIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SYSMETRIC_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SYSMETRIC_SUMMARY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SYSSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SYSTEM_CURSOR_CACHE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SYSTEM_EVENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SYSTEM_FIX_CONTROL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SYSTEM_PARAMETER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SYSTEM_PARAMETER2 TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SYSTEM_WAIT_CLASS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SYS_OPTIMIZER_ENV TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$SYS_TIME_MODEL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$TABLESPACE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$TEMPFILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$TEMPSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$TEMP_CACHE_TRANSFER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$TEMP_EXTENT_MAP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$TEMP_EXTENT_POOL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$TEMP_PING TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$TEMP_SPACE_HEADER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$THREAD TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$THRESHOLD_TYPES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$TIMER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$TOPLEVELCALL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$TRANSACTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$TRANSACTION_ENQUEUE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$TRANSPORTABLE_PLATFORM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$TSM_SESSIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$TYPE_SIZE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$UNDOSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$VPD_POLICY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$WAITCLASSMETRIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$WAITCLASSMETRIC_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$WAITSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$WALLET TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$WLM_PCMETRIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$WLM_PCMETRIC_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$WLM_PC_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$WORKLOAD_REPLAY_THREAD TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$XML_AUDIT_TRAIL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$XSTREAM_APPLY_COORDINATOR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$XSTREAM_APPLY_READER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$XSTREAM_APPLY_RECEIVER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$XSTREAM_APPLY_SERVER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$XSTREAM_CAPTURE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$XSTREAM_MESSAGE_TRACKING TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$XSTREAM_OUTBOUND_SERVER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$XSTREAM_TABLE_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$XSTREAM_TRANSACTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.GV_$_LOCK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.IMP10TYPIDUSED TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.IMP10TYPUSED TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.IMP8CDT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.IMP8CON TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.IMP8TTD TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.IMP9CON TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.INDCOMPARTV$ TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.INDPARTV$ TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.INDSUBPARTV$ TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_10_1_HISTGRM_MAX_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_10_1_HISTGRM_MIN_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_10_1_PIND_STATS_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_10_1_PTAB_COL_STATS_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_10_1_PTAB_STATS_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_10_1_SPIND_STATS_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_10_1_TAB_COL_STATS_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_10_1_TAB_ONLY_STATS_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_10_2_STRMCOLTYPE_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_10_2_STRMCOL_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_10_2_STRMSUBCOLTYPE_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_10_2_TAB_COL_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_ADD_SNAP_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_ALL_TSLTZ_TABLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_ALL_TSLTZ_TAB_COLS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_AUDIT_DEFAULT_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_AUDIT_OBJ_BASE_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_BASE_PROC_OBJNUM_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_BASE_PROC_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_BYTES_ALLOC_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_COLTYPE_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_COLUMN_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_COL_STATS_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_CONSTRAINT0_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_CONSTRAINT1_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_CONSTRAINT2_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_CONSTRAINT_COL_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_CUBE_FACT_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_CUBE_TAB_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_DEFERRED_STG_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_DEFROLE_LIST_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_DEPTYPES_BASE_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_DEPVIEWS_BASE_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_DOMIDX_2NDTAB_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_DOMIDX_PLSQL_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_DUMMY_COMMAND_RULE_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_DUMMY_FACTOR_LINK_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_DUMMY_FACTOR_TYPE_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_DUMMY_FACTOR_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_DUMMY_IDENTITY_MAP_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_DUMMY_IDENTITY_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_DUMMY_ISRM_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_DUMMY_ISR_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_DUMMY_REALM_AUTH_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_DUMMY_REALM_MEMBER_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_DUMMY_REALM_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_DUMMY_ROLE_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_DUMMY_RULE_SET_MEMBER_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_DUMMY_RULE_SET_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_DUMMY_RULE_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_EDITION_OBJ_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_EDITION_SCHEMAOBJ_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_EQNTABLE_BYTES_ALLOC_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_EXPACT_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_EXPREG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_FBA_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_FILE_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_FIND_SGC_COLS_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_FIND_SGI_COLS_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_HISTGRM_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_HNTP_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_HNT_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_HTABLE_BYTES_ALLOC_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_HTPART_BYTES_ALLOC_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_HTSPART_BYTES_ALLOC_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_INDARRAYTYPE_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_INDEXOP_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_INDEX_COL_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_IND_CACHE_STATS_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_IND_COL_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_IND_COMPART_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_IND_PARTOBJ_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_IND_PART_COL_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_IND_PART_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_IND_SUBPART_COL_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_IND_SUBPART_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_INSERT_TS_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_IONT_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_IOTABLE_BYTES_ALLOC_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_IOTPART_BYTES_ALLOC_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_IOT_PARTOBJ_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_JIJOIN_TABLE_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_JIJOIN_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_LOBCOMPPART_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_LOBFRAGINDEX_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_LOBFRAG_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_LOBINDEX_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_LOB_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_MAP_TABLE_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_MARKER_VIEW TO SELECT_CATALOG_ROLE;
GRANT EXECUTE ON SYS.KU$_MONITOR_T TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_MVLPROP_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_MVPROP_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_M_VIEW_LOG_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_NTABLE_BYTES_ALLOC_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_NTPART_PARENT_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_NTPART_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_NT_PARENT_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_OIDINDEX_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_OPANCILLARY_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_OPBINDING_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_OPQTYPE_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_OPTION_OBJNUM_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_OPTION_VIEW_OBJNUM_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_OV_TABLE_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_OV_TABPART_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_PARTLOB_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_PARTOBJ_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_PCOLUMN_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_PIND_STATS_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_PIOTLOBFRAG_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_PIOT_PART_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_PKREF_CONSTRAINT_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_PLUGTS_EARLY_TBLSP_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_PLUGTS_TABLESPACE_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_PREPOST_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_PRIM_COLUMN_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_PROCACT_SYS_PKG_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_PROCACT_SYS_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_PROC_AUDIT_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_PROC_GRANT_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_PROFILE_ATTR_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_PROXY_ROLE_LIST_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_PSW_HIST_LIST_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_PSW_HIST_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_PTABLE_TS_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_PTAB_STATS_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_PWDVFC_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_QTAB_STORAGE_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_RESOCOST_LIST_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_RESOCOST_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_RMGR_CONSUMER_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_RMGR_INIT_CONSUMER_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_RMGR_PLAN_DIRECT_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_RMGR_PLAN_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_SCHEMAOBJNUM_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_SCHEMAOBJ_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_SIMPLE_COL_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_SIMPLE_PKREF_COL_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_SIMPLE_SETID_COL_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_SPIND_STATS_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_STORAGE_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_STRMCOLTYPE_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_STRMCOL_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_STRMSUBCOLTYPE_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_SUBCOLTYPE_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_SUBLOBFRAGINDEX_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_SUBLOBFRAG_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_SYSCALLOUT_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TABCLUSTER_COL_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TABCLUSTER_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TABLE_TYPES_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TABLE_XMLSCHEMA_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TABPROP_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TAB_CACHE_STATS_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TAB_COL_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TAB_COMPART_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TAB_ONLY_STATS_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TAB_PARTOBJ_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TAB_PART_COL_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TAB_PART_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TAB_SUBPART_COL_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TAB_SUBPART_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TAB_TSUBPART_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TEMP_SUBPARTLOBFRG_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TEMP_SUBPART_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TLOB_COMPPART_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TRIGGERCOL_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TRIGGERDEP_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TTSP_IDX_TABLESPACE_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TTSP_INDPARTVIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TTSP_INDSUBPARTVIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TTS_IDXVIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TTS_IDX_TABLESPACE_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TTS_INDPARTVIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TTS_INDSUBPARTVIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TTS_IND_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TTS_MVL_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TTS_MV_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TTS_PARTLOBVIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TTS_SUBPARTLOBVIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TTS_TABPARTVIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TTS_TABSUBPARTVIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TTS_TABVIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TTS_TAB_TABLESPACE_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TTS_TYPES_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_TTS_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_UNLOAD_METHOD_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_UP_STATS_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_USER_MAPPING_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_USER_MAPPING_VIEW_TBL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_XMLSCHEMA_ELMT_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.KU$_XMLSCHEMA_TYPES_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.LOBCOMPPARTV$ TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.LOBFRAGV$ TO SELECT_CATALOG_ROLE;
GRANT EXECUTE ON SYS.LOGSTDBY$TABF TO SELECT_CATALOG_ROLE;
GRANT EXECUTE ON SYS.LOGSTDBY$UTABF TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.LOGSTDBY_UNSUPPORTED_TABLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.MAP_OBJECT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.ORA_KGLR7_OBJECTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.PARSED_PIECES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.PARSED_SIZE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.PLUGGABLE_SET_CHECK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.PROXY_ROLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.PROXY_USERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.PROXY_USERS_AND_ROLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.PS1$ TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.PSS1$ TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.REDACTION_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.REDACTION_POLICIES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.REDACTION_VALUES_FOR_TYPE_FULL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.REPCAT$_CDEF TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.REPCAT_GENERATED TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.REPCAT_REPCAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.REPCAT_REPCATLOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.REPCAT_REPCOLUMN_BASE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.REPCAT_REPFLAVOR_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.REPCAT_REPOBJECT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.REPCAT_REPOBJECT_BASE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.REPCAT_REPPROP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.REPCAT_REPSCHEMA TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.SM$AUDIT_CONFIG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.SM$INTEGRITY_CONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.SM$TS_AVAIL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.SM$TS_FREE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.SM$TS_USED TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.SOURCE_SIZE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.STRADDLING_RS_OBJECTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.STRADDLING_TS_OBJECTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.SYSCATALOG_ TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.SYS_DBA_SEGS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.SYS_OBJECTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.SYS_UNCOMPRESSED_SEGS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.SYS_UNCOMPRESSED_SEGS_BASE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.SYS_USER_SEGS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.TABCOMPARTV$ TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.TABPARTV$ TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.TABSUBPARTV$ TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.TP$ TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.TRANSPORT_SET_VIOLATIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.TRUSTED_SERVERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.TSP$ TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.TS_PITR_CHECK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.TS_PITR_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.TS_PITR_OBJECTS_TO_BE_DROPPED TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.TS_PLUG_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.TTS_OBJ_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.TTS_TAB_VIEW TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.USER_ADVISOR_DIR_TASK_INST TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.USER_AUDIT_POLICIES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.USER_AUDIT_POLICY_COLUMNS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ACCESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ACTIVE_SERVICES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ACTIVE_SESSION_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ALERT_TYPES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$AQ TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$AQ1 TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ARCHIVE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ARCHIVED_LOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ARCHIVE_DEST TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ARCHIVE_DEST_STATUS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ARCHIVE_GAP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ARCHIVE_PROCESSES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ASH_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ASM_ACFSSNAPSHOTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ASM_ACFSVOLUMES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ASM_ACFS_ENCRYPTION_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ASM_ACFS_SECURITY_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ASM_ALIAS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ASM_ATTRIBUTE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ASM_CLIENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ASM_DISK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ASM_DISKGROUP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ASM_DISKGROUP_STAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ASM_DISK_IOSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ASM_DISK_STAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ASM_FILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ASM_FILESYSTEM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ASM_OPERATION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ASM_TEMPLATE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ASM_USER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ASM_USERGROUP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ASM_USERGROUP_MEMBER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ASM_VOLUME TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ASM_VOLUME_STAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$AW_AGGREGATE_OP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$AW_ALLOCATE_OP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$AW_CALC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$AW_OLAP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$AW_SESSION_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BACKUP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_ARCHIVELOG_DETAILS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_ARCHIVELOG_SUMMARY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_ASYNC_IO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_CONTROLFILE_DETAILS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_CONTROLFILE_SUMMARY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_COPY_DETAILS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_COPY_SUMMARY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_CORRUPTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_DATAFILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_DATAFILE_DETAILS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_DATAFILE_SUMMARY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_DEVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_FILES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_PIECE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_PIECE_DETAILS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_REDOLOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_SET TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_SET_DETAILS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_SET_SUMMARY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_SPFILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_SPFILE_DETAILS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_SPFILE_SUMMARY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_SYNC_IO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BGPROCESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BLOCK_CHANGE_TRACKING TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BSP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BUFFERED_PUBLISHERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BUFFERED_QUEUES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BUFFERED_SUBSCRIBERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BUFFER_POOL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$BUFFER_POOL_STATISTICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$CALLTAG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$CELL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$CELL_CONFIG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$CELL_OFL_THREAD_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$CELL_REQUEST_TOTALS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$CELL_STATE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$CELL_THREAD_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$CHANNEL_WAITS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$CIRCUIT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$CLASS_CACHE_TRANSFER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$CLASS_PING TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$CLIENT_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$CLONEDFILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$CLUSTER_INTERCONNECTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$CONFIGURED_INTERCONNECTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$CONTEXT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$CONTROLFILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$CONTROLFILE_RECORD_SECTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$COPY_CORRUPTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$CORRUPT_XID_LIST TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$CPOOL_CC_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$CPOOL_CC_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$CPOOL_CONN_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$CPOOL_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$CR_BLOCK_SERVER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$CURRENT_BLOCK_SERVER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DATABASE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DATABASE_BLOCK_CORRUPTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DATABASE_INCARNATION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DATABASE_KEY_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DATAFILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DATAFILE_COPY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DATAFILE_HEADER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DATAGUARD_CONFIG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DATAGUARD_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DATAGUARD_STATUS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DATAPUMP_JOB TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DATAPUMP_SESSION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DBFILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DBLINK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DB_CACHE_ADVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DB_OBJECT_CACHE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DB_PIPES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DB_TRANSPORTABLE_PLATFORM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DEAD_CLEANUP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DELETED_OBJECT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DETACHED_SESSION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DISPATCHER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DISPATCHER_CONFIG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DISPATCHER_RATE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DLM_ALL_LOCKS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DLM_CONVERT_LOCAL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DLM_CONVERT_REMOTE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DLM_LATCH TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DLM_LOCKS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DLM_MISC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DLM_RESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DLM_TRAFFIC_CONTROLLER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DNFS_CHANNELS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DNFS_FILES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DNFS_SERVERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DNFS_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$DYNAMIC_REMASTER_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$EMON TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ENABLEDPRIVS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ENCRYPTED_TABLESPACES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ENCRYPTION_WALLET TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ENQUEUE_LOCK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ENQUEUE_STAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ENQUEUE_STATISTICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$EVENTMETRIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$EVENT_HISTOGRAM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$EVENT_NAME TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$EXECUTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$FAST_START_SERVERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$FAST_START_TRANSACTIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$FILEMETRIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$FILEMETRIC_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$FILESPACE_USAGE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$FILESTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$FILE_CACHE_TRANSFER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$FILE_HISTOGRAM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$FILE_OPTIMIZED_HISTOGRAM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$FILE_PING TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$FIXED_TABLE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$FIXED_VIEW_DEFINITION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$FLASHBACK_DATABASE_LOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$FLASHBACK_DATABASE_LOGFILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$FLASHBACK_DATABASE_STAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$FLASH_RECOVERY_AREA_USAGE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$FOREIGN_ARCHIVED_LOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$FS_FAILOVER_HISTOGRAM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$FS_FAILOVER_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$FS_OBSERVER_HISTOGRAM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$GCSHVMASTER_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$GCSPFMASTER_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$GC_ELEMENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$GC_ELEMENTS_W_COLLISIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$GES_BLOCKING_ENQUEUE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$GES_ENQUEUE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$GG_APPLY_COORDINATOR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$GG_APPLY_READER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$GG_APPLY_RECEIVER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$GG_APPLY_SERVER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$GLOBALCONTEXT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$GLOBAL_BLOCKED_LOCKS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$GLOBAL_TRANSACTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$GOLDENGATE_CAPABILITIES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$GOLDENGATE_CAPTURE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$GOLDENGATE_MESSAGE_TRACKING TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$GOLDENGATE_TABLE_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$GOLDENGATE_TRANSACTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$HANG_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$HANG_SESSION_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$HANG_STATISTICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$HM_CHECK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$HM_CHECK_PARAM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$HM_FINDING TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$HM_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$HM_RECOMMENDATION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$HM_RUN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$HS_AGENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$HS_PARAMETER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$HS_SESSION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$HVMASTER_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$INCMETER_CONFIG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$INCMETER_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$INCMETER_SUMMARY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$INDEXED_FIXED_COLUMN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$INSTANCE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$INSTANCE_CACHE_TRANSFER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$INSTANCE_LOG_GROUP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$INSTANCE_RECOVERY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$IOFUNCMETRIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$IOFUNCMETRIC_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$IOSTAT_CONSUMER_GROUP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$IOSTAT_FILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$IOSTAT_FUNCTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$IOSTAT_FUNCTION_DETAIL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$IOSTAT_NETWORK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$IO_CALIBRATION_STATUS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$IR_FAILURE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$IR_FAILURE_SET TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$IR_MANUAL_CHECKLIST TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$IR_REPAIR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$JAVAPOOL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$JAVA_LIBRARY_CACHE_MEMORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$JAVA_POOL_ADVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$KCCDI TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$KCCFE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LATCH TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LATCHHOLDER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LATCHNAME TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LATCH_CHILDREN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LATCH_MISSES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LATCH_PARENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LIBCACHE_LOCKS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LIBRARYCACHE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LIBRARY_CACHE_MEMORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LICENSE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LISTENER_NETWORK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOBSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOCK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOCKED_OBJECT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOCKS_WITH_COLLISIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOCK_ELEMENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOCK_TYPE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOGFILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOGHIST TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOGMNR_CALLBACK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOGMNR_CONTENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOGMNR_DICTIONARY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOGMNR_DICTIONARY_LOAD TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOGMNR_LATCH TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOGMNR_LOGFILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOGMNR_LOGS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOGMNR_PARAMETERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOGMNR_PROCESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOGMNR_REGION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOGMNR_SESSION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOGMNR_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOGMNR_TRANSACTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOGSTDBY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOGSTDBY_PROCESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOGSTDBY_PROGRESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOGSTDBY_STATE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOGSTDBY_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOGSTDBY_TRANSACTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$LOG_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$MANAGED_STANDBY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$MAP_COMP_LIST TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$MAP_ELEMENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$MAP_EXT_ELEMENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$MAP_FILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$MAP_FILE_EXTENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$MAP_FILE_IO_STACK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$MAP_LIBRARY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$MAP_SUBELEMENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$MEMORY_CURRENT_RESIZE_OPS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$MEMORY_DYNAMIC_COMPONENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$MEMORY_RESIZE_OPS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$MEMORY_TARGET_ADVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$METRIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$METRICGROUP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$METRICNAME TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$METRIC_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$MTTR_TARGET_ADVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$MUTEX_SLEEP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$MUTEX_SLEEP_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$MVREFRESH TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$MYSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$NFS_CLIENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$NFS_LOCKS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$NFS_OPEN_FILES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$OBJECT_DEPENDENCY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$OBJECT_DML_FREQUENCIES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$OBJECT_PRIVILEGE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$OBSOLETE_PARAMETER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$OFFLINE_RANGE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$OPEN_CURSOR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$OSSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PARAMETER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PARAMETER2 TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PARAMETER_VALID_VALUES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PERSISTENT_PUBLISHERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PERSISTENT_QMN_CACHE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PERSISTENT_QUEUES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PERSISTENT_SUBSCRIBERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PGASTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PGA_TARGET_ADVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PGA_TARGET_ADVICE_HISTOGRAM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$POLICY_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PQ_SLAVE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PQ_SYSSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PROCESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PROCESS_GROUP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PROCESS_MEMORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PROCESS_MEMORY_DETAIL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PROCESS_MEMORY_DETAIL_PROG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PROPAGATION_RECEIVER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PROPAGATION_SENDER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PROXY_ARCHIVEDLOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PROXY_ARCHIVELOG_DETAILS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PROXY_ARCHIVELOG_SUMMARY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PROXY_COPY_DETAILS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PROXY_COPY_SUMMARY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PROXY_DATAFILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PWFILE_USERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PX_BUFFER_ADVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PX_INSTANCE_GROUP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PX_PROCESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PX_PROCESS_SYSSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PX_SESSION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$PX_SESSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$QMON_COORDINATOR_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$QMON_SERVER_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$QMON_TASKS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$QMON_TASK_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$QUEUE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RECOVERY_AREA_USAGE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RECOVERY_FILE_DEST TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RECOVERY_FILE_STATUS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RECOVERY_LOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RECOVERY_PROGRESS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RECOVERY_STATUS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RECOVER_FILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$REDO_DEST_RESP_HISTOGRAM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$REPLPROP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$REPLQUEUE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$REQDIST TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RESERVED_WORDS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RESOURCE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RESOURCE_LIMIT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RESULT_CACHE_DEPENDENCY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RESULT_CACHE_MEMORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RESULT_CACHE_OBJECTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RESULT_CACHE_STATISTICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RESUMABLE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RFS_THREAD TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RMAN_BACKUP_JOB_DETAILS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RMAN_BACKUP_SUBJOB_DETAILS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RMAN_BACKUP_TYPE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RMAN_COMPRESSION_ALGORITHM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RMAN_CONFIGURATION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RMAN_ENCRYPTION_ALGORITHMS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RMAN_OUTPUT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RMAN_STATUS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ROLLNAME TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ROLLSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ROWCACHE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ROWCACHE_PARENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$ROWCACHE_SUBORDINATE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RO_USER_ACCOUNT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RSRCMGRMETRIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RSRCMGRMETRIC_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RULE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RULE_SET TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$RULE_SET_AGGREGATE_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SCHEDULER_RUNNING_JOBS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SECUREFILE_TIMER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SEGMENT_STATISTICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SEGSPACE_USAGE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SEGSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SEGSTAT_NAME TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SERVICEMETRIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SERVICEMETRIC_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SERVICES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SERVICE_EVENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SERVICE_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SERVICE_WAIT_CLASS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SERV_MOD_ACT_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SESSION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SESSION_BLOCKERS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SESSION_CURSOR_CACHE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SESSION_EVENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SESSION_FIX_CONTROL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SESSION_OBJECT_CACHE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SESSION_WAIT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SESSION_WAIT_CLASS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SESSION_WAIT_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SESSMETRIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SESSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SESS_IO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SESS_TIME_MODEL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SES_OPTIMIZER_ENV TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SGA TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SGAINFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SGASTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SGA_CURRENT_RESIZE_OPS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SGA_DYNAMIC_COMPONENTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SGA_DYNAMIC_FREE_MEMORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SGA_RESIZE_OPS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SGA_TARGET_ADVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SHARED_POOL_ADVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SHARED_POOL_RESERVED TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SHARED_SERVER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SHARED_SERVER_MONITOR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SORT_SEGMENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SORT_USAGE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SPPARAMETER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQLAREA TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQLAREA_PLAN_HASH TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQLCOMMAND TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQLSTATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQLSTATS_PLAN_HASH TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQLTEXT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQLTEXT_WITH_NEWLINES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQL_BIND_CAPTURE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQL_BIND_DATA TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQL_BIND_METADATA TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQL_CS_HISTOGRAM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQL_CS_SELECTIVITY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQL_CS_STATISTICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQL_CURSOR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQL_FEATURE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQL_FEATURE_DEPENDENCY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQL_FEATURE_HIERARCHY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQL_HINT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQL_JOIN_FILTER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQL_MONITOR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQL_OPTIMIZER_ENV TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQL_PLAN TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQL_PLAN_MONITOR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQL_PLAN_STATISTICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQL_PLAN_STATISTICS_ALL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQL_REDIRECTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQL_SHARED_CURSOR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQL_SHARED_MEMORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQL_WORKAREA TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQL_WORKAREA_ACTIVE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SQL_WORKAREA_HISTOGRAM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SSCR_SESSIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$STANDBY_EVENT_HISTOGRAM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$STANDBY_LOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$STATISTICS_LEVEL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$STATNAME TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$STREAMS_APPLY_COORDINATOR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$STREAMS_APPLY_READER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$STREAMS_APPLY_SERVER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$STREAMS_CAPTURE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$STREAMS_MESSAGE_TRACKING TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$STREAMS_POOL_ADVICE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$STREAMS_POOL_STATISTICS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$STREAMS_TRANSACTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SUBCACHE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SUBSCR_REGISTRATION_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SYSAUX_OCCUPANTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SYSMETRIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SYSMETRIC_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SYSMETRIC_SUMMARY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SYSSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SYSTEM_CURSOR_CACHE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SYSTEM_EVENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SYSTEM_FIX_CONTROL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SYSTEM_PARAMETER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SYSTEM_PARAMETER2 TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SYSTEM_WAIT_CLASS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SYS_OPTIMIZER_ENV TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$SYS_TIME_MODEL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$TABLESPACE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$TEMPFILE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$TEMPSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$TEMP_CACHE_TRANSFER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$TEMP_EXTENT_MAP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$TEMP_EXTENT_POOL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$TEMP_PING TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$TEMP_SPACE_HEADER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$THREAD TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$THRESHOLD_TYPES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$TIMER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$TOPLEVELCALL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$TRANSACTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$TRANSACTION_ENQUEUE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$TRANSPORTABLE_PLATFORM TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$TSM_SESSIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$TYPE_SIZE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$UNDOSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$UNUSABLE_BACKUPFILE_DETAILS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$VPD_POLICY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$WAITCLASSMETRIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$WAITCLASSMETRIC_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$WAITSTAT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$WAIT_CHAINS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$WALLET TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$WLM_PCMETRIC TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$WLM_PCMETRIC_HISTORY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$WLM_PC_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$WORKLOAD_REPLAY_THREAD TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$XML_AUDIT_TRAIL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$XSTREAM_APPLY_COORDINATOR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$XSTREAM_APPLY_READER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$XSTREAM_APPLY_RECEIVER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$XSTREAM_APPLY_SERVER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$XSTREAM_CAPTURE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$XSTREAM_MESSAGE_TRACKING TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$XSTREAM_OUTBOUND_SERVER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$XSTREAM_TABLE_STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$XSTREAM_TRANSACTION TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS.V_$_LOCK TO SELECT_CATALOG_ROLE;
GRANT EXECUTE ON SYS.XS$CATVIEW_UTIL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS."_DBA_APPLY_CONSTRAINT_COLUMNS" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS."_DBA_APPLY_OBJECT_CONSTRAINTS" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS."_DBA_STREAMS_ACTIONS" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS."_DBA_STREAMS_COMPONENT" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS."_DBA_STREAMS_COMPONENT_EVENT" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS."_DBA_STREAMS_COMPONENT_LINK" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS."_DBA_STREAMS_COMPONENT_PROP" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS."_DBA_STREAMS_COMPONENT_STAT" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS."_DBA_STREAMS_FINDINGS" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS."_DBA_STREAMS_RECOMMENDATIONS" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYS."_DBA_STREAMS_TP_COMPONENT_PROP" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYSTEM.MVIEW_EVALUATIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYSTEM.MVIEW_EXCEPTIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYSTEM.MVIEW_FILTER TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYSTEM.MVIEW_FILTERINSTANCE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYSTEM.MVIEW_LOG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYSTEM.MVIEW_RECOMMENDATIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYSTEM.MVIEW_WORKLOAD TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYSTEM.SCHEDULER_JOB_ARGS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYSTEM.SCHEDULER_JOB_ARGS_TBL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYSTEM.SCHEDULER_PROGRAM_ARGS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON SYSTEM.SCHEDULER_PROGRAM_ARGS_TBL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.APP_ROLE_MEMBERSHIP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.APP_USERS_AND_ROLES TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB."Folder36_TAB" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.MIGR9202STATUS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.SERVLET TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB."SYS_NTyuCUk50zSdLgRAAbeHleYA==" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB."SYS_NTyuCUk511SdLgRAAbeHleYA==" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB."SYS_NTyuCUk53LSdLgRAAbeHleYA==" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB."SYS_NTyuCUk53NSdLgRAAbeHleYA==" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB."SYS_NTyuCUk53PSdLgRAAbeHleYA==" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB."SYS_NTyuCUk53RSdLgRAAbeHleYA==" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB."SYS_NTyuCUk53TSdLgRAAbeHleYA==" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB."SYS_NTyuCUk5y3SdLgRAAbeHleYA==" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB."SYS_NTyuCUk5yUSdLgRAAbeHleYA==" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB."SYS_NTyuCUk5zsSdLgRAAbeHleYA==" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.X$NM6AT2A976LF979E0H003DT7INJ0 TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.X$PT6AT2A976LF979E0H003DT7INJ0 TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.X$QN6AT2A976LF979E0H003DT7INJ0 TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$ACL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$ALL_MODEL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$ANY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$ANYATTR TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$ATTRGROUP_DEF TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$ATTRGROUP_REF TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$ATTRIBUTE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$CHECKOUTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$CHOICE_MODEL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$COLUMN_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$COMPLEX_TYPE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$CONFIG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$DXPTAB TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$D_LINK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$ELEMENT TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$GROUP_DEF TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$GROUP_REF TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$H_INDEX TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$H_LINK TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$IMPORT_TT_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$MOUNTS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$NLOCKS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$NONCEKEY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$PATH_INDEX_PARAMS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$REPOS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$RESCONFIG TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$RESOURCE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$ROOT_INFO TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$SCHEMA TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$SEQUENCE_MODEL TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$SIMPLE_TYPE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$STATS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$TTSET TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$WORKSPACE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$XDB_READY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$XIDX_IMP_T TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$XIDX_PARAM_T TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$XTAB TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$XTABCOLS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XDB$XTABNMSP TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XS$CACHE_ACTIONS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XS$CACHE_DELETE TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XS$DATA_SECURITY TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XS$PRINCIPALS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XS$ROLESETS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB.XS$SECURITYCLASS TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB."aggregatePrivilege108_TAB" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB."description104_TAB" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB."description94_TAB" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB."fallback42_TAB" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB."fallback43_TAB" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB."fallback61_TAB" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB."fallback62_TAB" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB."ftp-log21_TAB" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB."http-log30_TAB" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB."include47_TAB" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB."include66_TAB" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB."privilege107_TAB" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB."title103_TAB" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB."title93_TAB" TO SELECT_CATALOG_ROLE;
GRANT SELECT ON XDB."xdb-log13_TAB" TO SELECT_CATALOG_ROLE;

-- Roles granted to SELECT_CATALOG_ROLE
GRANT HS_ADMIN_SELECT_ROLE TO SELECT_CATALOG_ROLE;
GRANT HS_ADMIN_ROLE TO SELECT_CATALOG_ROLE;

-- Grantees of SELECT_CATALOG_ROLE
GRANT SELECT_CATALOG_ROLE TO AACDBA;
GRANT SELECT_CATALOG_ROLE TO DBA WITH ADMIN OPTION;
GRANT SELECT_CATALOG_ROLE TO DBINSIGHT;
GRANT SELECT_CATALOG_ROLE TO EXP_FULL_DATABASE;
GRANT SELECT_CATALOG_ROLE TO IMP_FULL_DATABASE;
GRANT SELECT_CATALOG_ROLE TO OEM_MONITOR;
GRANT SELECT_CATALOG_ROLE TO SEC00E3APPD;
GRANT SELECT_CATALOG_ROLE TO SQLTXADMIN;
GRANT SELECT_CATALOG_ROLE TO SQLT_USER_ROLE;
GRANT SELECT_CATALOG_ROLE TO SYS WITH ADMIN OPTION;
GRANT SELECT_CATALOG_ROLE TO VA_SELECT_CATALOG_ROLE;
GRANT SELECT_CATALOG_ROLE TO VA_UTIL;
DROP ROLE EXECUTE_CATALOG_ROLE;

CREATE ROLE EXECUTE_CATALOG_ROLE NOT IDENTIFIED;

-- Object privileges granted to EXECUTE_CATALOG_ROLE
GRANT EXECUTE ON SYS.AS_REPLAY TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMSHSXP TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMSZEXP_SYSPKGGRNT TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_ALERT TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_APPLY_ADM TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_APPLY_POSITION TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_AQ TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_AQADM TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_AQELM TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_AQIN TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_AQJMS_INTERNAL TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_AQ_IMPORT_INTERNAL TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_AUDIT_MGMT TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_AUTO_TASK_EXPORT TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_CAPTURE_ADM TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_CAPTURE_SWITCH_ADM TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_CDC_IPUBLISH TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_CDC_PUBLISH TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_CDC_SYS_IPUBLISH TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_CDC_UTILITY TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_COMPARISON TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_DBLINK TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_DEFER TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_DEFER_REPCAT TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_DISTRIBUTED_TRUST_ADMIN TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_DST TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_FGA TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_FILE_GROUP TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_FILE_TRANSFER TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_GOLDENGATE_AUTH TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_INTERNAL_REPCAT TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_INTERNAL_SAFE_SCN TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_LOCK TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_LOGMNR TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_LOGMNR_D TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_LOGMNR_LOGREP_DICT TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_LOGMNR_SESSION TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_METADATA_BUILD TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_METADATA_DPBUILD TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_METADATA_INT TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_METADATA_UTIL TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_OFFLINE_OG TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_OFFLINE_SNAPSHOT TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_PIPE TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_PITR TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_PLUGTS TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_PLUGTSP TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_PROPAGATION_ADM TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_RECTIFIER_DIFF TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_REDACT TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_REDEFINITION TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_REPCAT TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_REPCAT_ADD_MASTER TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_REPCAT_ADMIN TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_REPCAT_DECL TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_RLS TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_RULE_COMPATIBLE_90 TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_RULE_EXIMP TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_SERVER_ALERT_EXPORT TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_SHARED_POOL TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_STREAMS_ADM TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_STREAMS_ADM_UTL_INT TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_STREAMS_ADVISOR_ADM TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_STREAMS_AUTH TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_STREAMS_HANDLER_ADM TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_STREAMS_LCR_INT TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_STREAMS_MC TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_STREAMS_MESSAGING TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_STREAMS_MT TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_STREAMS_RPC TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_STREAMS_SM TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_STREAMS_TABLESPACE_ADM TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_TRANSFORM_EXIMP TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_TTS TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_WORKLOAD_CAPTURE TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_WORKLOAD_REPLAY TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_XDS TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_XSTREAM_ADM TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_XSTREAM_ADM_UTL TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_XSTREAM_AUTH TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_XSTREAM_GG TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_XSTREAM_GG_ADM TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DBMS_XSTREAM_UTL_IVK TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.DIANA TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.KUPC$QUEUE TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.KUPC$QUEUE_INT TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.KUPC$QUE_INT TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.KUPD$DATA TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.KUPD$DATA_INT TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.KUPF$FILE_INT TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.KUPP$PROC TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.KUPU$UTILITIES_INT TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.KUPV$FT TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.KUPV$FT_INT TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.LOGMNR_EM_SUPPORT TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.OUTLN_EDIT_PKG TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.OUTLN_PKG TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON SYS.PIDL TO EXECUTE_CATALOG_ROLE;

-- Roles granted to EXECUTE_CATALOG_ROLE
GRANT HS_ADMIN_ROLE TO EXECUTE_CATALOG_ROLE;
GRANT HS_ADMIN_EXECUTE_ROLE TO EXECUTE_CATALOG_ROLE;

-- Grantees of EXECUTE_CATALOG_ROLE
GRANT EXECUTE_CATALOG_ROLE TO DBA WITH ADMIN OPTION;
GRANT EXECUTE_CATALOG_ROLE TO EXP_FULL_DATABASE;
GRANT EXECUTE_CATALOG_ROLE TO IMP_FULL_DATABASE;
GRANT EXECUTE_CATALOG_ROLE TO SYS WITH ADMIN OPTION;
DROP ROLE DELETE_CATALOG_ROLE;

CREATE ROLE DELETE_CATALOG_ROLE NOT IDENTIFIED;

-- Object privileges granted to DELETE_CATALOG_ROLE
GRANT DELETE ON SYS.AUD$ TO DELETE_CATALOG_ROLE;
GRANT DELETE ON SYS.AUD$_MOVED_TO_SYSTEM TO DELETE_CATALOG_ROLE;
GRANT DELETE ON SYS.FGA_LOG$ TO DELETE_CATALOG_ROLE;

-- Grantees of DELETE_CATALOG_ROLE
GRANT DELETE_CATALOG_ROLE TO DBA WITH ADMIN OPTION;
GRANT DELETE_CATALOG_ROLE TO SYS WITH ADMIN OPTION;
DROP ROLE EXP_FULL_DATABASE;

CREATE ROLE EXP_FULL_DATABASE NOT IDENTIFIED;

-- Object privileges granted to EXP_FULL_DATABASE
GRANT READ, WRITE ON DIRECTORY DATA_PUMP_DIR TO EXP_FULL_DATABASE;
GRANT EXECUTE ON SYS.DBMSZEXP_SYSPKGGRNT TO EXP_FULL_DATABASE;
GRANT EXECUTE ON SYS.DBMS_AQ_IMPORT_INTERNAL TO EXP_FULL_DATABASE;
GRANT EXECUTE ON SYS.DBMS_AUTO_TASK_EXPORT TO EXP_FULL_DATABASE;
GRANT EXECUTE ON SYS.DBMS_CDC_IMPDPV TO EXP_FULL_DATABASE;
GRANT EXECUTE ON SYS.DBMS_IJOB TO EXP_FULL_DATABASE;
GRANT EXECUTE ON SYS.DBMS_IREFRESH TO EXP_FULL_DATABASE;
GRANT EXECUTE ON SYS.DBMS_JVM_EXP_PERMS TO EXP_FULL_DATABASE;
GRANT EXECUTE ON SYS.DBMS_PSWMG_IMPORT TO EXP_FULL_DATABASE;
GRANT EXECUTE ON SYS.DBMS_RULE_EXIMP TO EXP_FULL_DATABASE;
GRANT EXECUTE ON SYS.DBMS_TRANSFORM_EXIMP TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS.EXU10LNK TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS.EXU8LNK TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS.EXU8PHS TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS.EXU9LNK TO EXP_FULL_DATABASE;
GRANT DELETE, INSERT, UPDATE ON SYS.INCEXP TO EXP_FULL_DATABASE;
GRANT DELETE, INSERT, UPDATE ON SYS.INCFIL TO EXP_FULL_DATABASE;
GRANT DELETE, INSERT, UPDATE ON SYS.INCVID TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS.KU$_PSW_HIST_LIST_VIEW TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS.KU$_PSW_HIST_VIEW TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_APPLY" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_APPLY_BATCH_SQL_STATS" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_APPLY_CHANGE_HANDLERS" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_APPLY_CONF_HDLR_COLUMNS" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_APPLY_COORDINATOR_STATS" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_APPLY_DML_CONF_COLUMNS" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_APPLY_DML_CONF_HANDLERS" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_APPLY_ERROR" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_APPLY_ERROR_HANDLER" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_APPLY_ERROR_TXN" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_APPLY_HANDLE_COLLISIONS" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_APPLY_MILESTONE" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_APPLY_PROGRESS" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_APPLY_READER_STATS" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_APPLY_REPERROR_HANDLERS" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_APPLY_SERVER_STATS" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_APPLY_SOURCE_OBJ" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_APPLY_SOURCE_SCHEMA" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_APPLY_SPILL_TXN" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_APPLY_TABLE_STATS" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_CAPTURE" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_STREAMS_MESSAGE_CONSUMERS" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_STREAMS_MESSAGE_RULES" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_STREAMS_MSG_NOTIFICATIONS" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_STREAMS_PRIVILEGED_USER" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_STREAMS_RULES" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_STREAMS_RULES_H" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_STREAMS_STMTS" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_STREAMS_TRANSFORMATIONS" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_XSTREAM_CONNECTION" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_XSTREAM_OUTBOUND" TO EXP_FULL_DATABASE;
GRANT SELECT ON SYS."_DBA_XSTREAM_PARAMETERS" TO EXP_FULL_DATABASE;

-- System privileges granted to EXP_FULL_DATABASE
BEGIN
SYS.DBMS_RESOURCE_MANAGER_PRIVS.GRANT_SYSTEM_PRIVILEGE
  (GRANTEE_NAME   => 'EXP_FULL_DATABASE', 
   PRIVILEGE_NAME => 'ADMINISTER_RESOURCE_MANAGER',
   ADMIN_OPTION   => FALSE);
END;
/
GRANT ADMINISTER SQL MANAGEMENT OBJECT TO EXP_FULL_DATABASE;
GRANT BACKUP ANY TABLE TO EXP_FULL_DATABASE;
GRANT CREATE SESSION TO EXP_FULL_DATABASE;
GRANT CREATE TABLE TO EXP_FULL_DATABASE;
GRANT EXECUTE ANY PROCEDURE TO EXP_FULL_DATABASE;
GRANT EXECUTE ANY TYPE TO EXP_FULL_DATABASE;
GRANT READ ANY FILE GROUP TO EXP_FULL_DATABASE;
GRANT RESUMABLE TO EXP_FULL_DATABASE;
GRANT SELECT ANY SEQUENCE TO EXP_FULL_DATABASE;
GRANT SELECT ANY TABLE TO EXP_FULL_DATABASE;

-- Roles granted to EXP_FULL_DATABASE
GRANT EXECUTE_CATALOG_ROLE TO EXP_FULL_DATABASE;
GRANT SELECT_CATALOG_ROLE TO EXP_FULL_DATABASE;

-- Grantees of EXP_FULL_DATABASE
GRANT EXP_FULL_DATABASE TO DATAPUMP_EXP_FULL_DATABASE;
GRANT EXP_FULL_DATABASE TO DATAPUMP_IMP_FULL_DATABASE;
GRANT EXP_FULL_DATABASE TO DBA;
GRANT EXP_FULL_DATABASE TO SYS WITH ADMIN OPTION;
DROP ROLE IMP_FULL_DATABASE;

CREATE ROLE IMP_FULL_DATABASE NOT IDENTIFIED;

-- Object privileges granted to IMP_FULL_DATABASE
GRANT READ, WRITE ON DIRECTORY DATA_PUMP_DIR TO IMP_FULL_DATABASE;
GRANT EXECUTE ON SYS.DBMS_AQADM TO IMP_FULL_DATABASE;
GRANT EXECUTE ON SYS.DBMS_AQ_IMPORT_INTERNAL TO IMP_FULL_DATABASE;
GRANT EXECUTE ON SYS.DBMS_AUTO_TASK_ADMIN TO IMP_FULL_DATABASE;
GRANT EXECUTE ON SYS.DBMS_AUTO_TASK_EXPORT TO IMP_FULL_DATABASE;
GRANT EXECUTE ON SYS.DBMS_CDC_IMPDPV TO IMP_FULL_DATABASE;
GRANT EXECUTE ON SYS.DBMS_IJOB TO IMP_FULL_DATABASE;
GRANT EXECUTE ON SYS.DBMS_IREFRESH TO IMP_FULL_DATABASE;
GRANT EXECUTE ON SYS.DBMS_JVM_EXP_PERMS TO IMP_FULL_DATABASE;
GRANT EXECUTE ON SYS.DBMS_PSWMG_IMPORT TO IMP_FULL_DATABASE;
GRANT EXECUTE ON SYS.DBMS_REDACT TO IMP_FULL_DATABASE;
GRANT EXECUTE ON SYS.DBMS_REPCAT_MIG TO IMP_FULL_DATABASE;
GRANT EXECUTE ON SYS.DBMS_RULE_EXIMP TO IMP_FULL_DATABASE;
GRANT EXECUTE ON SYS.DBMS_SERVER_ALERT TO IMP_FULL_DATABASE;
GRANT EXECUTE ON SYS.DBMS_TRANSFORM_EXIMP TO IMP_FULL_DATABASE;
GRANT DELETE, INSERT, SELECT, UPDATE ON SYS.EXPIMP_TTS_CT$ TO IMP_FULL_DATABASE;
GRANT SELECT ON SYS.KET$_CLIENT_CONFIG TO IMP_FULL_DATABASE;
GRANT UPDATE (FIELD_1) ON SYS.KET$_CLIENT_CONFIG TO IMP_FULL_DATABASE;
GRANT UPDATE (FIELD_2) ON SYS.KET$_CLIENT_CONFIG TO IMP_FULL_DATABASE;
GRANT UPDATE (FIELD_3) ON SYS.KET$_CLIENT_CONFIG TO IMP_FULL_DATABASE;

-- System privileges granted to IMP_FULL_DATABASE
GRANT ADMINISTER DATABASE TRIGGER TO IMP_FULL_DATABASE;
BEGIN
SYS.DBMS_RESOURCE_MANAGER_PRIVS.GRANT_SYSTEM_PRIVILEGE
  (GRANTEE_NAME   => 'IMP_FULL_DATABASE', 
   PRIVILEGE_NAME => 'ADMINISTER_RESOURCE_MANAGER',
   ADMIN_OPTION   => FALSE);
END;
/
GRANT ADMINISTER SQL MANAGEMENT OBJECT TO IMP_FULL_DATABASE;
GRANT ALTER ANY PROCEDURE TO IMP_FULL_DATABASE;
GRANT ALTER ANY TABLE TO IMP_FULL_DATABASE;
GRANT ALTER ANY TRIGGER TO IMP_FULL_DATABASE;
GRANT ALTER ANY TYPE TO IMP_FULL_DATABASE;
GRANT ALTER DATABASE TO IMP_FULL_DATABASE;
GRANT ALTER PROFILE TO IMP_FULL_DATABASE;
GRANT ALTER RESOURCE COST TO IMP_FULL_DATABASE;
GRANT ALTER USER TO IMP_FULL_DATABASE;
GRANT ANALYZE ANY TO IMP_FULL_DATABASE;
GRANT AUDIT ANY TO IMP_FULL_DATABASE;
GRANT AUDIT SYSTEM TO IMP_FULL_DATABASE;
GRANT BECOME USER TO IMP_FULL_DATABASE;
GRANT COMMENT ANY TABLE TO IMP_FULL_DATABASE;
GRANT CREATE ANY CLUSTER TO IMP_FULL_DATABASE;
GRANT CREATE ANY CONTEXT TO IMP_FULL_DATABASE;
GRANT CREATE ANY DIMENSION TO IMP_FULL_DATABASE;
GRANT CREATE ANY DIRECTORY TO IMP_FULL_DATABASE;
GRANT CREATE ANY INDEX TO IMP_FULL_DATABASE;
GRANT CREATE ANY INDEXTYPE TO IMP_FULL_DATABASE;
GRANT CREATE ANY LIBRARY TO IMP_FULL_DATABASE;
GRANT CREATE ANY MATERIALIZED VIEW TO IMP_FULL_DATABASE;
GRANT CREATE ANY OPERATOR TO IMP_FULL_DATABASE;
GRANT CREATE ANY PROCEDURE TO IMP_FULL_DATABASE;
GRANT CREATE ANY SEQUENCE TO IMP_FULL_DATABASE;
GRANT CREATE ANY SQL PROFILE TO IMP_FULL_DATABASE;
GRANT CREATE ANY SYNONYM TO IMP_FULL_DATABASE;
GRANT CREATE ANY TABLE TO IMP_FULL_DATABASE;
GRANT CREATE ANY TRIGGER TO IMP_FULL_DATABASE;
GRANT CREATE ANY TYPE TO IMP_FULL_DATABASE;
GRANT CREATE ANY VIEW TO IMP_FULL_DATABASE;
GRANT CREATE DATABASE LINK TO IMP_FULL_DATABASE;
GRANT CREATE PROFILE TO IMP_FULL_DATABASE;
GRANT CREATE PUBLIC DATABASE LINK TO IMP_FULL_DATABASE;
GRANT CREATE PUBLIC SYNONYM TO IMP_FULL_DATABASE;
GRANT CREATE ROLE TO IMP_FULL_DATABASE;
GRANT CREATE ROLLBACK SEGMENT TO IMP_FULL_DATABASE;
GRANT CREATE SESSION TO IMP_FULL_DATABASE;
GRANT CREATE TABLESPACE TO IMP_FULL_DATABASE;
GRANT CREATE USER TO IMP_FULL_DATABASE;
GRANT DELETE ANY TABLE TO IMP_FULL_DATABASE;
GRANT DROP ANY CLUSTER TO IMP_FULL_DATABASE;
GRANT DROP ANY CONTEXT TO IMP_FULL_DATABASE;
GRANT DROP ANY DIMENSION TO IMP_FULL_DATABASE;
GRANT DROP ANY DIRECTORY TO IMP_FULL_DATABASE;
GRANT DROP ANY INDEX TO IMP_FULL_DATABASE;
GRANT DROP ANY INDEXTYPE TO IMP_FULL_DATABASE;
GRANT DROP ANY LIBRARY TO IMP_FULL_DATABASE;
GRANT DROP ANY MATERIALIZED VIEW TO IMP_FULL_DATABASE;
GRANT DROP ANY OPERATOR TO IMP_FULL_DATABASE;
GRANT DROP ANY OUTLINE TO IMP_FULL_DATABASE;
GRANT DROP ANY PROCEDURE TO IMP_FULL_DATABASE;
GRANT DROP ANY ROLE TO IMP_FULL_DATABASE;
GRANT DROP ANY SEQUENCE TO IMP_FULL_DATABASE;
GRANT DROP ANY SQL PROFILE TO IMP_FULL_DATABASE;
GRANT DROP ANY SYNONYM TO IMP_FULL_DATABASE;
GRANT DROP ANY TABLE TO IMP_FULL_DATABASE;
GRANT DROP ANY TRIGGER TO IMP_FULL_DATABASE;
GRANT DROP ANY TYPE TO IMP_FULL_DATABASE;
GRANT DROP ANY VIEW TO IMP_FULL_DATABASE;
GRANT DROP PROFILE TO IMP_FULL_DATABASE;
GRANT DROP PUBLIC DATABASE LINK TO IMP_FULL_DATABASE;
GRANT DROP PUBLIC SYNONYM TO IMP_FULL_DATABASE;
GRANT DROP ROLLBACK SEGMENT TO IMP_FULL_DATABASE;
GRANT DROP TABLESPACE TO IMP_FULL_DATABASE;
GRANT DROP USER TO IMP_FULL_DATABASE;
GRANT EXECUTE ANY OPERATOR TO IMP_FULL_DATABASE;
GRANT EXECUTE ANY PROCEDURE TO IMP_FULL_DATABASE;
GRANT EXECUTE ANY TYPE TO IMP_FULL_DATABASE;
GRANT GLOBAL QUERY REWRITE TO IMP_FULL_DATABASE;
GRANT GRANT ANY OBJECT PRIVILEGE TO IMP_FULL_DATABASE;
GRANT GRANT ANY PRIVILEGE TO IMP_FULL_DATABASE;
GRANT GRANT ANY ROLE TO IMP_FULL_DATABASE;
GRANT INSERT ANY TABLE TO IMP_FULL_DATABASE;
BEGIN
SYS.DBMS_AQADM.GRANT_SYSTEM_PRIVILEGE (
  PRIVILEGE    => 'MANAGE_ANY',
  GRANTEE      => 'IMP_FULL_DATABASE',
  ADMIN_OPTION => FALSE);
END;
/
GRANT RESUMABLE TO IMP_FULL_DATABASE;
GRANT SELECT ANY TABLE TO IMP_FULL_DATABASE;
GRANT UPDATE ANY TABLE TO IMP_FULL_DATABASE;

-- Roles granted to IMP_FULL_DATABASE
GRANT SELECT_CATALOG_ROLE TO IMP_FULL_DATABASE;
GRANT EXECUTE_CATALOG_ROLE TO IMP_FULL_DATABASE;

-- Grantees of IMP_FULL_DATABASE
GRANT IMP_FULL_DATABASE TO DATAPUMP_IMP_FULL_DATABASE;
GRANT IMP_FULL_DATABASE TO DBA;
GRANT IMP_FULL_DATABASE TO SYS WITH ADMIN OPTION;
DROP ROLE RECOVERY_CATALOG_OWNER;

CREATE ROLE RECOVERY_CATALOG_OWNER NOT IDENTIFIED;

-- System privileges granted to RECOVERY_CATALOG_OWNER
GRANT ALTER SESSION TO RECOVERY_CATALOG_OWNER;
GRANT CREATE CLUSTER TO RECOVERY_CATALOG_OWNER;
GRANT CREATE DATABASE LINK TO RECOVERY_CATALOG_OWNER;
GRANT CREATE PROCEDURE TO RECOVERY_CATALOG_OWNER;
GRANT CREATE SEQUENCE TO RECOVERY_CATALOG_OWNER;
GRANT CREATE SESSION TO RECOVERY_CATALOG_OWNER;
GRANT CREATE SYNONYM TO RECOVERY_CATALOG_OWNER;
GRANT CREATE TABLE TO RECOVERY_CATALOG_OWNER;
GRANT CREATE TRIGGER TO RECOVERY_CATALOG_OWNER;
GRANT CREATE TYPE TO RECOVERY_CATALOG_OWNER;
GRANT CREATE VIEW TO RECOVERY_CATALOG_OWNER;

-- Grantees of RECOVERY_CATALOG_OWNER
GRANT RECOVERY_CATALOG_OWNER TO SYS WITH ADMIN OPTION;
DROP ROLE GATHER_SYSTEM_STATISTICS;

CREATE ROLE GATHER_SYSTEM_STATISTICS NOT IDENTIFIED;

-- Object privileges granted to GATHER_SYSTEM_STATISTICS
GRANT DELETE, INSERT, SELECT, UPDATE ON SYS.AUX_STATS$ TO GATHER_SYSTEM_STATISTICS;

-- Grantees of GATHER_SYSTEM_STATISTICS
GRANT GATHER_SYSTEM_STATISTICS TO AACDBA;
GRANT GATHER_SYSTEM_STATISTICS TO DBA;
GRANT GATHER_SYSTEM_STATISTICS TO SYS WITH ADMIN OPTION;
DROP ROLE LOGSTDBY_ADMINISTRATOR;

CREATE ROLE LOGSTDBY_ADMINISTRATOR NOT IDENTIFIED;

-- Object privileges granted to LOGSTDBY_ADMINISTRATOR
GRANT EXECUTE ON SYS.DBMS_INTERNAL_SAFE_SCN TO LOGSTDBY_ADMINISTRATOR;
GRANT EXECUTE ON SYS.DBMS_LOGSTDBY TO LOGSTDBY_ADMINISTRATOR;

-- System privileges granted to LOGSTDBY_ADMINISTRATOR
GRANT UNLIMITED TABLESPACE TO LOGSTDBY_ADMINISTRATOR;

-- Roles granted to LOGSTDBY_ADMINISTRATOR
GRANT RESOURCE TO LOGSTDBY_ADMINISTRATOR;

-- Grantees of LOGSTDBY_ADMINISTRATOR
GRANT LOGSTDBY_ADMINISTRATOR TO SYS WITH ADMIN OPTION;
DROP ROLE AQ_ADMINISTRATOR_ROLE;

CREATE ROLE AQ_ADMINISTRATOR_ROLE NOT IDENTIFIED;

-- Object privileges granted to AQ_ADMINISTRATOR_ROLE
GRANT SELECT ON SYS.AQ$INTERNET_USERS TO AQ_ADMINISTRATOR_ROLE;
GRANT SELECT ON SYS.AQ$_PROPAGATION_STATUS TO AQ_ADMINISTRATOR_ROLE;
GRANT SELECT ON SYS.DBA_AQ_AGENTS TO AQ_ADMINISTRATOR_ROLE;
GRANT SELECT ON SYS.DBA_AQ_AGENT_PRIVS TO AQ_ADMINISTRATOR_ROLE;
GRANT SELECT ON SYS.DBA_QUEUES TO AQ_ADMINISTRATOR_ROLE;
GRANT SELECT ON SYS.DBA_QUEUE_SCHEDULES TO AQ_ADMINISTRATOR_ROLE;
GRANT SELECT ON SYS.DBA_QUEUE_SUBSCRIBERS TO AQ_ADMINISTRATOR_ROLE;
GRANT SELECT ON SYS.DBA_QUEUE_TABLES TO AQ_ADMINISTRATOR_ROLE;
GRANT SELECT ON SYS.DBA_SUBSCR_REGISTRATIONS TO AQ_ADMINISTRATOR_ROLE;
GRANT EXECUTE ON SYS.DBMS_AQ TO AQ_ADMINISTRATOR_ROLE;
GRANT EXECUTE ON SYS.DBMS_AQADM TO AQ_ADMINISTRATOR_ROLE;
GRANT EXECUTE ON SYS.DBMS_AQELM TO AQ_ADMINISTRATOR_ROLE;
GRANT EXECUTE ON SYS.DBMS_AQIN TO AQ_ADMINISTRATOR_ROLE;
GRANT EXECUTE ON SYS.DBMS_AQJMS_INTERNAL TO AQ_ADMINISTRATOR_ROLE;
GRANT EXECUTE ON SYS.DBMS_AQ_IMPORT_INTERNAL TO AQ_ADMINISTRATOR_ROLE;
GRANT EXECUTE ON SYS.DBMS_RULE_EXIMP TO AQ_ADMINISTRATOR_ROLE;
GRANT EXECUTE ON SYS.DBMS_TRANSFORM TO AQ_ADMINISTRATOR_ROLE;
GRANT SELECT ON SYS.GV_$AQ TO AQ_ADMINISTRATOR_ROLE;
GRANT SELECT ON SYS.V_$AQ TO AQ_ADMINISTRATOR_ROLE;

-- System privileges granted to AQ_ADMINISTRATOR_ROLE
BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.CREATE_EVALUATION_CONTEXT_OBJ,
  GRANTEE      => 'AQ_ADMINISTRATOR_ROLE',
  GRANT_OPTION => TRUE);
END;
/
BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.CREATE_RULE_OBJ,
  GRANTEE      => 'AQ_ADMINISTRATOR_ROLE',
  GRANT_OPTION => TRUE);
END;
/
BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.CREATE_RULE_SET_OBJ,
  GRANTEE      => 'AQ_ADMINISTRATOR_ROLE',
  GRANT_OPTION => TRUE);
END;
/
BEGIN
SYS.DBMS_AQADM.GRANT_SYSTEM_PRIVILEGE (
  PRIVILEGE    => 'DEQUEUE_ANY',
  GRANTEE      => 'AQ_ADMINISTRATOR_ROLE',
  ADMIN_OPTION => TRUE);
END;
/
BEGIN
SYS.DBMS_AQADM.GRANT_SYSTEM_PRIVILEGE (
  PRIVILEGE    => 'ENQUEUE_ANY',
  GRANTEE      => 'AQ_ADMINISTRATOR_ROLE',
  ADMIN_OPTION => TRUE);
END;
/
BEGIN
SYS.DBMS_AQADM.GRANT_SYSTEM_PRIVILEGE (
  PRIVILEGE    => 'MANAGE_ANY',
  GRANTEE      => 'AQ_ADMINISTRATOR_ROLE',
  ADMIN_OPTION => TRUE);
END;
/

-- Grantees of AQ_ADMINISTRATOR_ROLE
GRANT AQ_ADMINISTRATOR_ROLE TO AACDBA WITH ADMIN OPTION;
GRANT AQ_ADMINISTRATOR_ROLE TO SYS WITH ADMIN OPTION;
GRANT AQ_ADMINISTRATOR_ROLE TO SYSTEM WITH ADMIN OPTION;
DROP ROLE AQ_USER_ROLE;

CREATE ROLE AQ_USER_ROLE NOT IDENTIFIED;

-- Object privileges granted to AQ_USER_ROLE
GRANT EXECUTE ON SYS.DBMS_AQ TO AQ_USER_ROLE;
GRANT EXECUTE ON SYS.DBMS_AQIN TO AQ_USER_ROLE;
GRANT EXECUTE ON SYS.DBMS_AQJMS_INTERNAL TO AQ_USER_ROLE;
GRANT EXECUTE ON SYS.DBMS_TRANSFORM TO AQ_USER_ROLE;

-- Grantees of AQ_USER_ROLE
GRANT AQ_USER_ROLE TO SYS WITH ADMIN OPTION;
DROP ROLE GLOBAL_AQ_USER_ROLE;

CREATE ROLE GLOBAL_AQ_USER_ROLE IDENTIFIED GLOBALLY;
DROP ROLE SCHEDULER_ADMIN;

CREATE ROLE SCHEDULER_ADMIN NOT IDENTIFIED;

-- System privileges granted to SCHEDULER_ADMIN
GRANT CREATE ANY JOB TO SCHEDULER_ADMIN WITH ADMIN OPTION;
GRANT CREATE EXTERNAL JOB TO SCHEDULER_ADMIN WITH ADMIN OPTION;
GRANT CREATE JOB TO SCHEDULER_ADMIN WITH ADMIN OPTION;
GRANT EXECUTE ANY CLASS TO SCHEDULER_ADMIN WITH ADMIN OPTION;
GRANT EXECUTE ANY PROGRAM TO SCHEDULER_ADMIN WITH ADMIN OPTION;
GRANT MANAGE SCHEDULER TO SCHEDULER_ADMIN WITH ADMIN OPTION;

-- Grantees of SCHEDULER_ADMIN
GRANT SCHEDULER_ADMIN TO AACDBA;
GRANT SCHEDULER_ADMIN TO DBA WITH ADMIN OPTION;
GRANT SCHEDULER_ADMIN TO SYS WITH ADMIN OPTION;
DROP ROLE HS_ADMIN_ROLE;

CREATE ROLE HS_ADMIN_ROLE NOT IDENTIFIED;

-- Object privileges granted to HS_ADMIN_ROLE
GRANT EXECUTE ON SYS.DBMS_HS TO HS_ADMIN_ROLE;
GRANT SELECT ON SYS.HS_ALL_CAPS TO HS_ADMIN_ROLE;
GRANT SELECT ON SYS.HS_ALL_DD TO HS_ADMIN_ROLE;
GRANT SELECT ON SYS.HS_ALL_INITS TO HS_ADMIN_ROLE;
GRANT SELECT ON SYS.HS_BASE_CAPS TO HS_ADMIN_ROLE;
GRANT SELECT ON SYS.HS_BASE_DD TO HS_ADMIN_ROLE;
GRANT SELECT ON SYS.HS_CLASS_CAPS TO HS_ADMIN_ROLE;
GRANT SELECT ON SYS.HS_CLASS_DD TO HS_ADMIN_ROLE;
GRANT SELECT ON SYS.HS_CLASS_INIT TO HS_ADMIN_ROLE;
GRANT SELECT ON SYS.HS_FDS_CLASS TO HS_ADMIN_ROLE;
GRANT SELECT ON SYS.HS_FDS_CLASS_DATE TO HS_ADMIN_ROLE;
GRANT SELECT ON SYS.HS_FDS_INST TO HS_ADMIN_ROLE;
GRANT SELECT ON SYS.HS_INST_CAPS TO HS_ADMIN_ROLE;
GRANT SELECT ON SYS.HS_INST_DD TO HS_ADMIN_ROLE;
GRANT SELECT ON SYS.HS_INST_INIT TO HS_ADMIN_ROLE;

-- Roles granted to HS_ADMIN_ROLE
GRANT HS_ADMIN_EXECUTE_ROLE TO HS_ADMIN_ROLE;
GRANT HS_ADMIN_SELECT_ROLE TO HS_ADMIN_ROLE;

-- Grantees of HS_ADMIN_ROLE
GRANT HS_ADMIN_ROLE TO EXECUTE_CATALOG_ROLE;
GRANT HS_ADMIN_ROLE TO SELECT_CATALOG_ROLE;
GRANT HS_ADMIN_ROLE TO SYS WITH ADMIN OPTION;
DROP ROLE OEM_ADVISOR;

CREATE ROLE OEM_ADVISOR NOT IDENTIFIED;

-- System privileges granted to OEM_ADVISOR
GRANT ADMINISTER SQL TUNING SET TO OEM_ADVISOR;
GRANT ADVISOR TO OEM_ADVISOR;
GRANT CREATE JOB TO OEM_ADVISOR;

-- Grantees of OEM_ADVISOR
GRANT OEM_ADVISOR TO SYS WITH ADMIN OPTION;
DROP ROLE OEM_MONITOR;

CREATE ROLE OEM_MONITOR NOT IDENTIFIED;

-- Object privileges granted to OEM_MONITOR
GRANT EXECUTE ON DBSNMP.BSLN TO OEM_MONITOR;
GRANT SELECT ON DBSNMP.BSLN_BASELINES TO OEM_MONITOR;
GRANT EXECUTE ON DBSNMP.BSLN_INTERNAL TO OEM_MONITOR;
GRANT SELECT ON DBSNMP.BSLN_METRIC_DEFAULTS TO OEM_MONITOR;
GRANT EXECUTE ON DBSNMP.BSLN_METRIC_SET TO OEM_MONITOR;
GRANT EXECUTE ON DBSNMP.BSLN_METRIC_T TO OEM_MONITOR;
GRANT EXECUTE ON DBSNMP.BSLN_OBSERVATION_SET TO OEM_MONITOR;
GRANT EXECUTE ON DBSNMP.BSLN_OBSERVATION_T TO OEM_MONITOR;
GRANT SELECT ON DBSNMP.BSLN_STATISTICS TO OEM_MONITOR;
GRANT EXECUTE ON DBSNMP.BSLN_STATISTICS_SET TO OEM_MONITOR;
GRANT EXECUTE ON DBSNMP.BSLN_STATISTICS_T TO OEM_MONITOR;
GRANT SELECT ON DBSNMP.BSLN_THRESHOLD_PARAMS TO OEM_MONITOR;
GRANT SELECT ON DBSNMP.BSLN_TIMEGROUPS TO OEM_MONITOR;
GRANT EXECUTE ON DBSNMP.BSLN_VARIANCE_SET TO OEM_MONITOR;
GRANT EXECUTE ON DBSNMP.BSLN_VARIANCE_T TO OEM_MONITOR;
GRANT SELECT ON DBSNMP.MGMT_BASELINE TO OEM_MONITOR;
GRANT SELECT ON DBSNMP.MGMT_BASELINE_SQL TO OEM_MONITOR;
GRANT SELECT ON DBSNMP.MGMT_BSLN_BASELINES TO OEM_MONITOR;
GRANT SELECT ON DBSNMP.MGMT_BSLN_DATASOURCES TO OEM_MONITOR;
GRANT SELECT ON DBSNMP.MGMT_BSLN_INTERVALS TO OEM_MONITOR;
GRANT SELECT ON DBSNMP.MGMT_BSLN_METRICS TO OEM_MONITOR;
GRANT SELECT ON DBSNMP.MGMT_BSLN_STATISTICS TO OEM_MONITOR;
GRANT SELECT ON DBSNMP.MGMT_BSLN_THRESHOLD_PARMS TO OEM_MONITOR;
GRANT SELECT ON DBSNMP.MGMT_HISTORY TO OEM_MONITOR;
GRANT SELECT ON DBSNMP.MGMT_HISTORY_SQL TO OEM_MONITOR;
GRANT SELECT ON DBSNMP.MGMT_LATEST TO OEM_MONITOR;
GRANT SELECT ON DBSNMP.MGMT_LATEST_SQL TO OEM_MONITOR;
GRANT EXECUTE ON DBSNMP.MGMT_RESPONSE TO OEM_MONITOR;
GRANT EXECUTE ON DBSNMP.MGMT_UPDATE_DB_FEATURE_LOG TO OEM_MONITOR;
GRANT EXECUTE ON SYS.DBMS_AQ TO OEM_MONITOR;
GRANT EXECUTE ON SYS.DBMS_AQADM TO OEM_MONITOR;
GRANT EXECUTE ON SYS.DBMS_DRS TO OEM_MONITOR;
GRANT EXECUTE ON SYS.DBMS_MONITOR TO OEM_MONITOR;
GRANT EXECUTE ON SYS.DBMS_SERVER_ALERT TO OEM_MONITOR;
GRANT EXECUTE ON SYS.DBMS_SYSTEM TO OEM_MONITOR;
GRANT EXECUTE ON SYS.DBMS_WORKLOAD_REPOSITORY TO OEM_MONITOR;

-- System privileges granted to OEM_MONITOR
GRANT ADVISOR TO OEM_MONITOR;
GRANT ANALYZE ANY TO OEM_MONITOR;
GRANT ANALYZE ANY DICTIONARY TO OEM_MONITOR;
GRANT CREATE JOB TO OEM_MONITOR;
GRANT CREATE SESSION TO OEM_MONITOR;
BEGIN
SYS.DBMS_AQADM.GRANT_SYSTEM_PRIVILEGE (
  PRIVILEGE    => 'MANAGE_ANY',
  GRANTEE      => 'OEM_MONITOR',
  ADMIN_OPTION => FALSE);
END;
/
GRANT SELECT ANY DICTIONARY TO OEM_MONITOR;

-- Roles granted to OEM_MONITOR
GRANT SELECT_CATALOG_ROLE TO OEM_MONITOR;

-- Grantees of OEM_MONITOR
GRANT OEM_MONITOR TO DBSNMP;
GRANT OEM_MONITOR TO SYS WITH ADMIN OPTION;
DROP ROLE JAVAUSERPRIV;

CREATE ROLE JAVAUSERPRIV NOT IDENTIFIED;

-- Grantees of JAVAUSERPRIV
GRANT JAVAUSERPRIV TO JAVASYSPRIV;
GRANT JAVAUSERPRIV TO SYS WITH ADMIN OPTION;
GRANT JAVAUSERPRIV TO XDB;
DROP ROLE JAVAIDPRIV;

CREATE ROLE JAVAIDPRIV NOT IDENTIFIED;

-- Grantees of JAVAIDPRIV
GRANT JAVAIDPRIV TO SYS WITH ADMIN OPTION;
DROP ROLE JAVASYSPRIV;

CREATE ROLE JAVASYSPRIV NOT IDENTIFIED;

-- Roles granted to JAVASYSPRIV
GRANT JAVAUSERPRIV TO JAVASYSPRIV;

-- Grantees of JAVASYSPRIV
GRANT JAVASYSPRIV TO SYS WITH ADMIN OPTION;
DROP ROLE JAVADEBUGPRIV;

CREATE ROLE JAVADEBUGPRIV NOT IDENTIFIED;

-- System privileges granted to JAVADEBUGPRIV
GRANT DEBUG ANY PROCEDURE TO JAVADEBUGPRIV;
GRANT DEBUG CONNECT SESSION TO JAVADEBUGPRIV;

-- Grantees of JAVADEBUGPRIV
GRANT JAVADEBUGPRIV TO SYS WITH ADMIN OPTION;
DROP ROLE EJBCLIENT;

CREATE ROLE EJBCLIENT NOT IDENTIFIED;

-- Grantees of EJBCLIENT
GRANT EJBCLIENT TO SYS WITH ADMIN OPTION;
DROP ROLE JAVA_ADMIN;

CREATE ROLE JAVA_ADMIN NOT IDENTIFIED;

-- Grantees of JAVA_ADMIN
GRANT JAVA_ADMIN TO DBA;
GRANT JAVA_ADMIN TO SYS WITH ADMIN OPTION;
DROP ROLE JAVA_DEPLOY;

CREATE ROLE JAVA_DEPLOY NOT IDENTIFIED;

-- Grantees of JAVA_DEPLOY
GRANT JAVA_DEPLOY TO DBA;
GRANT JAVA_DEPLOY TO SYS WITH ADMIN OPTION;
DROP ROLE ISCOPE_ROLE;

CREATE ROLE ISCOPE_ROLE NOT IDENTIFIED;

-- Object privileges granted to ISCOPE_ROLE
GRANT SELECT ON SYS.DBA_DATA_FILES TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ACCESS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ACTIVE_INSTANCES TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ACTIVE_SERVICES TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ACTIVE_SESSION_HISTORY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ACTIVE_SESS_POOL_MTH TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ADVISOR_PROGRESS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ALERT_TYPES TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$AQ TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$AQ1 TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ARCHIVE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ARCHIVED_LOG TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ARCHIVE_DEST TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ARCHIVE_DEST_STATUS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ARCHIVE_GAP TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ARCHIVE_PROCESSES TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ASM_ALIAS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ASM_CLIENT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ASM_DISK TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ASM_DISKGROUP TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ASM_DISKGROUP_STAT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ASM_DISK_STAT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ASM_FILE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ASM_OPERATION TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ASM_TEMPLATE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$AW_AGGREGATE_OP TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$AW_ALLOCATE_OP TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$AW_CALC TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$AW_LONGOPS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$AW_OLAP TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$AW_SESSION_INFO TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BACKUP TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_ARCHIVELOG_DETAILS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_ARCHIVELOG_SUMMARY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_ASYNC_IO TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_CONTROLFILE_DETAILS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_CONTROLFILE_SUMMARY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_COPY_DETAILS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_COPY_SUMMARY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_CORRUPTION TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_DATAFILE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_DATAFILE_DETAILS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_DATAFILE_SUMMARY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_DEVICE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_PIECE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_PIECE_DETAILS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_REDOLOG TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_SET TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_SET_DETAILS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_SET_SUMMARY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_SPFILE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_SPFILE_DETAILS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_SPFILE_SUMMARY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BACKUP_SYNC_IO TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BGPROCESS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BH TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BLOCKING_QUIESCE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BLOCK_CHANGE_TRACKING TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BSP TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BUFFERED_PUBLISHERS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BUFFERED_QUEUES TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BUFFERED_SUBSCRIBERS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BUFFER_POOL TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$BUFFER_POOL_STATISTICS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$CIRCUIT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$CLASS_CACHE_TRANSFER TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$CLASS_PING TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$CLIENT_STATS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$CLUSTER_INTERCONNECTS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$CONFIGURED_INTERCONNECTS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$CONTEXT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$CONTROLFILE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$CONTROLFILE_RECORD_SECTION TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$COPY_CORRUPTION TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$CR_BLOCK_SERVER TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$CURRENT_BLOCK_SERVER TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DATABASE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DATABASE_BLOCK_CORRUPTION TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DATABASE_INCARNATION TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DATAFILE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DATAFILE_COPY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DATAFILE_HEADER TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DATAGUARD_CONFIG TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DATAGUARD_STATS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DATAGUARD_STATUS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DATAPUMP_JOB TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DATAPUMP_SESSION TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DBFILE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DBLINK TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DB_CACHE_ADVICE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DB_OBJECT_CACHE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DB_PIPES TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DB_TRANSPORTABLE_PLATFORM TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DELETED_OBJECT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DISPATCHER TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DISPATCHER_CONFIG TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DISPATCHER_RATE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DLM_ALL_LOCKS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DLM_CONVERT_LOCAL TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DLM_CONVERT_REMOTE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DLM_LATCH TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DLM_LOCKS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DLM_MISC TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DLM_RESS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$DLM_TRAFFIC_CONTROLLER TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ENABLEDPRIVS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ENQUEUE_LOCK TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ENQUEUE_STAT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ENQUEUE_STATISTICS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$EVENTMETRIC TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$EVENT_HISTOGRAM TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$EVENT_NAME TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$EXECUTION TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$FAST_START_SERVERS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$FAST_START_TRANSACTIONS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$FILEMETRIC TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$FILEMETRIC_HISTORY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$FILESPACE_USAGE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$FILESTAT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$FILE_CACHE_TRANSFER TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$FILE_HISTOGRAM TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$FILE_PING TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$FIXED_TABLE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$FIXED_VIEW_DEFINITION TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$FLASHBACK_DATABASE_LOG TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$FLASHBACK_DATABASE_LOGFILE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$FLASHBACK_DATABASE_STAT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$FLASH_RECOVERY_AREA_USAGE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$GCSHVMASTER_INFO TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$GCSPFMASTER_INFO TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$GC_ELEMENT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$GC_ELEMENTS_W_COLLISIONS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$GES_BLOCKING_ENQUEUE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$GES_ENQUEUE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$GLOBALCONTEXT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$GLOBAL_BLOCKED_LOCKS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$GLOBAL_TRANSACTION TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$HS_AGENT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$HS_PARAMETER TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$HS_SESSION TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$HVMASTER_INFO TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$INDEXED_FIXED_COLUMN TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$INSTANCE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$INSTANCE_CACHE_TRANSFER TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$INSTANCE_LOG_GROUP TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$INSTANCE_RECOVERY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$JAVAPOOL TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$JAVA_LIBRARY_CACHE_MEMORY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$JAVA_POOL_ADVICE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$KCCDI TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$KCCFE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LATCH TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LATCHHOLDER TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LATCHNAME TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LATCH_CHILDREN TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LATCH_MISSES TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LATCH_PARENT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LIBRARYCACHE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LIBRARY_CACHE_MEMORY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LICENSE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOADISTAT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOADPSTAT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOCK TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOCKED_OBJECT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOCKS_WITH_COLLISIONS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOCK_ACTIVITY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOCK_ELEMENT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOCK_TYPE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOG TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOGFILE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOGHIST TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOGMNR_CALLBACK TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOGMNR_CONTENTS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOGMNR_DICTIONARY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOGMNR_DICTIONARY_LOAD TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOGMNR_LATCH TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOGMNR_LOGFILE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOGMNR_LOGS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOGMNR_PARAMETERS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOGMNR_PROCESS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOGMNR_REGION TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOGMNR_SESSION TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOGMNR_STATS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOGMNR_TRANSACTION TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOGSTDBY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOGSTDBY_PROCESS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOGSTDBY_PROGRESS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOGSTDBY_STATE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOGSTDBY_STATS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOGSTDBY_TRANSACTION TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$LOG_HISTORY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$MANAGED_STANDBY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$MAP_COMP_LIST TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$MAP_ELEMENT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$MAP_EXT_ELEMENT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$MAP_FILE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$MAP_FILE_EXTENT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$MAP_FILE_IO_STACK TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$MAP_LIBRARY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$MAP_SUBELEMENT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$MAX_ACTIVE_SESS_TARGET_MTH TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$METRIC TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$METRICGROUP TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$METRICNAME TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$METRIC_HISTORY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$MTTR_TARGET_ADVICE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$MUTEX_SLEEP TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$MUTEX_SLEEP_HISTORY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$MVREFRESH TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$MYSTAT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$NLS_PARAMETERS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$NLS_VALID_VALUES TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$OBJECT_DEPENDENCY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$OBSOLETE_PARAMETER TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$OFFLINE_RANGE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$OPEN_CURSOR TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$OPTION TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$OSSTAT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PARALLEL_DEGREE_LIMIT_MTH TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PARAMETER TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PARAMETER2 TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PARAMETER_VALID_VALUES TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PGASTAT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PGA_TARGET_ADVICE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PGA_TARGET_ADVICE_HISTOGRAM TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PQ_SESSTAT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PQ_SLAVE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PQ_SYSSTAT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PQ_TQSTAT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PROCESS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PROCESS_MEMORY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PROCESS_MEMORY_DETAIL TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PROCESS_MEMORY_DETAIL_PROG TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PROPAGATION_RECEIVER TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PROPAGATION_SENDER TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PROXY_ARCHIVEDLOG TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PROXY_ARCHIVELOG_DETAILS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PROXY_ARCHIVELOG_SUMMARY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PROXY_COPY_DETAILS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PROXY_COPY_SUMMARY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PROXY_DATAFILE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PWFILE_USERS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PX_BUFFER_ADVICE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PX_PROCESS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PX_PROCESS_SYSSTAT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PX_SESSION TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$PX_SESSTAT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$QUEUE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$QUEUEING_MTH TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RECOVERY_FILE_DEST TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RECOVERY_FILE_STATUS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RECOVERY_LOG TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RECOVERY_PROGRESS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RECOVERY_STATUS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RECOVER_FILE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$REPLPROP TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$REPLQUEUE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$REQDIST TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RESERVED_WORDS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RESOURCE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RESOURCE_LIMIT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RESTORE_POINT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RESUMABLE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RFS_THREAD TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RMAN_BACKUP_JOB_DETAILS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RMAN_BACKUP_SUBJOB_DETAILS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RMAN_BACKUP_TYPE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RMAN_CONFIGURATION TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RMAN_OUTPUT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RMAN_STATUS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ROLLNAME TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ROLLSTAT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ROWCACHE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ROWCACHE_PARENT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$ROWCACHE_SUBORDINATE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RSRC_CONSUMER_GROUP TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RSRC_CONSUMER_GROUP_CPU_MTH TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RSRC_CONS_GROUP_HISTORY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RSRC_PLAN TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RSRC_PLAN_CPU_MTH TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RSRC_PLAN_HISTORY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RSRC_SESSION_INFO TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RULE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RULE_SET TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$RULE_SET_AGGREGATE_STATS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SCHEDULER_RUNNING_JOBS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SEGMENT_STATISTICS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SEGSTAT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SEGSTAT_NAME TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SERVICEMETRIC TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SERVICEMETRIC_HISTORY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SERVICES TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SERVICE_EVENT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SERVICE_STATS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SERVICE_WAIT_CLASS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SERV_MOD_ACT_STATS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SESSION TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SESSION_CONNECT_INFO TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SESSION_CURSOR_CACHE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SESSION_EVENT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SESSION_FIX_CONTROL TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SESSION_LONGOPS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SESSION_OBJECT_CACHE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SESSION_WAIT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SESSION_WAIT_CLASS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SESSION_WAIT_HISTORY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SESSMETRIC TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SESSTAT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SESS_IO TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SESS_TIME_MODEL TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SES_OPTIMIZER_ENV TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SGA TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SGAINFO TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SGASTAT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SGA_CURRENT_RESIZE_OPS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SGA_DYNAMIC_COMPONENTS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SGA_DYNAMIC_FREE_MEMORY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SGA_RESIZE_OPS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SGA_TARGET_ADVICE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SHARED_POOL_ADVICE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SHARED_POOL_RESERVED TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SHARED_SERVER TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SHARED_SERVER_MONITOR TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SORT_SEGMENT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SORT_USAGE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SPPARAMETER TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SQL TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SQLAREA TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SQLAREA_PLAN_HASH TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SQLSTATS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SQLTEXT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SQLTEXT_WITH_NEWLINES TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SQL_BIND_CAPTURE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SQL_BIND_DATA TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SQL_BIND_METADATA TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SQL_CURSOR TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SQL_JOIN_FILTER TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SQL_OPTIMIZER_ENV TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SQL_PLAN TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SQL_PLAN_STATISTICS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SQL_PLAN_STATISTICS_ALL TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SQL_REDIRECTION TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SQL_SHARED_CURSOR TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SQL_SHARED_MEMORY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SQL_WORKAREA TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SQL_WORKAREA_ACTIVE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SQL_WORKAREA_HISTOGRAM TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$STANDBY_LOG TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$STATISTICS_LEVEL TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$STATNAME TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$STREAMS_APPLY_COORDINATOR TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$STREAMS_APPLY_READER TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$STREAMS_APPLY_SERVER TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$STREAMS_CAPTURE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$STREAMS_POOL_ADVICE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$STREAMS_TRANSACTION TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SUBCACHE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SYSAUX_OCCUPANTS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SYSMETRIC TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SYSMETRIC_HISTORY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SYSMETRIC_SUMMARY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SYSSTAT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SYSTEM_CURSOR_CACHE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SYSTEM_EVENT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SYSTEM_FIX_CONTROL TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SYSTEM_PARAMETER TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SYSTEM_PARAMETER2 TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SYSTEM_WAIT_CLASS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SYS_OPTIMIZER_ENV TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$SYS_TIME_MODEL TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$TABLESPACE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$TEMPFILE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$TEMPORARY_LOBS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$TEMPSTAT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$TEMP_CACHE_TRANSFER TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$TEMP_EXTENT_MAP TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$TEMP_EXTENT_POOL TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$TEMP_PING TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$TEMP_SPACE_HEADER TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$THREAD TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$THRESHOLD_TYPES TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$TIMER TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$TIMEZONE_FILE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$TIMEZONE_NAMES TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$TRANSACTION TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$TRANSACTION_ENQUEUE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$TRANSPORTABLE_PLATFORM TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$TSM_SESSIONS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$TYPE_SIZE TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$UNDOSTAT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$UNUSABLE_BACKUPFILE_DETAILS TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$VERSION TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$VPD_POLICY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$WAITCLASSMETRIC TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$WAITCLASSMETRIC_HISTORY TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$WAITSTAT TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$WALLET TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$XML_AUDIT_TRAIL TO ISCOPE_ROLE;
GRANT SELECT ON SYS.V_$_LOCK TO ISCOPE_ROLE;

-- Roles granted to ISCOPE_ROLE
GRANT VA_LOGIN TO ISCOPE_ROLE;

-- Grantees of ISCOPE_ROLE
GRANT ISCOPE_ROLE TO ISCOPE_ORCL;
GRANT ISCOPE_ROLE TO SYS WITH ADMIN OPTION;
DROP ROLE VOA_R;

CREATE ROLE VOA_R NOT IDENTIFIED;

-- Object privileges granted to VOA_R
GRANT SELECT ON VOA.AUTHENTICATION_LEVEL TO VOA_R;
GRANT SELECT ON VOA.AUTHENTICATION_LEVEL_H TO VOA_R;
GRANT SELECT ON VOA.ENROLLMENT_FORM_TYPE TO VOA_R;
GRANT SELECT ON VOA.ENROLLMENT_FORM_TYPE_H TO VOA_R;
GRANT SELECT ON VOA.VOA_ENROLLMENT_APPLICATION TO VOA_R;
GRANT SELECT ON VOA.VOA_ENROLLMENT_APPLICATION_H TO VOA_R;
GRANT SELECT ON VOA.VOA_ENROLLMENT_APP_DATA TO VOA_R;
GRANT SELECT ON VOA.VOA_ENROLLMENT_APP_STATUS TO VOA_R;
GRANT SELECT ON VOA.VOA_ENROLLMENT_APP_STATUS_H TO VOA_R;
GRANT SELECT ON VOA.VOA_RESUBMISSION TO VOA_R;

-- Grantees of VOA_R
GRANT VOA_R TO AACDBA WITH ADMIN OPTION;
GRANT VOA_R TO ADR;
GRANT VOA_R TO EEUSR;
GRANT VOA_R TO LOBR;
GRANT VOA_R TO DNS   CASTER;
GRANT VOA_R TO DNS   PENNYR;
GRANT VOA_R TO DNS   REYESJ;
GRANT VOA_R TO DNS  ALTMI;
GRANT VOA_R TO DNS PASHAA;
GRANT VOA_R TO DNS  KARANP;
GRANT VOA_R TO DNS  ELLISM;
GRANT VOA_R TO DNS  GREENW;
GRANT VOA_R TO DNS  PERKIJ;
GRANT VOA_R TO DNS   FIERRJ;
GRANT VOA_R TO DNS   PARVAV;
GRANT VOA_R TO DNS   ASAFOJ;
GRANT VOA_R TO DNS   BOYETD;
GRANT VOA_R TO DNS   CHAMPP;
GRANT VOA_R TO DNS   CORNED;
GRANT VOA_R TO DNS   GONZAS;
GRANT VOA_R TO DNS   HORNEE;
GRANT VOA_R TO DNS   JACON;
GRANT VOA_R TO DNS   PHIFEG;
GRANT VOA_R TO DNS   SCOTTS;
GRANT VOA_R TO DNS   TIDWG;
GRANT VOA_R TO DNS   VITENG;
GRANT VOA_R TO DNS   WALLASH;
GRANT VOA_R TO DNS   BOYETJ;
GRANT VOA_R TO DNS   GROOMA;
GRANT VOA_R TO DNS   FAULKJ;
GRANT VOA_R TO DNS   INNISJ;
GRANT VOA_R TO DNS   PURSCD;
GRANT VOA_R TO DNS   SCHIEK;
GRANT VOA_R TO DNS   SHEPPL;
GRANT VOA_R TO DNS   SURVES;
GRANT VOA_R TO DNS   ALLENM;
GRANT VOA_R TO DNS   DOR;
GRANT VOA_R TO DNS   FITZGR;
GRANT VOA_R TO DNS   ARCHET;
GRANT VOA_R TO DNS   HOUGAD;
GRANT VOA_R TO DNS   LINDSD;
GRANT VOA_R TO DNS   SHAHA;
GRANT VOA_R TO DNS   SINGHM;
GRANT VOA_R TO DNS   TUH;
GRANT VOA_R TO DNS   WOODC;
GRANT VOA_R TO DNS   CANINB;
GRANT VOA_R TO DNS   LOWRYB;
GRANT VOA_R TO DNS   DHEERA;
GRANT VOA_R TO       CHENY;
GRANT VOA_R TO       HASANM;
GRANT VOA_R TO       VENIGS;
GRANT VOA_R TO DNS   WILLIO;
GRANT VOA_R TO DNS   REENT;
DROP ROLE VOA_RW;

CREATE ROLE VOA_RW NOT IDENTIFIED;

-- Object privileges granted to VOA_RW
GRANT INSERT, SELECT, UPDATE ON VOA.AUTHENTICATION_LEVEL TO VOA_RW;
GRANT INSERT, SELECT, UPDATE ON VOA.AUTHENTICATION_LEVEL_H TO VOA_RW;
GRANT INSERT, SELECT, UPDATE ON VOA.ENROLLMENT_FORM_TYPE TO VOA_RW;
GRANT INSERT, SELECT, UPDATE ON VOA.ENROLLMENT_FORM_TYPE_H TO VOA_RW;
GRANT INSERT, SELECT, UPDATE ON VOA.VOA_ENROLLMENT_APPLICATION TO VOA_RW;
GRANT INSERT, SELECT, UPDATE ON VOA.VOA_ENROLLMENT_APPLICATION_H TO VOA_RW;
GRANT INSERT, SELECT, UPDATE ON VOA.VOA_ENROLLMENT_APP_DATA TO VOA_RW;
GRANT INSERT, SELECT, UPDATE ON VOA.VOA_ENROLLMENT_APP_STATUS TO VOA_RW;
GRANT INSERT, SELECT, UPDATE ON VOA.VOA_ENROLLMENT_APP_STATUS_H TO VOA_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON VOA.VOA_RESUBMISSION TO VOA_RW;

-- Grantees of VOA_RW
GRANT VOA_RW TO AACDBA WITH ADMIN OPTION;
GRANT VOA_RW TO EEUSR;
GRANT VOA_RW TO VOAUSR;
DROP ROLE VOA_SEQ_R;

CREATE ROLE VOA_SEQ_R NOT IDENTIFIED;

-- Object privileges granted to VOA_SEQ_R
GRANT SELECT ON VOA.AUTHENTICATION_LEVEL_H_S TO VOA_SEQ_R;
GRANT SELECT ON VOA.ENROLLMENT_FORM_TYPE_H_S TO VOA_SEQ_R;
GRANT SELECT ON VOA.VOA_ENROLLMENT_APPLICATION_H_S TO VOA_SEQ_R;
GRANT SELECT ON VOA.VOA_ENROLLMENT_APPLICATION_S TO VOA_SEQ_R;
GRANT SELECT ON VOA.VOA_ENROLLMENT_APP_DATA_S TO VOA_SEQ_R;
GRANT SELECT ON VOA.VOA_ENROLLMENT_APP_STATUS_H_S TO VOA_SEQ_R;
GRANT SELECT ON VOA.VOA_RESUBMISSION_S TO VOA_SEQ_R;

-- Grantees of VOA_SEQ_R
GRANT VOA_SEQ_R TO AACDBA WITH ADMIN OPTION;
GRANT VOA_SEQ_R TO EEUSR;
GRANT VOA_SEQ_R TO DNS  ALTMI;
GRANT VOA_SEQ_R TO DNS PASHAA;
GRANT VOA_SEQ_R TO DNS   DOR;
GRANT VOA_SEQ_R TO DNS   FITZGR;
GRANT VOA_SEQ_R TO DNS   LINDSD;
GRANT VOA_SEQ_R TO DNS   SHAHA;
GRANT VOA_SEQ_R TO DNS   SINGHM;
GRANT VOA_SEQ_R TO DNS   TUH;
GRANT VOA_SEQ_R TO DNS   WOODC;
GRANT VOA_SEQ_R TO DNS   CANINB;
GRANT VOA_SEQ_R TO DNS   DHEERA;
GRANT VOA_SEQ_R TO DNS   REENT;
GRANT VOA_SEQ_R TO VOAUSR;
DROP ROLE VOA_ADMIN;

CREATE ROLE VOA_ADMIN NOT IDENTIFIED;

-- System privileges granted to VOA_ADMIN
GRANT ALTER SESSION TO VOA_ADMIN;
GRANT CREATE PROCEDURE TO VOA_ADMIN;
GRANT CREATE SEQUENCE TO VOA_ADMIN;
GRANT CREATE SESSION TO VOA_ADMIN;
GRANT CREATE SYNONYM TO VOA_ADMIN;
GRANT CREATE TABLE TO VOA_ADMIN;
GRANT CREATE TRIGGER TO VOA_ADMIN;
GRANT CREATE TYPE TO VOA_ADMIN;
GRANT CREATE VIEW TO VOA_ADMIN;
GRANT UNLIMITED TABLESPACE TO VOA_ADMIN;

-- Grantees of VOA_ADMIN
GRANT VOA_ADMIN TO AACDBA WITH ADMIN OPTION;
GRANT VOA_ADMIN TO VOA;
DROP ROLE VA_UTIL;

CREATE ROLE VA_UTIL NOT IDENTIFIED;

-- System privileges granted to VA_UTIL
GRANT SELECT ANY DICTIONARY TO VA_UTIL;

-- Roles granted to VA_UTIL
GRANT SELECT_CATALOG_ROLE TO VA_UTIL;

-- Grantees of VA_UTIL
GRANT VA_UTIL TO SYSTEM WITH ADMIN OPTION;
DROP ROLE XDB_WEBSERVICES_OVER_HTTP;

CREATE ROLE XDB_WEBSERVICES_OVER_HTTP NOT IDENTIFIED;

-- Grantees of XDB_WEBSERVICES_OVER_HTTP
GRANT XDB_WEBSERVICES_OVER_HTTP TO SYS WITH ADMIN OPTION;
DROP ROLE ADR_ADMIN;

CREATE ROLE ADR_ADMIN NOT IDENTIFIED;

-- Object privileges granted to ADR_ADMIN
GRANT SELECT ON SYS.ALL_TABLES TO ADR_ADMIN;
GRANT SELECT ON SYS.ALL_TAB_COLS TO ADR_ADMIN;
GRANT SELECT ON SYS.DBA_JOBS TO ADR_ADMIN;
GRANT SELECT ON SYS.DBA_JOBS_RUNNING TO ADR_ADMIN;
GRANT EXECUTE ON SYS.DBMS_JOB TO ADR_ADMIN;
GRANT EXECUTE ON SYS.DBMS_LOCK TO ADR_ADMIN;
GRANT EXECUTE ON SYS.DBMS_OUTPUT TO ADR_ADMIN;
GRANT SELECT ON SYS.V_$DATABASE TO ADR_ADMIN;

-- System privileges granted to ADR_ADMIN
GRANT ALTER SESSION TO ADR_ADMIN;
GRANT CREATE DATABASE LINK TO ADR_ADMIN;
GRANT CREATE MATERIALIZED VIEW TO ADR_ADMIN;
GRANT CREATE PROCEDURE TO ADR_ADMIN;
GRANT CREATE SEQUENCE TO ADR_ADMIN;
GRANT CREATE SESSION TO ADR_ADMIN;
GRANT CREATE SYNONYM TO ADR_ADMIN;
GRANT CREATE TABLE TO ADR_ADMIN;
GRANT CREATE TRIGGER TO ADR_ADMIN;
GRANT CREATE VIEW TO ADR_ADMIN;
GRANT QUERY REWRITE TO ADR_ADMIN;
GRANT SELECT ANY DICTIONARY TO ADR_ADMIN;

-- Grantees of ADR_ADMIN
GRANT ADR_ADMIN TO ADR;
GRANT ADR_ADMIN TO ADRAAP;
GRANT ADR_ADMIN TO ADREXT;
GRANT ADR_ADMIN TO ADRMGT;
GRANT ADR_ADMIN TO ADRREF;
GRANT ADR_ADMIN TO ADRTMP;
GRANT ADR_ADMIN TO EESRV;
GRANT ADR_ADMIN TO LOBR;
GRANT ADR_ADMIN TO PSIM;
GRANT ADR_ADMIN TO SYSTEM WITH ADMIN OPTION;
DROP ROLE ADR_LOGIN;

CREATE ROLE ADR_LOGIN NOT IDENTIFIED;

-- System privileges granted to ADR_LOGIN
GRANT ALTER SESSION TO ADR_LOGIN;
GRANT CREATE SESSION TO ADR_LOGIN;

-- Grantees of ADR_LOGIN
GRANT ADR_LOGIN TO ADREXTUSR;
GRANT ADR_LOGIN TO ADRREFSYNC;
GRANT ADR_LOGIN TO BIZFLOWUSR;
GRANT ADR_LOGIN TO EERPT;
GRANT ADR_LOGIN TO EESRVUSR;
GRANT ADR_LOGIN TO EEUSR;
GRANT ADR_LOGIN TO ESRJMS;
GRANT ADR_LOGIN TO HECUSR;
GRANT ADR_LOGIN TO IAMUSR;
GRANT ADR_LOGIN TO LOBRUSR;
GRANT ADR_LOGIN TO PSIMUSR;
GRANT ADR_LOGIN TO SYSTEM WITH ADMIN OPTION;
DROP ROLE PSIM_R;

CREATE ROLE PSIM_R NOT IDENTIFIED;

-- Object privileges granted to PSIM_R
GRANT SELECT ON PSIM.ADR_ERROR_MESSAGES TO PSIM_R;
GRANT SELECT ON PSIM.ADR_PROCESS_LOG TO PSIM_R;
GRANT EXECUTE ON PSIM.BATCH_SEQ_PRIVS TO PSIM_R;
GRANT EXECUTE ON PSIM.BATCH_TAB_PRIVS TO PSIM_R;
GRANT SELECT ON PSIM.DATAMAN_HIGH_KEY TO PSIM_R;
GRANT SELECT ON PSIM.EVENT TO PSIM_R;
GRANT SELECT ON PSIM.IDM_MESSAGE_LOG TO PSIM_R;
GRANT SELECT ON PSIM.IDM_NOTE_REF TO PSIM_R;
GRANT SELECT ON PSIM.IDM_NOTIFICATION TO PSIM_R;
GRANT SELECT ON PSIM.IDM_NOTIFICATION_GROUP TO PSIM_R;
GRANT SELECT ON PSIM.IDM_STATION_MAP TO PSIM_R;
GRANT SELECT ON PSIM.IMDQ_ACTION TO PSIM_R;
GRANT SELECT ON PSIM.IMDQ_ACTION_REF TO PSIM_R;
GRANT SELECT ON PSIM.IMDQ_EXCEPTION TO PSIM_R;
GRANT SELECT ON PSIM.IMDQ_EXCEPTION_IDS TO PSIM_R;
GRANT SELECT ON PSIM.IMDQ_EXCEPTION_TRAIT TO PSIM_R;
GRANT SELECT ON PSIM.IMDQ_EXCEPTION_TYPE TO PSIM_R;
GRANT SELECT ON PSIM.IMDQ_MEMBER_SITES TO PSIM_R;
GRANT SELECT ON PSIM.IMDQ_MEM_ROLE_REF TO PSIM_R;
GRANT SELECT ON PSIM.IMDQ_ROLE TO PSIM_R;
GRANT SELECT ON PSIM.IMDQ_TASK TO PSIM_R;
GRANT SELECT ON PSIM.IMDQ_TASK_H TO PSIM_R;
GRANT SELECT ON PSIM.IMDQ_TASK_NOTES TO PSIM_R;
GRANT SELECT ON PSIM.IMDQ_TASK_SOI TO PSIM_R;
GRANT SELECT ON PSIM.IMDQ_TASK_VPIDS TO PSIM_R;
GRANT SELECT ON PSIM.IMDQ_TEAM_MEMBER TO PSIM_R;
GRANT EXECUTE ON PSIM.INITLOAD_PSIM_TRAITS_SP TO PSIM_R;
GRANT EXECUTE ON PSIM.INS_ERROR_MESSAGES_SP TO PSIM_R;
GRANT EXECUTE ON PSIM.INS_PROCESS_LOG_SP TO PSIM_R;
GRANT SELECT ON PSIM.PS_ADT_EVENT TO PSIM_R;
GRANT SELECT ON PSIM.PS_CHANGE_TYPE TO PSIM_R;
GRANT SELECT ON PSIM.PS_CORRELATION_CATEGORY TO PSIM_R;
GRANT SELECT ON PSIM.PS_DUPE_POTENTIAL TO PSIM_R;
GRANT SELECT ON PSIM.PS_DUPE_REASON_TYPE TO PSIM_R;
GRANT SELECT ON PSIM.PS_DUPE_RESOLUTION_TYPE TO PSIM_R;
GRANT SELECT ON PSIM.PS_EDIT TO PSIM_R;
GRANT SELECT ON PSIM.PS_EDIT_TYPE TO PSIM_R;
GRANT SELECT ON PSIM.PS_FILE_BASED_ENUM TO PSIM_R;
GRANT SELECT ON PSIM.PS_HIGH_KEY TO PSIM_R;
GRANT SELECT ON PSIM.PS_MESSAGE_LOG TO PSIM_R;
GRANT SELECT ON PSIM.PS_PERSON_ADDRESS TO PSIM_R;
GRANT SELECT ON PSIM.PS_PERSON_ADDRESS_HISTORY TO PSIM_R;
GRANT SELECT ON PSIM.PS_PERSON_ALIAS_LINK TO PSIM_R;
GRANT SELECT ON PSIM.PS_PERSON_CORRELATION TO PSIM_R;
GRANT SELECT ON PSIM.PS_PERSON_NAME TO PSIM_R;
GRANT SELECT ON PSIM.PS_PERSON_NAME_HISTORY TO PSIM_R;
GRANT SELECT ON PSIM.PS_PERSON_NPI TO PSIM_R;
GRANT SELECT ON PSIM.PS_PERSON_NPI_HISTORY TO PSIM_R;
GRANT SELECT ON PSIM.PS_PERSON_PHONE TO PSIM_R;
GRANT SELECT ON PSIM.PS_PERSON_PHONE_HISTORY TO PSIM_R;
GRANT SELECT ON PSIM.PS_PERSON_TRAIT TO PSIM_R;
GRANT SELECT ON PSIM.PS_PERSON_TRAIT_HISTORY TO PSIM_R;
GRANT SELECT ON PSIM.PS_PERSON_VPID TO PSIM_R;
GRANT SELECT ON PSIM.PS_SSN TO PSIM_R;
GRANT SELECT ON PSIM.PS_SSN_HISTORY TO PSIM_R;
GRANT SELECT ON PSIM.PS_SYSTEM_OF_INTEREST_TYPE TO PSIM_R;
GRANT SELECT ON PSIM.PS_VERIFICATION TO PSIM_R;
GRANT SELECT ON PSIM.PS_VERIFICATION_LEVEL_TYPE TO PSIM_R;
GRANT SELECT ON PSIM.PS_VIRTUAL_TABLE_TYPE TO PSIM_R;
GRANT SELECT ON PSIM.PS_VPID_SEQ TO PSIM_R;
GRANT SELECT ON PSIM.QUEUE TO PSIM_R;
GRANT SELECT ON PSIM.RPT_PSIM_TRAITS TO PSIM_R;

-- Grantees of PSIM_R
GRANT PSIM_R TO ADR;
GRANT PSIM_R TO ADRMGT;
GRANT PSIM_R TO BO_USR;
GRANT PSIM_R TO EESRV;
GRANT PSIM_R TO EEUSR;
GRANT PSIM_R TO FSCMB_USR;
GRANT PSIM_R TO HECUSR;
GRANT PSIM_R TO ISCOPE_ORCL;
GRANT PSIM_R TO DNS   CASTER;
GRANT PSIM_R TO DNS   PENNYR;
GRANT PSIM_R TO DNS   REYESJ;
GRANT PSIM_R TO SYSTEM WITH ADMIN OPTION;
GRANT PSIM_R TO DNS  WASSOM;
GRANT PSIM_R TO DNS  ALTMI;
GRANT PSIM_R TO DNS PASHAA;
GRANT PSIM_R TO DNS  MORGAR;
GRANT PSIM_R TO VHA06MARTIK;
GRANT PSIM_R TO DNS   KENNEL;
GRANT PSIM_R TO DNS   HALLT;
GRANT PSIM_R TO DNS  JACOBR;
GRANT PSIM_R TO DNS  JOHNSB;
GRANT PSIM_R TO DNS   BOYETD;
GRANT PSIM_R TO DNS   CHAMPP;
GRANT PSIM_R TO DNS   CORNED;
GRANT PSIM_R TO DNS   JACON;
GRANT PSIM_R TO DNS   JOHNSS;
GRANT PSIM_R TO DNS   PHIFEG;
GRANT PSIM_R TO DNS   SCOTTS;
GRANT PSIM_R TO DNS   TIDWG;
GRANT PSIM_R TO DNS   VITENG;
GRANT PSIM_R TO DNS   WALLASH;
GRANT PSIM_R TO DNS   WILLSC;
GRANT PSIM_R TO DNS   GROOMA;
GRANT PSIM_R TO DNS   WHELEC;
GRANT PSIM_R TO DNS   WOODM;
GRANT PSIM_R TO DNS   FAULKJ;
GRANT PSIM_R TO DNS   INNISJ;
GRANT PSIM_R TO DNS   PURSCD;
GRANT PSIM_R TO DNS   SHEPPL;
GRANT PSIM_R TO DNS   ALLENM;
GRANT PSIM_R TO DNS   DOR;
GRANT PSIM_R TO DNS   FITZGR;
GRANT PSIM_R TO DNS   ARCHET;
GRANT PSIM_R TO DNS   ARNOLN;
GRANT PSIM_R TO DNS   HUANGC;
GRANT PSIM_R TO DNS   LINDSD;
GRANT PSIM_R TO DNS   ROLINL;
GRANT PSIM_R TO DNS   SHAHA;
GRANT PSIM_R TO DNS   SINGHM;
GRANT PSIM_R TO DNS   TUH;
GRANT PSIM_R TO DNS   WOODC;
GRANT PSIM_R TO DNS   CANINB;
GRANT PSIM_R TO DNS   CHEKMM;
GRANT PSIM_R TO DNS   CHINC;
GRANT PSIM_R TO DNS   KOGANI;
GRANT PSIM_R TO DNS   LOPEZD;
GRANT PSIM_R TO DNS   ROCHAD;
GRANT PSIM_R TO DNS   STALLP;
GRANT PSIM_R TO DNS   DHEERA;
GRANT PSIM_R TO       BATESL;
GRANT PSIM_R TO       BOHMEG;
GRANT PSIM_R TO       PRICEW;
GRANT PSIM_R TO DNS         ;
GRANT PSIM_R TO DNS   REENT;
DROP ROLE VA_LOGIN;

CREATE ROLE VA_LOGIN NOT IDENTIFIED;

-- System privileges granted to VA_LOGIN
GRANT ALTER SESSION TO VA_LOGIN;
GRANT CREATE SESSION TO VA_LOGIN;

-- Grantees of VA_LOGIN
GRANT VA_LOGIN TO AACDBA;
GRANT VA_LOGIN TO ACAUSR;
GRANT VA_LOGIN TO ADRMGT;
GRANT VA_LOGIN TO ADRTMP;
GRANT VA_LOGIN TO BENS;
GRANT VA_LOGIN TO BENSUSR;
GRANT VA_LOGIN TO BO_USR;
GRANT VA_LOGIN TO CARUSR;
GRANT VA_LOGIN TO CDWENROLLUSR;
GRANT VA_LOGIN TO CIS;
GRANT VA_LOGIN TO CISUSR;
GRANT VA_LOGIN TO FSCMB_USR;
GRANT VA_LOGIN TO ISCOPE_ORCL;
GRANT VA_LOGIN TO ISCOPE_ROLE;
GRANT VA_LOGIN TO DNS   CASTER;
GRANT VA_LOGIN TO DNS   PARSOS;
GRANT VA_LOGIN TO DNS   PENNYR;
GRANT VA_LOGIN TO DNS   REYESJ;
GRANT VA_LOGIN TO SYS WITH ADMIN OPTION;
GRANT VA_LOGIN TO DNS  WASSOM;
GRANT VA_LOGIN TO DNS BARNAS;
GRANT VA_LOGIN TO DNS  ALTMI;
GRANT VA_LOGIN TO DNS  RAYD1;
GRANT VA_LOGIN TO DNS KAZMIM;
GRANT VA_LOGIN TO DNS MUHAMB;
GRANT VA_LOGIN TO DNS PASHAA;
GRANT VA_LOGIN TO DNS RYALIS;
GRANT VA_LOGIN TO DNS WIEGEL;
GRANT VA_LOGIN TO DNS  KARANP;
GRANT VA_LOGIN TO DNS  MORGAR;
GRANT VA_LOGIN TO DNS  ELLISM;
GRANT VA_LOGIN TO DNS  GREENW;
GRANT VA_LOGIN TO DNS  PERKIJ;
GRANT VA_LOGIN TO VAMQASCAMPOJ2;
GRANT VA_LOGIN TO VETCHOICEUSR;
GRANT VA_LOGIN TO VHA06MARTIK;
GRANT VA_LOGIN TO DNS   KENNEL;
GRANT VA_LOGIN TO DNS   HALLT;
GRANT VA_LOGIN TO DNS  JACOBR;
GRANT VA_LOGIN TO DNS  JOHNSB;
GRANT VA_LOGIN TO DNS   FIERRJ;
GRANT VA_LOGIN TO DNS   PARVAV;
GRANT VA_LOGIN TO DNS   ASAFOJ;
GRANT VA_LOGIN TO DNS   BOYETD;
GRANT VA_LOGIN TO DNS   CHAMPP;
GRANT VA_LOGIN TO DNS   CORNED;
GRANT VA_LOGIN TO DNS   GONZAS;
GRANT VA_LOGIN TO DNS   HORNEE;
GRANT VA_LOGIN TO DNS   HUNTEJ;
GRANT VA_LOGIN TO DNS   JACON;
GRANT VA_LOGIN TO DNS   JOHNSS;
GRANT VA_LOGIN TO DNS   PHIFEG;
GRANT VA_LOGIN TO DNS   SCOTTS;
GRANT VA_LOGIN TO DNS   SIMSB;
GRANT VA_LOGIN TO DNS   TIDWG;
GRANT VA_LOGIN TO DNS   VITENG;
GRANT VA_LOGIN TO DNS   WALLASH;
GRANT VA_LOGIN TO DNS   WILLSC;
GRANT VA_LOGIN TO DNS   BOYETJ;
GRANT VA_LOGIN TO DNS   GROOMA;
GRANT VA_LOGIN TO DNS   WHELEC;
GRANT VA_LOGIN TO DNS   WOODM;
GRANT VA_LOGIN TO DNS   FAULKJ;
GRANT VA_LOGIN TO DNS   INNISJ;
GRANT VA_LOGIN TO DNS   PURSCD;
GRANT VA_LOGIN TO DNS   SCHIEK;
GRANT VA_LOGIN TO DNS   SHEPPL;
GRANT VA_LOGIN TO DNS   SURVES;
GRANT VA_LOGIN TO DNS   ALLENM;
GRANT VA_LOGIN TO DNS   DOR;
GRANT VA_LOGIN TO DNS   FITZGR;
GRANT VA_LOGIN TO DNS   MIKHAA;
GRANT VA_LOGIN TO DNS   ARCHET;
GRANT VA_LOGIN TO DNS   ARNOLN;
GRANT VA_LOGIN TO DNS   HUANGC;
GRANT VA_LOGIN TO DNS   HOUGAD;
GRANT VA_LOGIN TO DNS   LINDSD;
GRANT VA_LOGIN TO DNS   ROLINL;
GRANT VA_LOGIN TO DNS   SHAHA;
GRANT VA_LOGIN TO DNS   SINGHM;
GRANT VA_LOGIN TO DNS   TUH;
GRANT VA_LOGIN TO DNS   WOODC;
GRANT VA_LOGIN TO DNS   CANINB;
GRANT VA_LOGIN TO DNS   CHEKMM;
GRANT VA_LOGIN TO DNS   CHINC;
GRANT VA_LOGIN TO DNS   GABRIA;
GRANT VA_LOGIN TO DNS   KOGANI;
GRANT VA_LOGIN TO DNS   LOPEZD;
GRANT VA_LOGIN TO DNS   LOWRYB;
GRANT VA_LOGIN TO DNS   ROCHAD;
GRANT VA_LOGIN TO DNS   STALLP;
GRANT VA_LOGIN TO DNS   DHEERA;
GRANT VA_LOGIN TO       BATESL;
GRANT VA_LOGIN TO       BOHMEG;
GRANT VA_LOGIN TO       CHENY;
GRANT VA_LOGIN TO       EVERHS;
GRANT VA_LOGIN TO       HALLLI;
GRANT VA_LOGIN TO       HASANM;
GRANT VA_LOGIN TO       PRICEW;
GRANT VA_LOGIN TO       VENIGS;
GRANT VA_LOGIN TO DNS         ;
GRANT VA_LOGIN TO DNS   WILLIO;
GRANT VA_LOGIN TO DNS   REENT;
GRANT VA_LOGIN TO DNS   SAWEIM;
GRANT VA_LOGIN TO VIERSUSR;
GRANT VA_LOGIN TO VOAUSR;
DROP ROLE PSIM_RW;

CREATE ROLE PSIM_RW NOT IDENTIFIED;

-- Object privileges granted to PSIM_RW
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.ADR_ERROR_MESSAGES TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.ADR_PROCESS_LOG TO PSIM_RW;
GRANT EXECUTE ON PSIM.BATCH_SEQ_PRIVS TO PSIM_RW;
GRANT EXECUTE ON PSIM.BATCH_TAB_PRIVS TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.DATAMAN_HIGH_KEY TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.EVENT TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.IDM_MESSAGE_LOG TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.IDM_NOTE_REF TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.IDM_NOTIFICATION TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.IDM_NOTIFICATION_GROUP TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.IDM_STATION_MAP TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.IMDQ_ACTION TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.IMDQ_ACTION_REF TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.IMDQ_EXCEPTION TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.IMDQ_EXCEPTION_IDS TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.IMDQ_EXCEPTION_TRAIT TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.IMDQ_EXCEPTION_TYPE TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.IMDQ_MEMBER_SITES TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.IMDQ_MEM_ROLE_REF TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.IMDQ_ROLE TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.IMDQ_TASK TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.IMDQ_TASK_H TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.IMDQ_TASK_NOTES TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.IMDQ_TASK_SOI TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.IMDQ_TASK_VPIDS TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.IMDQ_TEAM_MEMBER TO PSIM_RW;
GRANT EXECUTE ON PSIM.INITLOAD_PSIM_TRAITS_SP TO PSIM_RW;
GRANT EXECUTE ON PSIM.INS_ERROR_MESSAGES_SP TO PSIM_RW;
GRANT EXECUTE ON PSIM.INS_PROCESS_LOG_SP TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_ADT_EVENT TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_CHANGE_TYPE TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_CORRELATION_CATEGORY TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_DUPE_POTENTIAL TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_DUPE_REASON_TYPE TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_DUPE_RESOLUTION_TYPE TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_EDIT TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_EDIT_TYPE TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_FILE_BASED_ENUM TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_HIGH_KEY TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_MESSAGE_LOG TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_PERSON_ADDRESS TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_PERSON_ADDRESS_HISTORY TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_PERSON_ALIAS_LINK TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_PERSON_CORRELATION TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_PERSON_NAME TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_PERSON_NAME_HISTORY TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_PERSON_NPI TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_PERSON_NPI_HISTORY TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_PERSON_PHONE TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_PERSON_PHONE_HISTORY TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_PERSON_TRAIT TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_PERSON_TRAIT_HISTORY TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_PERSON_VPID TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_SSN TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_SSN_HISTORY TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_SYSTEM_OF_INTEREST_TYPE TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_VERIFICATION TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_VERIFICATION_LEVEL_TYPE TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_VIRTUAL_TABLE_TYPE TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.PS_VPID_SEQ TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.QUEUE TO PSIM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PSIM.RPT_PSIM_TRAITS TO PSIM_RW;

-- Grantees of PSIM_RW
GRANT PSIM_RW TO PSIMUSR;
GRANT PSIM_RW TO SYSTEM WITH ADMIN OPTION;
DROP ROLE PSIM_SEQ_R;

CREATE ROLE PSIM_SEQ_R NOT IDENTIFIED;

-- Object privileges granted to PSIM_SEQ_R
GRANT SELECT ON PSIM.EVENT_ID TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.IDM_MESSAGE_LOG_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.IDM_NOTE_REF_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.IDM_NOTIFICATION_GROUP_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.IDM_NOTIFICATION_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.IDM_STATION_MAP_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.IMDQ_ACTION_REF_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.IMDQ_ACTION_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.IMDQ_EXCEPTION_IDS_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.IMDQ_EXCEPTION_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.IMDQ_EXCEPTION_TRAIT_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.IMDQ_EXCEPTION_TYPE_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.IMDQ_MEMBER_SITES_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.IMDQ_MEM_ROLE_REF_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.IMDQ_ROLE_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.IMDQ_TASK_EXPN_REF_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.IMDQ_TASK_H_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.IMDQ_TASK_NOTES_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.IMDQ_TASK_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.IMDQ_TASK_SOI_REF_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.IMDQ_TASK_TRACKING_NUMBER_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.IMDQ_TASK_VPIDS_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.IMDQ_TEAM_MEMBER_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_ADT_EVENT_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_APPLICATION_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_CATEGORY_TYPE_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_CHANGE_TYPE_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_CORRELATION_CATEGORY_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_DUPE_POTENTIAL_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_DUPE_REASON_TYPE_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_DUPE_RESOLUTION_TYPE_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_EDIT_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_EDIT_TYPE_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_FILE_BASED_ENUM_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_LOG_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_MESSAGE_LOG_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_PERSON_ADDRESS_H_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_PERSON_ADDRESS_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_PERSON_ALIAS_LINK_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_PERSON_CORRELATION_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_PERSON_NAME_HISTORY_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_PERSON_NAME_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_PERSON_NPI_HISTORY_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_PERSON_NPI_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_PERSON_PHONE_HISTORY_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_PERSON_PHONE_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_PERSON_TRAIT_HISTORY_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_PERSON_TRAIT_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_PERSON_VPID_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_SSN_HISTORY_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_SSN_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_SYSTEM_OF_INTEREST_TYPE_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_TOPIC_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_VERIFICATION_LEVEL_TYPE_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_VERIFICATION_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.PS_VIRTUAL_TABLE_TYPE_S TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.QUEUE_ID TO PSIM_SEQ_R;
GRANT SELECT ON PSIM.RPT_PSIM_S TO PSIM_SEQ_R;

-- Grantees of PSIM_SEQ_R
GRANT PSIM_SEQ_R TO ADR;
GRANT PSIM_SEQ_R TO EESRVUSR;
GRANT PSIM_SEQ_R TO PSIMUSR;
GRANT PSIM_SEQ_R TO SYSTEM WITH ADMIN OPTION;
GRANT PSIM_SEQ_R TO DNS   STALLP;
DROP ROLE PSIM_VPID_RW;

CREATE ROLE PSIM_VPID_RW NOT IDENTIFIED;

-- Grantees of PSIM_VPID_RW
GRANT PSIM_VPID_RW TO EEUSR;
GRANT PSIM_VPID_RW TO ISCOPE_ORCL;
GRANT PSIM_VPID_RW TO SYSTEM WITH ADMIN OPTION;
DROP ROLE ADR_R;

CREATE ROLE ADR_R NOT IDENTIFIED;

-- Object privileges granted to ADR_R
GRANT SELECT ON ADR.ACTIVATION TO ADR_R;
GRANT SELECT ON ADR.ACTIVATION_H TO ADR_R;
GRANT SELECT ON ADR.ACTIVEAGG TO ADR_R;
GRANT SELECT ON ADR.ACTIVEAGG_TRACKER TO ADR_R;
GRANT SELECT ON ADR.ACTIVEAGG_VW TO ADR_R;
GRANT SELECT ON ADR.ADDRESS TO ADR_R;
GRANT SELECT ON ADR.ADDRESS_H TO ADR_R;
GRANT SELECT ON ADR.ADDR_CONFIDENTIAL_DTL TO ADR_R;
GRANT SELECT ON ADR.ADDR_CONFIDENTIAL_DTL_H TO ADR_R;
GRANT SELECT ON ADR.ADR_DB_VER TO ADR_R;
GRANT SELECT ON ADR.APP_PARAMETER TO ADR_R;
GRANT SELECT ON ADR.BATCH_REQUEST_FACILITY TO ADR_R;
GRANT SELECT ON ADR.BATCH_REQUEST_FACILITY_H TO ADR_R;
GRANT SELECT ON ADR.BATCH_REQUEST_PRIORITY_GROUP TO ADR_R;
GRANT SELECT ON ADR.BATCH_REQUEST_PRIORITY_GROUP_H TO ADR_R;
GRANT SELECT ON ADR.BENEFICIARY_MST TO ADR_R;
GRANT SELECT ON ADR.BENEFICIARY_MST_H TO ADR_R;
GRANT SELECT ON ADR.BENEFICIARY_NTR TO ADR_R;
GRANT SELECT ON ADR.BENEFICIARY_NTR_H TO ADR_R;
GRANT SELECT ON ADR.BENEFICIARY_SCI TO ADR_R;
GRANT SELECT ON ADR.BENEFICIARY_SCI_H TO ADR_R;
GRANT SELECT ON ADR.BENEFICIARY_TRAVEL TO ADR_R;
GRANT SELECT ON ADR.BENEFICIARY_TRAVEL_H TO ADR_R;
GRANT SELECT ON ADR.BENEFICIARY_VISIT_SUMMARY TO ADR_R;
GRANT SELECT ON ADR.BENEFICIARY_VISIT_SUMMARY_H TO ADR_R;
GRANT SELECT ON ADR.BROKER_SERVICE_ERROR TO ADR_R;
GRANT SELECT ON ADR.BROKER_SERVICE_LOG TO ADR_R;
GRANT SELECT ON ADR.BROKER_SERVICE_PAYLOAD TO ADR_R;
GRANT SELECT ON ADR.CANCEL_DECLINE TO ADR_R;
GRANT SELECT ON ADR.CANCEL_DECLINE_H TO ADR_R;
GRANT SELECT ON ADR.CASSCERTIFIEDTYPE TO ADR_R;
GRANT SELECT ON ADR.CATASTROPHIC_DISABILITY TO ADR_R;
GRANT SELECT ON ADR.CATASTROPHIC_DISABILITY_H TO ADR_R;
GRANT SELECT ON ADR.CAT_DSBLTY_CONDITION TO ADR_R;
GRANT SELECT ON ADR.CAT_DSBLTY_CONDITION_H TO ADR_R;
GRANT SELECT ON ADR.CAT_DSBLTY_DESCRIPTOR TO ADR_R;
GRANT SELECT ON ADR.CAT_DSBLTY_DESCRIPTOR_H TO ADR_R;
GRANT SELECT ON ADR.CAT_DSBLTY_DIAGNOSIS TO ADR_R;
GRANT SELECT ON ADR.CAT_DSBLTY_DIAGNOSIS_H TO ADR_R;
GRANT SELECT ON ADR.CAT_DSBLTY_PROCEDURE TO ADR_R;
GRANT SELECT ON ADR.CAT_DSBLTY_PROCEDURE_H TO ADR_R;
GRANT SELECT ON ADR.CL_VERIFICATION_METHOD TO ADR_R;
GRANT SELECT ON ADR.CL_VERIFICATION_METHOD_H TO ADR_R;
GRANT SELECT ON ADR.COMBAT_EPISODE TO ADR_R;
GRANT SELECT ON ADR.COMBAT_EPISODE_H TO ADR_R;
GRANT SELECT ON ADR.COMBAT_PAY TO ADR_R;
GRANT SELECT ON ADR.COMBAT_PAY_H TO ADR_R;
GRANT SELECT ON ADR.COM_AAC_ERROR_DETAIL TO ADR_R;
GRANT SELECT ON ADR.COM_CANCELED_REQUEST TO ADR_R;
GRANT SELECT ON ADR.COM_EMAIL_TEMPLATE TO ADR_R;
GRANT SELECT ON ADR.COM_FORM_STATISTICS TO ADR_R;
GRANT SELECT ON ADR.COM_HEC_REJECT_DETAIL TO ADR_R;
GRANT SELECT ON ADR.COM_LETTER_TEMPLATE TO ADR_R;
GRANT SELECT ON ADR.COM_MAILING TO ADR_R;
GRANT SELECT ON ADR.COM_MAILING_STATUS_DETAIL TO ADR_R;
GRANT SELECT ON ADR.COM_PRINT_CHECK TO ADR_R;
GRANT SELECT ON ADR.COM_PRINT_REQUEST TO ADR_R;
GRANT SELECT ON ADR.COM_TRANSMISSION_LOG TO ADR_R;
GRANT SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY TO ADR_R;
GRANT SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY_H TO ADR_R;
GRANT SELECT ON ADR.CONFLICT_DETAIL TO ADR_R;
GRANT SELECT ON ADR.CONFLICT_DETAIL_H TO ADR_R;
GRANT SELECT ON ADR.CORRESPONDENCE TO ADR_R;
GRANT SELECT ON ADR.CORRESPONDENCE_DOCUMENT TO ADR_R;
GRANT SELECT ON ADR.CORRESPONDENCE_H TO ADR_R;
GRANT SELECT ON ADR.CORRESPONDENCE_STATUS TO ADR_R;
GRANT SELECT ON ADR.CORRESPONDENCE_TYPE TO ADR_R;
GRANT SELECT ON ADR.DELIVERY_PREFERENCE TO ADR_R;
GRANT SELECT ON ADR.DELIVERY_PREFERENCE_EMAIL TO ADR_R;
GRANT SELECT ON ADR.DELIVERY_PREFERENCE_EMAIL_H TO ADR_R;
GRANT SELECT ON ADR.DELIVERY_PREFERENCE_H TO ADR_R;
GRANT SELECT ON ADR.DEPLOYMENT TO ADR_R;
GRANT SELECT ON ADR.DEPLOYMENT_H TO ADR_R;
GRANT SELECT ON ADR.EGT_SETTING TO ADR_R;
GRANT SELECT ON ADR.EGT_SETTING_H TO ADR_R;
GRANT SELECT ON ADR.EGT_SITE_STATISTICS TO ADR_R;
GRANT SELECT ON ADR.EGT_SITE_STATISTICS_H TO ADR_R;
GRANT SELECT ON ADR.EGT_STATISTICS TO ADR_R;
GRANT SELECT ON ADR.EGT_STATISTICS_H TO ADR_R;
GRANT SELECT ON ADR.ELIGIBILITY_DETERMINATION TO ADR_R;
GRANT SELECT ON ADR.ELIGIBILITY_DETERMINATION_H TO ADR_R;
GRANT SELECT ON ADR.ELIGIBILITY_STATUS_REASON TO ADR_R;
GRANT SELECT ON ADR.ELIGIBILITY_VERIFICATION TO ADR_R;
GRANT SELECT ON ADR.ELIGIBILITY_VERIFICATION_H TO ADR_R;
GRANT SELECT ON ADR.EMAIL TO ADR_R;
GRANT SELECT ON ADR.EMAIL_H TO ADR_R;
GRANT SELECT ON ADR.EMERGENCY_RESPONSE TO ADR_R;
GRANT SELECT ON ADR.EMERGENCY_RESPONSE_H TO ADR_R;
GRANT SELECT ON ADR.EMPLOYMENT TO ADR_R;
GRANT SELECT ON ADR.EMPLOYMENT_H TO ADR_R;
GRANT SELECT ON ADR.ENROLLMENT_DETERMINATION TO ADR_R;
GRANT SELECT ON ADR.ENROLLMENT_DETERMINATION_H TO ADR_R;
GRANT SELECT ON ADR.ENROLLMENT_OVERRIDE TO ADR_R;
GRANT SELECT ON ADR.ENROLLMENT_OVERRIDE_H TO ADR_R;
GRANT SELECT ON ADR.FEE_BASIS TO ADR_R;
GRANT SELECT ON ADR.FEE_BASIS_H TO ADR_R;
GRANT SELECT ON ADR.FINANCIAL_ASSET_DETAIL TO ADR_R;
GRANT SELECT ON ADR.FINANCIAL_ASSET_DETAIL_H TO ADR_R;
GRANT SELECT ON ADR.FINANCIAL_DEBT_DETAIL TO ADR_R;
GRANT SELECT ON ADR.FINANCIAL_DEBT_DETAIL_H TO ADR_R;
GRANT SELECT ON ADR.FINANCIAL_EXPENSE_DETAIL TO ADR_R;
GRANT SELECT ON ADR.FINANCIAL_EXPENSE_DETAIL_H TO ADR_R;
GRANT SELECT ON ADR.FINANCIAL_INCOME_DETAIL TO ADR_R;
GRANT SELECT ON ADR.FINANCIAL_INCOME_DETAIL_H TO ADR_R;
GRANT SELECT ON ADR.FINANCIAL_STATEMENT TO ADR_R;
GRANT SELECT ON ADR.FINANCIAL_STATEMENT_H TO ADR_R;
GRANT SELECT ON ADR.GEOCODE_STAGE TO ADR_R;
GRANT SELECT ON ADR.GEOCODE_STATION TO ADR_R;
GRANT SELECT ON ADR.GEOCODE_TRANSMIT TO ADR_R;
GRANT SELECT ON ADR.GEOCODE_TRANSMIT_ARCHIVE TO ADR_R;
GRANT SELECT ON ADR.HANDBOOK_BATCH_REQUEST TO ADR_R;
GRANT SELECT ON ADR.HANDBOOK_BATCH_REQUEST_H TO ADR_R;
GRANT SELECT ON ADR.HANDBOOK_DOCUMENT TO ADR_R;
GRANT SELECT ON ADR.HANDBOOK_MAIL_QUEUE TO ADR_R;
GRANT SELECT ON ADR.HANDBOOK_MAIL_QUEUE_H TO ADR_R;
GRANT SELECT ON ADR.HANDBOOK_MAIL_STATUS TO ADR_R;
GRANT SELECT ON ADR.HANDBOOK_MAIL_STATUS_H TO ADR_R;
GRANT SELECT ON ADR.HANDBOOK_REQUEST_VETERAN TO ADR_R;
GRANT SELECT ON ADR.HANDBOOK_REQUEST_VETERAN_H TO ADR_R;
GRANT SELECT ON ADR.HEALTH_BENEFITS_APPLICATION TO ADR_R;
GRANT SELECT ON ADR.HEALTH_BENEFITS_APPLICATION_H TO ADR_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN TO ADR_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_DESC TO ADR_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_DESC_H TO ADR_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_DETAIL TO ADR_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_DETAIL_H TO ADR_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_H TO ADR_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_NAME TO ADR_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_NAME_H TO ADR_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PROFILE TO ADR_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PROFILE_H TO ADR_R;
GRANT SELECT ON ADR.HEALTH_CARE_PROVIDER TO ADR_R;
GRANT SELECT ON ADR.HEALTH_CARE_PROVIDER_H TO ADR_R;
GRANT SELECT ON ADR.HL7_ARCHIVE_TRANSACTION_LOG TO ADR_R;
GRANT SELECT ON ADR.HL7_TRANSACTION_LOG TO ADR_R;
GRANT SELECT ON ADR.HL7_TRANSACTION_LOG_SAVE TO ADR_R;
GRANT SELECT ON ADR.INCOME_TEST TO ADR_R;
GRANT SELECT ON ADR.INCOME_TEST_DETAIL TO ADR_R;
GRANT SELECT ON ADR.INCOME_TEST_DETAIL_H TO ADR_R;
GRANT SELECT ON ADR.INCOME_TEST_H TO ADR_R;
GRANT SELECT ON ADR.INCOMPETENT_RULING TO ADR_R;
GRANT SELECT ON ADR.INCOMPETENT_RULING_H TO ADR_R;
GRANT SELECT ON ADR.INELIGIBLE_RULING TO ADR_R;
GRANT SELECT ON ADR.INELIGIBLE_RULING_H TO ADR_R;
GRANT SELECT ON ADR.INSURANCE TO ADR_R;
GRANT SELECT ON ADR.INSURANCE_H TO ADR_R;
GRANT SELECT ON ADR.IN_PROCESS_FINANCIALS TO ADR_R;
GRANT SELECT ON ADR.IRS_TRANSMISSION_DATA TO ADR_R;
GRANT SELECT ON ADR.IRS_TRANSMISSION_LOG TO ADR_R;
GRANT SELECT ON ADR.IRS_TRANSMISSION_LOG_DETAIL TO ADR_R;
GRANT SELECT ON ADR.IVM_MIGRATE TO ADR_R;
GRANT SELECT ON ADR.IVM_MIGRATE_ARCHIVE TO ADR_R;
GRANT SELECT ON ADR.IVM_MIGRATE_EXTRACT TO ADR_R;
GRANT SELECT ON ADR.IVM_MIGRATE_EXTRACT_DETAIL TO ADR_R;
GRANT SELECT ON ADR.IVM_MIGRATE_STATISTICS TO ADR_R;
GRANT SELECT ON ADR.JOB_CONFIG TO ADR_R;
GRANT SELECT ON ADR.JOB_RESULT TO ADR_R;
GRANT SELECT ON ADR.MEC_PERIOD_LAST_HIST_NEW TO ADR_R;
GRANT SELECT ON ADR.MEC_PERIOD_NEW TO ADR_R;
GRANT SELECT ON ADR.MEDAL_OF_HONOR TO ADR_R;
GRANT SELECT ON ADR.MEDAL_OF_HONOR_H TO ADR_R;
GRANT SELECT ON ADR.MEDICAID_FACTOR TO ADR_R;
GRANT SELECT ON ADR.MEDICAID_FACTOR_H TO ADR_R;
GRANT SELECT ON ADR.MILITARY_SERVICE TO ADR_R;
GRANT SELECT ON ADR.MILITARY_SERVICE_EPISODE TO ADR_R;
GRANT SELECT ON ADR.MILITARY_SERVICE_EPISODE_H TO ADR_R;
GRANT SELECT ON ADR.MILITARY_SERVICE_H TO ADR_R;
GRANT SELECT ON ADR.MONETARY_BENEFIT TO ADR_R;
GRANT SELECT ON ADR.MONETARY_BENEFIT_DETAIL TO ADR_R;
GRANT SELECT ON ADR.MONETARY_BENEFIT_DETAIL_H TO ADR_R;
GRANT SELECT ON ADR.MONETARY_BENEFIT_H TO ADR_R;
GRANT SELECT ON ADR.NCOA_ADDRESS_VERIFY_SUMMARY TO ADR_R;
GRANT SELECT ON ADR.PATIENT_PROVIDER_ASSIGNMENT TO ADR_R;
GRANT SELECT ON ADR.PATIENT_PROVIDER_ASSIGNMENT_H TO ADR_R;
GRANT SELECT ON ADR.PENSION TO ADR_R;
GRANT SELECT ON ADR.PENSION_H TO ADR_R;
GRANT SELECT ON ADR.PENSION_REASON TO ADR_R;
GRANT SELECT ON ADR.PERMISSION_SET TO ADR_R;
GRANT SELECT ON ADR.PERMISSION_SET_H TO ADR_R;
GRANT SELECT ON ADR.PERMISSION_SET_PERMISSIONS TO ADR_R;
GRANT SELECT ON ADR.PERMISSION_SET_PERMISSIONS_H TO ADR_R;
GRANT SELECT ON ADR.PERSON TO ADR_R;
GRANT SELECT ON ADR.PERSON_CHANGE_LOG TO ADR_R;
GRANT SELECT ON ADR.PERSON_CONTACT TO ADR_R;
GRANT SELECT ON ADR.PERSON_CONTACT_H TO ADR_R;
GRANT SELECT ON ADR.PERSON_ETHNICITY TO ADR_R;
GRANT SELECT ON ADR.PERSON_ETHNICITY_H TO ADR_R;
GRANT SELECT ON ADR.PERSON_H TO ADR_R;
GRANT SELECT ON ADR.PERSON_MERGE TO ADR_R;
GRANT SELECT ON ADR.PERSON_PREFERRED_LANGUAGE TO ADR_R;
GRANT SELECT ON ADR.PERSON_PREFERRED_LANGUAGE_H TO ADR_R;
GRANT SELECT ON ADR.PERSON_RACE TO ADR_R;
GRANT SELECT ON ADR.PERSON_RACE_H TO ADR_R;
GRANT SELECT ON ADR.PERSON_RELATION TO ADR_R;
GRANT SELECT ON ADR.PERSON_RELATION_H TO ADR_R;
GRANT SELECT ON ADR.PERSON_RELATION_MERGE TO ADR_R;
GRANT SELECT ON ADR.PERSON_RELATION_UNMERGE TO ADR_R;
GRANT SELECT ON ADR.PERSON_UNMERGE TO ADR_R;
GRANT SELECT ON ADR.PHONE TO ADR_R;
GRANT SELECT ON ADR.PHONE_H TO ADR_R;
GRANT SELECT ON ADR.PH_REGISTRY_DETAIL TO ADR_R;
GRANT SELECT ON ADR.PH_REGISTRY_DETAIL_H TO ADR_R;
GRANT SELECT ON ADR.POW_REGISTRY_DETAIL TO ADR_R;
GRANT SELECT ON ADR.POW_REGISTRY_DETAIL_H TO ADR_R;
GRANT SELECT ON ADR.PREFERRED_FACILITY TO ADR_R;
GRANT SELECT ON ADR.PREFERRED_FACILITY_H TO ADR_R;
GRANT SELECT ON ADR.PRISONER_OF_WAR_REGISTRY TO ADR_R;
GRANT SELECT ON ADR.PRISONER_OF_WAR_REGISTRY_H TO ADR_R;
GRANT SELECT ON ADR.PURPLE_HEART_REGISTRY TO ADR_R;
GRANT SELECT ON ADR.PURPLE_HEART_REGISTRY_H TO ADR_R;
GRANT SELECT ON ADR.QRTZ_BLOB_TRIGGERS TO ADR_R;
GRANT SELECT ON ADR.QRTZ_CALENDARS TO ADR_R;
GRANT SELECT ON ADR.QRTZ_CRON_TRIGGERS TO ADR_R;
GRANT SELECT ON ADR.QRTZ_FIRED_TRIGGERS TO ADR_R;
GRANT SELECT ON ADR.QRTZ_JOB_DETAILS TO ADR_R;
GRANT SELECT ON ADR.QRTZ_JOB_LISTENERS TO ADR_R;
GRANT SELECT ON ADR.QRTZ_LOCKS TO ADR_R;
GRANT SELECT ON ADR.QRTZ_PAUSED_TRIGGER_GRPS TO ADR_R;
GRANT SELECT ON ADR.QRTZ_SCHEDULER_STATE TO ADR_R;
GRANT SELECT ON ADR.QRTZ_SIMPLE_TRIGGERS TO ADR_R;
GRANT SELECT ON ADR.QRTZ_TRIGGERS TO ADR_R;
GRANT SELECT ON ADR.QRTZ_TRIGGER_LISTENERS TO ADR_R;
GRANT SELECT ON ADR.RATED_DISABILITY_DETAIL TO ADR_R;
GRANT SELECT ON ADR.RATED_DISABILITY_DETAIL_H TO ADR_R;
GRANT SELECT ON ADR.REGISTRY_LOAD_EXCEPTION TO ADR_R;
GRANT SELECT ON ADR.REGISTRY_LOAD_STATISTICS TO ADR_R;
GRANT SELECT ON ADR.REGISTRY_TRAIT TO ADR_R;
GRANT SELECT ON ADR.REGISTRY_TRAIT_DETAIL TO ADR_R;
GRANT SELECT ON ADR.REGISTRY_TRAIT_DETAIL_H TO ADR_R;
GRANT SELECT ON ADR.REGISTRY_TRAIT_H TO ADR_R;
GRANT SELECT ON ADR.RELAXATION_PERCENTAGE TO ADR_R;
GRANT SELECT ON ADR.RELAXATION_PERCENTAGE_H TO ADR_R;
GRANT SELECT ON ADR.ROLES TO ADR_R;
GRANT SELECT ON ADR.ROLES_H TO ADR_R;
GRANT SELECT ON ADR.ROLE_PERMISSIONS TO ADR_R;
GRANT SELECT ON ADR.ROLE_PERMISSIONS_H TO ADR_R;
GRANT SELECT ON ADR.ROLE_PERMISSION_SETS TO ADR_R;
GRANT SELECT ON ADR.ROLE_PERMISSION_SETS_H TO ADR_R;
GRANT SELECT ON ADR.RPT_CANCEL_DECLINE_REASON TO ADR_R;
GRANT SELECT ON ADR.RPT_COMPLETED_REPORTS TO ADR_R;
GRANT SELECT ON ADR.RPT_COM_ERROR TO ADR_R;
GRANT SELECT ON ADR.RPT_COM_REJECT_REASON TO ADR_R;
GRANT SELECT ON ADR.RPT_DAY_OF_WEEK TO ADR_R;
GRANT SELECT ON ADR.RPT_EED_WEEKLY TO ADR_R;
GRANT SELECT ON ADR.RPT_ELIGIBILITY_FACTOR TO ADR_R;
GRANT SELECT ON ADR.RPT_ENROLLMENT_CATEGORY TO ADR_R;
GRANT SELECT ON ADR.RPT_ENROLLMENT_OVERRIDE TO ADR_R;
GRANT SELECT ON ADR.RPT_ENROLLMENT_STATUS TO ADR_R;
GRANT SELECT ON ADR.RPT_FORM_TYPE TO ADR_R;
GRANT SELECT ON ADR.RPT_INVALID_ADDRESS_REASON TO ADR_R;
GRANT SELECT ON ADR.RPT_LETTER_FILE TO ADR_R;
GRANT SELECT ON ADR.RPT_MESSAGE TO ADR_R;
GRANT SELECT ON ADR.RPT_MESSAGE_ERROR TO ADR_R;
GRANT SELECT ON ADR.RPT_PERMISSIONS TO ADR_R;
GRANT SELECT ON ADR.RPT_PERSON_MERGE_STATUS TO ADR_R;
GRANT SELECT ON ADR.RPT_PH_REJECT_REASON TO ADR_R;
GRANT SELECT ON ADR.RPT_PRIORITY_GROUP TO ADR_R;
GRANT SELECT ON ADR.RPT_QUERY_SITE TO ADR_R;
GRANT SELECT ON ADR.RPT_REGISTRY TO ADR_R;
GRANT SELECT ON ADR.RPT_SCHEDULED_REPORTS TO ADR_R;
GRANT SELECT ON ADR.RPT_SITE TO ADR_R;
GRANT SELECT ON ADR.RPT_STATUS_COMPONENT TO ADR_R;
GRANT SELECT ON ADR.RPT_USERS TO ADR_R;
GRANT SELECT ON ADR.RPT_USER_GROUP TO ADR_R;
GRANT SELECT ON ADR.RPT_VBA_QUERY_STATUS TO ADR_R;
GRANT SELECT ON ADR.RPT_WKF_CASE TO ADR_R;
GRANT SELECT ON ADR.SEEDING TO ADR_R;
GRANT SELECT ON ADR.SELF_IDENTIFIED_GENDER TO ADR_R;
GRANT SELECT ON ADR.SERVICE_CONNECTED TO ADR_R;
GRANT SELECT ON ADR.SERVICE_CONNECTED_H TO ADR_R;
GRANT SELECT ON ADR.SHAD_REGISTRY TO ADR_R;
GRANT SELECT ON ADR.SHAD_REGISTRY_DETAIL TO ADR_R;
GRANT SELECT ON ADR.SHAD_REGISTRY_DETAIL_H TO ADR_R;
GRANT SELECT ON ADR.SHAD_REGISTRY_H TO ADR_R;
GRANT SELECT ON ADR.SIGNATURE_IMAGE TO ADR_R;
GRANT SELECT ON ADR.SIGNATURE_IMAGE_H TO ADR_R;
GRANT SELECT ON ADR.SITE_RECEIVED_ELIGIBILITY TO ADR_R;
GRANT SELECT ON ADR.SITE_RECEIVED_ELIGIBILITY_H TO ADR_R;
GRANT SELECT ON ADR.SITE_RECEIVED_ENROLLMENT TO ADR_R;
GRANT SELECT ON ADR.SITE_RECEIVED_ENROLLMENT_H TO ADR_R;
GRANT SELECT ON ADR.SPECIAL_FACTOR TO ADR_R;
GRANT SELECT ON ADR.SPECIAL_FACTOR_H TO ADR_R;
GRANT SELECT ON ADR.SSN TO ADR_R;
GRANT SELECT ON ADR.SSN_H TO ADR_R;
GRANT SELECT ON ADR.SSN_VERIFICATION TO ADR_R;
GRANT SELECT ON ADR.SSN_VERIFICATION_DETAIL TO ADR_R;
GRANT SELECT ON ADR.SSN_VERIFICATION_EXT TO ADR_R;
GRANT SELECT ON ADR.TRANSMISSION_STATUS TO ADR_R;
GRANT SELECT ON ADR.TRANSMISSION_TYPE TO ADR_R;
GRANT SELECT ON ADR.USERS TO ADR_R;
GRANT SELECT ON ADR.USERS_H TO ADR_R;
GRANT SELECT ON ADR.USER_LOGIN TO ADR_R;
GRANT SELECT ON ADR.USER_LOGIN_H TO ADR_R;
GRANT SELECT ON ADR.USER_PERMISSIONS TO ADR_R;
GRANT SELECT ON ADR.USER_PERMISSIONS_H TO ADR_R;
GRANT SELECT ON ADR.USER_PERMISSION_SETS TO ADR_R;
GRANT SELECT ON ADR.USER_PERMISSION_SETS_H TO ADR_R;
GRANT SELECT ON ADR.USER_ROLES TO ADR_R;
GRANT SELECT ON ADR.USER_ROLES_H TO ADR_R;
GRANT SELECT ON ADR.VA_PERSON_CLASS_DETAIL TO ADR_R;
GRANT SELECT ON ADR.VA_PERSON_CLASS_DETAIL_H TO ADR_R;
GRANT SELECT ON ADR.VA_PERSON_DIVISION_DETAIL TO ADR_R;
GRANT SELECT ON ADR.VA_PERSON_DIVISION_DETAIL_H TO ADR_R;
GRANT SELECT ON ADR.VCADMIN TO ADR_R;
GRANT SELECT ON ADR.VCADMIN_H TO ADR_R;
GRANT SELECT ON ADR.VCADMISTATUS_TYPE TO ADR_R;
GRANT SELECT ON ADR.VCELIGIBILITY TO ADR_R;
GRANT SELECT ON ADR.VCELIGIBILITY_H TO ADR_R;
GRANT SELECT ON ADR.VCESTATUSTYPE TO ADR_R;
GRANT SELECT ON ADR.WAITTIME TO ADR_R;
GRANT SELECT ON ADR.WAITTIME_ARCHIVE TO ADR_R;
GRANT SELECT ON ADR.WAITTIME_STAGE TO ADR_R;
GRANT SELECT ON ADR.WAITTYPE TO ADR_R;
GRANT SELECT ON ADR.WKF_CASE TO ADR_R;
GRANT SELECT ON ADR.WKF_CASE_ASSIGNMENT TO ADR_R;
GRANT SELECT ON ADR.WKF_CASE_ASSIGNMENT_H TO ADR_R;
GRANT SELECT ON ADR.WKF_CASE_COMMENTS TO ADR_R;
GRANT SELECT ON ADR.WKF_CASE_COMMENTS_H TO ADR_R;
GRANT SELECT ON ADR.WKF_CASE_H TO ADR_R;
GRANT SELECT ON ADR.WKF_CASE_STATUS_DETAIL TO ADR_R;
GRANT SELECT ON ADR.WKF_CASE_STATUS_DETAIL_H TO ADR_R;
GRANT SELECT ON ADR.WKF_MESSAGING_CASE TO ADR_R;
GRANT SELECT ON ADR.WKF_MESSAGING_CASE_H TO ADR_R;
GRANT SELECT ON ADRAAP.APPLICATION_IN_PROCESS TO ADR_R;
GRANT SELECT ON ADRAAP.ENROLLMENT_APPLICATION TO ADR_R;
GRANT SELECT ON ADREXT.ADR_DATA_EXTRACT_V TO ADR_R;
GRANT SELECT ON ADREXT.VERIFY_COLMN_DATA_MATRIX TO ADR_R;
GRANT SELECT ON ADRREF.STD_ENROLL_APPLICATION_METHOD TO ADR_R;
GRANT SELECT ON ADRREF.STD_ENROLL_APPLICATION_STATUS TO ADR_R;
GRANT SELECT ON ADRREF.STD_LANGUAGECODE TO ADR_R;
GRANT SELECT ON ADRREF.STD_LANGUAGECODEHISTORY TO ADR_R;
GRANT SELECT ON QUARTZ.QRTZV2_BLOB_TRIGGERS TO ADR_R;
GRANT SELECT ON QUARTZ.QRTZV2_CALENDARS TO ADR_R;
GRANT SELECT ON QUARTZ.QRTZV2_CRON_TRIGGERS TO ADR_R;
GRANT SELECT ON QUARTZ.QRTZV2_FIRED_TRIGGERS TO ADR_R;
GRANT SELECT ON QUARTZ.QRTZV2_JOB_DETAILS TO ADR_R;
GRANT SELECT ON QUARTZ.QRTZV2_LOCKS TO ADR_R;
GRANT SELECT ON QUARTZ.QRTZV2_PAUSED_TRIGGER_GRPS TO ADR_R;
GRANT SELECT ON QUARTZ.QRTZV2_SCHEDULER_STATE TO ADR_R;
GRANT SELECT ON QUARTZ.QRTZV2_SIMPLE_TRIGGERS TO ADR_R;
GRANT SELECT ON QUARTZ.QRTZV2_SIMPROP_TRIGGERS TO ADR_R;
GRANT SELECT ON QUARTZ.QRTZV2_TRIGGERS TO ADR_R;

-- Roles granted to ADR_R
GRANT ADREXT_R TO ADR_R;
GRANT ESRJMS_R TO ADR_R;
GRANT VETCHOICE_R TO ADR_R;

-- Grantees of ADR_R
GRANT ADR_R TO AACDBA;
GRANT ADR_R TO ADREXT;
GRANT ADR_R TO ADRMGT;
GRANT ADR_R TO ADRTMP;
GRANT ADR_R TO BO_USR;
GRANT ADR_R TO CDWENROLLUSR;
GRANT ADR_R TO EERPT;
GRANT ADR_R TO EESRV;
GRANT ADR_R TO EEUSR;
GRANT ADR_R TO FSCMB_USR;
GRANT ADR_R TO HECUSR;
GRANT ADR_R TO ISCOPE_ORCL;
GRANT ADR_R TO DNS   CASTER;
GRANT ADR_R TO DNS   PENNYR;
GRANT ADR_R TO DNS   REYESJ;
GRANT ADR_R TO SYSTEM WITH ADMIN OPTION;
GRANT ADR_R TO DNS  WASSOM;
GRANT ADR_R TO DNS  ALTMI;
GRANT ADR_R TO DNS PASHAA;
GRANT ADR_R TO DNS  KARANP;
GRANT ADR_R TO DNS  MORGAR;
GRANT ADR_R TO DNS  ELLISM;
GRANT ADR_R TO DNS  GREENW;
GRANT ADR_R TO DNS  PERKIJ;
GRANT ADR_R TO VAMQASCAMPOJ2;
GRANT ADR_R TO VHA06MARTIK;
GRANT ADR_R TO DNS   KENNEL;
GRANT ADR_R TO DNS   HALLT;
GRANT ADR_R TO DNS  JACOBR;
GRANT ADR_R TO DNS  JOHNSB;
GRANT ADR_R TO DNS   FIERRJ;
GRANT ADR_R TO DNS   PARVAV;
GRANT ADR_R TO DNS   ASAFOJ;
GRANT ADR_R TO DNS   BOYETD;
GRANT ADR_R TO DNS   CHAMPP;
GRANT ADR_R TO DNS   CORNED;
GRANT ADR_R TO DNS   GONZAS;
GRANT ADR_R TO DNS   HORNEE;
GRANT ADR_R TO DNS   HUNTEJ;
GRANT ADR_R TO DNS   JACON;
GRANT ADR_R TO DNS   JOHNSS;
GRANT ADR_R TO DNS   PHIFEG;
GRANT ADR_R TO DNS   SCOTTS;
GRANT ADR_R TO DNS   SIMSB;
GRANT ADR_R TO DNS   TIDWG;
GRANT ADR_R TO DNS   VITENG;
GRANT ADR_R TO DNS   WALLASH;
GRANT ADR_R TO DNS   WILLSC;
GRANT ADR_R TO DNS   BOYETJ;
GRANT ADR_R TO DNS   GROOMA;
GRANT ADR_R TO DNS   WHELEC;
GRANT ADR_R TO DNS   WOODM;
GRANT ADR_R TO DNS   FAULKJ;
GRANT ADR_R TO DNS   INNISJ;
GRANT ADR_R TO DNS   PURSCD;
GRANT ADR_R TO DNS   SCHIEK;
GRANT ADR_R TO DNS   SHEPPL;
GRANT ADR_R TO DNS   SURVES;
GRANT ADR_R TO DNS   ALLENM;
GRANT ADR_R TO DNS   DOR;
GRANT ADR_R TO DNS   FITZGR;
GRANT ADR_R TO DNS   ARCHET;
GRANT ADR_R TO DNS   ARNOLN;
GRANT ADR_R TO DNS   HUANGC;
GRANT ADR_R TO DNS   HOUGAD;
GRANT ADR_R TO DNS   LINDSD;
GRANT ADR_R TO DNS   ROLINL;
GRANT ADR_R TO DNS   SHAHA;
GRANT ADR_R TO DNS   SINGHM;
GRANT ADR_R TO DNS   TUH;
GRANT ADR_R TO DNS   WOODC;
GRANT ADR_R TO DNS   CANINB;
GRANT ADR_R TO DNS   CHEKMM;
GRANT ADR_R TO DNS   CHINC;
GRANT ADR_R TO DNS   KOGANI;
GRANT ADR_R TO DNS   LOPEZD;
GRANT ADR_R TO DNS   LOWRYB;
GRANT ADR_R TO DNS   ROCHAD;
GRANT ADR_R TO DNS   STALLP;
GRANT ADR_R TO DNS   DHEERA;
GRANT ADR_R TO       BATESL;
GRANT ADR_R TO       BOHMEG;
GRANT ADR_R TO       CHENY;
GRANT ADR_R TO       HASANM;
GRANT ADR_R TO       PRICEW;
GRANT ADR_R TO       VENIGS;
GRANT ADR_R TO DNS         ;
GRANT ADR_R TO DNS   WILLIO;
GRANT ADR_R TO DNS   REENT;
GRANT ADR_R TO DNS   SAWEIM;
GRANT ADR_R TO VOA;
GRANT ADR_R TO VOAUSR;
DROP ROLE ADR_RW;

CREATE ROLE ADR_RW NOT IDENTIFIED;

-- Object privileges granted to ADR_RW
GRANT INSERT, SELECT, UPDATE ON ADR.ACTIVATION TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.ACTIVATION_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ADDRESS TO ADR_RW;
GRANT SELECT ON ADR.ADDRESS_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ADDR_CONFIDENTIAL_DTL TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ADDR_CONFIDENTIAL_DTL_H TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.ADR_DB_VER TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.APP_PARAMETER TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.BATCH_REQUEST_FACILITY TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.BATCH_REQUEST_FACILITY_H TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.BATCH_REQUEST_PRIORITY_GROUP TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.BATCH_REQUEST_PRIORITY_GROUP_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.BENEFICIARY_MST TO ADR_RW;
GRANT SELECT ON ADR.BENEFICIARY_MST_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.BENEFICIARY_NTR TO ADR_RW;
GRANT SELECT ON ADR.BENEFICIARY_NTR_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.BENEFICIARY_SCI TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.BENEFICIARY_SCI_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.BENEFICIARY_TRAVEL TO ADR_RW;
GRANT SELECT ON ADR.BENEFICIARY_TRAVEL_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.BENEFICIARY_VISIT_SUMMARY TO ADR_RW;
GRANT SELECT ON ADR.BENEFICIARY_VISIT_SUMMARY_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.BROKER_SERVICE_ERROR TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.BROKER_SERVICE_LOG TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.BROKER_SERVICE_PAYLOAD TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CANCEL_DECLINE TO ADR_RW;
GRANT SELECT ON ADR.CANCEL_DECLINE_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CASSCERTIFIEDTYPE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CATASTROPHIC_DISABILITY TO ADR_RW;
GRANT SELECT ON ADR.CATASTROPHIC_DISABILITY_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CAT_DSBLTY_CONDITION TO ADR_RW;
GRANT SELECT ON ADR.CAT_DSBLTY_CONDITION_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CAT_DSBLTY_DESCRIPTOR TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CAT_DSBLTY_DESCRIPTOR_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CAT_DSBLTY_DIAGNOSIS TO ADR_RW;
GRANT SELECT ON ADR.CAT_DSBLTY_DIAGNOSIS_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CAT_DSBLTY_PROCEDURE TO ADR_RW;
GRANT SELECT ON ADR.CAT_DSBLTY_PROCEDURE_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CL_VERIFICATION_METHOD TO ADR_RW;
GRANT SELECT ON ADR.CL_VERIFICATION_METHOD_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COMBAT_EPISODE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COMBAT_EPISODE_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COMBAT_PAY TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COMBAT_PAY_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_AAC_ERROR_DETAIL TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_CANCELED_REQUEST TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_EMAIL_TEMPLATE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_FORM_STATISTICS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_HEC_REJECT_DETAIL TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_LETTER_TEMPLATE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_MAILING TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_MAILING_STATUS_DETAIL TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_PRINT_CHECK TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_PRINT_REQUEST TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_TRANSMISSION_LOG TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CONFIDENTIAL_ADDR_CATGRY TO ADR_RW;
GRANT SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CONFLICT_DETAIL TO ADR_RW;
GRANT SELECT ON ADR.CONFLICT_DETAIL_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CORRESPONDENCE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CORRESPONDENCE_DOCUMENT TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CORRESPONDENCE_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CORRESPONDENCE_STATUS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CORRESPONDENCE_TYPE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.DELIVERY_PREFERENCE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.DELIVERY_PREFERENCE_EMAIL TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.DELIVERY_PREFERENCE_EMAIL_H TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.DELIVERY_PREFERENCE_H TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.DEPLOYMENT TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.DEPLOYMENT_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.EGT_SETTING TO ADR_RW;
GRANT SELECT ON ADR.EGT_SETTING_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.EGT_SITE_STATISTICS TO ADR_RW;
GRANT SELECT ON ADR.EGT_SITE_STATISTICS_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.EGT_STATISTICS TO ADR_RW;
GRANT SELECT ON ADR.EGT_STATISTICS_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ELIGIBILITY_DETERMINATION TO ADR_RW;
GRANT SELECT ON ADR.ELIGIBILITY_DETERMINATION_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ELIGIBILITY_STATUS_REASON TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ELIGIBILITY_VERIFICATION TO ADR_RW;
GRANT SELECT ON ADR.ELIGIBILITY_VERIFICATION_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.EMAIL TO ADR_RW;
GRANT SELECT ON ADR.EMAIL_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.EMERGENCY_RESPONSE TO ADR_RW;
GRANT SELECT ON ADR.EMERGENCY_RESPONSE_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.EMPLOYMENT TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.EMPLOYMENT_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ENROLLMENT_DETERMINATION TO ADR_RW;
GRANT SELECT ON ADR.ENROLLMENT_DETERMINATION_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ENROLLMENT_OVERRIDE TO ADR_RW;
GRANT SELECT ON ADR.ENROLLMENT_OVERRIDE_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.FEE_BASIS TO ADR_RW;
GRANT SELECT ON ADR.FEE_BASIS_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.FINANCIAL_ASSET_DETAIL TO ADR_RW;
GRANT SELECT ON ADR.FINANCIAL_ASSET_DETAIL_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.FINANCIAL_DEBT_DETAIL TO ADR_RW;
GRANT SELECT ON ADR.FINANCIAL_DEBT_DETAIL_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.FINANCIAL_EXPENSE_DETAIL TO ADR_RW;
GRANT SELECT ON ADR.FINANCIAL_EXPENSE_DETAIL_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.FINANCIAL_INCOME_DETAIL TO ADR_RW;
GRANT SELECT ON ADR.FINANCIAL_INCOME_DETAIL_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.FINANCIAL_STATEMENT TO ADR_RW;
GRANT SELECT ON ADR.FINANCIAL_STATEMENT_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.GEOCODE_STAGE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.GEOCODE_STATION TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.GEOCODE_TRANSMIT TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.GEOCODE_TRANSMIT_ARCHIVE TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.HANDBOOK_BATCH_REQUEST TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.HANDBOOK_BATCH_REQUEST_H TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.HANDBOOK_DOCUMENT TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.HANDBOOK_MAIL_QUEUE TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.HANDBOOK_MAIL_QUEUE_H TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.HANDBOOK_MAIL_STATUS TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.HANDBOOK_MAIL_STATUS_H TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.HANDBOOK_REQUEST_VETERAN TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.HANDBOOK_REQUEST_VETERAN_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFITS_APPLICATION TO ADR_RW;
GRANT SELECT ON ADR.HEALTH_BENEFITS_APPLICATION_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFIT_PLAN TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFIT_PLAN_DESC TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFIT_PLAN_DESC_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFIT_PLAN_DETAIL TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFIT_PLAN_DETAIL_H TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFIT_PLAN_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFIT_PLAN_NAME TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFIT_PLAN_NAME_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFIT_PROFILE TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFIT_PROFILE_H TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.HEALTH_CARE_PROVIDER TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.HEALTH_CARE_PROVIDER_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HL7_ARCHIVE_TRANSACTION_LOG TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HL7_TRANSACTION_LOG TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HL7_TRANSACTION_LOG_SAVE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.INCOME_TEST TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.INCOME_TEST_DETAIL TO ADR_RW;
GRANT SELECT ON ADR.INCOME_TEST_DETAIL_H TO ADR_RW;
GRANT SELECT ON ADR.INCOME_TEST_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.INCOMPETENT_RULING TO ADR_RW;
GRANT SELECT ON ADR.INCOMPETENT_RULING_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.INELIGIBLE_RULING TO ADR_RW;
GRANT SELECT ON ADR.INELIGIBLE_RULING_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.INSURANCE TO ADR_RW;
GRANT SELECT ON ADR.INSURANCE_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.IN_PROCESS_FINANCIALS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.IRS_TRANSMISSION_DATA TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.IRS_TRANSMISSION_LOG TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.IRS_TRANSMISSION_LOG_DETAIL TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.IVM_MIGRATE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.IVM_MIGRATE_ARCHIVE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.IVM_MIGRATE_EXTRACT TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.IVM_MIGRATE_EXTRACT_DETAIL TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.IVM_MIGRATE_STATISTICS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.JOB_CONFIG TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.JOB_RESULT TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.MEC_PERIOD_LAST_HIST_NEW TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.MEC_PERIOD_NEW TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.MEDAL_OF_HONOR TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.MEDAL_OF_HONOR_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.MEDICAID_FACTOR TO ADR_RW;
GRANT SELECT ON ADR.MEDICAID_FACTOR_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.MILITARY_SERVICE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.MILITARY_SERVICE_EPISODE TO ADR_RW;
GRANT SELECT ON ADR.MILITARY_SERVICE_EPISODE_H TO ADR_RW;
GRANT SELECT ON ADR.MILITARY_SERVICE_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.MONETARY_BENEFIT TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.MONETARY_BENEFIT_DETAIL TO ADR_RW;
GRANT SELECT ON ADR.MONETARY_BENEFIT_DETAIL_H TO ADR_RW;
GRANT SELECT ON ADR.MONETARY_BENEFIT_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.NCOA_ADDRESS_VERIFY_SUMMARY TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.PATIENT_PROVIDER_ASSIGNMENT TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.PATIENT_PROVIDER_ASSIGNMENT_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PENSION TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.PENSION_H TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.PENSION_REASON TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERMISSION_SET TO ADR_RW;
GRANT SELECT ON ADR.PERMISSION_SET_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERMISSION_SET_PERMISSIONS TO ADR_RW;
GRANT SELECT ON ADR.PERMISSION_SET_PERMISSIONS_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON_CHANGE_LOG TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON_CONTACT TO ADR_RW;
GRANT SELECT ON ADR.PERSON_CONTACT_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON_ETHNICITY TO ADR_RW;
GRANT SELECT ON ADR.PERSON_ETHNICITY_H TO ADR_RW;
GRANT SELECT ON ADR.PERSON_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON_MERGE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON_PREFERRED_LANGUAGE TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.PERSON_PREFERRED_LANGUAGE_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON_RACE TO ADR_RW;
GRANT SELECT ON ADR.PERSON_RACE_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON_RELATION TO ADR_RW;
GRANT SELECT ON ADR.PERSON_RELATION_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON_RELATION_MERGE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON_RELATION_UNMERGE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON_UNMERGE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PHONE TO ADR_RW;
GRANT SELECT ON ADR.PHONE_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PH_REGISTRY_DETAIL TO ADR_RW;
GRANT SELECT ON ADR.PH_REGISTRY_DETAIL_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.POW_REGISTRY_DETAIL TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.POW_REGISTRY_DETAIL_H TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.PREFERRED_FACILITY TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.PREFERRED_FACILITY_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PRISONER_OF_WAR_REGISTRY TO ADR_RW;
GRANT SELECT ON ADR.PRISONER_OF_WAR_REGISTRY_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PURPLE_HEART_REGISTRY TO ADR_RW;
GRANT SELECT ON ADR.PURPLE_HEART_REGISTRY_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.QRTZ_BLOB_TRIGGERS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.QRTZ_CALENDARS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.QRTZ_CRON_TRIGGERS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.QRTZ_FIRED_TRIGGERS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.QRTZ_JOB_DETAILS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.QRTZ_JOB_LISTENERS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.QRTZ_LOCKS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.QRTZ_PAUSED_TRIGGER_GRPS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.QRTZ_SCHEDULER_STATE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.QRTZ_SIMPLE_TRIGGERS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.QRTZ_TRIGGERS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.QRTZ_TRIGGER_LISTENERS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RATED_DISABILITY_DETAIL TO ADR_RW;
GRANT SELECT ON ADR.RATED_DISABILITY_DETAIL_H TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.REGISTRY_LOAD_EXCEPTION TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.REGISTRY_LOAD_STATISTICS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.REGISTRY_TRAIT TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.REGISTRY_TRAIT_DETAIL TO ADR_RW;
GRANT SELECT ON ADR.REGISTRY_TRAIT_DETAIL_H TO ADR_RW;
GRANT SELECT ON ADR.REGISTRY_TRAIT_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RELAXATION_PERCENTAGE TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.RELAXATION_PERCENTAGE_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ROLES TO ADR_RW;
GRANT SELECT ON ADR.ROLES_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ROLE_PERMISSIONS TO ADR_RW;
GRANT SELECT ON ADR.ROLE_PERMISSIONS_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ROLE_PERMISSION_SETS TO ADR_RW;
GRANT SELECT ON ADR.ROLE_PERMISSION_SETS_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_CANCEL_DECLINE_REASON TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_COMPLETED_REPORTS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_COM_ERROR TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_COM_REJECT_REASON TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_DAY_OF_WEEK TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_EED_WEEKLY TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_ELIGIBILITY_FACTOR TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_ENROLLMENT_CATEGORY TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_ENROLLMENT_OVERRIDE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_ENROLLMENT_STATUS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_FORM_TYPE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_INVALID_ADDRESS_REASON TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_LETTER_FILE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_MESSAGE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_MESSAGE_ERROR TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_PERMISSIONS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_PERSON_MERGE_STATUS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_PH_REJECT_REASON TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_PRIORITY_GROUP TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_QUERY_SITE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_REGISTRY TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_SCHEDULED_REPORTS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_SITE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_STATUS_COMPONENT TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_USERS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_USER_GROUP TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_VBA_QUERY_STATUS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_WKF_CASE TO ADR_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.SEEDING TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SELF_IDENTIFIED_GENDER TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SERVICE_CONNECTED TO ADR_RW;
GRANT SELECT ON ADR.SERVICE_CONNECTED_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SHAD_REGISTRY TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SHAD_REGISTRY_DETAIL TO ADR_RW;
GRANT SELECT ON ADR.SHAD_REGISTRY_DETAIL_H TO ADR_RW;
GRANT SELECT ON ADR.SHAD_REGISTRY_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SIGNATURE_IMAGE TO ADR_RW;
GRANT SELECT ON ADR.SIGNATURE_IMAGE_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SITE_RECEIVED_ELIGIBILITY TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SITE_RECEIVED_ELIGIBILITY_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SITE_RECEIVED_ENROLLMENT TO ADR_RW;
GRANT SELECT ON ADR.SITE_RECEIVED_ENROLLMENT_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SPECIAL_FACTOR TO ADR_RW;
GRANT SELECT ON ADR.SPECIAL_FACTOR_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SSN TO ADR_RW;
GRANT SELECT ON ADR.SSN_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SSN_VERIFICATION TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SSN_VERIFICATION_DETAIL TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.TRANSMISSION_STATUS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.TRANSMISSION_TYPE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.USERS TO ADR_RW;
GRANT SELECT ON ADR.USERS_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.USER_LOGIN TO ADR_RW;
GRANT SELECT ON ADR.USER_LOGIN_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.USER_PERMISSIONS TO ADR_RW;
GRANT SELECT ON ADR.USER_PERMISSIONS_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.USER_PERMISSION_SETS TO ADR_RW;
GRANT SELECT ON ADR.USER_PERMISSION_SETS_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.USER_ROLES TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.USER_ROLES_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.VA_PERSON_CLASS_DETAIL TO ADR_RW;
GRANT SELECT ON ADR.VA_PERSON_CLASS_DETAIL_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.VA_PERSON_DIVISION_DETAIL TO ADR_RW;
GRANT SELECT ON ADR.VA_PERSON_DIVISION_DETAIL_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.VCADMIN TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.VCADMIN_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.VCADMISTATUS_TYPE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.VCELIGIBILITY TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.VCELIGIBILITY_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.VCESTATUSTYPE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.WAITTIME TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.WAITTIME_ARCHIVE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.WAITTIME_STAGE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.WAITTYPE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.WKF_CASE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.WKF_CASE_ASSIGNMENT TO ADR_RW;
GRANT SELECT ON ADR.WKF_CASE_ASSIGNMENT_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.WKF_CASE_COMMENTS TO ADR_RW;
GRANT SELECT ON ADR.WKF_CASE_COMMENTS_H TO ADR_RW;
GRANT SELECT ON ADR.WKF_CASE_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.WKF_CASE_STATUS_DETAIL TO ADR_RW;
GRANT SELECT ON ADR.WKF_CASE_STATUS_DETAIL_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.WKF_MESSAGING_CASE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.WKF_MESSAGING_CASE_H TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRAAP.APPLICATION_IN_PROCESS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRAAP.ENROLLMENT_APPLICATION TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRREF.STD_ENROLL_APPLICATION_METHOD TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRREF.STD_ENROLL_APPLICATION_STATUS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON QUARTZ.QRTZV2_BLOB_TRIGGERS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON QUARTZ.QRTZV2_CALENDARS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON QUARTZ.QRTZV2_CRON_TRIGGERS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON QUARTZ.QRTZV2_FIRED_TRIGGERS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON QUARTZ.QRTZV2_JOB_DETAILS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON QUARTZ.QRTZV2_LOCKS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON QUARTZ.QRTZV2_PAUSED_TRIGGER_GRPS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON QUARTZ.QRTZV2_SCHEDULER_STATE TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON QUARTZ.QRTZV2_SIMPLE_TRIGGERS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON QUARTZ.QRTZV2_SIMPROP_TRIGGERS TO ADR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON QUARTZ.QRTZV2_TRIGGERS TO ADR_RW;

-- Roles granted to ADR_RW
GRANT VETCHOICE_RW TO ADR_RW;
GRANT ESRJMS_RW TO ADR_RW;

-- Grantees of ADR_RW
GRANT ADR_RW TO ADREXT;
GRANT ADR_RW TO EEUSR;
GRANT ADR_RW TO DNS   CASTER;
GRANT ADR_RW TO DNS   PENNYR;
GRANT ADR_RW TO SYSTEM WITH ADMIN OPTION;
GRANT ADR_RW TO DNS   FAULKJ;
DROP ROLE ADR_SEQ_R;

CREATE ROLE ADR_SEQ_R NOT IDENTIFIED;

-- Object privileges granted to ADR_SEQ_R
GRANT SELECT ON ADR.ACTIVATION_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.CAT_DSBLTY_DESCRIPTOR_H_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.CAT_DSBLTY_DESCRIPTOR_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.CL_VERIFICATION_METHOD_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.COM_MAILING_BARCODE_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.CORRESPONDENCE_DOCUMENT_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.CORRESPONDENCE_H_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.CORRESPONDENCE_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.CORRESPONDENCE_STATUS_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.CORRESPONDENCE_TYPE_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.DELIVERY_PREFERENCE_EMAIL_H_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.DELIVERY_PREFERENCE_EMAIL_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.DELIVERY_PREFERENCE_H_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.DELIVERY_PREFERENCE_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.DEPLOYMENT_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.GEOCODE_STATION_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.GEOCODE_TRANSMIT_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_DESC_H_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_DESC_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_DETAIL_H_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_DETAIL_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_H_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_NAME_H_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_NAME_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PROFILE_H_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PROFILE_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.IRS_TRANSMISSION_DATA_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.IRS_TRANSMISSION_LOG_DETAIL_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.IRS_TRANSMISSION_LOG_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.IVM_MIGRATE_ARCHIVE_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.LOOKUP_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.MEDAL_OF_HONOR_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.PENSION_REASON_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.PENSION_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.PERSON_PREFERRED_LANGUAGE_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.RELAXATION_PERCENTAGE_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.SEEDING_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.SELF_IDENTIFIED_GENDER_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.TRANSACTION_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.TRANSMISSION_STATUS_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.VCADMIN_H_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.VCADMIN_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.VCELIGIBILITY_H_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.VCELIGIBILITY_S TO ADR_SEQ_R;
GRANT SELECT ON ADR.WAITTIME_S TO ADR_SEQ_R;

-- Grantees of ADR_SEQ_R
GRANT ADR_SEQ_R TO ADREXT;
GRANT ADR_SEQ_R TO EERPT;
GRANT ADR_SEQ_R TO EESRVUSR;
GRANT ADR_SEQ_R TO EEUSR;
GRANT ADR_SEQ_R TO IAMUSR;
GRANT ADR_SEQ_R TO ISCOPE_ORCL;
GRANT ADR_SEQ_R TO PSIMUSR;
GRANT ADR_SEQ_R TO SYSTEM WITH ADMIN OPTION;
DROP ROLE ADR_H_SEQ_R;

CREATE ROLE ADR_H_SEQ_R NOT IDENTIFIED;

-- Object privileges granted to ADR_H_SEQ_R
GRANT SELECT ON ADR.ACTIVATION_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.ADDRESS_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.ADDR_CONFIDENTIAL_DTL_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.BATCH_REQUEST_FACILITY_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.BATCH_REQUEST_PRI_GRP_H_ID_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.BENEFICIARY_MST_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.BENEFICIARY_NTR_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.BENEFICIARY_SCI_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.BENEFICIARY_TRAVEL_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.BENEFICIARY_VISIT_SUMMARY_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.CANCEL_DECLINE_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.CATASTROPHIC_DISABILITY_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.CAT_DSBLTY_CONDITION_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.CAT_DSBLTY_DIAGNOSIS_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.CAT_DSBLTY_PROCEDURE_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.CL_VERIFICATION_METHOD_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.COMBAT_EPISODE_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.COMBAT_PAY_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.CONFLICT_DETAIL_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.DEPLOYMENT_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.EGT_SETTING_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.EGT_SITE_STATISTICS_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.EGT_STATISTICS_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.ELIGIBILITY_DETERMINATION_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.ELIGIBILITY_VERIFICATION_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.EMAIL_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.EMERGENCY_RESPONSE_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.EMPLOYMENT_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.ENROLLMENT_DETERMINATION_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.ENROLLMENT_OVERRIDE_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.FEE_BASIS_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.FINANCIAL_ASSET_DETAIL_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.FINANCIAL_DEBT_DETAIL_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.FINANCIAL_EXPENSE_DETAIL_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.FINANCIAL_INCOME_DETAIL_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.FINANCIAL_STATEMENT_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.HANDBOOK_BATCH_REQUEST_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.HANDBOOK_MAIL_QUEUE_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.HANDBOOK_MAIL_STATUS_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.HANDBOOK_REQUEST_VETERAN_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.HEALTH_BENEFITS_APP_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.HEALTH_CARE_PROVIDER_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.INCOME_TEST_DETAIL_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.INCOME_TEST_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.INCOMPETENT_RULING_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.INELIGIBLE_RULING_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.INSURANCE_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.MEDAL_OF_HONOR_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.MEDICAID_FACTOR_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.MILITARY_SERVICE_EPISODE_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.MILITARY_SERVICE_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.MONETARY_BENEFIT_DETAIL_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.MONETARY_BENEFIT_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.PATIENT_PROV_ASSIGN_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.PENSION_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.PERMISSION_SET_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.PERMSSN_SET_PERMSSNS_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.PERSON_CONTACT_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.PERSON_ETHNICITY_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.PERSON_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.PERSON_PREFERRED_LANGUAGE_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.PERSON_RACE_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.PERSON_RELATION_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.PHONE_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.PH_REGISTRY_DETAIL_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.POW_REGISTRY_DETAIL_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.PREFERRED_FACILITY_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.PRISONER_OF_WAR_REGISTRY_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.PURPLE_HEART_REGISTRY_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.RATED_DISABILITY_DETAIL_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.REGISTRY_TRAIT_DETAIL_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.REGISTRY_TRAIT_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.RELAXATION_PERCENTAGE_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.ROLES_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.ROLE_PERMISSIONS_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.ROLE_PERMISSION_SETS_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.SERVICE_CONNECTED_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.SHAD_REGISTRY_DETAIL_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.SHAD_REGISTRY_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.SIGNATURE_IMAGE_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.SITE_RECEIVED_ELIGIBILITY_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.SITE_RECEIVED_ENROLLMENT_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.SPECIAL_FACTOR_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.SSN_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.USERS_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.USER_LOGIN_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.USER_PERMISSIONS_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.USER_PERMISSION_SETS_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.USER_ROLES_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.VA_PERSON_CLASS_DETAIL_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.VA_PERSON_DIVISION_DETAIL_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.WKF_CASE_ASSIGNMENT_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.WKF_CASE_COMMENTS_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.WKF_CASE_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.WKF_CASE_STATUS_DETAIL_H_S TO ADR_H_SEQ_R;
GRANT SELECT ON ADR.WKF_MESSAGING_CASE_H_S TO ADR_H_SEQ_R;

-- Grantees of ADR_H_SEQ_R
GRANT ADR_H_SEQ_R TO EERPT;
GRANT ADR_H_SEQ_R TO SYSTEM WITH ADMIN OPTION;
DROP ROLE XDB_WEBSERVICES;

CREATE ROLE XDB_WEBSERVICES NOT IDENTIFIED;

-- Grantees of XDB_WEBSERVICES
GRANT XDB_WEBSERVICES TO SYS WITH ADMIN OPTION;
DROP ROLE XDB_WEBSERVICES_WITH_PUBLIC;

CREATE ROLE XDB_WEBSERVICES_WITH_PUBLIC NOT IDENTIFIED;

-- Grantees of XDB_WEBSERVICES_WITH_PUBLIC
GRANT XDB_WEBSERVICES_WITH_PUBLIC TO SYS WITH ADMIN OPTION;
DROP ROLE EE_V_R;

CREATE ROLE EE_V_R NOT IDENTIFIED;

-- Object privileges granted to EE_V_R
GRANT SELECT ON EEUSR.ACK_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.ADDRESS_CHANGE_SRC_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.ADDRESS_INVALID_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.AFFECTED_EXTREMITY_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.AGENT_ORANGE_LOCATION_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.ALLIED_COUNTRY_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.APP_PARAMETER_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.APP_PARAMETER_UNIT TO EE_V_R;
GRANT SELECT ON EEUSR.CANCEL_DECLINE_REASON_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.CANCEL_DECLINE_STATUS_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.CAT_DSBLTY_EVAL_MTHD_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.CL_SOURCE_OF_CHANGE TO EE_V_R;
GRANT SELECT ON EEUSR.CL_VERIFICATION_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.COLLECTION_METHOD_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.COM_AAC_ERROR_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.COM_AAC_REJECT_REASON_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.COM_LETTER_GENERATED_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.COM_LETTER_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.COM_MAILING_STATUS_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.COM_MAILING_TRIGGER_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.CONDITION_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.CONFIDENTIAL_ADDR_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.DEATH_NOTIFICATION_SRC_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.DIAGNOSIS_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.DIAGNOSTIC_EXTREMITY_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.EGT_STATUS_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.EGT_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.ELGBTY_STATUS_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.ELGBTY_VRFN_SOURCE_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.ELIGIBILITY_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.EMAIL_CHANGE_SOURCE_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.EMAIL_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.EMPLOYMENT_STATUS_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.ENROLLMENT_DATA_SRC_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.FEDERAL_AGENCY_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.FEE_BASIS_PROGRAM_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.FEE_BASIS_TREATMENT_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.FILIPINO_VET_DOC_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.FINANCIAL_ASSET_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.FINANCIAL_EXPENSE_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.FINANCIAL_INCOME_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.FIN_STMT_MAPPING_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.GMT_INCOME_THRESHOLD TO EE_V_R;
GRANT SELECT ON EEUSR.HL7_MESSAGE_STATUS_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.HLTH_BENEFIT_PLAN_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.INCOME_TEST_SRC_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.INCOME_TEST_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.INCOME_THRESHOLD TO EE_V_R;
GRANT SELECT ON EEUSR.INSURANCE_MAPPING_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.INSURANCE_PLAN_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.INSURANCE_RPT_SRC_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.IVM_MIGRATE_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.LANGUAGE_CODE TO EE_V_R;
GRANT SELECT ON EEUSR.MEANS_TEST_STATUS_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.MESSAGE_TRANSMISSION_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.MONETARY_BENEFIT_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.MST_STATUS_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.MT_NOT_REQD_RSN_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.NCOA_DELIVERY_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.NCOA_STATUS_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.NCOA_ZIP_MATCH_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.NCOA_ZIP_NO_MATCH_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.NTR_VERIFY_METHOD_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.PERMISSION_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.PERSON_CONTACT_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.PERSON_RELATION_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.PHONE_CHANGE_SOURCE_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.PHONE_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.PH_DATA_SOURCE_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.PH_DOCUMENT_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.PH_STATUS_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.POLICY_HOLDER_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.POW_CONFINE_LOCN_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.POW_DATA_SOURCE_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.POW_DOCUMENT_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.PRIORITY_GROUP_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.PRIORITY_SUB_GROUP_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.PROCEDURE_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.PRSN_RELATION_MAPPING_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.PSEUDO_SSN_REASON_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.RADIATION_EXP_METHOD_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.REGISTRY_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.RPT_DAY_OF_MONTH_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.RPT_DAY_OF_QUARTER_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.RPT_DAY_OF_WEEK_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.RPT_DETAIL_BY_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.RPT_DETAIL_FOR_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.RPT_DIVISION_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.RPT_EED_WEEKLY_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.RPT_EXCEPTION_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.RPT_LETTER_FILE_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.RPT_MONTH_LIST_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.RPT_OUTPUT_FILE_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.RPT_OUTPUT_FORMAT_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.RPT_PERIOD_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.RPT_QUARTER_LIST_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.RPT_RUN_FREQUENCY_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.RPT_SCHEDULE_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.RPT_SITE_DISPLAY_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.RPT_STANDARD_REPORTS TO EE_V_R;
GRANT SELECT ON EEUSR.RPT_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.RPT_WEEK_OF_MONTH_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.RPT_WORK_ITEM_STATUS_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.SENSITIVITY_CHG_SRC_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.SERVICE_BRANCH_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.SERVICE_DISCHARGE_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.SHAD_DOCUMENT_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.SIGNATURE_INDICATOR_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.SITE_NO_UPLOAD_REASON_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.SITE_UPLOAD_STATUS_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.SPCL_FACTOR_MAPPING_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.SSA_MESSAGE_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.SSN_CHANGE_SOURCE_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.SSN_VRFN_STATUS_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.USER_GROUP_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.VBA_QUERY_STATUS_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.WKF_CASE_ACTIVITY_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.WKF_CASE_REQUEST_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.WKF_CASE_STATUS_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.WKF_CASE_TYPE TO EE_V_R;
GRANT SELECT ON EEUSR.WKF_ISSUE_TYPE TO EE_V_R;

-- Grantees of EE_V_R
GRANT EE_V_R TO AACDBA;
GRANT EE_V_R TO ADRMGT;
GRANT EE_V_R TO BO_USR;
GRANT EE_V_R TO DNS   CASTER;
GRANT EE_V_R TO DNS   PENNYR;
GRANT EE_V_R TO DNS   REYESJ;
GRANT EE_V_R TO SYSTEM WITH ADMIN OPTION;
GRANT EE_V_R TO DNS  WASSOM;
GRANT EE_V_R TO DNS  ALTMI;
GRANT EE_V_R TO DNS PASHAA;
GRANT EE_V_R TO DNS  KARANP;
GRANT EE_V_R TO DNS  MORGAR;
GRANT EE_V_R TO VAMQASCAMPOJ2;
GRANT EE_V_R TO VHA06MARTIK;
GRANT EE_V_R TO DNS   KENNEL;
GRANT EE_V_R TO DNS   HALLT;
GRANT EE_V_R TO DNS  JACOBR;
GRANT EE_V_R TO DNS  JOHNSB;
GRANT EE_V_R TO DNS   FIERRJ;
GRANT EE_V_R TO DNS   PARVAV;
GRANT EE_V_R TO DNS   ASAFOJ;
GRANT EE_V_R TO DNS   BOYETD;
GRANT EE_V_R TO DNS   CHAMPP;
GRANT EE_V_R TO DNS   CORNED;
GRANT EE_V_R TO DNS   GONZAS;
GRANT EE_V_R TO DNS   HORNEE;
GRANT EE_V_R TO DNS   HUNTEJ;
GRANT EE_V_R TO DNS   JACON;
GRANT EE_V_R TO DNS   JOHNSS;
GRANT EE_V_R TO DNS   PHIFEG;
GRANT EE_V_R TO DNS   SCOTTS;
GRANT EE_V_R TO DNS   SIMSB;
GRANT EE_V_R TO DNS   TIDWG;
GRANT EE_V_R TO DNS   VITENG;
GRANT EE_V_R TO DNS   WALLASH;
GRANT EE_V_R TO DNS   WILLSC;
GRANT EE_V_R TO DNS   BOYETJ;
GRANT EE_V_R TO DNS   GROOMA;
GRANT EE_V_R TO DNS   WHELEC;
GRANT EE_V_R TO DNS   WOODM;
GRANT EE_V_R TO DNS   FAULKJ;
GRANT EE_V_R TO DNS   INNISJ;
GRANT EE_V_R TO DNS   PURSCD;
GRANT EE_V_R TO DNS   SCHIEK;
GRANT EE_V_R TO DNS   SHEPPL;
GRANT EE_V_R TO DNS   SURVES;
GRANT EE_V_R TO DNS   ALLENM;
GRANT EE_V_R TO DNS   DOR;
GRANT EE_V_R TO DNS   FITZGR;
GRANT EE_V_R TO DNS   ARCHET;
GRANT EE_V_R TO DNS   ARNOLN;
GRANT EE_V_R TO DNS   HUANGC;
GRANT EE_V_R TO DNS   HOUGAD;
GRANT EE_V_R TO DNS   LINDSD;
GRANT EE_V_R TO DNS   ROLINL;
GRANT EE_V_R TO DNS   SHAHA;
GRANT EE_V_R TO DNS   SINGHM;
GRANT EE_V_R TO DNS   TUH;
GRANT EE_V_R TO DNS   WOODC;
GRANT EE_V_R TO DNS   CANINB;
GRANT EE_V_R TO DNS   CHEKMM;
GRANT EE_V_R TO DNS   CHINC;
GRANT EE_V_R TO DNS   KOGANI;
GRANT EE_V_R TO DNS   LOPEZD;
GRANT EE_V_R TO DNS   LOWRYB;
GRANT EE_V_R TO DNS   ROCHAD;
GRANT EE_V_R TO DNS   DHEERA;
GRANT EE_V_R TO       BATESL;
GRANT EE_V_R TO       BOHMEG;
GRANT EE_V_R TO       CHENY;
GRANT EE_V_R TO       HASANM;
GRANT EE_V_R TO       PRICEW;
GRANT EE_V_R TO       VENIGS;
GRANT EE_V_R TO DNS         ;
GRANT EE_V_R TO DNS   WILLIO;
GRANT EE_V_R TO DNS   REENT;
GRANT EE_V_R TO DNS   SAWEIM;
DROP ROLE EE_RPT_R;

CREATE ROLE EE_RPT_R NOT IDENTIFIED;

-- Object privileges granted to EE_RPT_R
GRANT SELECT ON PSIM.ADR_ERROR_MESSAGES TO EE_RPT_R;
GRANT SELECT ON PSIM.ADR_PROCESS_LOG TO EE_RPT_R;
GRANT SELECT ON PSIM.RPT_PSIM_TRAITS TO EE_RPT_R;

-- Grantees of EE_RPT_R
GRANT EE_RPT_R TO AACDBA;
GRANT EE_RPT_R TO ADREXT;
GRANT EE_RPT_R TO ADRMGT;
GRANT EE_RPT_R TO BO_USR;
GRANT EE_RPT_R TO EERPT;
GRANT EE_RPT_R TO EEUSR;
GRANT EE_RPT_R TO DNS   CASTER;
GRANT EE_RPT_R TO DNS   PENNYR;
GRANT EE_RPT_R TO DNS   REYESJ;
GRANT EE_RPT_R TO SYSTEM WITH ADMIN OPTION;
GRANT EE_RPT_R TO DNS  WASSOM;
GRANT EE_RPT_R TO DNS  ALTMI;
GRANT EE_RPT_R TO DNS PASHAA;
GRANT EE_RPT_R TO DNS  KARANP;
GRANT EE_RPT_R TO DNS  MORGAR;
GRANT EE_RPT_R TO VAMQASCAMPOJ2;
GRANT EE_RPT_R TO VHA06MARTIK;
GRANT EE_RPT_R TO DNS   KENNEL;
GRANT EE_RPT_R TO DNS   HALLT;
GRANT EE_RPT_R TO DNS  JACOBR;
GRANT EE_RPT_R TO DNS  JOHNSB;
GRANT EE_RPT_R TO DNS   FIERRJ;
GRANT EE_RPT_R TO DNS   PARVAV;
GRANT EE_RPT_R TO DNS   ASAFOJ;
GRANT EE_RPT_R TO DNS   BOYETD;
GRANT EE_RPT_R TO DNS   CHAMPP;
GRANT EE_RPT_R TO DNS   CORNED;
GRANT EE_RPT_R TO DNS   GONZAS;
GRANT EE_RPT_R TO DNS   HORNEE;
GRANT EE_RPT_R TO DNS   HUNTEJ;
GRANT EE_RPT_R TO DNS   JACON;
GRANT EE_RPT_R TO DNS   JOHNSS;
GRANT EE_RPT_R TO DNS   PHIFEG;
GRANT EE_RPT_R TO DNS   SCOTTS;
GRANT EE_RPT_R TO DNS   SIMSB;
GRANT EE_RPT_R TO DNS   TIDWG;
GRANT EE_RPT_R TO DNS   VITENG;
GRANT EE_RPT_R TO DNS   WALLASH;
GRANT EE_RPT_R TO DNS   WILLSC;
GRANT EE_RPT_R TO DNS   BOYETJ;
GRANT EE_RPT_R TO DNS   GROOMA;
GRANT EE_RPT_R TO DNS   WHELEC;
GRANT EE_RPT_R TO DNS   WOODM;
GRANT EE_RPT_R TO DNS   FAULKJ;
GRANT EE_RPT_R TO DNS   INNISJ;
GRANT EE_RPT_R TO DNS   PURSCD;
GRANT EE_RPT_R TO DNS   SCHIEK;
GRANT EE_RPT_R TO DNS   SHEPPL;
GRANT EE_RPT_R TO DNS   SURVES;
GRANT EE_RPT_R TO DNS   ALLENM;
GRANT EE_RPT_R TO DNS   DOR;
GRANT EE_RPT_R TO DNS   FITZGR;
GRANT EE_RPT_R TO DNS   ARCHET;
GRANT EE_RPT_R TO DNS   ARNOLN;
GRANT EE_RPT_R TO DNS   HUANGC;
GRANT EE_RPT_R TO DNS   HOUGAD;
GRANT EE_RPT_R TO DNS   LINDSD;
GRANT EE_RPT_R TO DNS   ROLINL;
GRANT EE_RPT_R TO DNS   SHAHA;
GRANT EE_RPT_R TO DNS   SINGHM;
GRANT EE_RPT_R TO DNS   TUH;
GRANT EE_RPT_R TO DNS   WOODC;
GRANT EE_RPT_R TO DNS   CANINB;
GRANT EE_RPT_R TO DNS   CHEKMM;
GRANT EE_RPT_R TO DNS   CHINC;
GRANT EE_RPT_R TO DNS   KOGANI;
GRANT EE_RPT_R TO DNS   LOPEZD;
GRANT EE_RPT_R TO DNS   LOWRYB;
GRANT EE_RPT_R TO DNS   ROCHAD;
GRANT EE_RPT_R TO DNS   DHEERA;
GRANT EE_RPT_R TO       BATESL;
GRANT EE_RPT_R TO       BOHMEG;
GRANT EE_RPT_R TO       CHENY;
GRANT EE_RPT_R TO       HASANM;
GRANT EE_RPT_R TO       PRICEW;
GRANT EE_RPT_R TO       VENIGS;
GRANT EE_RPT_R TO DNS         ;
GRANT EE_RPT_R TO DNS   WILLIO;
GRANT EE_RPT_R TO DNS   REENT;
GRANT EE_RPT_R TO DNS   SAWEIM;
DROP ROLE ADREXT_R;

CREATE ROLE ADREXT_R NOT IDENTIFIED;

-- Object privileges granted to ADREXT_R
GRANT SELECT ON ADREXT.ADR_DATA_EXTRACT_NEW TO ADREXT_R;
GRANT SELECT ON ADREXT.APP_LOG TO ADREXT_R;
GRANT SELECT ON ADREXT.LOAD_TRACKER TO ADREXT_R;
GRANT SELECT ON ADREXT.OPP_TEMP_ADDR TO ADREXT_R;
GRANT SELECT ON ADREXT.OPP_TEMP_BASE TO ADREXT_R;
GRANT SELECT ON ADREXT.OPP_TEMP_BEN_MST TO ADREXT_R;
GRANT SELECT ON ADREXT.OPP_TEMP_BEN_NTR TO ADREXT_R;
GRANT SELECT ON ADREXT.OPP_TEMP_DEBT TO ADREXT_R;
GRANT SELECT ON ADREXT.OPP_TEMP_ELIG_VERIFY TO ADREXT_R;
GRANT SELECT ON ADREXT.OPP_TEMP_ENROLL_DET_H TO ADREXT_R;
GRANT SELECT ON ADREXT.OPP_TEMP_ENROLL_STAT TO ADREXT_R;
GRANT SELECT ON ADREXT.OPP_TEMP_HEALTH_BEN_APPL TO ADREXT_R;
GRANT SELECT ON ADREXT.OPP_TEMP_HEALTH_BEN_APP_H TO ADREXT_R;
GRANT SELECT ON ADREXT.OPP_TEMP_INCOME_TEST TO ADREXT_R;
GRANT SELECT ON ADREXT.OPP_TEMP_INCOMP_RULING TO ADREXT_R;
GRANT SELECT ON ADREXT.OPP_TEMP_INC_TST_FIN_ST TO ADREXT_R;
GRANT SELECT ON ADREXT.OPP_TEMP_INELIG_RULING TO ADREXT_R;
GRANT SELECT ON ADREXT.OPP_TEMP_INSURANCE TO ADREXT_R;
GRANT SELECT ON ADREXT.OPP_TEMP_LASTKNOWN_EDH TO ADREXT_R;
GRANT SELECT ON ADREXT.OPP_TEMP_MEDICAID_FCTR TO ADREXT_R;
GRANT SELECT ON ADREXT.OPP_TEMP_MONETARY_BEN TO ADREXT_R;
GRANT SELECT ON ADREXT.OPP_TEMP_PHONE TO ADREXT_R;
GRANT SELECT ON ADREXT.OPP_TEMP_POW_REG TO ADREXT_R;
GRANT SELECT ON ADREXT.OPP_TEMP_PRSN_ETHNICITY TO ADREXT_R;
GRANT SELECT ON ADREXT.OPP_TEMP_PRSN_RACE TO ADREXT_R;
GRANT SELECT ON ADREXT.OPP_TEMP_PURP_HRT_REG TO ADREXT_R;
GRANT SELECT ON ADREXT.OPP_TEMP_SPECIAL_FCTR TO ADREXT_R;
GRANT SELECT ON ADREXT.OPP_TEMP_SVC_CONNECTED TO ADREXT_R;
GRANT SELECT ON ADREXT.OPP_WORKFLOW_CFG TO ADREXT_R;
GRANT SELECT ON ADREXT.VERIFY_COLMN_DATA_MATRIX TO ADREXT_R;

-- Grantees of ADREXT_R
GRANT ADREXT_R TO AACDBA;
GRANT ADREXT_R TO ADR;
GRANT ADREXT_R TO ADRMGT;
GRANT ADREXT_R TO ADR_R;
GRANT ADREXT_R TO EEUSR;
GRANT ADREXT_R TO ISCOPE_ORCL;
GRANT ADREXT_R TO DNS   CASTER;
GRANT ADREXT_R TO DNS   PENNYR;
GRANT ADREXT_R TO DNS   REYESJ;
GRANT ADREXT_R TO SYSTEM WITH ADMIN OPTION;
GRANT ADREXT_R TO DNS  ALTMI;
GRANT ADREXT_R TO DNS PASHAA;
GRANT ADREXT_R TO DNS  KARANP;
GRANT ADREXT_R TO VAMQASCAMPOJ2;
GRANT ADREXT_R TO VHA06MARTIK;
GRANT ADREXT_R TO DNS   KENNEL;
GRANT ADREXT_R TO DNS   HALLT;
GRANT ADREXT_R TO DNS  JACOBR;
GRANT ADREXT_R TO DNS  JOHNSB;
GRANT ADREXT_R TO DNS   FIERRJ;
GRANT ADREXT_R TO DNS   PARVAV;
GRANT ADREXT_R TO DNS   ASAFOJ;
GRANT ADREXT_R TO DNS   BOYETD;
GRANT ADREXT_R TO DNS   CHAMPP;
GRANT ADREXT_R TO DNS   CORNED;
GRANT ADREXT_R TO DNS   GONZAS;
GRANT ADREXT_R TO DNS   HORNEE;
GRANT ADREXT_R TO DNS   HUNTEJ;
GRANT ADREXT_R TO DNS   JACON;
GRANT ADREXT_R TO DNS   JOHNSS;
GRANT ADREXT_R TO DNS   PHIFEG;
GRANT ADREXT_R TO DNS   SCOTTS;
GRANT ADREXT_R TO DNS   SIMSB;
GRANT ADREXT_R TO DNS   TIDWG;
GRANT ADREXT_R TO DNS   VITENG;
GRANT ADREXT_R TO DNS   WALLASH;
GRANT ADREXT_R TO DNS   BOYETJ;
GRANT ADREXT_R TO DNS   GROOMA;
GRANT ADREXT_R TO DNS   FAULKJ;
GRANT ADREXT_R TO DNS   INNISJ;
GRANT ADREXT_R TO DNS   PURSCD;
GRANT ADREXT_R TO DNS   SCHIEK;
GRANT ADREXT_R TO DNS   SHEPPL;
GRANT ADREXT_R TO DNS   SURVES;
GRANT ADREXT_R TO DNS   ALLENM;
GRANT ADREXT_R TO DNS   DOR;
GRANT ADREXT_R TO DNS   FITZGR;
GRANT ADREXT_R TO DNS   ARCHET;
GRANT ADREXT_R TO DNS   ARNOLN;
GRANT ADREXT_R TO DNS   HUANGC;
GRANT ADREXT_R TO DNS   HOUGAD;
GRANT ADREXT_R TO DNS   LINDSD;
GRANT ADREXT_R TO DNS   ROLINL;
GRANT ADREXT_R TO DNS   SHAHA;
GRANT ADREXT_R TO DNS   SINGHM;
GRANT ADREXT_R TO DNS   TUH;
GRANT ADREXT_R TO DNS   WOODC;
GRANT ADREXT_R TO DNS   CANINB;
GRANT ADREXT_R TO DNS   CHEKMM;
GRANT ADREXT_R TO DNS   KOGANI;
GRANT ADREXT_R TO DNS   LOPEZD;
GRANT ADREXT_R TO DNS   LOWRYB;
GRANT ADREXT_R TO DNS   DHEERA;
GRANT ADREXT_R TO       CHENY;
GRANT ADREXT_R TO       HASANM;
GRANT ADREXT_R TO       VENIGS;
GRANT ADREXT_R TO DNS         ;
GRANT ADREXT_R TO DNS   WILLIO;
GRANT ADREXT_R TO DNS   REENT;
GRANT ADREXT_R TO DNS   SAWEIM;
DROP ROLE ADREXT_RW;

CREATE ROLE ADREXT_RW NOT IDENTIFIED;

-- Object privileges granted to ADREXT_RW
GRANT DELETE, INSERT, SELECT, UPDATE ON ADREXT.ADR_DATA_EXTRACT_NEW TO ADREXT_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADREXT.OPP_TEMP_ADDR TO ADREXT_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADREXT.OPP_TEMP_BASE TO ADREXT_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADREXT.OPP_TEMP_BEN_MST TO ADREXT_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADREXT.OPP_TEMP_BEN_NTR TO ADREXT_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADREXT.OPP_TEMP_DEBT TO ADREXT_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADREXT.OPP_TEMP_ELIG_VERIFY TO ADREXT_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADREXT.OPP_TEMP_ENROLL_DET_H TO ADREXT_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADREXT.OPP_TEMP_ENROLL_STAT TO ADREXT_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADREXT.OPP_TEMP_HEALTH_BEN_APPL TO ADREXT_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADREXT.OPP_TEMP_HEALTH_BEN_APP_H TO ADREXT_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADREXT.OPP_TEMP_INCOME_TEST TO ADREXT_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADREXT.OPP_TEMP_INCOMP_RULING TO ADREXT_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADREXT.OPP_TEMP_INC_TST_FIN_ST TO ADREXT_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADREXT.OPP_TEMP_INELIG_RULING TO ADREXT_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADREXT.OPP_TEMP_INSURANCE TO ADREXT_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADREXT.OPP_TEMP_LASTKNOWN_EDH TO ADREXT_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADREXT.OPP_TEMP_MEDICAID_FCTR TO ADREXT_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADREXT.OPP_TEMP_MONETARY_BEN TO ADREXT_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADREXT.OPP_TEMP_PHONE TO ADREXT_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADREXT.OPP_TEMP_POW_REG TO ADREXT_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADREXT.OPP_TEMP_PRSN_ETHNICITY TO ADREXT_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADREXT.OPP_TEMP_PRSN_RACE TO ADREXT_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADREXT.OPP_TEMP_PURP_HRT_REG TO ADREXT_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADREXT.OPP_TEMP_SPECIAL_FCTR TO ADREXT_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADREXT.OPP_TEMP_SVC_CONNECTED TO ADREXT_RW;

-- Grantees of ADREXT_RW
GRANT ADREXT_RW TO ADREXTUSR;
GRANT ADREXT_RW TO SYSTEM WITH ADMIN OPTION;
DROP ROLE ADREXT_SEQ_R;

CREATE ROLE ADREXT_SEQ_R NOT IDENTIFIED;

-- Object privileges granted to ADREXT_SEQ_R
GRANT SELECT ON ADREXT.ADR_DATA_EXTRACT_S TO ADREXT_SEQ_R;
GRANT SELECT ON ADREXT.ADR_EXTRACT_CHGS_S TO ADREXT_SEQ_R;
GRANT SELECT ON ADREXT.APP_LOG_S TO ADREXT_SEQ_R;
GRANT SELECT ON ADREXT.LOAD_TRACKER_S TO ADREXT_SEQ_R;
GRANT SELECT ON ADREXT.OPP_WORKFLOW_CFG_S TO ADREXT_SEQ_R;

-- Grantees of ADREXT_SEQ_R
GRANT ADREXT_SEQ_R TO ADR;
GRANT ADREXT_SEQ_R TO ADREXTUSR;
GRANT ADREXT_SEQ_R TO EEUSR;
GRANT ADREXT_SEQ_R TO ISCOPE_ORCL;
GRANT ADREXT_SEQ_R TO SYSTEM WITH ADMIN OPTION;
DROP ROLE CARUSR_R;

CREATE ROLE CARUSR_R NOT IDENTIFIED;

-- Object privileges granted to CARUSR_R
GRANT SELECT ON ADR.PERMISSION_SET TO CARUSR_R;
GRANT SELECT ON ADR.PERMISSION_SET_H TO CARUSR_R;
GRANT SELECT ON ADR.PERSON TO CARUSR_R;
GRANT SELECT ON ADR.PERSON_H TO CARUSR_R;
GRANT SELECT ON ADR.ROLES TO CARUSR_R;
GRANT SELECT ON ADR.ROLES_H TO CARUSR_R;
GRANT SELECT ON ADR.USERS TO CARUSR_R;
GRANT SELECT ON ADR.USERS_H TO CARUSR_R;
GRANT SELECT ON ADR.USER_LOGIN TO CARUSR_R;
GRANT SELECT ON ADR.USER_LOGIN_H TO CARUSR_R;
GRANT SELECT ON ADR.USER_PERMISSIONS TO CARUSR_R;
GRANT SELECT ON ADR.USER_PERMISSIONS_H TO CARUSR_R;
GRANT SELECT ON ADR.USER_ROLES TO CARUSR_R;
GRANT SELECT ON ADR.USER_ROLES_H TO CARUSR_R;

-- Grantees of CARUSR_R
GRANT CARUSR_R TO AACDBA WITH ADMIN OPTION;
GRANT CARUSR_R TO CARUSR;
DROP ROLE BENS_ADMIN;

CREATE ROLE BENS_ADMIN NOT IDENTIFIED;

-- System privileges granted to BENS_ADMIN
GRANT ALTER SESSION TO BENS_ADMIN;
GRANT CREATE PROCEDURE TO BENS_ADMIN;
GRANT CREATE SEQUENCE TO BENS_ADMIN;
GRANT CREATE SESSION TO BENS_ADMIN;
GRANT CREATE SYNONYM TO BENS_ADMIN;
GRANT CREATE TABLE TO BENS_ADMIN;
GRANT CREATE TRIGGER TO BENS_ADMIN;
GRANT CREATE TYPE TO BENS_ADMIN;
GRANT CREATE VIEW TO BENS_ADMIN;
GRANT UNLIMITED TABLESPACE TO BENS_ADMIN;

-- Roles granted to BENS_ADMIN
GRANT RESOURCE TO BENS_ADMIN;
GRANT VA_SELECT_CATALOG_ROLE TO BENS_ADMIN;

-- Grantees of BENS_ADMIN
GRANT BENS_ADMIN TO AACDBA WITH ADMIN OPTION;
GRANT BENS_ADMIN TO BENS;
DROP ROLE BENS_R;

CREATE ROLE BENS_R NOT IDENTIFIED;

-- Object privileges granted to BENS_R
GRANT SELECT ON BENS.ACTIVATION_STATE TO BENS_R;
GRANT SELECT ON BENS.CONTACT_CERTIFICATE TO BENS_R;
GRANT SELECT ON BENS.CONTACT_DETAIL TO BENS_R;
GRANT SELECT ON BENS.CONTACT_PHONE TO BENS_R;
GRANT SELECT ON BENS.EVENT_CATALOG_ENTRY TO BENS_R;
GRANT SELECT ON BENS.EVENT_CLASS TO BENS_R;
GRANT SELECT ON BENS.EVENT_CLASS_COMMENT TO BENS_R;
GRANT SELECT ON BENS.EVENT_CLASS_REGISTRANT TO BENS_R;
GRANT SELECT ON BENS.EVENT_CODE TO BENS_R;
GRANT SELECT ON BENS.ORGANIZATION TO BENS_R;
GRANT SELECT ON BENS.ORGANIZATION_COMMENT TO BENS_R;
GRANT SELECT ON BENS.REGISTRANT TO BENS_R;
GRANT SELECT ON BENS.TAXONOMY TO BENS_R;
GRANT SELECT ON BENS.TAXONOMY_VERSION TO BENS_R;

-- Grantees of BENS_R
GRANT BENS_R TO AACDBA WITH ADMIN OPTION;
GRANT BENS_R TO DNS   REYESJ;
GRANT BENS_R TO DNS BARNAS;
GRANT BENS_R TO DNS  ALTMI;
GRANT BENS_R TO DNS  RAYD1;
GRANT BENS_R TO DNS KAZMIM;
GRANT BENS_R TO DNS MUHAMB;
GRANT BENS_R TO DNS PASHAA;
GRANT BENS_R TO DNS RYALIS;
GRANT BENS_R TO DNS WIEGEL;
GRANT BENS_R TO DNS  KARANP;
GRANT BENS_R TO DNS   CHAMPP;
GRANT BENS_R TO DNS   CORNED;
GRANT BENS_R TO DNS   JOHNSS;
GRANT BENS_R TO DNS   PHIFEG;
GRANT BENS_R TO DNS   SCOTTS;
GRANT BENS_R TO DNS   TIDWG;
GRANT BENS_R TO DNS   VITENG;
GRANT BENS_R TO DNS   WALLASH;
GRANT BENS_R TO DNS   GROOMA;
GRANT BENS_R TO DNS   PURSCD;
GRANT BENS_R TO DNS   DOR;
GRANT BENS_R TO DNS   FITZGR;
GRANT BENS_R TO DNS   ARCHET;
GRANT BENS_R TO DNS   LINDSD;
GRANT BENS_R TO DNS   SHAHA;
GRANT BENS_R TO DNS   SINGHM;
GRANT BENS_R TO DNS   TUH;
GRANT BENS_R TO DNS   WOODC;
GRANT BENS_R TO DNS   CANINB;
GRANT BENS_R TO DNS   LOWRYB;
GRANT BENS_R TO DNS   DHEERA;
GRANT BENS_R TO DNS   REENT;
DROP ROLE BENS_RW;

CREATE ROLE BENS_RW NOT IDENTIFIED;

-- Object privileges granted to BENS_RW
GRANT INSERT, SELECT, UPDATE ON BENS.ACTIVATION_STATE TO BENS_RW;
GRANT INSERT, SELECT, UPDATE ON BENS.CONTACT_CERTIFICATE TO BENS_RW;
GRANT INSERT, SELECT, UPDATE ON BENS.CONTACT_DETAIL TO BENS_RW;
GRANT INSERT, SELECT, UPDATE ON BENS.CONTACT_PHONE TO BENS_RW;
GRANT INSERT, SELECT, UPDATE ON BENS.EVENT_CATALOG_ENTRY TO BENS_RW;
GRANT INSERT, SELECT, UPDATE ON BENS.EVENT_CLASS TO BENS_RW;
GRANT INSERT, SELECT, UPDATE ON BENS.EVENT_CLASS_COMMENT TO BENS_RW;
GRANT INSERT, SELECT, UPDATE ON BENS.EVENT_CLASS_REGISTRANT TO BENS_RW;
GRANT INSERT, SELECT, UPDATE ON BENS.EVENT_CODE TO BENS_RW;
GRANT INSERT, SELECT, UPDATE ON BENS.ORGANIZATION TO BENS_RW;
GRANT INSERT, SELECT, UPDATE ON BENS.ORGANIZATION_COMMENT TO BENS_RW;
GRANT INSERT, SELECT, UPDATE ON BENS.REGISTRANT TO BENS_RW;
GRANT INSERT, SELECT, UPDATE ON BENS.TAXONOMY TO BENS_RW;
GRANT INSERT, SELECT, UPDATE ON BENS.TAXONOMY_VERSION TO BENS_RW;

-- Grantees of BENS_RW
GRANT BENS_RW TO AACDBA WITH ADMIN OPTION;
GRANT BENS_RW TO BENSUSR;
GRANT BENS_RW TO VIERSUSR;
DROP ROLE BENS_SEQ_R;

CREATE ROLE BENS_SEQ_R NOT IDENTIFIED;

-- Object privileges granted to BENS_SEQ_R
GRANT SELECT ON BENS.ACTIVATION_STATE TO BENS_SEQ_R;
GRANT SELECT ON BENS.CONTACT_CERTIFICATE TO BENS_SEQ_R;
GRANT SELECT ON BENS.CONTACT_DETAIL TO BENS_SEQ_R;
GRANT SELECT ON BENS.CONTACT_PHONE TO BENS_SEQ_R;
GRANT SELECT ON BENS.EVENT_CATALOG_ENTRY TO BENS_SEQ_R;
GRANT SELECT ON BENS.EVENT_CLASS TO BENS_SEQ_R;
GRANT SELECT ON BENS.EVENT_CLASS_COMMENT TO BENS_SEQ_R;
GRANT SELECT ON BENS.EVENT_CLASS_REGISTRANT TO BENS_SEQ_R;
GRANT SELECT ON BENS.EVENT_CODE TO BENS_SEQ_R;
GRANT SELECT ON BENS.ORGANIZATION TO BENS_SEQ_R;
GRANT SELECT ON BENS.ORGANIZATION_COMMENT TO BENS_SEQ_R;
GRANT SELECT ON BENS.REGISTRANT TO BENS_SEQ_R;
GRANT SELECT ON BENS.TAXONOMY TO BENS_SEQ_R;
GRANT SELECT ON BENS.TAXONOMY_VERSION TO BENS_SEQ_R;

-- Grantees of BENS_SEQ_R
GRANT BENS_SEQ_R TO AACDBA WITH ADMIN OPTION;
GRANT BENS_SEQ_R TO BENSUSR;
GRANT BENS_SEQ_R TO DNS   REYESJ;
GRANT BENS_SEQ_R TO DNS  ALTMI;
GRANT BENS_SEQ_R TO DNS  RAYD1;
GRANT BENS_SEQ_R TO DNS KAZMIM;
GRANT BENS_SEQ_R TO DNS MUHAMB;
GRANT BENS_SEQ_R TO DNS PASHAA;
GRANT BENS_SEQ_R TO DNS   WALLASH;
GRANT BENS_SEQ_R TO DNS   GROOMA;
GRANT BENS_SEQ_R TO DNS   PURSCD;
GRANT BENS_SEQ_R TO DNS   DOR;
GRANT BENS_SEQ_R TO DNS   FITZGR;
GRANT BENS_SEQ_R TO DNS   ARCHET;
GRANT BENS_SEQ_R TO DNS   LINDSD;
GRANT BENS_SEQ_R TO DNS   SHAHA;
GRANT BENS_SEQ_R TO DNS   SINGHM;
GRANT BENS_SEQ_R TO DNS   TUH;
GRANT BENS_SEQ_R TO DNS   WOODC;
GRANT BENS_SEQ_R TO DNS   CANINB;
GRANT BENS_SEQ_R TO DNS   DHEERA;
GRANT BENS_SEQ_R TO DNS   REENT;
GRANT BENS_SEQ_R TO VIERSUSR;
DROP ROLE JRULE_RW;

CREATE ROLE JRULE_RW NOT IDENTIFIED;

-- Object privileges granted to JRULE_RW
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.ABSTRACTQUERY TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.ABSTRACTQUERYDTLS TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.ALGORITHMKIND TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.ARGUMENT TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.BASELINE TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.BASELINECONTENT TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.BASELINEDEPENDENCY TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.BASELINEKIND TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.BOM TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.BOM2XOMMAPPING TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.BOM2XOMMAPPINGDTLS TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.BOMDTLS TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.BOMPATHENTRY TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.BRSTUDIO TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.CONNECTIONENTRY TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.DEFINITION TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.DEPENDENCY TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.DIRECTIONKIND TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.EXECUTION_TRACES TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.EXITCRITERIAKIND TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.EXTRACTOR TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.ILRGROUP TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.INITIALVALUE TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.LOCKTBL TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.MESSAGEMAP TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.METAMODEL TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.ORDERINGKIND TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.OVERRIDDENRULE TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.PARAMETER TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.PERMISSION TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.PROJECTINFO TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.PROJECTINFOTAG TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.PROXY TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RPLFTRGT TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RS_ENABLED_VIEW TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RTSRESOURCE TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RTSSCHEMA TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RULEAPP TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RULEAPPPROPERTY TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RULEAPPS TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RULEAPP_PROPERTIES TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RULEARTIFACT TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RULEARTIFACTAGGRGTD TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RULEARTIFACTDTLS TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RULEARTIFACTSIBLING TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RULEARTIFACTSTDXTD TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RULEARTIFACTTAG TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RULEFLOW TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RULEFLOWAGGRGTD TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RULEFLOWDTLS TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RULEFLOWSIBLING TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RULEFLOWSTDXTD TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RULEFLOWTAG TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RULEPACKAGE TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RULEPACKAGEDTLS TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RULEPACKAGESIBLING TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RULEPACKAGESTDXTD TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RULEPROJECT TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RULEPROJECTTAG TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RULESET TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RULESETPROPERTY TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RULESETS TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RULESET_PROPERTIES TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.RULESET_RESOURCES TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.SCENARIOSUITE TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.SCENARIOSUITEAGGRGTD TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.SCENARIOSUITEDTLS TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.SCENARIOSUITEKPIREPORT TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.SCENARIOSUITEREPORT TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.SCENARIOSUITERESOURCE TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.SCENARIOTESTREPORT TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.SCHEMAVERSION TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.SCOPEELEMENT TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.SERVER TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.SERVERKIND TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.STATUS TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.TASK TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.TEMPLATE TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.TEMPLATEAGGRGTD TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.TEMPLATEDTLS TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.TESTREPORT TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.USERSETTING TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.VARIABLE TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.VARIABLESET TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.VARIABLESETAGGRGTD TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.VARIABLESETDTLS TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.VERSION TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.VOCABULARY TO JRULE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON JRULE.VOCABULARYDTLS TO JRULE_RW;

-- Grantees of JRULE_RW
GRANT JRULE_RW TO AACDBA WITH ADMIN OPTION;
GRANT JRULE_RW TO ESIJRULEUSR;
GRANT JRULE_RW TO ESRJRULEUSR;
DROP ROLE JRULE_SEQ_R;

CREATE ROLE JRULE_SEQ_R NOT IDENTIFIED;

-- Object privileges granted to JRULE_SEQ_R
GRANT SELECT ON JRULE.ABSTRACTQUERYIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.ARGUMENTIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.BASELINEDEPENDENCYIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.BASELINEIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.BOM2XOMMAPPINGIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.BOMIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.BOMPATHENTRYIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.CONNECTIONENTRYIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.DEFINITIONIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.DEPENDENCYIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.EXECUTION_TRACES_SEQUENCE TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.EXTRACTORIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.GROUPIDENTITITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.INITIALVALUEIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.LOCKTBLIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.MESSAGEMAPIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.METAMODELIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.OVERRIDDENRULEIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.PARAMETERIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.PERMISSIONIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.PROJECTINFOIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.PROJECTINFOTAGIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.PROXYIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.RTSRESOURCEIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.RTSSCHEMAIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.RULEAPPIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.RULEAPPPROPERTYIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.RULEAPPS_SEQUENCE TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.RULEAPP_PROPERTIES_SEQUENCE TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.RULEARTIFACTIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.RULEARTIFACTTAGIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.RULEFLOWIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.RULEFLOWTAGIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.RULEPACKAGEIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.RULEPROJECTIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.RULEPROJECTTAGIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.RULESETIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.RULESETPROPERTYIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.RULESETS_SEQUENCE TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.RULESET_PROPERTIES_SEQUENCE TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.RULESET_RESOURCES_SEQUENCE TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.SCENARIOSUITEIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.SCENARIOSUITEKPIREPORTIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.SCENARIOSUITEREPORTIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.SCENARIOSUITERESOURCEIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.SCENARIOTESTREPORTIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.SCOPEELEMENTIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.SERVERIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.TASKIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.TEMPLATEIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.TESTREPORTIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.USERSETTINGIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.VARIABLEIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.VARIABLESETIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.VERSIONIDENTITY TO JRULE_SEQ_R;
GRANT SELECT ON JRULE.VOCABULARYIDENTITY TO JRULE_SEQ_R;

-- Grantees of JRULE_SEQ_R
GRANT JRULE_SEQ_R TO AACDBA WITH ADMIN OPTION;
GRANT JRULE_SEQ_R TO ESIJRULEUSR;
GRANT JRULE_SEQ_R TO ESRJRULEUSR;
GRANT JRULE_SEQ_R TO DNS  ALTMI;
GRANT JRULE_SEQ_R TO DNS PASHAA;
GRANT JRULE_SEQ_R TO DNS   DOR;
GRANT JRULE_SEQ_R TO DNS   FITZGR;
GRANT JRULE_SEQ_R TO DNS   LINDSD;
GRANT JRULE_SEQ_R TO DNS   SHAHA;
GRANT JRULE_SEQ_R TO DNS   SINGHM;
GRANT JRULE_SEQ_R TO DNS   TUH;
GRANT JRULE_SEQ_R TO DNS   WOODC;
GRANT JRULE_SEQ_R TO DNS   CANINB;
GRANT JRULE_SEQ_R TO DNS   DHEERA;
GRANT JRULE_SEQ_R TO DNS   REENT;
DROP ROLE IAM_R;

CREATE ROLE IAM_R NOT IDENTIFIED;

-- Object privileges granted to IAM_R
GRANT SELECT ON ADR.ROLES TO IAM_R;
GRANT SELECT ON ADR.USERS TO IAM_R;
GRANT SELECT ON ADR.USERS_H TO IAM_R;
GRANT SELECT ON ADR.USER_ROLES TO IAM_R;
GRANT SELECT ON ADR.USER_ROLES_H TO IAM_R;
GRANT SELECT ON SDSADM.STD_INSTITUTION TO IAM_R;

-- Grantees of IAM_R
GRANT IAM_R TO AACDBA WITH ADMIN OPTION;
GRANT IAM_R TO DNS   REYESJ;
GRANT IAM_R TO DNS  ALTMI;
GRANT IAM_R TO DNS PASHAA;
GRANT IAM_R TO DNS   WALLASH;
GRANT IAM_R TO DNS   GROOMA;
GRANT IAM_R TO DNS   PURSCD;
GRANT IAM_R TO DNS   FITZGR;
GRANT IAM_R TO DNS   ARCHET;
GRANT IAM_R TO DNS   DHEERA;
GRANT IAM_R TO DNS   REENT;
DROP ROLE IAM_RW;

CREATE ROLE IAM_RW NOT IDENTIFIED;

-- Object privileges granted to IAM_RW
GRANT SELECT ON ADR.ROLES TO IAM_RW;
GRANT INSERT, SELECT, UPDATE ON ADR.USERS TO IAM_RW;
GRANT INSERT, SELECT ON ADR.USERS_H TO IAM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.USER_ROLES TO IAM_RW;
GRANT INSERT, SELECT ON ADR.USER_ROLES_H TO IAM_RW;
GRANT SELECT ON SDSADM.STD_INSTITUTION TO IAM_RW;

-- Grantees of IAM_RW
GRANT IAM_RW TO AACDBA WITH ADMIN OPTION;
GRANT IAM_RW TO IAMUSR;
DROP ROLE VA_SELECT_CATALOG_ROLE;

CREATE ROLE VA_SELECT_CATALOG_ROLE NOT IDENTIFIED;

-- Object privileges granted to VA_SELECT_CATALOG_ROLE
GRANT SELECT ON AACDBA.VA_DBA_USERS TO VA_SELECT_CATALOG_ROLE;

-- System privileges granted to VA_SELECT_CATALOG_ROLE
GRANT SELECT ANY DICTIONARY TO VA_SELECT_CATALOG_ROLE;

-- Roles granted to VA_SELECT_CATALOG_ROLE
GRANT SELECT_CATALOG_ROLE TO VA_SELECT_CATALOG_ROLE;
GRANT PLUSTRACE TO VA_SELECT_CATALOG_ROLE;

-- Grantees of VA_SELECT_CATALOG_ROLE
GRANT VA_SELECT_CATALOG_ROLE TO ACA;
GRANT VA_SELECT_CATALOG_ROLE TO ADRREFSYNC;
GRANT VA_SELECT_CATALOG_ROLE TO BENS_ADMIN;
GRANT VA_SELECT_CATALOG_ROLE TO CIS_ADMIN;
GRANT VA_SELECT_CATALOG_ROLE TO EESRV;
GRANT VA_SELECT_CATALOG_ROLE TO ESIJRULEUSR;
GRANT VA_SELECT_CATALOG_ROLE TO ESRJMS;
GRANT VA_SELECT_CATALOG_ROLE TO ESRJRULEUSR;
GRANT VA_SELECT_CATALOG_ROLE TO JRULE;
GRANT VA_SELECT_CATALOG_ROLE TO ODM;
GRANT VA_SELECT_CATALOG_ROLE TO ODMUSR;
GRANT VA_SELECT_CATALOG_ROLE TO PATS_ADMIN;
GRANT VA_SELECT_CATALOG_ROLE TO PSIMUSR;
GRANT VA_SELECT_CATALOG_ROLE TO SYS WITH ADMIN OPTION;
GRANT VA_SELECT_CATALOG_ROLE TO DNS  ALTMI;
GRANT VA_SELECT_CATALOG_ROLE TO DNS PASHAA;
GRANT VA_SELECT_CATALOG_ROLE TO DNS   FAULKJ;
GRANT VA_SELECT_CATALOG_ROLE TO DNS   DOR;
GRANT VA_SELECT_CATALOG_ROLE TO DNS   FITZGR;
GRANT VA_SELECT_CATALOG_ROLE TO DNS   LINDSD;
GRANT VA_SELECT_CATALOG_ROLE TO DNS   SHAHA;
GRANT VA_SELECT_CATALOG_ROLE TO DNS   SINGHM;
GRANT VA_SELECT_CATALOG_ROLE TO DNS   TUH;
GRANT VA_SELECT_CATALOG_ROLE TO DNS   WOODC;
GRANT VA_SELECT_CATALOG_ROLE TO DNS   CANINB;
GRANT VA_SELECT_CATALOG_ROLE TO DNS   DHEERA;
GRANT VA_SELECT_CATALOG_ROLE TO DNS   REENT;
GRANT VA_SELECT_CATALOG_ROLE TO VOA;
DROP ROLE IDH_SELECT;

CREATE ROLE IDH_SELECT NOT IDENTIFIED;

-- Object privileges granted to IDH_SELECT
GRANT SELECT ON IDHADM02.MPI_ENTIQUE_ID TO IDH_SELECT;
GRANT SELECT ON IDHADM02.MPI_ENTLKEM_ID TO IDH_SELECT;
GRANT SELECT ON IDHADM02.MPI_ENTLKIQ_ID TO IDH_SELECT;
GRANT SELECT ON IDHADM02.MPI_ENTLKOQ_ID TO IDH_SELECT;
GRANT SELECT ON IDHADM02.MPI_ENTNOTE_ID TO IDH_SELECT;
GRANT SELECT ON IDHADM02.MPI_ENTOQUE_ID TO IDH_SELECT;
GRANT SELECT ON IDHADM02.MPI_ENTRULE_ID TO IDH_SELECT;

-- System privileges granted to IDH_SELECT
GRANT ALTER SESSION TO IDH_SELECT;
GRANT CREATE SESSION TO IDH_SELECT;
GRANT CREATE SYNONYM TO IDH_SELECT;
GRANT SELECT ANY DICTIONARY TO IDH_SELECT;

-- Grantees of IDH_SELECT
GRANT IDH_SELECT TO DNS   CASTER;
GRANT IDH_SELECT TO DNS   PENNYR;
GRANT IDH_SELECT TO DNS   REYESJ;
GRANT IDH_SELECT TO SYSTEM WITH ADMIN OPTION;
GRANT IDH_SELECT TO DNS  ALTMI;
GRANT IDH_SELECT TO DNS PASHAA;
GRANT IDH_SELECT TO DNS   FIERRJ;
GRANT IDH_SELECT TO DNS   PARVAV;
GRANT IDH_SELECT TO DNS   ASAFOJ;
GRANT IDH_SELECT TO DNS   BOYETD;
GRANT IDH_SELECT TO DNS   CHAMPP;
GRANT IDH_SELECT TO DNS   CORNED;
GRANT IDH_SELECT TO DNS   GONZAS;
GRANT IDH_SELECT TO DNS   HORNEE;
GRANT IDH_SELECT TO DNS   JACON;
GRANT IDH_SELECT TO DNS   PHIFEG;
GRANT IDH_SELECT TO DNS   SCOTTS;
GRANT IDH_SELECT TO DNS   TIDWG;
GRANT IDH_SELECT TO DNS   VITENG;
GRANT IDH_SELECT TO DNS   WALLASH;
GRANT IDH_SELECT TO DNS   GROOMA;
GRANT IDH_SELECT TO DNS   FAULKJ;
GRANT IDH_SELECT TO DNS   PURSCD;
GRANT IDH_SELECT TO DNS   ALLENM;
GRANT IDH_SELECT TO DNS   DOR;
GRANT IDH_SELECT TO DNS   FITZGR;
GRANT IDH_SELECT TO DNS   ARCHET;
GRANT IDH_SELECT TO DNS   HOUGAD;
GRANT IDH_SELECT TO DNS   SHAHA;
GRANT IDH_SELECT TO DNS   TUH;
GRANT IDH_SELECT TO DNS   WOODC;
GRANT IDH_SELECT TO DNS   CANINB;
GRANT IDH_SELECT TO DNS   LOPEZD;
GRANT IDH_SELECT TO DNS   DHEERA;
GRANT IDH_SELECT TO DNS   WILLIO;
GRANT IDH_SELECT TO DNS   REENT;
DROP ROLE IDH_OWNER;

CREATE ROLE IDH_OWNER NOT IDENTIFIED;

-- Object privileges granted to IDH_OWNER
GRANT WRITE ON DIRECTORY IDH_OUTPUT TO IDH_OWNER;

-- System privileges granted to IDH_OWNER
GRANT ALTER SESSION TO IDH_OWNER;
GRANT CREATE PROCEDURE TO IDH_OWNER;
GRANT CREATE SEQUENCE TO IDH_OWNER;
GRANT CREATE SESSION TO IDH_OWNER;
GRANT CREATE SYNONYM TO IDH_OWNER;
GRANT CREATE TABLE TO IDH_OWNER;
GRANT CREATE TRIGGER TO IDH_OWNER;
GRANT CREATE VIEW TO IDH_OWNER;
GRANT SELECT ANY DICTIONARY TO IDH_OWNER;

-- Grantees of IDH_OWNER
GRANT IDH_OWNER TO IDHADM02;
GRANT IDH_OWNER TO SYSTEM WITH ADMIN OPTION;
DROP ROLE CIS_ADMIN;

CREATE ROLE CIS_ADMIN NOT IDENTIFIED;

-- System privileges granted to CIS_ADMIN
GRANT ALTER SESSION TO CIS_ADMIN;
GRANT CREATE PROCEDURE TO CIS_ADMIN;
GRANT CREATE SEQUENCE TO CIS_ADMIN;
GRANT CREATE SESSION TO CIS_ADMIN;
GRANT CREATE SYNONYM TO CIS_ADMIN;
GRANT CREATE TABLE TO CIS_ADMIN;
GRANT CREATE TRIGGER TO CIS_ADMIN;
GRANT CREATE TYPE TO CIS_ADMIN;
GRANT CREATE VIEW TO CIS_ADMIN;
GRANT UNLIMITED TABLESPACE TO CIS_ADMIN;

-- Roles granted to CIS_ADMIN
GRANT RESOURCE TO CIS_ADMIN;
GRANT VA_SELECT_CATALOG_ROLE TO CIS_ADMIN;

-- Grantees of CIS_ADMIN
GRANT CIS_ADMIN TO AACDBA WITH ADMIN OPTION;
GRANT CIS_ADMIN TO CIS;
DROP ROLE CIS_R;

CREATE ROLE CIS_R NOT IDENTIFIED;

-- Object privileges granted to CIS_R
GRANT SELECT ON CIS.CIS_ADDRESS_TYPE TO CIS_R;
GRANT SELECT ON CIS.CIS_ADDRESS_TYPE_H TO CIS_R;
GRANT SELECT ON CIS.CIS_AUDIT_LOG TO CIS_R;
GRANT SELECT ON CIS.CIS_CONT_INFO TO CIS_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_ADDRESS TO CIS_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_ADDRESS_H TO CIS_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_DATA_QUALITY TO CIS_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_DATA_QUALITY_H TO CIS_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_EMAIL TO CIS_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_EMAIL_H TO CIS_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_H TO CIS_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_PHONE TO CIS_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_PHONE_H TO CIS_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_PREF TO CIS_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_PREF_H TO CIS_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_PROF TO CIS_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_PROF_H TO CIS_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_PURPOSE TO CIS_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_PURPOSE_H TO CIS_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_RULE_STATUS TO CIS_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_RULE_STATUS_H TO CIS_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_STATUS TO CIS_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_STATUS_H TO CIS_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_TYPE TO CIS_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_TYPE_H TO CIS_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_TYPE_PRPS TO CIS_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_TYPE_PRPS_H TO CIS_R;
GRANT SELECT ON CIS.CIS_EMAIL_TYPE TO CIS_R;
GRANT SELECT ON CIS.CIS_EMAIL_TYPE_H TO CIS_R;
GRANT SELECT ON CIS.CIS_INFLGHT_DATA TO CIS_R;
GRANT SELECT ON CIS.CIS_INFLGHT_DATA_CLOB TO CIS_R;
GRANT SELECT ON CIS.CIS_INFLGHT_DATA_STATUS TO CIS_R;
GRANT SELECT ON CIS.CIS_INFLGHT_DATA_STATUS_H TO CIS_R;
GRANT SELECT ON CIS.CIS_INFLGHT_STATUS_TYPE TO CIS_R;
GRANT SELECT ON CIS.CIS_INFLGHT_STATUS_TYPE_H TO CIS_R;
GRANT SELECT ON CIS.CIS_PARTY TO CIS_R;
GRANT SELECT ON CIS.CIS_PARTY_INFO TO CIS_R;
GRANT SELECT ON CIS.CIS_PARTY_INFO_H TO CIS_R;
GRANT SELECT ON CIS.CIS_PARTY_RLNSHP TO CIS_R;
GRANT SELECT ON CIS.CIS_PARTY_RLNSHP_H TO CIS_R;
GRANT SELECT ON CIS.CIS_PARTY_RLNSHP_TYPE TO CIS_R;
GRANT SELECT ON CIS.CIS_PARTY_RLNSHP_TYPE_H TO CIS_R;
GRANT SELECT ON CIS.CIS_PARTY_SRC_ID_TYPE TO CIS_R;
GRANT SELECT ON CIS.CIS_PARTY_SRC_ID_TYPE_H TO CIS_R;
GRANT SELECT ON CIS.CIS_PHONE_TYPE TO CIS_R;
GRANT SELECT ON CIS.CIS_PHONE_TYPE_H TO CIS_R;
GRANT SELECT ON CIS.CIS_PREF_TYPE TO CIS_R;
GRANT SELECT ON CIS.CIS_PREF_TYPE_H TO CIS_R;
GRANT SELECT ON CIS.CIS_PROPAGATE_EVENT TO CIS_R;
GRANT SELECT ON CIS.CIS_PROPAGATE_EVENT_ACK TO CIS_R;
GRANT SELECT ON CIS.CIS_PROPAGATE_EVENT_H TO CIS_R;
GRANT SELECT ON CIS.CIS_PROVENANCE TO CIS_R;
GRANT SELECT ON CIS.CIS_PURPOSE_TYPE TO CIS_R;
GRANT SELECT ON CIS.CIS_PURPOSE_TYPE_H TO CIS_R;
GRANT SELECT ON CIS.CIS_RULE_TYPE TO CIS_R;
GRANT SELECT ON CIS.CIS_RULE_TYPE_H TO CIS_R;
GRANT SELECT ON CIS.CIS_STAT_TYPE TO CIS_R;
GRANT SELECT ON CIS.CIS_STAT_TYPE_H TO CIS_R;
GRANT SELECT ON CIS.CIS_SUBSCRIBER TO CIS_R;
GRANT SELECT ON CIS.CIS_VLDTN_PRBLM TO CIS_R;
GRANT SELECT ON CIS.CIS_VLDTN_PRBLM_H TO CIS_R;
GRANT SELECT ON CIS.CIS_VLDTN_PRBLM_TYPE TO CIS_R;
GRANT SELECT ON CIS.CIS_VLDTN_PRBLM_TYPE_H TO CIS_R;
GRANT SELECT ON CIS.CIS_VLDTN_RSLT TO CIS_R;
GRANT SELECT ON CIS.CIS_VLDTN_RSLT_CLOB TO CIS_R;
GRANT SELECT ON CIS.CIS_VLDTN_RSLT_CLOB_H TO CIS_R;
GRANT SELECT ON CIS.CIS_VLDTN_RSLT_H TO CIS_R;
GRANT SELECT ON CIS.CIS_VLDTN_STATUS_TYPE TO CIS_R;
GRANT SELECT ON CIS.CIS_VLDTN_STATUS_TYPE_H TO CIS_R;
GRANT SELECT ON CIS.CK_LOG TO CIS_R;

-- Grantees of CIS_R
GRANT CIS_R TO AACDBA WITH ADMIN OPTION;
GRANT CIS_R TO CIS_DEV;
GRANT CIS_R TO CIS_MAINT;
GRANT CIS_R TO CIS_SQA;
GRANT CIS_R TO DNS   REYESJ;
GRANT CIS_R TO DNS BARNAS;
GRANT CIS_R TO DNS  ALTMI;
GRANT CIS_R TO DNS  RAYD1;
GRANT CIS_R TO DNS KAZMIM;
GRANT CIS_R TO DNS MUHAMB;
GRANT CIS_R TO DNS PASHAA;
GRANT CIS_R TO DNS RYALIS;
GRANT CIS_R TO DNS WIEGEL;
GRANT CIS_R TO DNS  KARANP;
GRANT CIS_R TO DNS   CHAMPP;
GRANT CIS_R TO DNS   CORNED;
GRANT CIS_R TO DNS   JOHNSS;
GRANT CIS_R TO DNS   PHIFEG;
GRANT CIS_R TO DNS   SCOTTS;
GRANT CIS_R TO DNS   TIDWG;
GRANT CIS_R TO DNS   VITENG;
GRANT CIS_R TO DNS   WALLASH;
GRANT CIS_R TO DNS   GROOMA;
GRANT CIS_R TO DNS   PURSCD;
GRANT CIS_R TO DNS   DOR;
GRANT CIS_R TO DNS   FITZGR;
GRANT CIS_R TO DNS   ARCHET;
GRANT CIS_R TO DNS   LINDSD;
GRANT CIS_R TO DNS   SHAHA;
GRANT CIS_R TO DNS   SINGHM;
GRANT CIS_R TO DNS   TUH;
GRANT CIS_R TO DNS   WOODC;
GRANT CIS_R TO DNS   CANINB;
GRANT CIS_R TO DNS   LOWRYB;
GRANT CIS_R TO DNS   DHEERA;
GRANT CIS_R TO DNS   REENT;
DROP ROLE CIS_RW;

CREATE ROLE CIS_RW NOT IDENTIFIED;

-- Object privileges granted to CIS_RW
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_ADDRESS_TYPE TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_ADDRESS_TYPE_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_AUDIT_LOG TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_ADDRESS TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_ADDRESS_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_DATA_QUALITY TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_DATA_QUALITY_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_EMAIL TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_EMAIL_H TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_PHONE TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_PHONE_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_PREF TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_PREF_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_PROF TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_PROF_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_PURPOSE TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_PURPOSE_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_RULE_STATUS TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_RULE_STATUS_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_STATUS TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_STATUS_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_TYPE TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_TYPE_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_TYPE_PRPS TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_TYPE_PRPS_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_EMAIL_TYPE TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_EMAIL_TYPE_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_INFLGHT_DATA TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_INFLGHT_DATA_CLOB TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_INFLGHT_DATA_STATUS TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_INFLGHT_DATA_STATUS_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_INFLGHT_STATUS_TYPE TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_INFLGHT_STATUS_TYPE_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_PARTY TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_PARTY_INFO TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_PARTY_INFO_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_PARTY_RLNSHP TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_PARTY_RLNSHP_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_PARTY_RLNSHP_TYPE TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_PARTY_RLNSHP_TYPE_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_PARTY_SRC_ID_TYPE TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_PARTY_SRC_ID_TYPE_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_PHONE_TYPE TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_PHONE_TYPE_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_PREF_TYPE TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_PREF_TYPE_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_PROPAGATE_EVENT TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_PROPAGATE_EVENT_ACK TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_PROPAGATE_EVENT_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_PROVENANCE TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_PURPOSE_TYPE TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_PURPOSE_TYPE_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_RULE_TYPE TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_RULE_TYPE_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_STAT_TYPE TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_STAT_TYPE_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_SUBSCRIBER TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_VLDTN_PRBLM TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_VLDTN_PRBLM_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_VLDTN_PRBLM_TYPE TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_VLDTN_PRBLM_TYPE_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_VLDTN_RSLT TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_VLDTN_RSLT_CLOB TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_VLDTN_RSLT_CLOB_H TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_VLDTN_RSLT_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_VLDTN_STATUS_TYPE TO CIS_RW;
GRANT INSERT, SELECT, UPDATE ON CIS.CIS_VLDTN_STATUS_TYPE_H TO CIS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CK_LOG TO CIS_RW;

-- Grantees of CIS_RW
GRANT CIS_RW TO AACDBA WITH ADMIN OPTION;
GRANT CIS_RW TO CISUSR;
GRANT CIS_RW TO VIERSUSR;
DROP ROLE CIS_SEQ_R;

CREATE ROLE CIS_SEQ_R NOT IDENTIFIED;

-- Object privileges granted to CIS_SEQ_R
GRANT SELECT ON CIS.CIS_ADDRESS_TYPE_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_ADDRESS_TYPE_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_AUDIT_LOG_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_ADDRESS_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_ADDRESS_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_DATA_QUALITY_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_DATA_QUALITY_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_EMAIL_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_EMAIL_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_PHONE_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_PHONE_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_PREF_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_PREF_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_PROF_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_PROF_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_PURPOSE_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_PURPOSE_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_RULE_STATUS_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_RULE_STATUS_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_STATUS_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_STATUS_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_TYPE_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_TYPE_PRPS_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_TYPE_PRPS_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_CONT_INFO_TYPE_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_EMAIL_TYPE_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_EMAIL_TYPE_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_INFLGHT_DATA_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_INFLGHT_DATA_STATUS_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_INFLGHT_DATA_STATUS_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_INFLGHT_STATUS_TYPE_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_INFLGHT_STATUS_TYPE_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_PARTY_INFO_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_PARTY_INFO_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_PARTY_RLNSHP_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_PARTY_RLNSHP_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_PARTY_RLNSHP_TYPE_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_PARTY_RLNSHP_TYPE_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_PARTY_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_PARTY_SRC_ID_TYPE_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_PARTY_SRC_ID_TYPE_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_PHONE_TYPE_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_PHONE_TYPE_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_PREF_TYPE_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_PREF_TYPE_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_PROPAGATE_EVENT_ACK_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_PROPAGATE_EVENT_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_PROPAGATE_EVENT_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_PROVENANCE_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_PURPOSE_TYPE_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_PURPOSE_TYPE_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_RULE_TYPE_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_RULE_TYPE_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_STAT_TYPE_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_STAT_TYPE_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_SUBSCRIBER_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_VLDTN_PRBLM_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_VLDTN_PRBLM_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_VLDTN_PRBLM_TYPE_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_VLDTN_PRBLM_TYPE_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_VLDTN_RSLT_CLOB_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_VLDTN_RSLT_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_VLDTN_RSLT_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_VLDTN_STATUS_TYPE_H_S TO CIS_SEQ_R;
GRANT SELECT ON CIS.CIS_VLDTN_STATUS_TYPE_S TO CIS_SEQ_R;

-- Grantees of CIS_SEQ_R
GRANT CIS_SEQ_R TO AACDBA WITH ADMIN OPTION;
GRANT CIS_SEQ_R TO CISUSR;
GRANT CIS_SEQ_R TO DNS  ALTMI;
GRANT CIS_SEQ_R TO DNS  RAYD1;
GRANT CIS_SEQ_R TO DNS KAZMIM;
GRANT CIS_SEQ_R TO DNS MUHAMB;
GRANT CIS_SEQ_R TO DNS PASHAA;
GRANT CIS_SEQ_R TO DNS   DOR;
GRANT CIS_SEQ_R TO DNS   FITZGR;
GRANT CIS_SEQ_R TO DNS   LINDSD;
GRANT CIS_SEQ_R TO DNS   SHAHA;
GRANT CIS_SEQ_R TO DNS   SINGHM;
GRANT CIS_SEQ_R TO DNS   TUH;
GRANT CIS_SEQ_R TO DNS   WOODC;
GRANT CIS_SEQ_R TO DNS   CANINB;
GRANT CIS_SEQ_R TO DNS   DHEERA;
GRANT CIS_SEQ_R TO DNS   REENT;
GRANT CIS_SEQ_R TO VIERSUSR;
DROP ROLE AUTHENTICATEDUSER;

CREATE ROLE AUTHENTICATEDUSER NOT IDENTIFIED;

-- Grantees of AUTHENTICATEDUSER
GRANT AUTHENTICATEDUSER TO SYS WITH ADMIN OPTION;
DROP ROLE PLUSTRACE;

CREATE ROLE PLUSTRACE NOT IDENTIFIED;

-- Object privileges granted to PLUSTRACE
GRANT SELECT ON SYS.V_$MYSTAT TO PLUSTRACE;
GRANT SELECT ON SYS.V_$SESSTAT TO PLUSTRACE;
GRANT SELECT ON SYS.V_$STATNAME TO PLUSTRACE;

-- Grantees of PLUSTRACE
GRANT PLUSTRACE TO DBA WITH ADMIN OPTION;
GRANT PLUSTRACE TO SYS WITH ADMIN OPTION;
GRANT PLUSTRACE TO VA_SELECT_CATALOG_ROLE;
DROP ROLE LOBR_R;

CREATE ROLE LOBR_R NOT IDENTIFIED;

-- Object privileges granted to LOBR_R
GRANT SELECT ON LOBR.FILE_ATTACHMENT TO LOBR_R;
GRANT SELECT ON LOBR.FILE_ATTACHMENT_DETAIL TO LOBR_R;
GRANT SELECT ON LOBR.FILE_IMAGE TO LOBR_R;

-- Grantees of LOBR_R
GRANT LOBR_R TO AACDBA;
GRANT LOBR_R TO DNS   CASTER;
GRANT LOBR_R TO DNS   PENNYR;
GRANT LOBR_R TO DNS   REYESJ;
GRANT LOBR_R TO SYSTEM WITH ADMIN OPTION;
GRANT LOBR_R TO DNS  ALTMI;
GRANT LOBR_R TO DNS PASHAA;
GRANT LOBR_R TO DNS  KARANP;
GRANT LOBR_R TO VAMQASCAMPOJ2;
GRANT LOBR_R TO VHA06MARTIK;
GRANT LOBR_R TO DNS   KENNEL;
GRANT LOBR_R TO DNS   HALLT;
GRANT LOBR_R TO DNS  JOHNSB;
GRANT LOBR_R TO DNS   FIERRJ;
GRANT LOBR_R TO DNS   PARVAV;
GRANT LOBR_R TO DNS   ASAFOJ;
GRANT LOBR_R TO DNS   BOYETD;
GRANT LOBR_R TO DNS   CHAMPP;
GRANT LOBR_R TO DNS   CORNED;
GRANT LOBR_R TO DNS   GONZAS;
GRANT LOBR_R TO DNS   HORNEE;
GRANT LOBR_R TO DNS   HUNTEJ;
GRANT LOBR_R TO DNS   JACON;
GRANT LOBR_R TO DNS   JOHNSS;
GRANT LOBR_R TO DNS   PHIFEG;
GRANT LOBR_R TO DNS   SCOTTS;
GRANT LOBR_R TO DNS   SIMSB;
GRANT LOBR_R TO DNS   TIDWG;
GRANT LOBR_R TO DNS   VITENG;
GRANT LOBR_R TO DNS   WALLASH;
GRANT LOBR_R TO DNS   BOYETJ;
GRANT LOBR_R TO DNS   GROOMA;
GRANT LOBR_R TO DNS   FAULKJ;
GRANT LOBR_R TO DNS   INNISJ;
GRANT LOBR_R TO DNS   PURSCD;
GRANT LOBR_R TO DNS   SCHIEK;
GRANT LOBR_R TO DNS   SHEPPL;
GRANT LOBR_R TO DNS   SURVES;
GRANT LOBR_R TO DNS   ALLENM;
GRANT LOBR_R TO DNS   DOR;
GRANT LOBR_R TO DNS   FITZGR;
GRANT LOBR_R TO DNS   ARCHET;
GRANT LOBR_R TO DNS   ARNOLN;
GRANT LOBR_R TO DNS   HOUGAD;
GRANT LOBR_R TO DNS   LINDSD;
GRANT LOBR_R TO DNS   ROLINL;
GRANT LOBR_R TO DNS   SHAHA;
GRANT LOBR_R TO DNS   SINGHM;
GRANT LOBR_R TO DNS   TUH;
GRANT LOBR_R TO DNS   WOODC;
GRANT LOBR_R TO DNS   CANINB;
GRANT LOBR_R TO DNS   LOWRYB;
GRANT LOBR_R TO DNS   DHEERA;
GRANT LOBR_R TO       CHENY;
GRANT LOBR_R TO       HASANM;
GRANT LOBR_R TO       VENIGS;
GRANT LOBR_R TO DNS         ;
GRANT LOBR_R TO DNS   WILLIO;
GRANT LOBR_R TO DNS   REENT;
GRANT LOBR_R TO DNS   SAWEIM;
DROP ROLE LOBR_RW;

CREATE ROLE LOBR_RW NOT IDENTIFIED;

-- Object privileges granted to LOBR_RW
GRANT INSERT, SELECT, UPDATE ON LOBR.FILE_ATTACHMENT TO LOBR_RW;
GRANT INSERT, SELECT, UPDATE ON LOBR.FILE_ATTACHMENT_DETAIL TO LOBR_RW;
GRANT INSERT, SELECT, UPDATE ON LOBR.FILE_IMAGE TO LOBR_RW;

-- Grantees of LOBR_RW
GRANT LOBR_RW TO EEUSR;
GRANT LOBR_RW TO LOBRUSR;
GRANT LOBR_RW TO SYSTEM WITH ADMIN OPTION;
DROP ROLE LOBR_R_S;

CREATE ROLE LOBR_R_S NOT IDENTIFIED;

-- Object privileges granted to LOBR_R_S
GRANT SELECT ON LOBR.FILE_ATTACHMENT_DETAIL_S TO LOBR_R_S;
GRANT SELECT ON LOBR.FILE_ATTACHMENT_S TO LOBR_R_S;
GRANT SELECT ON LOBR.FILE_IMAGE_S TO LOBR_R_S;

-- Grantees of LOBR_R_S
GRANT LOBR_R_S TO EEUSR;
GRANT LOBR_R_S TO LOBRUSR;
GRANT LOBR_R_S TO SYSTEM WITH ADMIN OPTION;
GRANT LOBR_R_S TO DNS  ALTMI;
GRANT LOBR_R_S TO DNS PASHAA;
GRANT LOBR_R_S TO DNS   FIERRJ;
GRANT LOBR_R_S TO DNS   PARVAV;
GRANT LOBR_R_S TO DNS   HORNEE;
GRANT LOBR_R_S TO DNS   DOR;
GRANT LOBR_R_S TO DNS   FITZGR;
GRANT LOBR_R_S TO DNS   LINDSD;
GRANT LOBR_R_S TO DNS   SHAHA;
GRANT LOBR_R_S TO DNS   SINGHM;
GRANT LOBR_R_S TO DNS   TUH;
GRANT LOBR_R_S TO DNS   WOODC;
GRANT LOBR_R_S TO DNS   CANINB;
GRANT LOBR_R_S TO DNS   DHEERA;
GRANT LOBR_R_S TO DNS   WILLIO;
GRANT LOBR_R_S TO DNS   REENT;
DROP ROLE XDBADMIN;

CREATE ROLE XDBADMIN NOT IDENTIFIED;

-- Object privileges granted to XDBADMIN
GRANT SELECT ON SYS.DBA_EPG_DAD_AUTHORIZATION TO XDBADMIN;
GRANT DELETE, INSERT, SELECT ON XDB.APP_ROLE_MEMBERSHIP TO XDBADMIN;
GRANT DELETE, INSERT, SELECT ON XDB.APP_USERS_AND_ROLES TO XDBADMIN;
GRANT ALTER, DELETE, INSERT, SELECT, UPDATE, ON COMMIT REFRESH, QUERY REWRITE, DEBUG, FLASHBACK ON XDB.XDB$CONFIG TO XDBADMIN;

-- Grantees of XDBADMIN
GRANT XDBADMIN TO DBA;
GRANT XDBADMIN TO SYS WITH ADMIN OPTION;
DROP ROLE XDB_SET_INVOKER;

CREATE ROLE XDB_SET_INVOKER NOT IDENTIFIED;

-- Grantees of XDB_SET_INVOKER
GRANT XDB_SET_INVOKER TO DBA;
GRANT XDB_SET_INVOKER TO SYS WITH ADMIN OPTION;
DROP ROLE EESRV_SEQ_R;

CREATE ROLE EESRV_SEQ_R NOT IDENTIFIED;

-- Object privileges granted to EESRV_SEQ_R
GRANT SELECT ON EESRV.REQUEST_FIELD_S TO EESRV_SEQ_R;
GRANT SELECT ON EESRV.REQUEST_GROUP_S TO EESRV_SEQ_R;
GRANT SELECT ON EESRV.SERVICE_LOG_S TO EESRV_SEQ_R;
GRANT SELECT ON EESRV.SERVICE_REQUEST_ASSIGNMENT_S TO EESRV_SEQ_R;
GRANT SELECT ON EESRV.SERVICE_REQUEST_S TO EESRV_SEQ_R;
GRANT SELECT ON EESRV.SERVICE_USER_S TO EESRV_SEQ_R;

-- Grantees of EESRV_SEQ_R
GRANT EESRV_SEQ_R TO AACDBA WITH ADMIN OPTION;
GRANT EESRV_SEQ_R TO EESRVUSR;
GRANT EESRV_SEQ_R TO EEUSR;
DROP ROLE ADRMGT_SEQ_R;

CREATE ROLE ADRMGT_SEQ_R NOT IDENTIFIED;

-- Object privileges granted to ADRMGT_SEQ_R
GRANT SELECT ON ADRMGT.ADR_PARAMETER_H_ID_S TO ADRMGT_SEQ_R;
GRANT SELECT ON ADRMGT.ADR_PARAMETER_ID_S TO ADRMGT_SEQ_R;
GRANT SELECT ON ADRMGT.ADR_USER_CONTACT_H_S TO ADRMGT_SEQ_R;
GRANT SELECT ON ADRMGT.ADR_USER_CONTACT_S TO ADRMGT_SEQ_R;
GRANT SELECT ON ADRMGT.CCR_H_S TO ADRMGT_SEQ_R;
GRANT SELECT ON ADRMGT.CCR_S TO ADRMGT_SEQ_R;
GRANT SELECT ON ADRMGT.DEPLOYMENT_H_S TO ADRMGT_SEQ_R;
GRANT SELECT ON ADRMGT.DEPLOYMENT_S TO ADRMGT_SEQ_R;
GRANT SELECT ON ADRMGT.JOB_PROCESS_ERRS_ID_S TO ADRMGT_SEQ_R;
GRANT SELECT ON ADRMGT.JOB_PROCESS_LOGS_ID_S TO ADRMGT_SEQ_R;
GRANT SELECT ON ADRMGT.OAC_PARAMETER_S TO ADRMGT_SEQ_R;
GRANT SELECT ON ADRMGT.RELEASE_H_S TO ADRMGT_SEQ_R;
GRANT SELECT ON ADRMGT.RELEASE_S TO ADRMGT_SEQ_R;

-- Grantees of ADRMGT_SEQ_R
GRANT ADRMGT_SEQ_R TO AACDBA WITH ADMIN OPTION;
GRANT ADRMGT_SEQ_R TO ADR;
GRANT ADRMGT_SEQ_R TO ADREXT;
GRANT ADRMGT_SEQ_R TO PSIM;
GRANT ADRMGT_SEQ_R TO DNS   SINGHM;
DROP ROLE ADRMGT_APP_R;

CREATE ROLE ADRMGT_APP_R NOT IDENTIFIED;

-- Object privileges granted to ADRMGT_APP_R
GRANT SELECT ON ADRMGT.ADR_PARAMETER TO ADRMGT_APP_R;
GRANT SELECT ON ADRMGT.ADR_PARAMETER_H TO ADRMGT_APP_R;
GRANT SELECT ON ADRMGT.JOB_PROCESS_ERRS TO ADRMGT_APP_R;
GRANT SELECT ON ADRMGT.JOB_PROCESS_LOGS TO ADRMGT_APP_R;

-- Grantees of ADRMGT_APP_R
GRANT ADRMGT_APP_R TO AACDBA WITH ADMIN OPTION;
GRANT ADRMGT_APP_R TO DNS   CASTER;
GRANT ADRMGT_APP_R TO DNS   PENNYR;
GRANT ADRMGT_APP_R TO DNS   REYESJ;
GRANT ADRMGT_APP_R TO DNS  ALTMI;
GRANT ADRMGT_APP_R TO DNS PASHAA;
GRANT ADRMGT_APP_R TO DNS   BOYETD;
GRANT ADRMGT_APP_R TO DNS   CHAMPP;
GRANT ADRMGT_APP_R TO DNS   CORNED;
GRANT ADRMGT_APP_R TO DNS   JACON;
GRANT ADRMGT_APP_R TO DNS   PHIFEG;
GRANT ADRMGT_APP_R TO DNS   SCOTTS;
GRANT ADRMGT_APP_R TO DNS   TIDWG;
GRANT ADRMGT_APP_R TO DNS   VITENG;
GRANT ADRMGT_APP_R TO DNS   WALLASH;
GRANT ADRMGT_APP_R TO DNS   BOYETJ;
GRANT ADRMGT_APP_R TO DNS   GROOMA;
GRANT ADRMGT_APP_R TO DNS   FAULKJ;
GRANT ADRMGT_APP_R TO DNS   INNISJ;
GRANT ADRMGT_APP_R TO DNS   PURSCD;
GRANT ADRMGT_APP_R TO DNS   SCHIEK;
GRANT ADRMGT_APP_R TO DNS   SHEPPL;
GRANT ADRMGT_APP_R TO DNS   SURVES;
GRANT ADRMGT_APP_R TO DNS   ALLENM;
GRANT ADRMGT_APP_R TO DNS   DOR;
GRANT ADRMGT_APP_R TO DNS   FITZGR;
GRANT ADRMGT_APP_R TO DNS   ARCHET;
GRANT ADRMGT_APP_R TO DNS   LINDSD;
GRANT ADRMGT_APP_R TO DNS   SHAHA;
GRANT ADRMGT_APP_R TO DNS   SINGHM;
GRANT ADRMGT_APP_R TO DNS   TUH;
GRANT ADRMGT_APP_R TO DNS   WOODC;
GRANT ADRMGT_APP_R TO DNS   CANINB;
GRANT ADRMGT_APP_R TO DNS   DHEERA;
GRANT ADRMGT_APP_R TO       CHENY;
GRANT ADRMGT_APP_R TO       HASANM;
GRANT ADRMGT_APP_R TO       VENIGS;
GRANT ADRMGT_APP_R TO DNS   REENT;
DROP ROLE ADRMGT_APP_RW;

CREATE ROLE ADRMGT_APP_RW NOT IDENTIFIED;

-- Object privileges granted to ADRMGT_APP_RW
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRMGT.ADR_PARAMETER TO ADRMGT_APP_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRMGT.ADR_PARAMETER_H TO ADRMGT_APP_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRMGT.JOB_PROCESS_ERRS TO ADRMGT_APP_RW;
GRANT EXECUTE ON ADRMGT.JOB_PROCESS_ERR_SP TO ADRMGT_APP_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRMGT.JOB_PROCESS_LOGS TO ADRMGT_APP_RW;
GRANT EXECUTE ON ADRMGT.JOB_PROCESS_LOG_SP TO ADRMGT_APP_RW;

-- Grantees of ADRMGT_APP_RW
GRANT ADRMGT_APP_RW TO AACDBA WITH ADMIN OPTION;
GRANT ADRMGT_APP_RW TO ADR;
GRANT ADRMGT_APP_RW TO ADREXT;
GRANT ADRMGT_APP_RW TO ADRREF;
GRANT ADRMGT_APP_RW TO PSIM;
DROP ROLE ADRMGT_CM_R;

CREATE ROLE ADRMGT_CM_R NOT IDENTIFIED;

-- Object privileges granted to ADRMGT_CM_R
GRANT SELECT ON ADRMGT.CCR TO ADRMGT_CM_R;
GRANT SELECT ON ADRMGT.CCR_H TO ADRMGT_CM_R;
GRANT SELECT ON ADRMGT.DEPLOYMENT TO ADRMGT_CM_R;
GRANT SELECT ON ADRMGT.DEPLOYMENT_H TO ADRMGT_CM_R;
GRANT SELECT ON ADRMGT.RELEASE TO ADRMGT_CM_R;
GRANT SELECT ON ADRMGT.RELEASE_H TO ADRMGT_CM_R;
GRANT SELECT ON ADRMGT.TOP10TBL TO ADRMGT_CM_R;

-- Grantees of ADRMGT_CM_R
GRANT ADRMGT_CM_R TO AACDBA WITH ADMIN OPTION;
GRANT ADRMGT_CM_R TO DNS  ALTMI;
GRANT ADRMGT_CM_R TO DNS PASHAA;
GRANT ADRMGT_CM_R TO DNS   FAULKJ;
GRANT ADRMGT_CM_R TO DNS   DOR;
GRANT ADRMGT_CM_R TO DNS   FITZGR;
GRANT ADRMGT_CM_R TO DNS   LINDSD;
GRANT ADRMGT_CM_R TO DNS   SHAHA;
GRANT ADRMGT_CM_R TO DNS   TUH;
GRANT ADRMGT_CM_R TO DNS   WOODC;
GRANT ADRMGT_CM_R TO DNS   CANINB;
GRANT ADRMGT_CM_R TO DNS   DHEERA;
GRANT ADRMGT_CM_R TO DNS   REENT;
DROP ROLE ADRMGT_CM_RW;

CREATE ROLE ADRMGT_CM_RW NOT IDENTIFIED;

-- Object privileges granted to ADRMGT_CM_RW
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRMGT.CCR TO ADRMGT_CM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRMGT.CCR_H TO ADRMGT_CM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRMGT.DEPLOYMENT TO ADRMGT_CM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRMGT.DEPLOYMENT_H TO ADRMGT_CM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRMGT.RELEASE TO ADRMGT_CM_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRMGT.RELEASE_H TO ADRMGT_CM_RW;

-- Grantees of ADRMGT_CM_RW
GRANT ADRMGT_CM_RW TO AACDBA WITH ADMIN OPTION;
GRANT ADRMGT_CM_RW TO ADREXT;
GRANT ADRMGT_CM_RW TO PSIM;
GRANT ADRMGT_CM_RW TO DNS   SHAHA;
GRANT ADRMGT_CM_RW TO DNS   SINGHM;
DROP ROLE HS_ADMIN_EXECUTE_ROLE;

CREATE ROLE HS_ADMIN_EXECUTE_ROLE NOT IDENTIFIED;

-- Object privileges granted to HS_ADMIN_EXECUTE_ROLE
GRANT EXECUTE ON SYS.DBMS_HS TO HS_ADMIN_EXECUTE_ROLE;

-- Grantees of HS_ADMIN_EXECUTE_ROLE
GRANT HS_ADMIN_EXECUTE_ROLE TO EXECUTE_CATALOG_ROLE;
GRANT HS_ADMIN_EXECUTE_ROLE TO HS_ADMIN_ROLE;
GRANT HS_ADMIN_EXECUTE_ROLE TO SYS WITH ADMIN OPTION;
DROP ROLE ADRMGT_DBA_R;

CREATE ROLE ADRMGT_DBA_R NOT IDENTIFIED;

-- Object privileges granted to ADRMGT_DBA_R
GRANT SELECT ON ADRMGT.ADR_USER_CONTACT TO ADRMGT_DBA_R;
GRANT SELECT ON ADRMGT.ADR_USER_CONTACT_H TO ADRMGT_DBA_R;
GRANT SELECT ON ADRMGT.OAC_PARAMETER TO ADRMGT_DBA_R;
GRANT SELECT ON ADRMGT.STATS_TABLE_140111_190204 TO ADRMGT_DBA_R;

-- Grantees of ADRMGT_DBA_R
GRANT ADRMGT_DBA_R TO AACDBA WITH ADMIN OPTION;
GRANT ADRMGT_DBA_R TO ACA;
GRANT ADRMGT_DBA_R TO BENS;
GRANT ADRMGT_DBA_R TO CIS;
GRANT ADRMGT_DBA_R TO DNS  ALTMI;
GRANT ADRMGT_DBA_R TO DNS PASHAA;
GRANT ADRMGT_DBA_R TO DNS   FAULKJ;
GRANT ADRMGT_DBA_R TO DNS   DOR;
GRANT ADRMGT_DBA_R TO DNS   FITZGR;
GRANT ADRMGT_DBA_R TO DNS   LINDSD;
GRANT ADRMGT_DBA_R TO DNS   SHAHA;
GRANT ADRMGT_DBA_R TO DNS   SINGHM;
GRANT ADRMGT_DBA_R TO DNS   TUH;
GRANT ADRMGT_DBA_R TO DNS   WOODC;
GRANT ADRMGT_DBA_R TO DNS   CANINB;
GRANT ADRMGT_DBA_R TO DNS   DHEERA;
GRANT ADRMGT_DBA_R TO DNS   REENT;
GRANT ADRMGT_DBA_R TO VOA;
DROP ROLE ADRMGT_DBA_RW;

CREATE ROLE ADRMGT_DBA_RW NOT IDENTIFIED;

-- Object privileges granted to ADRMGT_DBA_RW
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRMGT.ADR_USER_CONTACT TO ADRMGT_DBA_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRMGT.ADR_USER_CONTACT_H TO ADRMGT_DBA_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRMGT.OAC_PARAMETER TO ADRMGT_DBA_RW;

-- Grantees of ADRMGT_DBA_RW
GRANT ADRMGT_DBA_RW TO AACDBA WITH ADMIN OPTION;
GRANT ADRMGT_DBA_RW TO DNS  ALTMI;
GRANT ADRMGT_DBA_RW TO DNS PASHAA;
GRANT ADRMGT_DBA_RW TO DNS   DOR;
GRANT ADRMGT_DBA_RW TO DNS   FITZGR;
GRANT ADRMGT_DBA_RW TO DNS   WOODC;
GRANT ADRMGT_DBA_RW TO DNS   CANINB;
GRANT ADRMGT_DBA_RW TO DNS   DHEERA;
GRANT ADRMGT_DBA_RW TO DNS   REENT;
DROP ROLE EESRV_R;

CREATE ROLE EESRV_R NOT IDENTIFIED;

-- Object privileges granted to EESRV_R
GRANT SELECT ON ADRAAP.APPLICATION_IN_PROCESS TO EESRV_R;
GRANT SELECT ON ADRAAP.ENROLLMENT_APPLICATION TO EESRV_R;
GRANT SELECT ON ADRREF.STD_ENROLL_APPLICATION_METHOD TO EESRV_R;
GRANT SELECT ON ADRREF.STD_ENROLL_APPLICATION_STATUS TO EESRV_R;
GRANT SELECT ON EESRV.FIELD TO EESRV_R;
GRANT SELECT ON EESRV.FIELD_GROUP TO EESRV_R;
GRANT SELECT ON EESRV.FIELD_GROUP_H TO EESRV_R;
GRANT SELECT ON EESRV.FIELD_H TO EESRV_R;
GRANT SELECT ON EESRV.REQUEST_FIELD TO EESRV_R;
GRANT SELECT ON EESRV.REQUEST_FIELD_H TO EESRV_R;
GRANT SELECT ON EESRV.REQUEST_GROUP TO EESRV_R;
GRANT SELECT ON EESRV.REQUEST_GROUP_H TO EESRV_R;
GRANT SELECT ON EESRV.SERVICE_LOG TO EESRV_R;
GRANT SELECT ON EESRV.SERVICE_REQUEST TO EESRV_R;
GRANT SELECT ON EESRV.SERVICE_REQUEST_ASSIGNMENT TO EESRV_R;
GRANT SELECT ON EESRV.SERVICE_REQUEST_ASSIGNMENT_H TO EESRV_R;
GRANT SELECT ON EESRV.SERVICE_REQUEST_H TO EESRV_R;
GRANT SELECT ON EESRV.SERVICE_USER TO EESRV_R;
GRANT SELECT ON EESRV.SERVICE_USER_H TO EESRV_R;

-- Grantees of EESRV_R
GRANT EESRV_R TO AACDBA WITH ADMIN OPTION;
GRANT EESRV_R TO EEUSR;
GRANT EESRV_R TO DNS   CASTER;
GRANT EESRV_R TO DNS   PENNYR;
GRANT EESRV_R TO DNS   REYESJ;
GRANT EESRV_R TO DNS  ALTMI;
GRANT EESRV_R TO DNS PASHAA;
GRANT EESRV_R TO DNS  KARANP;
GRANT EESRV_R TO DNS  MORGAR;
GRANT EESRV_R TO VHA06MARTIK;
GRANT EESRV_R TO DNS   KENNEL;
GRANT EESRV_R TO DNS   HALLT;
GRANT EESRV_R TO DNS  JOHNSB;
GRANT EESRV_R TO DNS   BOYETD;
GRANT EESRV_R TO DNS   CHAMPP;
GRANT EESRV_R TO DNS   CORNED;
GRANT EESRV_R TO DNS   JACON;
GRANT EESRV_R TO DNS   JOHNSS;
GRANT EESRV_R TO DNS   PHIFEG;
GRANT EESRV_R TO DNS   SCOTTS;
GRANT EESRV_R TO DNS   TIDWG;
GRANT EESRV_R TO DNS   VITENG;
GRANT EESRV_R TO DNS   WALLASH;
GRANT EESRV_R TO DNS   WILLSC;
GRANT EESRV_R TO DNS   BOYETJ;
GRANT EESRV_R TO DNS   GROOMA;
GRANT EESRV_R TO DNS   WHELEC;
GRANT EESRV_R TO DNS   WOODM;
GRANT EESRV_R TO DNS   FAULKJ;
GRANT EESRV_R TO DNS   INNISJ;
GRANT EESRV_R TO DNS   PURSCD;
GRANT EESRV_R TO DNS   SCHIEK;
GRANT EESRV_R TO DNS   SHEPPL;
GRANT EESRV_R TO DNS   SURVES;
GRANT EESRV_R TO DNS   ALLENM;
GRANT EESRV_R TO DNS   DOR;
GRANT EESRV_R TO DNS   FITZGR;
GRANT EESRV_R TO DNS   ARCHET;
GRANT EESRV_R TO DNS   ARNOLN;
GRANT EESRV_R TO DNS   HUANGC;
GRANT EESRV_R TO DNS   LINDSD;
GRANT EESRV_R TO DNS   ROLINL;
GRANT EESRV_R TO DNS   SHAHA;
GRANT EESRV_R TO DNS   SINGHM;
GRANT EESRV_R TO DNS   TUH;
GRANT EESRV_R TO DNS   WOODC;
GRANT EESRV_R TO DNS   CANINB;
GRANT EESRV_R TO DNS   CHEKMM;
GRANT EESRV_R TO DNS   CHINC;
GRANT EESRV_R TO DNS   KOGANI;
GRANT EESRV_R TO DNS   LOPEZD;
GRANT EESRV_R TO DNS   LOWRYB;
GRANT EESRV_R TO DNS   ROCHAD;
GRANT EESRV_R TO DNS   DHEERA;
GRANT EESRV_R TO       BATESL;
GRANT EESRV_R TO       CHENY;
GRANT EESRV_R TO       HASANM;
GRANT EESRV_R TO       PRICEW;
GRANT EESRV_R TO       VENIGS;
GRANT EESRV_R TO DNS         ;
GRANT EESRV_R TO DNS   REENT;
DROP ROLE EESRV_RW;

CREATE ROLE EESRV_RW NOT IDENTIFIED;

-- Object privileges granted to EESRV_RW
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRAAP.APPLICATION_IN_PROCESS TO EESRV_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRAAP.ENROLLMENT_APPLICATION TO EESRV_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRREF.STD_ENROLL_APPLICATION_METHOD TO EESRV_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRREF.STD_ENROLL_APPLICATION_STATUS TO EESRV_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON EESRV.FIELD TO EESRV_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON EESRV.FIELD_GROUP TO EESRV_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON EESRV.FIELD_GROUP_H TO EESRV_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON EESRV.FIELD_H TO EESRV_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON EESRV.REQUEST_FIELD TO EESRV_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON EESRV.REQUEST_FIELD_H TO EESRV_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON EESRV.REQUEST_GROUP TO EESRV_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON EESRV.REQUEST_GROUP_H TO EESRV_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON EESRV.SERVICE_LOG TO EESRV_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON EESRV.SERVICE_REQUEST TO EESRV_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON EESRV.SERVICE_REQUEST_ASSIGNMENT TO EESRV_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON EESRV.SERVICE_REQUEST_ASSIGNMENT_H TO EESRV_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON EESRV.SERVICE_REQUEST_H TO EESRV_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON EESRV.SERVICE_USER TO EESRV_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON EESRV.SERVICE_USER_H TO EESRV_RW;

-- Grantees of EESRV_RW
GRANT EESRV_RW TO AACDBA WITH ADMIN OPTION;
GRANT EESRV_RW TO EESRVUSR;
GRANT EESRV_RW TO EEUSR;
DROP ROLE JRULE_R;

CREATE ROLE JRULE_R NOT IDENTIFIED;

-- Object privileges granted to JRULE_R
GRANT SELECT ON JRULE.ABSTRACTQUERY TO JRULE_R;
GRANT SELECT ON JRULE.ALGORITHMKIND TO JRULE_R;
GRANT SELECT ON JRULE.ARGUMENT TO JRULE_R;
GRANT SELECT ON JRULE.BASELINE TO JRULE_R;
GRANT SELECT ON JRULE.BASELINECONTENT TO JRULE_R;
GRANT SELECT ON JRULE.BASELINEDEPENDENCY TO JRULE_R;
GRANT SELECT ON JRULE.BASELINEKIND TO JRULE_R;
GRANT SELECT ON JRULE.BOM TO JRULE_R;
GRANT SELECT ON JRULE.BOM2XOMMAPPING TO JRULE_R;
GRANT SELECT ON JRULE.BOMPATHENTRY TO JRULE_R;
GRANT SELECT ON JRULE.BRSTUDIO TO JRULE_R;
GRANT SELECT ON JRULE.CONNECTIONENTRY TO JRULE_R;
GRANT SELECT ON JRULE.DEFINITION TO JRULE_R;
GRANT SELECT ON JRULE.DEPENDENCY TO JRULE_R;
GRANT SELECT ON JRULE.DIRECTIONKIND TO JRULE_R;
GRANT SELECT ON JRULE.EXECUTION_TRACES TO JRULE_R;
GRANT SELECT ON JRULE.EXITCRITERIAKIND TO JRULE_R;
GRANT SELECT ON JRULE.EXTRACTOR TO JRULE_R;
GRANT SELECT ON JRULE.ILRGROUP TO JRULE_R;
GRANT SELECT ON JRULE.INITIALVALUE TO JRULE_R;
GRANT SELECT ON JRULE.LOCKTBL TO JRULE_R;
GRANT SELECT ON JRULE.MESSAGEMAP TO JRULE_R;
GRANT SELECT ON JRULE.METAMODEL TO JRULE_R;
GRANT SELECT ON JRULE.ORDERINGKIND TO JRULE_R;
GRANT SELECT ON JRULE.OVERRIDDENRULE TO JRULE_R;
GRANT SELECT ON JRULE.PARAMETER TO JRULE_R;
GRANT SELECT ON JRULE.PERMISSION TO JRULE_R;
GRANT SELECT ON JRULE.PROJECTINFO TO JRULE_R;
GRANT SELECT ON JRULE.PROJECTINFOTAG TO JRULE_R;
GRANT SELECT ON JRULE.PROXY TO JRULE_R;
GRANT SELECT ON JRULE.RPLFTRGT TO JRULE_R;
GRANT SELECT ON JRULE.RTSRESOURCE TO JRULE_R;
GRANT SELECT ON JRULE.RTSSCHEMA TO JRULE_R;
GRANT SELECT ON JRULE.RULEAPP TO JRULE_R;
GRANT SELECT ON JRULE.RULEAPPPROPERTY TO JRULE_R;
GRANT SELECT ON JRULE.RULEAPPS TO JRULE_R;
GRANT SELECT ON JRULE.RULEAPP_PROPERTIES TO JRULE_R;
GRANT SELECT ON JRULE.RULEARTIFACT TO JRULE_R;
GRANT SELECT ON JRULE.RULEARTIFACTSIBLING TO JRULE_R;
GRANT SELECT ON JRULE.RULEARTIFACTTAG TO JRULE_R;
GRANT SELECT ON JRULE.RULEFLOW TO JRULE_R;
GRANT SELECT ON JRULE.RULEFLOWSIBLING TO JRULE_R;
GRANT SELECT ON JRULE.RULEFLOWTAG TO JRULE_R;
GRANT SELECT ON JRULE.RULEPACKAGE TO JRULE_R;
GRANT SELECT ON JRULE.RULEPACKAGESIBLING TO JRULE_R;
GRANT SELECT ON JRULE.RULEPROJECT TO JRULE_R;
GRANT SELECT ON JRULE.RULEPROJECTTAG TO JRULE_R;
GRANT SELECT ON JRULE.RULESET TO JRULE_R;
GRANT SELECT ON JRULE.RULESETPROPERTY TO JRULE_R;
GRANT SELECT ON JRULE.RULESETS TO JRULE_R;
GRANT SELECT ON JRULE.RULESET_PROPERTIES TO JRULE_R;
GRANT SELECT ON JRULE.RULESET_RESOURCES TO JRULE_R;
GRANT SELECT ON JRULE.SCENARIOSUITE TO JRULE_R;
GRANT SELECT ON JRULE.SCENARIOSUITEKPIREPORT TO JRULE_R;
GRANT SELECT ON JRULE.SCENARIOSUITEREPORT TO JRULE_R;
GRANT SELECT ON JRULE.SCENARIOSUITERESOURCE TO JRULE_R;
GRANT SELECT ON JRULE.SCENARIOTESTREPORT TO JRULE_R;
GRANT SELECT ON JRULE.SCHEMAVERSION TO JRULE_R;
GRANT SELECT ON JRULE.SCOPEELEMENT TO JRULE_R;
GRANT SELECT ON JRULE.SERVER TO JRULE_R;
GRANT SELECT ON JRULE.SERVERKIND TO JRULE_R;
GRANT SELECT ON JRULE.STATUS TO JRULE_R;
GRANT SELECT ON JRULE.TASK TO JRULE_R;
GRANT SELECT ON JRULE.TEMPLATE TO JRULE_R;
GRANT SELECT ON JRULE.TESTREPORT TO JRULE_R;
GRANT SELECT ON JRULE.USERSETTING TO JRULE_R;
GRANT SELECT ON JRULE.VARIABLE TO JRULE_R;
GRANT SELECT ON JRULE.VARIABLESET TO JRULE_R;
GRANT SELECT ON JRULE.VERSION TO JRULE_R;
GRANT SELECT ON JRULE.VOCABULARY TO JRULE_R;

-- Grantees of JRULE_R
GRANT JRULE_R TO AACDBA WITH ADMIN OPTION;
GRANT JRULE_R TO DNS  ALTMI;
GRANT JRULE_R TO DNS PASHAA;
GRANT JRULE_R TO DNS   DOR;
GRANT JRULE_R TO DNS   FITZGR;
GRANT JRULE_R TO DNS   LINDSD;
GRANT JRULE_R TO DNS   SHAHA;
GRANT JRULE_R TO DNS   SINGHM;
GRANT JRULE_R TO DNS   TUH;
GRANT JRULE_R TO DNS   WOODC;
GRANT JRULE_R TO DNS   CANINB;
GRANT JRULE_R TO DNS   DHEERA;
GRANT JRULE_R TO DNS   REENT;
DROP ROLE VBR_RW;

CREATE ROLE VBR_RW NOT IDENTIFIED;

-- Object privileges granted to VBR_RW
GRANT INSERT, SELECT, UPDATE ON VBR.DOCUMENT TO VBR_RW;
GRANT INSERT, SELECT, UPDATE ON VBR.DOCUMENT_RECEIPT TO VBR_RW;
GRANT INSERT, SELECT, UPDATE ON VBR.DOCUMENT_TYPE TO VBR_RW;
GRANT INSERT, SELECT, UPDATE ON VBR.VETERAN_IDENTIFIER_TYPE TO VBR_RW;
GRANT INSERT, SELECT, UPDATE ON VBR.VET_HEALTH_BENEFIT_PLAN TO VBR_RW;

-- Grantees of VBR_RW
GRANT VBR_RW TO AACDBA WITH ADMIN OPTION;
GRANT VBR_RW TO EEUSR;
GRANT VBR_RW TO VBR;
GRANT VBR_RW TO VBRUSR;
DROP ROLE EESRV_H_SEQ_R;

CREATE ROLE EESRV_H_SEQ_R NOT IDENTIFIED;

-- Object privileges granted to EESRV_H_SEQ_R
GRANT SELECT ON EESRV.FIELD_GROUP_H_S TO EESRV_H_SEQ_R;
GRANT SELECT ON EESRV.FIELD_H_S TO EESRV_H_SEQ_R;
GRANT SELECT ON EESRV.REQUEST_FIELD_H_S TO EESRV_H_SEQ_R;
GRANT SELECT ON EESRV.REQUEST_GROUP_H_S TO EESRV_H_SEQ_R;
GRANT SELECT ON EESRV.SERVICE_REQUEST_ASSIGNMENT_H_S TO EESRV_H_SEQ_R;
GRANT SELECT ON EESRV.SERVICE_REQUEST_H_S TO EESRV_H_SEQ_R;
GRANT SELECT ON EESRV.SERVICE_USER_H_S TO EESRV_H_SEQ_R;

-- Grantees of EESRV_H_SEQ_R
GRANT EESRV_H_SEQ_R TO AACDBA WITH ADMIN OPTION;
GRANT EESRV_H_SEQ_R TO EESRVUSR;
DROP ROLE HS_ADMIN_SELECT_ROLE;

CREATE ROLE HS_ADMIN_SELECT_ROLE NOT IDENTIFIED;

-- Object privileges granted to HS_ADMIN_SELECT_ROLE
GRANT SELECT ON SYS.HS_ALL_CAPS TO HS_ADMIN_SELECT_ROLE;
GRANT SELECT ON SYS.HS_ALL_DD TO HS_ADMIN_SELECT_ROLE;
GRANT SELECT ON SYS.HS_ALL_INITS TO HS_ADMIN_SELECT_ROLE;
GRANT SELECT ON SYS.HS_BASE_CAPS TO HS_ADMIN_SELECT_ROLE;
GRANT SELECT ON SYS.HS_BASE_DD TO HS_ADMIN_SELECT_ROLE;
GRANT SELECT ON SYS.HS_CLASS_CAPS TO HS_ADMIN_SELECT_ROLE;
GRANT SELECT ON SYS.HS_CLASS_DD TO HS_ADMIN_SELECT_ROLE;
GRANT SELECT ON SYS.HS_CLASS_INIT TO HS_ADMIN_SELECT_ROLE;
GRANT SELECT ON SYS.HS_FDS_CLASS TO HS_ADMIN_SELECT_ROLE;
GRANT SELECT ON SYS.HS_FDS_CLASS_DATE TO HS_ADMIN_SELECT_ROLE;
GRANT SELECT ON SYS.HS_FDS_INST TO HS_ADMIN_SELECT_ROLE;
GRANT SELECT ON SYS.HS_INST_CAPS TO HS_ADMIN_SELECT_ROLE;
GRANT SELECT ON SYS.HS_INST_DD TO HS_ADMIN_SELECT_ROLE;
GRANT SELECT ON SYS.HS_INST_INIT TO HS_ADMIN_SELECT_ROLE;

-- Grantees of HS_ADMIN_SELECT_ROLE
GRANT HS_ADMIN_SELECT_ROLE TO HS_ADMIN_ROLE;
GRANT HS_ADMIN_SELECT_ROLE TO SELECT_CATALOG_ROLE;
GRANT HS_ADMIN_SELECT_ROLE TO SYS WITH ADMIN OPTION;
DROP ROLE ADRREF_R;

CREATE ROLE ADRREF_R NOT IDENTIFIED;

-- Object privileges granted to ADRREF_R
GRANT SELECT ON ADRAAP.APPLICATION_IN_PROCESS TO ADRREF_R;
GRANT SELECT ON ADRAAP.ENROLLMENT_APPLICATION TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_APPPARAMETERTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_APPPARAMETERTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_APPPARAMETERUNIT TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_APPPARAMETERUNITHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_APPPARAMGRPTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_APPPARAMGRPTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_CLSOURCEOFCHANGE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_CLSOURCEOFCHANGEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_CLVERIFICATIONTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_CLVERIFICATIONTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_COMMERRORTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_COMMERRORTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_COMMLETTERGENTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_COMMLETTERGENTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_COMMLETTERTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_COMMLETTERTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_COMMMAILINGSTTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_COMMMAILINGSTTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_COMMMLTRIGGERTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_COMMMLTRIGGERTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_COMREJECTREASONTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_COMREJECTREASONTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_ENROLL_APPLICATION_METHOD TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_ENROLL_APPLICATION_STATUS TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_HANDBOOKBATCHREQUESTSTATUS TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_HANDBOOKMAILSTATTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_HANDBOOKRELEASECONTROL TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_HLTHBENEFITPLANTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_HLTHBENEFITPLANTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_LANGUAGECODE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_LANGUAGECODEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_NCOADELIVERYTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_NCOADELIVERYTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_NCOASTATUSTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_NCOASTATUSTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_NCOAZIPMATCHTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_NCOAZIPMATCHTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_NCOAZIPNOMATCHTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_NCOAZIPNOMATCHTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_PERMISSIONTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_PERMISSIONTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_REPORTELIGFACTOR TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_REPORTELIGFACTORHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_REPORTENROLLPRSTAT TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_REPORTENROLLPRSTATHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_REPORTTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_REPORTTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTDAYOFMONTHTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTDAYOFMONTHTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTDAYOFQUARTERTYP TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTDAYOFQUARTERTYPHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTDAYOFWEEKTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTDAYOFWEEKTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTDETAILBYTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTDETAILBYTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTDETAILFORTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTDETAILFORTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTDIVISIONTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTDIVISIONTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTEEDWEEKLYTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTEEDWEEKLYTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTEXCEPTIONTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTEXCEPTIONTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTLETTERFILETYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTLETTERFILETYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTMONTHLIST TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTMONTHLISTHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTOUTFORMATTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTOUTFORMATTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTOUTPUTFILETYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTOUTPUTFILETYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTPERIODTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTPERIODTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTQUARTERLIST TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTQUARTERLISTHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTRUNFREQUENCYTYP TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTRUNFREQUENCYTYPHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTSCHEDULETYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTSCHEDULETYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTSITEDISPLAYTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTSITEDISPLAYTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTSTANDARDREPORTS TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTSTANDARDREPORTSHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTSTATUSCOMPONENT TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTSTATUSCOMPONENTHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTWEEKOFMONTHTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTWEEKOFMONTHTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTWORKITEMSTTYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_RPTWORKITEMSTTYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_USERABSENCETYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_USERABSENCETYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_WKFDATAJOBACTION TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_WKFDATAJOBACTIONHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_WKFDATAJOBSTATUS TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_WKFDATAJOBSTATUSHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_WKFISSUETYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_WKFISSUETYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_WKFLOCASEACTIVITYHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_WKFLOCASEREQUESTHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_WKFLOCASESTATUSHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_WKFLOCASETYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_WKFLOUPDATETYPEHISTORY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_WORKFLOWCASEACTIVITY TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_WORKFLOWCASEREQUEST TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_WORKFLOWCASESTATUS TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_WORKFLOWCASETYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.STD_WORKFLOWUPDATETYPE TO ADRREF_R;
GRANT SELECT ON ADRREF.TABLEMANAGER TO ADRREF_R;

-- Grantees of ADRREF_R
GRANT ADRREF_R TO AACDBA WITH ADMIN OPTION;
GRANT ADRREF_R TO ADRREFSYNC;
GRANT ADRREF_R TO DNS   CASTER;
GRANT ADRREF_R TO DNS   PENNYR;
GRANT ADRREF_R TO DNS   REYESJ;
GRANT ADRREF_R TO SDS_SELECT;
GRANT ADRREF_R TO DNS  ALTMI;
GRANT ADRREF_R TO DNS PASHAA;
GRANT ADRREF_R TO DNS  KARANP;
GRANT ADRREF_R TO VAMQASCAMPOJ2;
GRANT ADRREF_R TO VHA06MARTIK;
GRANT ADRREF_R TO DNS   KENNEL;
GRANT ADRREF_R TO DNS   HALLT;
GRANT ADRREF_R TO DNS  JACOBR;
GRANT ADRREF_R TO DNS  JOHNSB;
GRANT ADRREF_R TO DNS   FIERRJ;
GRANT ADRREF_R TO DNS   PARVAV;
GRANT ADRREF_R TO DNS   ASAFOJ;
GRANT ADRREF_R TO DNS   BOYETD;
GRANT ADRREF_R TO DNS   CHAMPP;
GRANT ADRREF_R TO DNS   CORNED;
GRANT ADRREF_R TO DNS   GONZAS;
GRANT ADRREF_R TO DNS   HORNEE;
GRANT ADRREF_R TO DNS   HUNTEJ;
GRANT ADRREF_R TO DNS   JACON;
GRANT ADRREF_R TO DNS   JOHNSS;
GRANT ADRREF_R TO DNS   PHIFEG;
GRANT ADRREF_R TO DNS   SCOTTS;
GRANT ADRREF_R TO DNS   SIMSB;
GRANT ADRREF_R TO DNS   TIDWG;
GRANT ADRREF_R TO DNS   VITENG;
GRANT ADRREF_R TO DNS   WALLASH;
GRANT ADRREF_R TO DNS   BOYETJ;
GRANT ADRREF_R TO DNS   GROOMA;
GRANT ADRREF_R TO DNS   FAULKJ;
GRANT ADRREF_R TO DNS   INNISJ;
GRANT ADRREF_R TO DNS   PURSCD;
GRANT ADRREF_R TO DNS   SCHIEK;
GRANT ADRREF_R TO DNS   SHEPPL;
GRANT ADRREF_R TO DNS   SURVES;
GRANT ADRREF_R TO DNS   ALLENM;
GRANT ADRREF_R TO DNS   FITZGR;
GRANT ADRREF_R TO DNS   ARCHET;
GRANT ADRREF_R TO DNS   ARNOLN;
GRANT ADRREF_R TO DNS   HOUGAD;
GRANT ADRREF_R TO DNS   LINDSD;
GRANT ADRREF_R TO DNS   ROLINL;
GRANT ADRREF_R TO DNS   SHAHA;
GRANT ADRREF_R TO DNS   SINGHM;
GRANT ADRREF_R TO DNS   TUH;
GRANT ADRREF_R TO DNS   WOODC;
GRANT ADRREF_R TO DNS   LOWRYB;
GRANT ADRREF_R TO DNS   DHEERA;
GRANT ADRREF_R TO       CHENY;
GRANT ADRREF_R TO       HASANM;
GRANT ADRREF_R TO       VENIGS;
GRANT ADRREF_R TO DNS         ;
GRANT ADRREF_R TO DNS   WILLIO;
GRANT ADRREF_R TO DNS   REENT;
GRANT ADRREF_R TO DNS   SAWEIM;
DROP ROLE ADRREF_RW;

CREATE ROLE ADRREF_RW NOT IDENTIFIED;

-- Object privileges granted to ADRREF_RW
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRAAP.APPLICATION_IN_PROCESS TO ADRREF_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRAAP.ENROLLMENT_APPLICATION TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_APPPARAMETERTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_APPPARAMETERTYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_APPPARAMETERUNIT TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_APPPARAMETERUNITHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_APPPARAMGRPTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_APPPARAMGRPTYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_CLSOURCEOFCHANGE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_CLSOURCEOFCHANGEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_CLVERIFICATIONTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_CLVERIFICATIONTYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_COMMERRORTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_COMMERRORTYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_COMMLETTERGENTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_COMMLETTERGENTYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_COMMLETTERTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_COMMLETTERTYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_COMMMAILINGSTTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_COMMMAILINGSTTYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_COMMMLTRIGGERTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_COMMMLTRIGGERTYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_COMREJECTREASONTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_COMREJECTREASONTYPEHISTORY TO ADRREF_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRREF.STD_ENROLL_APPLICATION_METHOD TO ADRREF_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRREF.STD_ENROLL_APPLICATION_STATUS TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_HANDBOOKBATCHREQUESTSTATUS TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_HANDBOOKMAILSTATTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_HANDBOOKRELEASECONTROL TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_HLTHBENEFITPLANTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_HLTHBENEFITPLANTYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_LANGUAGECODE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_LANGUAGECODEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_NCOADELIVERYTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_NCOADELIVERYTYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_NCOASTATUSTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_NCOASTATUSTYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_NCOAZIPMATCHTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_NCOAZIPMATCHTYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_NCOAZIPNOMATCHTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_NCOAZIPNOMATCHTYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_PERMISSIONTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_PERMISSIONTYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_REPORTELIGFACTOR TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_REPORTELIGFACTORHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_REPORTENROLLPRSTAT TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_REPORTENROLLPRSTATHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_REPORTTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_REPORTTYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTDAYOFMONTHTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTDAYOFMONTHTYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTDAYOFQUARTERTYP TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTDAYOFQUARTERTYPHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTDAYOFWEEKTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTDAYOFWEEKTYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTDETAILBYTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTDETAILBYTYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTDETAILFORTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTDETAILFORTYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTDIVISIONTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTDIVISIONTYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTEEDWEEKLYTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTEEDWEEKLYTYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTEXCEPTIONTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTEXCEPTIONTYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTLETTERFILETYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTLETTERFILETYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTMONTHLIST TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTMONTHLISTHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTOUTFORMATTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTOUTFORMATTYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTOUTPUTFILETYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTOUTPUTFILETYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTPERIODTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTPERIODTYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTQUARTERLIST TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTQUARTERLISTHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTRUNFREQUENCYTYP TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTRUNFREQUENCYTYPHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTSCHEDULETYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTSCHEDULETYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTSITEDISPLAYTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTSITEDISPLAYTYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTSTANDARDREPORTS TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTSTANDARDREPORTSHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTSTATUSCOMPONENT TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTSTATUSCOMPONENTHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTWEEKOFMONTHTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTWEEKOFMONTHTYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTWORKITEMSTTYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTWORKITEMSTTYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_USERABSENCETYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_USERABSENCETYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WKFDATAJOBACTION TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WKFDATAJOBACTIONHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WKFDATAJOBSTATUS TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WKFDATAJOBSTATUSHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WKFISSUETYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WKFISSUETYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WKFLOCASEACTIVITYHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WKFLOCASEREQUESTHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WKFLOCASESTATUSHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WKFLOCASETYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WKFLOUPDATETYPEHISTORY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WORKFLOWCASEACTIVITY TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WORKFLOWCASEREQUEST TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WORKFLOWCASESTATUS TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WORKFLOWCASETYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WORKFLOWUPDATETYPE TO ADRREF_RW;
GRANT INSERT, SELECT, UPDATE ON ADRREF.TABLEMANAGER TO ADRREF_RW;

-- Grantees of ADRREF_RW
GRANT ADRREF_RW TO AACDBA WITH ADMIN OPTION;
DROP ROLE SEC_SCAN;

CREATE ROLE SEC_SCAN NOT IDENTIFIED;

-- Object privileges granted to SEC_SCAN
GRANT SELECT ON SYS.DBA_DATA_FILES TO SEC_SCAN;
GRANT SELECT ON SYS.DBA_DB_LINKS TO SEC_SCAN;
GRANT SELECT ON SYS.DBA_ENCRYPTED_COLUMNS TO SEC_SCAN;
GRANT SELECT ON SYS.DBA_EXTERNAL_TABLES TO SEC_SCAN;
GRANT SELECT ON SYS.DBA_INDEXES TO SEC_SCAN;
GRANT SELECT ON SYS.DBA_IND_PARTITIONS TO SEC_SCAN;
GRANT SELECT ON SYS.DBA_JOBS TO SEC_SCAN;
GRANT SELECT ON SYS.DBA_OBJECTS TO SEC_SCAN;
GRANT SELECT ON SYS.DBA_OBJ_AUDIT_OPTS TO SEC_SCAN;
GRANT SELECT ON SYS.DBA_POLICIES TO SEC_SCAN;
GRANT SELECT ON SYS.DBA_PRIV_AUDIT_OPTS TO SEC_SCAN;
GRANT SELECT ON SYS.DBA_PROFILES TO SEC_SCAN;
GRANT SELECT ON SYS.DBA_PROXIES TO SEC_SCAN;
GRANT SELECT ON SYS.DBA_REGISTRY TO SEC_SCAN;
GRANT SELECT ON SYS.DBA_ROLES TO SEC_SCAN;
GRANT SELECT ON SYS.DBA_ROLE_PRIVS TO SEC_SCAN;
GRANT SELECT ON SYS.DBA_SOURCE TO SEC_SCAN;
GRANT SELECT ON SYS.DBA_STMT_AUDIT_OPTS TO SEC_SCAN;
GRANT SELECT ON SYS.DBA_SYS_PRIVS TO SEC_SCAN;
GRANT SELECT ON SYS.DBA_TABLES TO SEC_SCAN;
GRANT SELECT ON SYS.DBA_TABLESPACES TO SEC_SCAN;
GRANT SELECT ON SYS.DBA_TAB_PARTITIONS TO SEC_SCAN;
GRANT SELECT ON SYS.DBA_TAB_PRIVS TO SEC_SCAN;
GRANT SELECT ON SYS.DBA_TS_QUOTAS TO SEC_SCAN;
GRANT SELECT ON SYS.DBA_USERS TO SEC_SCAN;
GRANT SELECT ON SYS.DBA_USERS_WITH_DEFPWD TO SEC_SCAN;
GRANT EXECUTE ON SYS.DBMS_CRYPTO TO SEC_SCAN;
GRANT SELECT ON SYS.LINK$ TO SEC_SCAN;
GRANT SELECT ON SYS.PRODUCT_COMPONENT_VERSION TO SEC_SCAN;
GRANT SELECT ON SYS.PROFILE$ TO SEC_SCAN;
GRANT SELECT ON SYS.PROFNAME$ TO SEC_SCAN;
GRANT SELECT ON SYS.PROXY_USERS TO SEC_SCAN;
GRANT SELECT ON SYS.REGISTRY$HISTORY TO SEC_SCAN;
GRANT SELECT ON SYS.RESOURCE_MAP TO SEC_SCAN;
GRANT SELECT ON SYS.ROLE_TAB_PRIVS TO SEC_SCAN;
GRANT SELECT ON SYS.SYSAUTH$ TO SEC_SCAN;
GRANT SELECT ON SYS.USER$ TO SEC_SCAN;
GRANT EXECUTE ON SYS.UTL_RAW TO SEC_SCAN;
GRANT SELECT ON SYS.V_$CONTROLFILE TO SEC_SCAN;
GRANT SELECT ON SYS.V_$DATABASE TO SEC_SCAN;
GRANT SELECT ON SYS.V_$DATAFILE TO SEC_SCAN;
GRANT SELECT ON SYS.V_$FIXED_TABLE TO SEC_SCAN;
GRANT SELECT ON SYS.V_$LOG TO SEC_SCAN;
GRANT SELECT ON SYS.V_$LOGFILE TO SEC_SCAN;
GRANT SELECT ON SYS.V_$PARAMETER TO SEC_SCAN;
GRANT SELECT ON SYS.V_$PWFILE_USERS TO SEC_SCAN;

-- System privileges granted to SEC_SCAN
GRANT CREATE SESSION TO SEC_SCAN;

-- Grantees of SEC_SCAN
GRANT SEC_SCAN TO SEC00E3APPD;
GRANT SEC_SCAN TO SYS WITH ADMIN OPTION;
DROP ROLE ADRTMP_R;

CREATE ROLE ADRTMP_R NOT IDENTIFIED;

-- Object privileges granted to ADRTMP_R
GRANT SELECT ON ADRTMP.ADDRESS_2025 TO ADRTMP_R;
GRANT SELECT ON ADRTMP.BENEFICIARY_VISIT_SUMMARY_2025 TO ADRTMP_R;
GRANT SELECT ON ADRTMP.CONFLICT_DETAIL_2025 TO ADRTMP_R;
GRANT SELECT ON ADRTMP.FEE_BASIS_2025 TO ADRTMP_R;
GRANT SELECT ON ADRTMP.HL7_TRANSACTION_LOG_2025 TO ADRTMP_R;
GRANT SELECT ON ADRTMP.INSURANCE_2025 TO ADRTMP_R;
GRANT SELECT ON ADRTMP.MILITARY_SERVICE_2025 TO ADRTMP_R;
GRANT SELECT ON ADRTMP.MILITARY_SERVICE_EPISODE_2025 TO ADRTMP_R;
GRANT SELECT ON ADRTMP.PHONE_2025 TO ADRTMP_R;
GRANT SELECT ON ADRTMP.QUEST_SL_EXPLAIN TO ADRTMP_R;
GRANT SELECT ON ADRTMP.SERVICE_LOG_PROCESSED TO ADRTMP_R;

-- Grantees of ADRTMP_R
GRANT ADRTMP_R TO AACDBA WITH ADMIN OPTION;
GRANT ADRTMP_R TO ADRTMP;
GRANT ADRTMP_R TO DNS   CASTER;
GRANT ADRTMP_R TO DNS   PARSOS;
GRANT ADRTMP_R TO DNS   PENNYR;
GRANT ADRTMP_R TO DNS   REYESJ;
GRANT ADRTMP_R TO DNS  ALTMI;
GRANT ADRTMP_R TO DNS PASHAA;
GRANT ADRTMP_R TO VAMQASCAMPOJ2;
GRANT ADRTMP_R TO DNS   FIERRJ;
GRANT ADRTMP_R TO DNS   PARVAV;
GRANT ADRTMP_R TO DNS   ASAFOJ;
GRANT ADRTMP_R TO DNS   BOYETD;
GRANT ADRTMP_R TO DNS   CHAMPP;
GRANT ADRTMP_R TO DNS   CORNED;
GRANT ADRTMP_R TO DNS   GONZAS;
GRANT ADRTMP_R TO DNS   HORNEE;
GRANT ADRTMP_R TO DNS   HUNTEJ;
GRANT ADRTMP_R TO DNS   JACON;
GRANT ADRTMP_R TO DNS   PHIFEG;
GRANT ADRTMP_R TO DNS   SCOTTS;
GRANT ADRTMP_R TO DNS   SIMSB;
GRANT ADRTMP_R TO DNS   TIDWG;
GRANT ADRTMP_R TO DNS   VITENG;
GRANT ADRTMP_R TO DNS   WALLASH;
GRANT ADRTMP_R TO DNS   BOYETJ;
GRANT ADRTMP_R TO DNS   GROOMA;
GRANT ADRTMP_R TO DNS   FAULKJ;
GRANT ADRTMP_R TO DNS   INNISJ;
GRANT ADRTMP_R TO DNS   PURSCD;
GRANT ADRTMP_R TO DNS   SCHIEK;
GRANT ADRTMP_R TO DNS   SHEPPL;
GRANT ADRTMP_R TO DNS   SURVES;
GRANT ADRTMP_R TO DNS   ALLENM;
GRANT ADRTMP_R TO DNS   DOR;
GRANT ADRTMP_R TO DNS   FITZGR;
GRANT ADRTMP_R TO DNS   MIKHAA;
GRANT ADRTMP_R TO DNS   ARCHET;
GRANT ADRTMP_R TO DNS   HOUGAD;
GRANT ADRTMP_R TO DNS   LINDSD;
GRANT ADRTMP_R TO DNS   SHAHA;
GRANT ADRTMP_R TO DNS   TUH;
GRANT ADRTMP_R TO DNS   WOODC;
GRANT ADRTMP_R TO DNS   CANINB;
GRANT ADRTMP_R TO DNS   DHEERA;
GRANT ADRTMP_R TO       CHENY;
GRANT ADRTMP_R TO       EVERHS;
GRANT ADRTMP_R TO       HALLLI;
GRANT ADRTMP_R TO       HASANM;
GRANT ADRTMP_R TO       VENIGS;
GRANT ADRTMP_R TO DNS   WILLIO;
GRANT ADRTMP_R TO DNS   REENT;
GRANT ADRTMP_R TO DNS   SAWEIM;
DROP ROLE ADRTMP_RW;

CREATE ROLE ADRTMP_RW NOT IDENTIFIED;

-- Object privileges granted to ADRTMP_RW
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRTMP.ADDRESS_2025 TO ADRTMP_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRTMP.BENEFICIARY_VISIT_SUMMARY_2025 TO ADRTMP_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRTMP.CONFLICT_DETAIL_2025 TO ADRTMP_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRTMP.FEE_BASIS_2025 TO ADRTMP_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRTMP.HL7_TRANSACTION_LOG_2025 TO ADRTMP_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRTMP.INSURANCE_2025 TO ADRTMP_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRTMP.MILITARY_SERVICE_2025 TO ADRTMP_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRTMP.MILITARY_SERVICE_EPISODE_2025 TO ADRTMP_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRTMP.PHONE_2025 TO ADRTMP_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRTMP.QUEST_SL_EXPLAIN TO ADRTMP_RW;

-- Grantees of ADRTMP_RW
GRANT ADRTMP_RW TO AACDBA WITH ADMIN OPTION;
GRANT ADRTMP_RW TO ADR;
GRANT ADRTMP_RW TO ADRTMP;
GRANT ADRTMP_RW TO DNS  ALTMI;
GRANT ADRTMP_RW TO DNS PASHAA;
GRANT ADRTMP_RW TO DNS   DOR;
GRANT ADRTMP_RW TO DNS   FITZGR;
GRANT ADRTMP_RW TO DNS   LINDSD;
GRANT ADRTMP_RW TO DNS   TUH;
GRANT ADRTMP_RW TO DNS   WOODC;
GRANT ADRTMP_RW TO DNS   CANINB;
GRANT ADRTMP_RW TO DNS   DHEERA;
GRANT ADRTMP_RW TO DNS   REENT;
DROP ROLE VBR_R;

CREATE ROLE VBR_R NOT IDENTIFIED;

-- Object privileges granted to VBR_R
GRANT SELECT ON VBR.DOCUMENT TO VBR_R;
GRANT SELECT ON VBR.DOCUMENT_RECEIPT TO VBR_R;
GRANT SELECT ON VBR.DOCUMENT_TYPE TO VBR_R;
GRANT SELECT ON VBR.VETERAN_IDENTIFIER_TYPE TO VBR_R;
GRANT SELECT ON VBR.VET_HEALTH_BENEFIT_PLAN TO VBR_R;

-- Grantees of VBR_R
GRANT VBR_R TO AACDBA WITH ADMIN OPTION;
GRANT VBR_R TO DNS   CASTER;
GRANT VBR_R TO DNS   PENNYR;
GRANT VBR_R TO DNS   REYESJ;
GRANT VBR_R TO DNS  ALTMI;
GRANT VBR_R TO DNS PASHAA;
GRANT VBR_R TO DNS  KARANP;
GRANT VBR_R TO VAMQASCAMPOJ2;
GRANT VBR_R TO VHA06MARTIK;
GRANT VBR_R TO DNS   KENNEL;
GRANT VBR_R TO DNS   HALLT;
GRANT VBR_R TO DNS  JOHNSB;
GRANT VBR_R TO DNS   FIERRJ;
GRANT VBR_R TO DNS   PARVAV;
GRANT VBR_R TO DNS   ASAFOJ;
GRANT VBR_R TO DNS   BOYETD;
GRANT VBR_R TO DNS   CHAMPP;
GRANT VBR_R TO DNS   CORNED;
GRANT VBR_R TO DNS   GONZAS;
GRANT VBR_R TO DNS   HORNEE;
GRANT VBR_R TO DNS   HUNTEJ;
GRANT VBR_R TO DNS   JACON;
GRANT VBR_R TO DNS   JOHNSS;
GRANT VBR_R TO DNS   PHIFEG;
GRANT VBR_R TO DNS   SCOTTS;
GRANT VBR_R TO DNS   SIMSB;
GRANT VBR_R TO DNS   TIDWG;
GRANT VBR_R TO DNS   VITENG;
GRANT VBR_R TO DNS   WALLASH;
GRANT VBR_R TO DNS   BOYETJ;
GRANT VBR_R TO DNS   GROOMA;
GRANT VBR_R TO DNS   FAULKJ;
GRANT VBR_R TO DNS   INNISJ;
GRANT VBR_R TO DNS   PURSCD;
GRANT VBR_R TO DNS   SCHIEK;
GRANT VBR_R TO DNS   SHEPPL;
GRANT VBR_R TO DNS   SURVES;
GRANT VBR_R TO DNS   ALLENM;
GRANT VBR_R TO DNS   FITZGR;
GRANT VBR_R TO DNS   ARCHET;
GRANT VBR_R TO DNS   ARNOLN;
GRANT VBR_R TO DNS   HOUGAD;
GRANT VBR_R TO DNS   LINDSD;
GRANT VBR_R TO DNS   ROLINL;
GRANT VBR_R TO DNS   SINGHM;
GRANT VBR_R TO DNS   TUH;
GRANT VBR_R TO DNS   WOODC;
GRANT VBR_R TO DNS   LOWRYB;
GRANT VBR_R TO DNS   DHEERA;
GRANT VBR_R TO       CHENY;
GRANT VBR_R TO       HASANM;
GRANT VBR_R TO       VENIGS;
GRANT VBR_R TO DNS         ;
GRANT VBR_R TO DNS   WILLIO;
GRANT VBR_R TO DNS   REENT;
GRANT VBR_R TO DNS   SAWEIM;
GRANT VBR_R TO VOA;
DROP ROLE VBR_ADMIN;

CREATE ROLE VBR_ADMIN NOT IDENTIFIED;

-- System privileges granted to VBR_ADMIN
GRANT ALTER SESSION TO VBR_ADMIN;
GRANT CREATE MATERIALIZED VIEW TO VBR_ADMIN;
GRANT CREATE PROCEDURE TO VBR_ADMIN;
GRANT CREATE SEQUENCE TO VBR_ADMIN;
GRANT CREATE SESSION TO VBR_ADMIN;
GRANT CREATE SYNONYM TO VBR_ADMIN;
GRANT CREATE TABLE TO VBR_ADMIN;
GRANT CREATE TRIGGER TO VBR_ADMIN;
GRANT CREATE VIEW TO VBR_ADMIN;
GRANT QUERY REWRITE TO VBR_ADMIN;
GRANT SELECT ANY DICTIONARY TO VBR_ADMIN;

-- Grantees of VBR_ADMIN
GRANT VBR_ADMIN TO AACDBA WITH ADMIN OPTION;
GRANT VBR_ADMIN TO VBR;
GRANT VBR_ADMIN TO VBRUSR;
DROP ROLE ADRFILE_R;

CREATE ROLE ADRFILE_R NOT IDENTIFIED;

-- Object privileges granted to ADRFILE_R
GRANT SELECT ON ADRFILE.APPLICATION TO ADRFILE_R;
GRANT SELECT ON ADRFILE.DIRECTORY TO ADRFILE_R;
GRANT SELECT ON ADRFILE.DIRECTORY_PATTERN TO ADRFILE_R;
GRANT SELECT ON ADRFILE.DOCUMENT_ACCESS_LOG TO ADRFILE_R;
GRANT SELECT ON ADRFILE.FILES TO ADRFILE_R;
GRANT SELECT ON ADRFILE.MOUNT_POINT TO ADRFILE_R;

-- Grantees of ADRFILE_R
GRANT ADRFILE_R TO AACDBA WITH ADMIN OPTION;
GRANT ADRFILE_R TO DNS   CASTER;
GRANT ADRFILE_R TO DNS   PENNYR;
GRANT ADRFILE_R TO DNS   REYESJ;
GRANT ADRFILE_R TO DNS  ALTMI;
GRANT ADRFILE_R TO DNS PASHAA;
GRANT ADRFILE_R TO DNS  KARANP;
GRANT ADRFILE_R TO VAMQASCAMPOJ2;
GRANT ADRFILE_R TO VHA06MARTIK;
GRANT ADRFILE_R TO DNS   KENNEL;
GRANT ADRFILE_R TO DNS   HALLT;
GRANT ADRFILE_R TO DNS  JOHNSB;
GRANT ADRFILE_R TO DNS   FIERRJ;
GRANT ADRFILE_R TO DNS   PARVAV;
GRANT ADRFILE_R TO DNS   ASAFOJ;
GRANT ADRFILE_R TO DNS   BOYETD;
GRANT ADRFILE_R TO DNS   CHAMPP;
GRANT ADRFILE_R TO DNS   CORNED;
GRANT ADRFILE_R TO DNS   GONZAS;
GRANT ADRFILE_R TO DNS   HORNEE;
GRANT ADRFILE_R TO DNS   HUNTEJ;
GRANT ADRFILE_R TO DNS   JACON;
GRANT ADRFILE_R TO DNS   JOHNSS;
GRANT ADRFILE_R TO DNS   PHIFEG;
GRANT ADRFILE_R TO DNS   SCOTTS;
GRANT ADRFILE_R TO DNS   SIMSB;
GRANT ADRFILE_R TO DNS   TIDWG;
GRANT ADRFILE_R TO DNS   VITENG;
GRANT ADRFILE_R TO DNS   WALLASH;
GRANT ADRFILE_R TO DNS   BOYETJ;
GRANT ADRFILE_R TO DNS   GROOMA;
GRANT ADRFILE_R TO DNS   FAULKJ;
GRANT ADRFILE_R TO DNS   INNISJ;
GRANT ADRFILE_R TO DNS   PURSCD;
GRANT ADRFILE_R TO DNS   SCHIEK;
GRANT ADRFILE_R TO DNS   SHEPPL;
GRANT ADRFILE_R TO DNS   SURVES;
GRANT ADRFILE_R TO DNS   ALLENM;
GRANT ADRFILE_R TO DNS   FITZGR;
GRANT ADRFILE_R TO DNS   ARCHET;
GRANT ADRFILE_R TO DNS   ARNOLN;
GRANT ADRFILE_R TO DNS   HOUGAD;
GRANT ADRFILE_R TO DNS   LINDSD;
GRANT ADRFILE_R TO DNS   ROLINL;
GRANT ADRFILE_R TO DNS   SHAHA;
GRANT ADRFILE_R TO DNS   SINGHM;
GRANT ADRFILE_R TO DNS   TUH;
GRANT ADRFILE_R TO DNS   WOODC;
GRANT ADRFILE_R TO DNS   LOWRYB;
GRANT ADRFILE_R TO DNS   DHEERA;
GRANT ADRFILE_R TO       CHENY;
GRANT ADRFILE_R TO       HASANM;
GRANT ADRFILE_R TO       VENIGS;
GRANT ADRFILE_R TO DNS         ;
GRANT ADRFILE_R TO DNS   WILLIO;
GRANT ADRFILE_R TO DNS   REENT;
GRANT ADRFILE_R TO DNS   SAWEIM;
DROP ROLE ADRFILE_RW;

CREATE ROLE ADRFILE_RW NOT IDENTIFIED;

-- Object privileges granted to ADRFILE_RW
GRANT INSERT, SELECT, UPDATE ON ADRFILE.APPLICATION TO ADRFILE_RW;
GRANT INSERT, SELECT, UPDATE ON ADRFILE.DIRECTORY TO ADRFILE_RW;
GRANT INSERT, SELECT, UPDATE ON ADRFILE.DIRECTORY_PATTERN TO ADRFILE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRFILE.DOCUMENT_ACCESS_LOG TO ADRFILE_RW;
GRANT INSERT, SELECT, UPDATE ON ADRFILE.FILES TO ADRFILE_RW;
GRANT INSERT, SELECT, UPDATE ON ADRFILE.MOUNT_POINT TO ADRFILE_RW;

-- Grantees of ADRFILE_RW
GRANT ADRFILE_RW TO AACDBA WITH ADMIN OPTION;
GRANT ADRFILE_RW TO ADRFILE;
GRANT ADRFILE_RW TO ADRFILEUSR;
GRANT ADRFILE_RW TO EEUSR;
DROP ROLE ADRFILE_ADMIN;

CREATE ROLE ADRFILE_ADMIN NOT IDENTIFIED;

-- System privileges granted to ADRFILE_ADMIN
GRANT ALTER SESSION TO ADRFILE_ADMIN;
GRANT CREATE MATERIALIZED VIEW TO ADRFILE_ADMIN;
GRANT CREATE PROCEDURE TO ADRFILE_ADMIN;
GRANT CREATE SEQUENCE TO ADRFILE_ADMIN;
GRANT CREATE SESSION TO ADRFILE_ADMIN;
GRANT CREATE SYNONYM TO ADRFILE_ADMIN;
GRANT CREATE TABLE TO ADRFILE_ADMIN;
GRANT CREATE TRIGGER TO ADRFILE_ADMIN;
GRANT CREATE VIEW TO ADRFILE_ADMIN;
GRANT QUERY REWRITE TO ADRFILE_ADMIN;
GRANT SELECT ANY DICTIONARY TO ADRFILE_ADMIN;

-- Grantees of ADRFILE_ADMIN
GRANT ADRFILE_ADMIN TO AACDBA WITH ADMIN OPTION;
GRANT ADRFILE_ADMIN TO ADRFILE;
GRANT ADRFILE_ADMIN TO ADRFILEUSR;
DROP ROLE ADRFILE_SEQ_R;

CREATE ROLE ADRFILE_SEQ_R NOT IDENTIFIED;

-- Object privileges granted to ADRFILE_SEQ_R
GRANT SELECT ON ADRFILE.APPLICATION_S TO ADRFILE_SEQ_R;
GRANT SELECT ON ADRFILE.DIRECTORY_PATTERN_S TO ADRFILE_SEQ_R;
GRANT SELECT ON ADRFILE.DIRECTORY_S TO ADRFILE_SEQ_R;
GRANT SELECT ON ADRFILE.DOCUMENT_ACCESS_LOG_S TO ADRFILE_SEQ_R;
GRANT SELECT ON ADRFILE.FILES_S TO ADRFILE_SEQ_R;
GRANT SELECT ON ADRFILE.MOUNT_POINT_S TO ADRFILE_SEQ_R;

-- Grantees of ADRFILE_SEQ_R
GRANT ADRFILE_SEQ_R TO AACDBA WITH ADMIN OPTION;
GRANT ADRFILE_SEQ_R TO EEUSR;
DROP ROLE ODM_SEQ_R;

CREATE ROLE ODM_SEQ_R NOT IDENTIFIED;

-- Object privileges granted to ODM_SEQ_R
GRANT SELECT ON ODM.EXECUTION_TRACES_SEQUENCE TO ODM_SEQ_R;
GRANT SELECT ON ODM.RULEAPPS_SEQUENCE TO ODM_SEQ_R;
GRANT SELECT ON ODM.RULEAPP_PROPERTIES_SEQUENCE TO ODM_SEQ_R;
GRANT SELECT ON ODM.RULESETS_SEQUENCE TO ODM_SEQ_R;
GRANT SELECT ON ODM.RULESET_PROPERTIES_SEQUENCE TO ODM_SEQ_R;
GRANT SELECT ON ODM.RULESET_RESOURCES_SEQUENCE TO ODM_SEQ_R;
GRANT SELECT ON ODM.XOM_LIBRARIES_SEQUENCE TO ODM_SEQ_R;
GRANT SELECT ON ODM.XOM_LIBRARY_VALUES_SEQUENCE TO ODM_SEQ_R;
GRANT SELECT ON ODM.XOM_RESOURCES_SEQUENCE TO ODM_SEQ_R;

-- Grantees of ODM_SEQ_R
GRANT ODM_SEQ_R TO AACDBA WITH ADMIN OPTION;
GRANT ODM_SEQ_R TO ODMUSR;
DROP ROLE ODM_RW;

CREATE ROLE ODM_RW NOT IDENTIFIED;

-- Grantees of ODM_RW
GRANT ODM_RW TO AACDBA WITH ADMIN OPTION;
DROP ROLE ESRJMS_R;

CREATE ROLE ESRJMS_R NOT IDENTIFIED;

-- Object privileges granted to ESRJMS_R
GRANT SELECT ON ESRJMS.MS01WLSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS02WLSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS03WLSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS04WLSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS05WLSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS06WLSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS07WLSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS08WLSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS09WLSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS10JMSSTATE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS10JMSSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS10WLSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS11JMSSTATE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS11JMSSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS11WLSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS12JMSSTATE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS12JMSSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS12WLSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS13JMSSTATE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS13JMSSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS13WLSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS14JMSSTATE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS14JMSSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS14WLSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS15JMSSTATE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS15JMSSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS15WLSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS16WLSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS17WLSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS1JMSSTATE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS1JMSSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS2JMSSTATE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS2JMSSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS3JMSSTATE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS3JMSSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS4JMSSTATE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS4JMSSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS5JMSSTATE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS5JMSSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS6JMSSTATE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS6JMSSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS7JMSSTATE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS7JMSSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS8JMSSTATE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS8JMSSTORE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS9JMSSTATE TO ESRJMS_R;
GRANT SELECT ON ESRJMS.MS9JMSSTORE TO ESRJMS_R;

-- Grantees of ESRJMS_R
GRANT ESRJMS_R TO AACDBA WITH ADMIN OPTION;
GRANT ESRJMS_R TO ADR_R;
GRANT ESRJMS_R TO DNS   REYESJ;
GRANT ESRJMS_R TO DNS  ALTMI;
GRANT ESRJMS_R TO DNS PASHAA;
GRANT ESRJMS_R TO DNS   WALLASH;
GRANT ESRJMS_R TO DNS   GROOMA;
GRANT ESRJMS_R TO DNS   PURSCD;
GRANT ESRJMS_R TO DNS   FITZGR;
GRANT ESRJMS_R TO DNS   ARCHET;
GRANT ESRJMS_R TO DNS   WOODC;
GRANT ESRJMS_R TO DNS   DHEERA;
GRANT ESRJMS_R TO DNS   REENT;
DROP ROLE ESRJMS_RW;

CREATE ROLE ESRJMS_RW NOT IDENTIFIED;

-- Object privileges granted to ESRJMS_RW
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS01WLSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS02WLSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS03WLSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS04WLSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS05WLSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS06WLSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS07WLSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS08WLSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS09WLSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS10JMSSTATE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS10JMSSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS10WLSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS11JMSSTATE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS11JMSSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS11WLSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS12JMSSTATE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS12JMSSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS12WLSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS13JMSSTATE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS13JMSSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS13WLSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS14JMSSTATE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS14JMSSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS14WLSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS15JMSSTATE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS15JMSSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS15WLSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS16WLSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS17WLSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS1JMSSTATE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS1JMSSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS2JMSSTATE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS2JMSSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS3JMSSTATE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS3JMSSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS4JMSSTATE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS4JMSSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS5JMSSTATE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS5JMSSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS6JMSSTATE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS6JMSSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS7JMSSTATE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS7JMSSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS8JMSSTATE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS8JMSSTORE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS9JMSSTATE TO ESRJMS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ESRJMS.MS9JMSSTORE TO ESRJMS_RW;

-- Grantees of ESRJMS_RW
GRANT ESRJMS_RW TO AACDBA WITH ADMIN OPTION;
GRANT ESRJMS_RW TO ADR_RW;
DROP ROLE PSIM_ADR_R;

CREATE ROLE PSIM_ADR_R NOT IDENTIFIED;

-- Object privileges granted to PSIM_ADR_R
GRANT SELECT ON ADR.ADDRESS TO PSIM_ADR_R;
GRANT SELECT ON ADR.ADDRESS_H TO PSIM_ADR_R;
GRANT SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY TO PSIM_ADR_R;
GRANT SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY_H TO PSIM_ADR_R;
GRANT SELECT ON ADR.EMAIL TO PSIM_ADR_R;
GRANT SELECT ON ADR.EMAIL_H TO PSIM_ADR_R;
GRANT SELECT ON ADR.PERSON TO PSIM_ADR_R;
GRANT SELECT ON ADR.PERSON_CONTACT TO PSIM_ADR_R;
GRANT SELECT ON ADR.PERSON_CONTACT_H TO PSIM_ADR_R;
GRANT SELECT ON ADR.PERSON_ETHNICITY TO PSIM_ADR_R;
GRANT SELECT ON ADR.PERSON_ETHNICITY_H TO PSIM_ADR_R;
GRANT SELECT ON ADR.PERSON_H TO PSIM_ADR_R;
GRANT SELECT ON ADR.PERSON_RACE TO PSIM_ADR_R;
GRANT SELECT ON ADR.PERSON_RACE_H TO PSIM_ADR_R;
GRANT SELECT ON ADR.PERSON_RELATION TO PSIM_ADR_R;
GRANT SELECT ON ADR.PERSON_RELATION_H TO PSIM_ADR_R;
GRANT SELECT ON ADR.PHONE TO PSIM_ADR_R;
GRANT SELECT ON ADR.PHONE_H TO PSIM_ADR_R;
GRANT SELECT ON ADR.SSN TO PSIM_ADR_R;
GRANT SELECT ON ADR.SSN_H TO PSIM_ADR_R;
GRANT SELECT ON ADR.VA_PERSON_CLASS_DETAIL TO PSIM_ADR_R;
GRANT SELECT ON ADR.VA_PERSON_CLASS_DETAIL_H TO PSIM_ADR_R;
GRANT SELECT ON ADR.VA_PERSON_DIVISION_DETAIL TO PSIM_ADR_R;
GRANT SELECT ON ADR.VA_PERSON_DIVISION_DETAIL_H TO PSIM_ADR_R;

-- Grantees of PSIM_ADR_R
GRANT PSIM_ADR_R TO AACDBA WITH ADMIN OPTION;
GRANT PSIM_ADR_R TO ADR;
GRANT PSIM_ADR_R TO ADRMGT;
GRANT PSIM_ADR_R TO EESRV;
GRANT PSIM_ADR_R TO FSCMB_USR;
GRANT PSIM_ADR_R TO DNS   CASTER;
GRANT PSIM_ADR_R TO DNS   PENNYR;
GRANT PSIM_ADR_R TO DNS   REYESJ;
GRANT PSIM_ADR_R TO PSIM;
GRANT PSIM_ADR_R TO SYSTEM;
GRANT PSIM_ADR_R TO DNS  ALTMI;
GRANT PSIM_ADR_R TO DNS PASHAA;
GRANT PSIM_ADR_R TO VHA06MARTIK;
GRANT PSIM_ADR_R TO DNS   KENNEL;
GRANT PSIM_ADR_R TO DNS   HALLT;
GRANT PSIM_ADR_R TO DNS  JOHNSB;
GRANT PSIM_ADR_R TO DNS   BOYETD;
GRANT PSIM_ADR_R TO DNS   CHAMPP;
GRANT PSIM_ADR_R TO DNS   CORNED;
GRANT PSIM_ADR_R TO DNS   JACON;
GRANT PSIM_ADR_R TO DNS   PHIFEG;
GRANT PSIM_ADR_R TO DNS   SCOTTS;
GRANT PSIM_ADR_R TO DNS   TIDWG;
GRANT PSIM_ADR_R TO DNS   VITENG;
GRANT PSIM_ADR_R TO DNS   WALLASH;
GRANT PSIM_ADR_R TO DNS   GROOMA;
GRANT PSIM_ADR_R TO DNS   FAULKJ;
GRANT PSIM_ADR_R TO DNS   PURSCD;
GRANT PSIM_ADR_R TO DNS   ALLENM;
GRANT PSIM_ADR_R TO DNS   DOR;
GRANT PSIM_ADR_R TO DNS   FITZGR;
GRANT PSIM_ADR_R TO DNS   ARCHET;
GRANT PSIM_ADR_R TO DNS   LINDSD;
GRANT PSIM_ADR_R TO DNS   SINGHM;
GRANT PSIM_ADR_R TO DNS   TUH;
GRANT PSIM_ADR_R TO DNS   WOODC;
GRANT PSIM_ADR_R TO DNS   CANINB;
GRANT PSIM_ADR_R TO DNS   LOPEZD;
GRANT PSIM_ADR_R TO DNS   DHEERA;
GRANT PSIM_ADR_R TO DNS   REENT;
GRANT PSIM_ADR_R TO VOA;
DROP ROLE PSIM_ADR_RW;

CREATE ROLE PSIM_ADR_RW NOT IDENTIFIED;

-- Object privileges granted to PSIM_ADR_RW
GRANT DELETE, INSERT, UPDATE ON ADR.ADDRESS TO PSIM_ADR_RW;
GRANT DELETE, INSERT, UPDATE ON ADR.CONFIDENTIAL_ADDR_CATGRY TO PSIM_ADR_RW;
GRANT DELETE, INSERT, UPDATE ON ADR.EMAIL TO PSIM_ADR_RW;
GRANT DELETE, INSERT, UPDATE ON ADR.PERSON TO PSIM_ADR_RW;
GRANT DELETE, INSERT, UPDATE ON ADR.PERSON_CONTACT TO PSIM_ADR_RW;
GRANT DELETE, INSERT, UPDATE ON ADR.PERSON_ETHNICITY TO PSIM_ADR_RW;
GRANT DELETE, INSERT, UPDATE ON ADR.PERSON_RACE TO PSIM_ADR_RW;
GRANT DELETE, INSERT, UPDATE ON ADR.PERSON_RELATION TO PSIM_ADR_RW;
GRANT DELETE, INSERT, UPDATE ON ADR.PHONE TO PSIM_ADR_RW;
GRANT DELETE, INSERT, UPDATE ON ADR.SSN TO PSIM_ADR_RW;
GRANT DELETE, INSERT, UPDATE ON ADR.VA_PERSON_CLASS_DETAIL TO PSIM_ADR_RW;
GRANT DELETE, INSERT, UPDATE ON ADR.VA_PERSON_DIVISION_DETAIL TO PSIM_ADR_RW;

-- Grantees of PSIM_ADR_RW
GRANT PSIM_ADR_RW TO AACDBA WITH ADMIN OPTION;
GRANT PSIM_ADR_RW TO PSIMUSR;
GRANT PSIM_ADR_RW TO SYSTEM;
DROP ROLE DBFS_ROLE;

CREATE ROLE DBFS_ROLE NOT IDENTIFIED;

-- Object privileges granted to DBFS_ROLE
GRANT SELECT ON SYS.DBFS$_MOUNTS TO DBFS_ROLE;
GRANT SELECT ON SYS.DBFS$_STORES TO DBFS_ROLE;
GRANT SELECT ON SYS.DBFS_CONTENT TO DBFS_ROLE;
GRANT SELECT ON SYS.DBFS_CONTENT_PROPERTIES TO DBFS_ROLE;
GRANT SELECT ON SYS.DBFS_HS$_FS TO DBFS_ROLE;
GRANT SELECT ON SYS.DBFS_SFS$_FS TO DBFS_ROLE;
GRANT SELECT ON SYS.DBFS_SFS$_FSSEQ TO DBFS_ROLE;
GRANT SELECT ON SYS.DBFS_SFS$_FST TO DBFS_ROLE;
GRANT SELECT ON SYS.DBFS_SFS$_FSTO TO DBFS_ROLE;
GRANT SELECT ON SYS.DBFS_SFS$_FSTP TO DBFS_ROLE;
GRANT SELECT ON SYS.DBFS_SFS$_SNAP TO DBFS_ROLE;
GRANT SELECT ON SYS.DBFS_SFS$_TAB TO DBFS_ROLE;
GRANT SELECT ON SYS.DBFS_SFS$_VOL TO DBFS_ROLE;
GRANT EXECUTE ON SYS.DBMS_DBFS_CONTENT TO DBFS_ROLE;
GRANT EXECUTE ON SYS.DBMS_DBFS_CONTENT_ADMIN TO DBFS_ROLE;
GRANT EXECUTE ON SYS.DBMS_DBFS_CONTENT_CONTEXT_T TO DBFS_ROLE;
GRANT EXECUTE ON SYS.DBMS_DBFS_CONTENT_LIST_ITEMS_T TO DBFS_ROLE;
GRANT EXECUTE ON SYS.DBMS_DBFS_CONTENT_LIST_ITEM_T TO DBFS_ROLE;
GRANT EXECUTE ON SYS.DBMS_DBFS_CONTENT_PROPERTIES_T TO DBFS_ROLE;
GRANT EXECUTE ON SYS.DBMS_DBFS_CONTENT_PROPERTY_T TO DBFS_ROLE;
GRANT EXECUTE ON SYS.DBMS_DBFS_CONTENT_RAW_T TO DBFS_ROLE;
GRANT EXECUTE ON SYS.DBMS_DBFS_HS TO DBFS_ROLE;
GRANT EXECUTE ON SYS.DBMS_DBFS_SFS TO DBFS_ROLE;
GRANT EXECUTE ON SYS.DBMS_DBFS_SFS_ADMIN TO DBFS_ROLE;
GRANT EXECUTE ON SYS.DBMS_FUSE TO DBFS_ROLE;
GRANT EXECUTE ON SYS.DBMS_SESSION TO DBFS_ROLE;
GRANT EXECUTE ON SYS.DBMS_SYSTEM TO DBFS_ROLE;
GRANT SELECT ON SYS.PROPERTIES_TAB TO DBFS_ROLE;
GRANT SELECT ON SYS.S_PROPS_TAB TO DBFS_ROLE;
GRANT SELECT ON SYS.USR_PROPERTIES_TAB TO DBFS_ROLE;

-- Grantees of DBFS_ROLE
GRANT DBFS_ROLE TO SYS WITH ADMIN OPTION;
DROP ROLE DATAPUMP_EXP_FULL_DATABASE;

CREATE ROLE DATAPUMP_EXP_FULL_DATABASE NOT IDENTIFIED;

-- System privileges granted to DATAPUMP_EXP_FULL_DATABASE
GRANT CREATE SESSION TO DATAPUMP_EXP_FULL_DATABASE;
GRANT CREATE TABLE TO DATAPUMP_EXP_FULL_DATABASE;

-- Roles granted to DATAPUMP_EXP_FULL_DATABASE
GRANT EXP_FULL_DATABASE TO DATAPUMP_EXP_FULL_DATABASE;

-- Grantees of DATAPUMP_EXP_FULL_DATABASE
GRANT DATAPUMP_EXP_FULL_DATABASE TO DBA;
GRANT DATAPUMP_EXP_FULL_DATABASE TO SYS WITH ADMIN OPTION;
DROP ROLE DATAPUMP_IMP_FULL_DATABASE;

CREATE ROLE DATAPUMP_IMP_FULL_DATABASE NOT IDENTIFIED;

-- Object privileges granted to DATAPUMP_IMP_FULL_DATABASE
GRANT EXECUTE ON SYS.DBMS_AUTO_TASK_ADMIN TO DATAPUMP_IMP_FULL_DATABASE;
GRANT EXECUTE ON SYS.DBMS_SERVER_ALERT TO DATAPUMP_IMP_FULL_DATABASE;

-- System privileges granted to DATAPUMP_IMP_FULL_DATABASE
GRANT ALTER DATABASE TO DATAPUMP_IMP_FULL_DATABASE;
GRANT ALTER PROFILE TO DATAPUMP_IMP_FULL_DATABASE;
GRANT ALTER RESOURCE COST TO DATAPUMP_IMP_FULL_DATABASE;
GRANT ALTER USER TO DATAPUMP_IMP_FULL_DATABASE;
GRANT AUDIT ANY TO DATAPUMP_IMP_FULL_DATABASE;
GRANT AUDIT SYSTEM TO DATAPUMP_IMP_FULL_DATABASE;
GRANT CREATE PROFILE TO DATAPUMP_IMP_FULL_DATABASE;
GRANT CREATE SESSION TO DATAPUMP_IMP_FULL_DATABASE;
GRANT DELETE ANY TABLE TO DATAPUMP_IMP_FULL_DATABASE;
GRANT EXECUTE ANY OPERATOR TO DATAPUMP_IMP_FULL_DATABASE;
GRANT GRANT ANY OBJECT PRIVILEGE TO DATAPUMP_IMP_FULL_DATABASE;
GRANT GRANT ANY PRIVILEGE TO DATAPUMP_IMP_FULL_DATABASE;
GRANT GRANT ANY ROLE TO DATAPUMP_IMP_FULL_DATABASE;
GRANT SELECT ANY TABLE TO DATAPUMP_IMP_FULL_DATABASE;

-- Roles granted to DATAPUMP_IMP_FULL_DATABASE
GRANT EXP_FULL_DATABASE TO DATAPUMP_IMP_FULL_DATABASE;
GRANT IMP_FULL_DATABASE TO DATAPUMP_IMP_FULL_DATABASE;

-- Grantees of DATAPUMP_IMP_FULL_DATABASE
GRANT DATAPUMP_IMP_FULL_DATABASE TO DBA;
GRANT DATAPUMP_IMP_FULL_DATABASE TO SYS WITH ADMIN OPTION;
DROP ROLE ADM_PARALLEL_EXECUTE_TASK;

CREATE ROLE ADM_PARALLEL_EXECUTE_TASK NOT IDENTIFIED;

-- Object privileges granted to ADM_PARALLEL_EXECUTE_TASK
GRANT SELECT ON SYS.DBA_PARALLEL_EXECUTE_CHUNKS TO ADM_PARALLEL_EXECUTE_TASK;
GRANT SELECT ON SYS.DBA_PARALLEL_EXECUTE_TASKS TO ADM_PARALLEL_EXECUTE_TASK;

-- Grantees of ADM_PARALLEL_EXECUTE_TASK
GRANT ADM_PARALLEL_EXECUTE_TASK TO SYS WITH ADMIN OPTION;
DROP ROLE ODM_R;

CREATE ROLE ODM_R NOT IDENTIFIED;

-- Object privileges granted to ODM_R
GRANT SELECT ON ODM.EXECUTION_TRACES TO ODM_R;
GRANT SELECT ON ODM.RS_ENABLED_VIEW TO ODM_R;
GRANT SELECT ON ODM.RULEAPPS TO ODM_R;
GRANT SELECT ON ODM.RULEAPP_PROPERTIES TO ODM_R;
GRANT SELECT ON ODM.RULESETS TO ODM_R;
GRANT SELECT ON ODM.RULESET_PROPERTIES TO ODM_R;
GRANT SELECT ON ODM.RULESET_RESOURCES TO ODM_R;
GRANT SELECT ON ODM.XOM_LIBRARIES TO ODM_R;
GRANT SELECT ON ODM.XOM_LIBRARY_VALUES TO ODM_R;
GRANT SELECT ON ODM.XOM_RESOURCES TO ODM_R;

-- Grantees of ODM_R
GRANT ODM_R TO AACDBA WITH ADMIN OPTION;
GRANT ODM_R TO ODMUSR;
GRANT ODM_R TO DNS   REYESJ;
GRANT ODM_R TO DNS  ALTMI;
GRANT ODM_R TO DNS PASHAA;
GRANT ODM_R TO DNS   WALLASH;
GRANT ODM_R TO DNS   GROOMA;
GRANT ODM_R TO DNS   PURSCD;
GRANT ODM_R TO DNS   DOR;
GRANT ODM_R TO DNS   FITZGR;
GRANT ODM_R TO DNS   ARCHET;
GRANT ODM_R TO DNS   LINDSD;
GRANT ODM_R TO DNS   SINGHM;
GRANT ODM_R TO DNS   TUH;
GRANT ODM_R TO DNS   WOODC;
GRANT ODM_R TO DNS   CANINB;
GRANT ODM_R TO DNS   DHEERA;
GRANT ODM_R TO DNS   REENT;
DROP ROLE ACA_R;

CREATE ROLE ACA_R NOT IDENTIFIED;

-- Object privileges granted to ACA_R
GRANT SELECT ON ACA.AFFORDABLE_CARE_PROGRAM_R TO ACA_R;
GRANT SELECT ON ACA.AFFORDABLE_CARE_REQUEST TO ACA_R;
GRANT SELECT ON ACA.APPLICANT_IDENTITY TO ACA_R;
GRANT SELECT ON ACA.HEALTH_CARE_PERIOD TO ACA_R;
GRANT SELECT ON ACA.IDENTITY_TYPE_R TO ACA_R;
GRANT SELECT ON ACA.REQUEST_PROGRAM TO ACA_R;
GRANT SELECT ON ACA.VA_BUSINESS_RESPONSE_R TO ACA_R;
GRANT SELECT ON ACA.VA_ERROR_R TO ACA_R;

-- Grantees of ACA_R
GRANT ACA_R TO AACDBA WITH ADMIN OPTION;
GRANT ACA_R TO ADR;
GRANT ACA_R TO DNS   REYESJ;
GRANT ACA_R TO DNS  ALTMI;
GRANT ACA_R TO DNS  RAYD1;
GRANT ACA_R TO DNS KAZMIM;
GRANT ACA_R TO DNS MUHAMB;
GRANT ACA_R TO DNS PASHAA;
GRANT ACA_R TO DNS   CHAMPP;
GRANT ACA_R TO DNS   CORNED;
GRANT ACA_R TO DNS   JOHNSS;
GRANT ACA_R TO DNS   PHIFEG;
GRANT ACA_R TO DNS   SCOTTS;
GRANT ACA_R TO DNS   TIDWG;
GRANT ACA_R TO DNS   VITENG;
GRANT ACA_R TO DNS   WALLASH;
GRANT ACA_R TO DNS   GROOMA;
GRANT ACA_R TO DNS   PURSCD;
GRANT ACA_R TO DNS   DOR;
GRANT ACA_R TO DNS   FITZGR;
GRANT ACA_R TO DNS   ARCHET;
GRANT ACA_R TO DNS   LINDSD;
GRANT ACA_R TO DNS   SHAHA;
GRANT ACA_R TO DNS   SINGHM;
GRANT ACA_R TO DNS   TUH;
GRANT ACA_R TO DNS   WOODC;
GRANT ACA_R TO DNS   CANINB;
GRANT ACA_R TO DNS   DHEERA;
GRANT ACA_R TO DNS   REENT;
DROP ROLE ACA_RW;

CREATE ROLE ACA_RW NOT IDENTIFIED;

-- Object privileges granted to ACA_RW
GRANT INSERT, SELECT, UPDATE ON ACA.AFFORDABLE_CARE_PROGRAM_R TO ACA_RW;
GRANT INSERT, SELECT, UPDATE ON ACA.AFFORDABLE_CARE_REQUEST TO ACA_RW;
GRANT INSERT, SELECT, UPDATE ON ACA.APPLICANT_IDENTITY TO ACA_RW;
GRANT INSERT, SELECT, UPDATE ON ACA.HEALTH_CARE_PERIOD TO ACA_RW;
GRANT INSERT, SELECT, UPDATE ON ACA.IDENTITY_TYPE_R TO ACA_RW;
GRANT INSERT, SELECT, UPDATE ON ACA.REQUEST_PROGRAM TO ACA_RW;
GRANT INSERT, SELECT, UPDATE ON ACA.VA_BUSINESS_RESPONSE_R TO ACA_RW;
GRANT INSERT, SELECT, UPDATE ON ACA.VA_ERROR_R TO ACA_RW;

-- Grantees of ACA_RW
GRANT ACA_RW TO AACDBA WITH ADMIN OPTION;
GRANT ACA_RW TO ACAUSR;
GRANT ACA_RW TO VIERSUSR;
DROP ROLE ACA_SEQ_R;

CREATE ROLE ACA_SEQ_R NOT IDENTIFIED;

-- Object privileges granted to ACA_SEQ_R
GRANT SELECT ON ACA.AFFORDABLE_CARE_REQUEST_S TO ACA_SEQ_R;
GRANT SELECT ON ACA.APPLICANT_IDENTITY_S TO ACA_SEQ_R;
GRANT SELECT ON ACA.HEALTH_CARE_PERIOD_S TO ACA_SEQ_R;
GRANT SELECT ON ACA.REQUEST_PROGRAM_S TO ACA_SEQ_R;

-- Grantees of ACA_SEQ_R
GRANT ACA_SEQ_R TO AACDBA WITH ADMIN OPTION;
GRANT ACA_SEQ_R TO ACAUSR;
GRANT ACA_SEQ_R TO VIERSUSR;
DROP ROLE ACA_ADMIN;

CREATE ROLE ACA_ADMIN NOT IDENTIFIED;

-- System privileges granted to ACA_ADMIN
GRANT ALTER SESSION TO ACA_ADMIN;
GRANT CREATE PROCEDURE TO ACA_ADMIN;
GRANT CREATE SEQUENCE TO ACA_ADMIN;
GRANT CREATE SESSION TO ACA_ADMIN;
GRANT CREATE SYNONYM TO ACA_ADMIN;
GRANT CREATE TABLE TO ACA_ADMIN;
GRANT CREATE TRIGGER TO ACA_ADMIN;
GRANT CREATE TYPE TO ACA_ADMIN;
GRANT CREATE VIEW TO ACA_ADMIN;
GRANT UNLIMITED TABLESPACE TO ACA_ADMIN;

-- Grantees of ACA_ADMIN
GRANT ACA_ADMIN TO AACDBA WITH ADMIN OPTION;
GRANT ACA_ADMIN TO ACA;
DROP ROLE AACDBA_RO;

CREATE ROLE AACDBA_RO NOT IDENTIFIED;

-- Object privileges granted to AACDBA_RO
GRANT SELECT ON AACDBA.SAVED_STATS TO AACDBA_RO;
GRANT SELECT ON AACDBA.SEGMENT_SPACE_USAGE TO AACDBA_RO;
GRANT SELECT ON AACDBA.SESSION_METRICS TO AACDBA_RO;
GRANT SELECT ON AACDBA.TABLESPACE_USAGE TO AACDBA_RO;

-- Grantees of AACDBA_RO
GRANT AACDBA_RO TO AACDBA WITH ADMIN OPTION;
GRANT AACDBA_RO TO DNS  ALTMI;
GRANT AACDBA_RO TO DNS PASHAA;
GRANT AACDBA_RO TO DNS   DOR;
GRANT AACDBA_RO TO DNS   FITZGR;
GRANT AACDBA_RO TO DNS   LINDSD;
GRANT AACDBA_RO TO DNS   SINGHM;
GRANT AACDBA_RO TO DNS   TUH;
GRANT AACDBA_RO TO DNS   WOODC;
GRANT AACDBA_RO TO DNS   CANINB;
GRANT AACDBA_RO TO DNS   DHEERA;
GRANT AACDBA_RO TO DNS   REENT;
DROP ROLE SQLT_USER_ROLE;

CREATE ROLE SQLT_USER_ROLE NOT IDENTIFIED;

-- Object privileges granted to SQLT_USER_ROLE
GRANT EXECUTE ON SQLTXADMIN.SQLT$A TO SQLT_USER_ROLE;
GRANT EXECUTE ON SQLTXADMIN.SQLT$C TO SQLT_USER_ROLE;
GRANT EXECUTE ON SQLTXADMIN.SQLT$D TO SQLT_USER_ROLE;
GRANT EXECUTE ON SQLTXADMIN.SQLT$E TO SQLT_USER_ROLE;
GRANT EXECUTE ON SQLTXADMIN.SQLT$H TO SQLT_USER_ROLE;
GRANT EXECUTE ON SQLTXADMIN.SQLT$I TO SQLT_USER_ROLE;
GRANT EXECUTE ON SQLTXADMIN.SQLT$M TO SQLT_USER_ROLE;
GRANT EXECUTE ON SQLTXADMIN.SQLT$R TO SQLT_USER_ROLE;
GRANT EXECUTE ON SQLTXADMIN.SQLT$S TO SQLT_USER_ROLE;
GRANT EXECUTE ON SQLTXADMIN.SQLT$T TO SQLT_USER_ROLE;
GRANT SELECT ON SQLTXADMIN.SQLT$_DBA_ALL_TABLES_V TO SQLT_USER_ROLE;
GRANT SELECT ON SQLTXADMIN.SQLT$_GV$CELL_STATE_V TO SQLT_USER_ROLE;
GRANT SELECT ON SQLTXADMIN.SQLT$_LOG_V TO SQLT_USER_ROLE;
GRANT EXECUTE ON SQLTXADMIN.TRCA$E TO SQLT_USER_ROLE;
GRANT EXECUTE ON SQLTXADMIN.TRCA$G TO SQLT_USER_ROLE;
GRANT EXECUTE ON SQLTXADMIN.TRCA$I TO SQLT_USER_ROLE;
GRANT EXECUTE ON SQLTXADMIN.TRCA$P TO SQLT_USER_ROLE;
GRANT EXECUTE ON SQLTXADMIN.TRCA$R TO SQLT_USER_ROLE;
GRANT EXECUTE ON SQLTXADMIN.TRCA$T TO SQLT_USER_ROLE;
GRANT EXECUTE ON SQLTXADMIN.TRCA$X TO SQLT_USER_ROLE;
GRANT SELECT ON SQLTXADMIN.TRCA$_GROUP_V TO SQLT_USER_ROLE;
GRANT SELECT ON SQLTXADMIN.TRCA$_PROGRESS_V TO SQLT_USER_ROLE;
GRANT SELECT ON SQLTXADMIN.TRCA$_PURGE_CANDIDATE_V TO SQLT_USER_ROLE;
GRANT SELECT ON SQLTXADMIN.TRCA$_SQL_V TO SQLT_USER_ROLE;
GRANT SELECT ON SQLTXPLAIN.SQLG$_PIVOT TO SQLT_USER_ROLE;
GRANT DELETE, INSERT, SELECT ON SQLTXPLAIN.SQLG$_TEMP TO SQLT_USER_ROLE;
GRANT DELETE, INSERT, SELECT, UPDATE ON SQLTXPLAIN.SQLI$_DB_LINK TO SQLT_USER_ROLE;
GRANT INSERT, SELECT ON SQLTXPLAIN.SQLI$_FILE TO SQLT_USER_ROLE;
GRANT SELECT ON SQLTXPLAIN.SQLT$_DBA_CONSTRAINTS TO SQLT_USER_ROLE;
GRANT SELECT ON SQLTXPLAIN.SQLT$_DBA_HIST_SQLSTAT TO SQLT_USER_ROLE;
GRANT SELECT, UPDATE ON SQLTXPLAIN.SQLT$_DBA_INDEXES TO SQLT_USER_ROLE;
GRANT SELECT ON SQLTXPLAIN.SQLT$_DBA_IND_STATS_VERSIONS TO SQLT_USER_ROLE;
GRANT SELECT, UPDATE ON SQLTXPLAIN.SQLT$_DBA_OBJECTS TO SQLT_USER_ROLE;
GRANT SELECT, UPDATE ON SQLTXPLAIN.SQLT$_DBA_OBJECT_TABLES TO SQLT_USER_ROLE;
GRANT SELECT, UPDATE ON SQLTXPLAIN.SQLT$_DBA_TABLES TO SQLT_USER_ROLE;
GRANT SELECT ON SQLTXPLAIN.SQLT$_DBA_TABLESPACES TO SQLT_USER_ROLE;
GRANT SELECT ON SQLTXPLAIN.SQLT$_DBA_TAB_STATS_VERSIONS TO SQLT_USER_ROLE;
GRANT INSERT, SELECT ON SQLTXPLAIN.SQLT$_FND_HISTOGRAM_COLS TO SQLT_USER_ROLE;
GRANT SELECT ON SQLTXPLAIN.SQLT$_GV$CELL_STATE TO SQLT_USER_ROLE;
GRANT SELECT ON SQLTXPLAIN.SQLT$_LOG TO SQLT_USER_ROLE;
GRANT INSERT, SELECT ON SQLTXPLAIN.SQLT$_METADATA TO SQLT_USER_ROLE;
GRANT SELECT ON SQLTXPLAIN.SQLT$_PLAN_EXTENSION TO SQLT_USER_ROLE;
GRANT DELETE, INSERT, SELECT ON SQLTXPLAIN.SQLT$_SQL_PLAN_TABLE TO SQLT_USER_ROLE;
GRANT SELECT, UPDATE ON SQLTXPLAIN.SQLT$_SQL_STATEMENT TO SQLT_USER_ROLE;
GRANT INSERT, SELECT ON SQLTXPLAIN.SQLT$_STATTAB TO SQLT_USER_ROLE;
GRANT SELECT ON SQLTXPLAIN.SQLT$_STGTAB_SQLPROF TO SQLT_USER_ROLE;
GRANT SELECT ON SQLTXPLAIN.TRCA$_FILE TO SQLT_USER_ROLE;
GRANT INSERT ON SQLTXPLAIN.TRCA$_PLAN_TABLE TO SQLT_USER_ROLE;
GRANT SELECT, UPDATE ON SQLTXPLAIN.TRCA$_TABLES TO SQLT_USER_ROLE;
GRANT SELECT ON SQLTXPLAIN.TRCA$_TOOL_EXECUTION TO SQLT_USER_ROLE;
GRANT EXECUTE ON SYS.DBMS_METADATA TO SQLT_USER_ROLE;
GRANT READ, WRITE ON DIRECTORY SQLT$STAGE TO SQLT_USER_ROLE;
GRANT SELECT ON SYS.SQLT$_MY_V$SESSION TO SQLT_USER_ROLE;
GRANT SELECT ON SYS.SQLT$_MY_V$SQL TO SQLT_USER_ROLE;
GRANT SELECT ON SYS.TRCA$_LOG_V TO SQLT_USER_ROLE;

-- System privileges granted to SQLT_USER_ROLE
GRANT ADVISOR TO SQLT_USER_ROLE;

-- Roles granted to SQLT_USER_ROLE
GRANT SELECT_CATALOG_ROLE TO SQLT_USER_ROLE;

-- Grantees of SQLT_USER_ROLE
GRANT SQLT_USER_ROLE TO PSIMUSR;
GRANT SQLT_USER_ROLE TO SYS WITH ADMIN OPTION;
DROP ROLE BIZFLOW_RW;

CREATE ROLE BIZFLOW_RW NOT IDENTIFIED;

-- Object privileges granted to BIZFLOW_RW
GRANT INSERT, SELECT, UPDATE ON ADR.WKF_CASE TO BIZFLOW_RW;
GRANT INSERT, SELECT, UPDATE ON VOA.VOA_ENROLLMENT_APPLICATION TO BIZFLOW_RW;
GRANT INSERT, SELECT ON VOA.VOA_ENROLLMENT_APPLICATION_H TO BIZFLOW_RW;

-- Grantees of BIZFLOW_RW
GRANT BIZFLOW_RW TO AACDBA WITH ADMIN OPTION;
GRANT BIZFLOW_RW TO BIZFLOWUSR;
DROP ROLE BIZFLOW_R;

CREATE ROLE BIZFLOW_R NOT IDENTIFIED;

-- Object privileges granted to BIZFLOW_R
GRANT SELECT ON ADR.ENROLLMENT_DETERMINATION TO BIZFLOW_R;
GRANT SELECT ON ADR.PERSON TO BIZFLOW_R;
GRANT SELECT ON ADRREF.STD_WORKFLOWCASETYPE TO BIZFLOW_R;
GRANT SELECT ON VBR.VETERAN_IDENTIFIER_TYPE TO BIZFLOW_R;
GRANT SELECT ON VOA.ENROLLMENT_FORM_TYPE TO BIZFLOW_R;
GRANT SELECT ON VOA.ENROLLMENT_FORM_TYPE_H TO BIZFLOW_R;

-- Grantees of BIZFLOW_R
GRANT BIZFLOW_R TO AACDBA WITH ADMIN OPTION;
GRANT BIZFLOW_R TO BIZFLOWUSR;
GRANT BIZFLOW_R TO DNS   REYESJ;
GRANT BIZFLOW_R TO DNS  ALTMI;
GRANT BIZFLOW_R TO DNS PASHAA;
GRANT BIZFLOW_R TO DNS   WALLASH;
GRANT BIZFLOW_R TO DNS   GROOMA;
GRANT BIZFLOW_R TO DNS   PURSCD;
GRANT BIZFLOW_R TO DNS   FITZGR;
GRANT BIZFLOW_R TO DNS   ARCHET;
GRANT BIZFLOW_R TO DNS   DHEERA;
GRANT BIZFLOW_R TO DNS   REENT;
DROP ROLE SDS_ADMIN;

CREATE ROLE SDS_ADMIN NOT IDENTIFIED;

-- Object privileges granted to SDS_ADMIN
GRANT SELECT ON SDSADM.MLOG$_STD_ADDRESSCHANGESOU TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ADDRESSCHANGESOU1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ADDRESSDELIVERYF TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ADDRESSINVALIDRE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ADDRESSTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ADDRESSTYPEHISTO TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ADMINISTRATIVEEN TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ADRSDLVRYFLRCDHI TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ADRSINVALRSNHIST TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_AFFECTEDEXTREMIT TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_AFFECTEDEXTREMIT1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_AGENCY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_AGENCYHISTORY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_AGENTORANGELOCAT TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_AGENTORANGELOCNH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ALLIEDCOUNTRY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ALLIEDCOUNTRYHIS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ASSETTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ASSETTYPEHISTORY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ASSIGNINGAUTHORI TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ASSIGNINGAUTHORI1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_BENEFITSCOORDTYP TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_BENEFITSCOORDTYP1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_CANCELDECLINEHIS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_CANCELDECLINEREA TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_CANCELDECLINESTT TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_CANCELDECLINESTT1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_CATADISABILITYEX TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_CATADISABILITYEX1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_CLINDETERTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_CLINDETERTYPEHIS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_CODINGSYSTEM TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_CODINGSYSTEMHIST TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_COLLECTIONHISTOR TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_COLLECTIONMETHOD TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_COMBATLOCATION TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_COMBATLOCATIONHI TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_COMBATPAYTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_COMBATPAYTYPEHIS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_COMBATSVCLOCATIO TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_COMBATSVCLOCATIO1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_COMBATSVCSOURCE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_COMBATSVCSOURCEH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_CONDITIONCODE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_CONDITIONCODEHIS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_CONFADDRCATHISTO TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_CONFIDENTIALADDR TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_COUNTRY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_COUNTRYHISTORY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_COUNTY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_COUNTYHISTORY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_DEATHNOTIFICATIO TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_DEATHNOTIFICATIO1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_DECORATIONDOCUME TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_DECORATIONSTATUS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_DECORATIONSTATUS1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_DECORATIONTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_DECORATIONTYPEHI TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_DECORATNDOCTYPHI TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_DEGREE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_DEGREEHISTORY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_DIAGNOSISCODSCH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_DIAGNOSISCODSCHH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_DIAGNOSISTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_DIAGNOSISTYPEHIS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_DISABILITYCONDIT TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_DISABILITYCONDIT1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_EGTPROCESSSTATUS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_EGTPROCESSSTATUS1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_EGTTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_EGTTYPEHISTORY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ELECTRONICPLANTY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ELECTRONICPLANTY1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ELIGIBILITYCODE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ELIGIBILITYCODEH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ELIGIBILITYCODET TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ELIGIBILITYCODET1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ELIGIBILITYFACTO TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ELIGIBILITYFACTO1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ELIGIBILITYPRIMA TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ELIGIBILITYSTATU TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ELIGIBILITYSTATU1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ELIGIBILITYVRSCT TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ELIGIBILITYVRSCT1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ELIGPRMRYDATASRC TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_EMAILADDRESSTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_EMAILADDRESSTYPE1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_EMAILCHANGESOURC TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_EMAILCHANGESOURC1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_EMAIL_DOMAIN TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_EMAIL_DOMAINHIST TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_EMERGENCYRESPONS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_EMERGENCYRESPONS1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_EMPLOYMENTSTATUS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_EMPLOYMENTSTATUS1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ENROLLMENTCATTYP TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ENROLLMENTCATTYP1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ENROLLMENTOVERRI TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ENROLLMENTOVRDER TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ENROLLMENTPRIORG TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ENROLLMENTPRIORG1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ENROLLMENTPRIORS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ENROLLMENTPRIORS1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ENROLLMENTSOURCE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ENROLLMENTSOURCE1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ENROLLMENTSTATUS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ENROLLMENTSTATUS1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ENTITLEMENTCODE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ENTITLEMENTCODEH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ETHCOLLMTHDHISTO TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ETHNICITY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ETHNICITYCOLLECT TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ETHNICITYHISTORY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_EVALUATIONMETHOD TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_EVALUATIONMETHOD1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_EXPENSETYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_EXPENSETYPEHISTO TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_EXTREMITYCODE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_EXTREMITYCODEHIS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_FACILITYTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_FACILITYTYPEHIST TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_FEEBASISPRGRMHIS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_FEEBASISPROGRAM TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_FEEBASISTREATMEN TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_FEEBASISTRTMNTHI TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_FILIPINOVETERANP TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_FILIPINOVETPROOF TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_FINANCIALMAPPING TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_FINANCIALMAPPING1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_FINANINFOSOURCE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_FINANINFOSOURCEH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_GENDER TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_GENDERHISTORY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_GMTTHRESHOLDS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7ACKCODEHISTOR TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7ACKNOWLEDGEME TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7ACKNOWLEDGEME1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7ACKTYPEHISTOR TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7ACTIONCODE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7ACTIONCODEHIS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7DATATYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7DATATYPEHISTO TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7EVENTTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7EVENTTYPEHIST TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7FILELEVELEVEN TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7FILELEVELEVEN1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7MASTERFILEIDC TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7MASTERFILEIDC1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7MESSAGESTRUC TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7MESSAGESTRUCH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7MESSAGETYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7MESSAGETYPEHI TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7OBSERVRESULTC TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7OBSERVRESULTC1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7PRIMARYKEYVAL TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7PRIMKEYVALTYP TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7PROCESSINGID TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7PROCESSINGMOD TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7PROCIDHISTORY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7PROCMODEHISTO TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7QRYRESPFMTCOD TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7QRYRESPFMTCOD1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7QRYRESPSTATUS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7QUANLIMREQHIS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7QUANTITYLIMIT TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7QUERYPRIORITY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7QUERYPRIORITY1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7QUERYRESPONSE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7QUERYRESULTS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7QUERYRESULTSH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7RECLEVERRRET TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7RECLEVERRRETH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7RECLEVEVCODE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7RECLEVEVCODEH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7RESPLEVCODE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7RESPLEVCODEHI TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7RESPMODALITY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7RESPMODALITYH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7SRCOFCOMMENT TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7SRCOFCOMMENTH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7VALUETYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7VALUETYPEHIST TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7VERSIONID TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7VERSIONIDHIST TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7WHATSUBJECTFL TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7WHATSUBJECTFL1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_IDENTIFIERTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_IDENTIFIERTYPEHI TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_IDEVENTTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_IDEVENTTYPEHISTO TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_IDEXCEPTYPEGROUP TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_IDEXCEPTYPEGROUP1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_IDTASKPROBCATEGO TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_IDTASKPROBCATEGO1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_IDTASKSTATUSTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_IDTASKSTATUSTYPE1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_INCOMETESTSOURCE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_INCOMETESTSOURCE1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_INCOMETESTTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_INCOMETESTTYPEHI TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_INCOMETHRESHOLD TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_INCOMETHRESHOLDH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_INCOMETYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_INCOMETYPEHISTOR TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_INCOMEVERIFSTATU TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_INCOMEVERIFSTATU1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_INSPLANTYPEHISTO TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_INSRPRTSRCHISTOR TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_INSTITUTION TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_INSTITUTIONCODE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_INSURANCEHOLDERT TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_INSURANCEHOLDERT1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_INSURANCEMAPPING TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_INSURANCEMAPPING1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_INSURANCEPLANTYP TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_INSURANCEREPORTS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_INSURANCETYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_INSURANCETYPEHIS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_IVMMIGRATETYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_IVMMIGRATETYPEHI TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_LOCATIONTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_LOCATIONTYPEHIST TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_MARITALSTATUS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_MARITALSTATUSHIS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_MASMOVEMENTTRANS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_MASMTTHISTORY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_MEANSTESTSIGSTAT TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_MEANSTESTSIGSTAT1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_MEANSTESTSTATUS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_MEANSTESTSTATUSH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_MESSAGESTATUS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_MESSAGESTATUSHIS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_MESSAGETYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_MESSAGETYPEHISTO TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_MILHISTORYTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_MILHISTORYTYPEHI TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_MILITARYSVCCOMP TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_MILITARYSVCCOMPH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_MONETARYBENEFITT TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_MONETARYBENEFITT1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_MSTSTATUS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_MSTSTATUSHISTORY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_MTNOTREQRSNTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_MTNOTREQRSNTYPEH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_NAMETYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_NAMETYPEHISTORY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_NOSITEUPLOADREAS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_NOSITEUPLOADREAS1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_NPPESORGALIASTYP TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_NPPESORGALIASTYP1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_NPPESORGALTID TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_NPPESORGALTIDHIS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_NPPESORGALTRSN TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_NPPESORGALTRSNHI TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_NTRQUALIFIER TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_NTRQUALIFIERHIST TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_NTRVERIFICATIONM TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_NTRVERIFICATNMTH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_OEFOIFSOURCE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_OEFOIFSOURCEHIST TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ORGPROVTAXONOMY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ORGPROVTAXONOMYH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_OTHERFEDERALAGEN TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_OTHERFEDERALAGEN1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PATIENTTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PATIENTTYPEHISTO TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PERIODOFSERVICE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PERIODOFSERVICEH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PERMANENTCODE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PERMANENTCODEHIS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONCATEGORY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONCATEGORYHI TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONCLASS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONCLASSCHIST TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONCLASSCLASS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONCLASSHISTO TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONCLASSPROVI TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONCLASSPTHIS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONCONTACTTYP TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONCONTACTTYP1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONMERGESTATU TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONMERGESTATU1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONRELATION TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONRELATIONHI TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PHDATASRCTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PHDATASRCTYPEHIS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PHONECHANGESOURC TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PHONECHANGESOURC1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PHONECONTACTTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PHONECONTACTTYPE1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PLACEOFADMISSION TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PLACEOFADMISSION1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PLANCATEGORYTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PLANCATEGORYTYPE1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_POLICYHOLDERTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_POLICYHOLDERTYPE1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_POWCASLOCNHISTOR TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_POWCASUALTYLOCAT TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_POWCONFINELOCNTY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_POWCONFINELOCNTY1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_POWDATASOURCETYP TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_POWDATASOURCETYP1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_POWDOCUMENTTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_POWDOCUMENTTYPEH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_POWPERIOD TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_POWPERIODHISTORY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PROGRAMOFSTUDY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PROGRAMOFSTUDYHI TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PSEUDOSSNREASON TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PSEUDOSSNREASONH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PTFDISCHARGECODE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_PTFDISCHARGECODE1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_RACE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_RACEHISTORY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_RADIATIONEXPOSUR TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_RADIATNEXPSRMTHD TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_REGISTRYTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_REGISTRYTYPEHIST TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_REJECTEDREMARKS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_REJECTEDREMARKSH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_RELATIONALCONJUN TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_RELATIONALOPERAT TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_RELATIONSHIP TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_RELATIONSHIPHIST TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_RELATNLCONJUNCTN TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_RELATNLOPERATORH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_RELIGION TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_RELIGIONHISTORY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_RELTOVETINSURANC TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_RELTOVETINSURANC1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SENSITIVITYCHANG TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SENSITIVITYCHNGS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SERVICE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SERVICEBRANCH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SERVICEBRANCHHIS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SERVICEDISCHARGE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SERVICEHISTORY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SHADDOCUMENTTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SHADDOCUMENTTYPE1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SIGNATUREINDTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SIGNATUREINDTYPE1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SITEUPLOADSTATUS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SITEUPLOADSTATUS1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SPECIALFACTORMAP TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SPECIALFACTORMAP1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SPECIALTYSERVICE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SPECIALTYSERVICE1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SSAMESSAGETYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SSAMESSAGETYPEHI TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SSAVERIFCODE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SSAVERIFCODEHIST TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SSNCHANGESOURCE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SSNCHANGESOURCEH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SSNTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SSNTYPEHISTORY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SSNVERIFICATIONS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SSNVERIFSTATUSHI TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_STATCNTYXREF TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_STATE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_STATEHISTORY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_STATISTICALAREA TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_STATISTICALAREAH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_STATISTICALAREAT TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_STATISTICALAREAT1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_SVCDSCHRGCDHISTO TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_TRANSACTIONTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_TRANSACTIONTYPEH TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_USERGROUPTYPE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_USERGROUPTYPEHIS TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_VBAQUERYSTATUSTY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_VBAQUERYSTATUSTY1 TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_YESNOCODE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_YESNOCODEHISTORY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ZIPASSIGNMENT TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ZIPCLASSIFICATIO TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ZIPCODE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ZIPPLACE TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ZIPPLACEFACILITY TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ZIPTOMSA TO SDS_ADMIN;
GRANT SELECT ON SDSADM.MLOG$_STD_ZIPTOMSAHISTORY TO SDS_ADMIN;

-- Grantees of SDS_ADMIN
GRANT SDS_ADMIN TO AACDBA WITH ADMIN OPTION;
GRANT SDS_ADMIN TO SYSTEM;
DROP ROLE SDS_EDIT;

CREATE ROLE SDS_EDIT NOT IDENTIFIED;

-- Object privileges granted to SDS_EDIT
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ADDRESSCHANGESOURCE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ADDRESSCHANGESOURCEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ADDRESSDELIVERYFAILURECODE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ADDRESSINVALIDREASON TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ADDRESSTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ADDRESSTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ADMINISTRATIVEENTITY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ADRSDLVRYFLRCDHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ADRSINVALRSNHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_AFFECTEDEXTREMITY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_AFFECTEDEXTREMITYHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_AGENCY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_AGENCYHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_AGENTORANGELOCATION TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_AGENTORANGELOCNHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ALLIEDCOUNTRY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ALLIEDCOUNTRYHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_APPLICATION TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_APPLICATIONHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ASSETTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ASSETTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ASSIGNINGAUTHORITY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ASSIGNINGAUTHORITYHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_BENEFITSCOORDTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_BENEFITSCOORDTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_BILLINGTRANSTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_BILLINGTRANSTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_CANCELDECLINEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_CANCELDECLINEREASON TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_CANCELDECLINESTTYP TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_CANCELDECLINESTTYPHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_CATADISABILITYEXTCD TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_CATADISABILITYEXTCDHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_CLINDETERTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_CLINDETERTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_CODESET TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_CODINGSYSTEM TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_CODINGSYSTEMHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_COLLECTIONHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_COLLECTIONMETHOD TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_COMBATLOCATION TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_COMBATLOCATIONHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_COMBATPAYTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_COMBATPAYTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_COMBATSVCLOCATION TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_COMBATSVCLOCATIONHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_COMBATSVCSOURCE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_COMBATSVCSOURCEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_CONDITIONCODE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_CONDITIONCODEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_CONFADDRCATHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_CONFIDENTIALADDRESSCAT TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_CORRESPONDENCETYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_CORRESPONDENCETYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_COUNTRY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_COUNTRYHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_COUNTY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_COUNTYHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DATABASEVERSION TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DATACHANGESOURCE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DATACHANGESOURCEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DATACOLLECTJOBTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DATACOLLECTJOBTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DEATHNOTIFICATION TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DEATHNOTIFICATIONHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DECORATIONDOCUMENTTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DECORATIONSTATUS TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DECORATIONSTATUSHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DECORATIONTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DECORATIONTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DECORATNDOCTYPHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DEGREE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DEGREEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DELIVERYPREFTYP TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DELIVERYPREFTYPHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DELIVERYSRCTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DELIVERYSRCTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DESCRIPTORCODE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DESCRIPTORCODEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DETAILEDINCFINDOC TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DETAILEDINCFINDOCHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DETAILEDINCOMETYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DETAILEDINCOMETYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DIAGNOSISCODE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DIAGNOSISCODEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DIAGNOSISCODSCH TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DIAGNOSISCODSCHHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DIAGNOSISTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DIAGNOSISTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DISABILITYCONDITION TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DISABILITYCONDITIONHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DISTRIBUTIONCODE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DISTRIBUTIONCODEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DISTRIBUTIONTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DISTRIBUTIONTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DOCUMENTSOURCETYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_DOCUMENTSOURCETYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_EGTPROCESSSTATUS TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_EGTPROCESSSTATUSHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_EGTTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_EGTTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ELECTRONICPLANTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ELECTRONICPLANTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ELIGDOCTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ELIGDOCTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ELIGIBILITYCODE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ELIGIBILITYCODEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ELIGIBILITYCODETYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ELIGIBILITYCODETYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ELIGIBILITYFACTOR TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ELIGIBILITYFACTORHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ELIGIBILITYPRIMARYDATASRC TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ELIGIBILITYSTATUS TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ELIGIBILITYSTATUSHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ELIGIBILITYVRSCTYP TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ELIGIBILITYVRSCTYPHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ELIGPRMRYDATASRCHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_EMAILADDRESSTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_EMAILADDRESSTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_EMAILCHANGESOURCE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_EMAILCHANGESOURCEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_EMAIL_DOMAIN TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_EMAIL_DOMAINHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_EMERGENCYRESPONSE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_EMERGENCYRESPONSEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_EMPLOYMENTSTATUS TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_EMPLOYMENTSTATUSHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ENROLLMENTCATTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ENROLLMENTCATTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ENROLLMENTOVERRIDEREASON TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ENROLLMENTOVRDERSNHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ENROLLMENTPRIORGRP TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ENROLLMENTPRIORGRPHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ENROLLMENTPRIORSGRP TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ENROLLMENTPRIORSGRPHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ENROLLMENTSOURCE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ENROLLMENTSOURCEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ENROLLMENTSTATUS TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ENROLLMENTSTATUSHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ENTITLEMENTCODE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ENTITLEMENTCODEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ETHCOLLMTHDHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ETHNICITY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ETHNICITYCOLLECTIONMETHOD TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ETHNICITYHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_EVALUATIONMETHOD TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_EVALUATIONMETHODHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_EXCLUSIONRSNTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_EXCLUSIONRSNTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_EXPENSETYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_EXPENSETYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_EXTREMITYCODE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_EXTREMITYCODEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_FACILITYTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_FACILITYTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_FEEBASISPRGRMHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_FEEBASISPROGRAM TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_FEEBASISTREATMENTCODETYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_FEEBASISTRTMNTHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_FILIPINOVETERANPROOF TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_FILIPINOVETPROOFHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_FINANCIALDOCUMTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_FINANCIALDOCUMTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_FINANCIALMAPPING TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_FINANCIALMAPPINGHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_FINANINFOSOURCE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_FINANINFOSOURCEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_FTITRANSSTATUS TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_FTITRANSSTATUSHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_FTITRANSTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_FTITRANSTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_GENDER TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_GENDERHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_GMTTHRESHOLDS TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HEALTHBENEFITPLAN TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HEALTHBENEFITPLANHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HEALTHBENEFITTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HEALTHBENEFITTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL724ETHNICITYMAP TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL724ETHNICITYMAPHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL724MARITALSTAMAP TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL724MARITALSTAMAPHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL724RACEMAP TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL724RACEMAPHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7ACKCODEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7ACKNOWLEDGEMENTCODE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7ACKNOWLEDGEMENTTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7ACKTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7ACTIONCODE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7ACTIONCODEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7DATATYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7DATATYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7EVENTTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7EVENTTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7FILELEVELEVENT TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7FILELEVELEVENTHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7MASTERFILEIDCODE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7MASTERFILEIDCODEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7MESSAGESTRUC TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7MESSAGESTRUCHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7MESSAGETYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7MESSAGETYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7OBSERVRESULTCODE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7OBSERVRESULTCODEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7PRIMARYKEYVALUETYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7PRIMKEYVALTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7PROCESSINGID TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7PROCESSINGMODE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7PROCIDHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7PROCMODEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7QRYRESPFMTCODE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7QRYRESPFMTCODEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7QRYRESPSTATUSHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7QUANLIMREQHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7QUANTITYLIMITEDREQUEST TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7QUERYPRIORITY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7QUERYPRIORITYHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7QUERYRESPONSESTATUS TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7QUERYRESULTS TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7QUERYRESULTSHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7RECLEVERRRET TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7RECLEVERRRETHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7RECLEVEVCODE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7RECLEVEVCODEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7RESPLEVCODE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7RESPLEVCODEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7RESPMODALITY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7RESPMODALITYHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7SRCOFCOMMENT TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7SRCOFCOMMENTHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7VALUETYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7VALUETYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7VERSIONID TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7VERSIONIDHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7WHATSUBJECTFLTR TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7WHATSUBJECTFLTRHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IDENTIFIERTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IDENTIFIERTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IDEVENTTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IDEVENTTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IDEXCEPTYPEGROUP TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IDEXCEPTYPEGROUPHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IDTASKPROBCATEGORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IDTASKPROBCATEGORYHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IDTASKSTATUSTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IDTASKSTATUSTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INCOMETESTSOURCE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INCOMETESTSOURCEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INCOMETESTTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INCOMETESTTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INCOMETHRESHOLD TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INCOMETHRESHOLDHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INCOMETYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INCOMETYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INCOMEVERIFSTATUS TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INCOMEVERIFSTATUSHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INSPLANTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INSRPRTSRCHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INSTITUTION TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INSTITUTIONCODE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INSURANCEHOLDERTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INSURANCEHOLDERTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INSURANCEMAPPING TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INSURANCEMAPPINGHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INSURANCEPLANTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INSURANCEREPORTSOURCE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INSURANCETYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INSURANCETYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IVMCASEPRIORCRIT TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IVMCASEPRIORCRITHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IVMDECISIONTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IVMDECISIONTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IVMMIGRATETYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IVMMIGRATETYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IVMUNIT TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IVMUNITHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_LOCATIONTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_LOCATIONTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MARITALSTATUS TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MARITALSTATUSHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MASMOVEMENTTRANSACTIONTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MASMTTHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MEANSTESTSIGSTATUS TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MEANSTESTSIGSTATUSHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MEANSTESTSTATUS TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MEANSTESTSTATUSHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MESSAGESTATUS TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MESSAGESTATUSHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MESSAGETYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MESSAGETYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MHDATASOURCE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MHDATASOURCEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MILHISTORYTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MILHISTORYTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MILITARYSVCCOMP TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MILITARYSVCCOMPHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MILITARYSVCQRYSTAT TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MILITARYSVCQRYSTATHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MONETARYBENEFITTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MONETARYBENEFITTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MSDSCOUNTRY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MSDSCOUNTRYHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MSTSTATUS TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MSTSTATUSHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MTNOTREQRSNTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MTNOTREQRSNTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NAMEDCONTINGENCY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NAMEDCONTINGENCYHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NAMETYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NAMETYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NOSITEUPLOADREASON TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NOSITEUPLOADREASONHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NPPESORGALIASTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NPPESORGALIASTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NPPESORGALTID TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NPPESORGALTIDHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NPPESORGALTRSN TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NPPESORGALTRSNHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NTRQUALIFIER TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NTRQUALIFIERHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NTRVERIFICATIONMETHOD TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NTRVERIFICATNMTHDHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_OEFOIFSOURCE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_OEFOIFSOURCEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ORGPROVTAXONOMY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ORGPROVTAXONOMYHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_OTHERFEDERALAGENCY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_OTHERFEDERALAGENCYHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PATIENTTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PATIENTTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERIODOFSERVICE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERIODOFSERVICEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERMANENTCODE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERMANENTCODEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONCATEGORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONCATEGORYHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONCLASS TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONCLASSCHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONCLASSCLASSIFICATION TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONCLASSHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONCLASSPROVIDERTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONCLASSPTHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONCONTACTTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONCONTACTTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONMERGESTATUS TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONMERGESTATUSHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONRELATION TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONRELATIONHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PHDATASRCTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PHDATASRCTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PHONECHANGESOURCE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PHONECHANGESOURCEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PHONECONTACTTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PHONECONTACTTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PLACEOFADMISSION TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PLACEOFADMISSIONHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PLANCATEGORYTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PLANCATEGORYTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_POLICYHOLDERTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_POLICYHOLDERTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_POWCASLOCNHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_POWCASUALTYLOCATION TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_POWCONFINELOCNTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_POWCONFINELOCNTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_POWDATASOURCETYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_POWDATASOURCETYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_POWDOCUMENTTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_POWDOCUMENTTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_POWPERIOD TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_POWPERIODHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PREFFACSRCDESIG TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PREFFACSRCDESIGHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PRIMCARETMPURPCODE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PRIMCARETMPURPCODEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PROCEDURECODE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PROCEDURECODEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PROGRAMOFSTUDY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PROGRAMOFSTUDYHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PSEUDOSSNREASON TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PSEUDOSSNREASONHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PTFDISCHARGECODE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PTFDISCHARGECODEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PUBLICATIONTOPIC TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PUBLICATIONTOPICHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RACE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RACEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RADIATIONEXPOSUREMETHOD TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RADIATNEXPSRMTHDHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_REGISTRYTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_REGISTRYTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_REJECTEDREMARKS TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_REJECTEDREMARKSHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RELATIONALCONJUNCTION TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RELATIONALOPERATOR TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RELATIONSHIP TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RELATIONSHIPHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RELATNLCONJUNCTNHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RELATNLOPERATORHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RELIGION TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RELIGIONHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RELTOVETINSURANCE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RELTOVETINSURANCEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SEEDSTATUSCODE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SEEDSTATUSCODEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SENSITIVITYCHANGESOURCE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SENSITIVITYCHNGSRCHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SERVICE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SERVICEBRANCH TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SERVICEBRANCHHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SERVICEDISCHARGECODE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SERVICEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SHADDOCUMENTTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SHADDOCUMENTTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SIGNATUREINDTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SIGNATUREINDTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SITEUPLOADSTATUS TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SITEUPLOADSTATUSHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SPECIALFACTORMAP TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SPECIALFACTORMAPHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SPECIALOPERATION TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SPECIALOPERATIONHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SPECIALTYSERVICE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SPECIALTYSERVICEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SPINALINJURYCODE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SPINALINJURYCODEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SSAMESSAGETYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SSAMESSAGETYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SSAVERIFCODE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SSAVERIFCODEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SSNCHANGESOURCE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SSNCHANGESOURCEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SSNTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SSNTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SSNVERIFICATIONSTATUS TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SSNVERIFSTATUSHISTORY TO SDS_EDIT;
GRANT DELETE, INSERT, SELECT, UPDATE ON SDSADM.STD_STATCNTYXREF TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_STATE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_STATEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_STATISTICALAREA TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_STATISTICALAREAHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_STATISTICALAREATYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_STATISTICALAREATYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SVCDSCHRGCDHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_TABLEMANAGER TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_TERMINATIONREASON TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_TERMINATIONREASONHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_TRANSACTIONTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_TRANSACTIONTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_USERGROUPTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_USERGROUPTYPEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_VBAQUERYSTATUSTYPE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_VBAQUERYSTATUSTYPEHISTORY TO SDS_EDIT;
GRANT SELECT ON SDSADM.STD_VUID TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_YESNOCODE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_YESNOCODEHISTORY TO SDS_EDIT;
GRANT DELETE, INSERT, SELECT, UPDATE ON SDSADM.STD_ZIPASSIGNMENT TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ZIPCLASSIFICATION TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ZIPCLASSIFICATIONHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ZIPCODE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ZIPCODEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ZIPPLACE TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ZIPPLACEFACILITY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ZIPPLACEFACILITYHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ZIPPLACEHISTORY TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ZIPTOMSA TO SDS_EDIT;
GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ZIPTOMSAHISTORY TO SDS_EDIT;

-- System privileges granted to SDS_EDIT
GRANT ALTER SESSION TO SDS_EDIT;
GRANT CREATE SESSION TO SDS_EDIT;

-- Grantees of SDS_EDIT
GRANT SDS_EDIT TO AACDBA WITH ADMIN OPTION;
GRANT SDS_EDIT TO SDSMGR;
GRANT SDS_EDIT TO SYSTEM;
DROP ROLE SDS_OWNER;

CREATE ROLE SDS_OWNER NOT IDENTIFIED;

-- Object privileges granted to SDS_OWNER
GRANT WRITE ON DIRECTORY MVIEW_OUTPUT TO SDS_OWNER;

-- System privileges granted to SDS_OWNER
GRANT ALTER SESSION TO SDS_OWNER;
GRANT CREATE PROCEDURE TO SDS_OWNER;
GRANT CREATE SEQUENCE TO SDS_OWNER;
GRANT CREATE SESSION TO SDS_OWNER;
GRANT CREATE SYNONYM TO SDS_OWNER;
GRANT CREATE TABLE TO SDS_OWNER;
GRANT CREATE TRIGGER TO SDS_OWNER;
GRANT CREATE VIEW TO SDS_OWNER;
GRANT SELECT ANY DICTIONARY TO SDS_OWNER;

-- Grantees of SDS_OWNER
GRANT SDS_OWNER TO AACDBA WITH ADMIN OPTION;
GRANT SDS_OWNER TO SDSADM;
GRANT SDS_OWNER TO SYSTEM;
DROP ROLE SDS_PROXY;

CREATE ROLE SDS_PROXY NOT IDENTIFIED;

-- Object privileges granted to SDS_PROXY
GRANT SELECT ON SDSADM.MLOG$_STD_ADDRESSCHANGESOU TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ADDRESSCHANGESOU1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ADDRESSDELIVERYF TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ADDRESSINVALIDRE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ADDRESSTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ADDRESSTYPEHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ADMINISTRATIVEEN TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ADRSDLVRYFLRCDHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ADRSINVALRSNHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_AFFECTEDEXTREMIT TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_AFFECTEDEXTREMIT1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_AGENCY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_AGENCYHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_AGENTORANGELOCAT TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_AGENTORANGELOCNH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ALLIEDCOUNTRY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ALLIEDCOUNTRYHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_APPLICATION TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_APPLICATIONHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ASSETTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ASSETTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ASSIGNINGAUTHORI TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ASSIGNINGAUTHORI1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_BENEFITSCOORDTYP TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_BENEFITSCOORDTYP1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_BILLINGTRANSTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_BILLINGTRANSTYPE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_CANCELDECLINEHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_CANCELDECLINEREA TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_CANCELDECLINESTT TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_CANCELDECLINESTT1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_CATADISABILITYEX TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_CATADISABILITYEX1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_CLINDETERTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_CLINDETERTYPEHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_CODESET TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_CODINGSYSTEM TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_CODINGSYSTEMHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_COLLECTIONHISTOR TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_COLLECTIONMETHOD TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_COMBATLOCATION TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_COMBATLOCATIONHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_COMBATPAYTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_COMBATPAYTYPEHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_COMBATSVCLOCATIO TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_COMBATSVCLOCATIO1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_COMBATSVCSOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_COMBATSVCSOURCEH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_CONDITIONCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_CONDITIONCODEHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_CONFADDRCATHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_CONFIDENTIALADDR TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_CORRESPONDENCETY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_CORRESPONDENCETY1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_COUNTRY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_COUNTRYHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_COUNTY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_COUNTYHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DATABASEVERSION TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DATACHANGESOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DATACHANGESOURCE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DATACOLLECTJOBTY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DATACOLLECTJOBTY1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DEATHNOTIFICATIO TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DEATHNOTIFICATIO1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DECORATIONDOCUME TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DECORATIONSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DECORATIONSTATUS1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DECORATIONTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DECORATIONTYPEHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DECORATNDOCTYPHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DEGREE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DEGREEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DELIVERYPREFTYP TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DELIVERYPREFTYPH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DELIVERYSRCTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DELIVERYSRCTYPEH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DESCRIPTORCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DESCRIPTORCODEHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DETAILEDINCFINDO TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DETAILEDINCFINDO1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DETAILEDINCOMETY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DETAILEDINCOMETY1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DIAGNOSISCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DIAGNOSISCODEHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DIAGNOSISCODSCH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DIAGNOSISCODSCHH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DIAGNOSISTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DIAGNOSISTYPEHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DISABILITYCONDIT TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DISABILITYCONDIT1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DISTRIBUTIONCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DISTRIBUTIONCODE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DISTRIBUTIONTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DISTRIBUTIONTYPE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DOCUMENTSOURCETY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_DOCUMENTSOURCETY1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_EGTPROCESSSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_EGTPROCESSSTATUS1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_EGTTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_EGTTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ELECTRONICPLANTY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ELECTRONICPLANTY1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ELIGDOCTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ELIGDOCTYPEHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ELIGIBILITYCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ELIGIBILITYCODEH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ELIGIBILITYCODET TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ELIGIBILITYCODET1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ELIGIBILITYFACTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ELIGIBILITYFACTO1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ELIGIBILITYPRIMA TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ELIGIBILITYSTATU TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ELIGIBILITYSTATU1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ELIGIBILITYVRSCT TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ELIGIBILITYVRSCT1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ELIGPRMRYDATASRC TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_EMAILADDRESSTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_EMAILADDRESSTYPE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_EMAILCHANGESOURC TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_EMAILCHANGESOURC1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_EMAIL_DOMAIN TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_EMAIL_DOMAINHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_EMERGENCYRESPONS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_EMERGENCYRESPONS1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_EMPLOYMENTSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_EMPLOYMENTSTATUS1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ENROLLMENTCATTYP TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ENROLLMENTCATTYP1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ENROLLMENTOVERRI TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ENROLLMENTOVRDER TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ENROLLMENTPRIORG TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ENROLLMENTPRIORG1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ENROLLMENTPRIORS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ENROLLMENTPRIORS1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ENROLLMENTSOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ENROLLMENTSOURCE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ENROLLMENTSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ENROLLMENTSTATUS1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ENTITLEMENTCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ENTITLEMENTCODEH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ETHCOLLMTHDHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ETHNICITY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ETHNICITYCOLLECT TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ETHNICITYHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_EVALUATIONMETHOD TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_EVALUATIONMETHOD1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_EXCLUSIONRSNTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_EXCLUSIONRSNTYPE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_EXPENSETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_EXPENSETYPEHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_EXTREMITYCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_EXTREMITYCODEHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_FACILITYTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_FACILITYTYPEHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_FEEBASISPRGRMHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_FEEBASISPROGRAM TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_FEEBASISTREATMEN TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_FEEBASISTRTMNTHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_FILIPINOVETERANP TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_FILIPINOVETPROOF TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_FINANCIALDOCUMTY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_FINANCIALDOCUMTY1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_FINANCIALMAPPING TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_FINANCIALMAPPING1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_FINANINFOSOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_FINANINFOSOURCEH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_FTITRANSSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_FTITRANSSTATUSHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_FTITRANSTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_FTITRANSTYPEHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_GENDER TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_GENDERHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_GMTTHRESHOLDS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HEALTHBENEFITPLA TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HEALTHBENEFITPLA1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HEALTHBENEFITTYP TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HEALTHBENEFITTYP1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL724ETHNICITYMA TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL724ETHNICITYMA1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL724MARITALSTAM TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL724MARITALSTAM1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL724RACEMAP TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL724RACEMAPHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7ACKCODEHISTOR TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7ACKNOWLEDGEME TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7ACKNOWLEDGEME1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7ACKTYPEHISTOR TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7ACTIONCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7ACTIONCODEHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7DATATYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7DATATYPEHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7EVENTTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7EVENTTYPEHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7FILELEVELEVEN TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7FILELEVELEVEN1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7MASTERFILEIDC TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7MASTERFILEIDC1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7MESSAGESTRUC TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7MESSAGESTRUCH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7MESSAGETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7MESSAGETYPEHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7OBSERVRESULTC TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7OBSERVRESULTC1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7PRIMARYKEYVAL TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7PRIMKEYVALTYP TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7PROCESSINGID TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7PROCESSINGMOD TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7PROCIDHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7PROCMODEHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7QRYRESPFMTCOD TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7QRYRESPFMTCOD1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7QRYRESPSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7QUANLIMREQHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7QUANTITYLIMIT TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7QUERYPRIORITY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7QUERYPRIORITY1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7QUERYRESPONSE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7QUERYRESULTS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7QUERYRESULTSH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7RECLEVERRRET TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7RECLEVERRRETH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7RECLEVEVCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7RECLEVEVCODEH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7RESPLEVCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7RESPLEVCODEHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7RESPMODALITY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7RESPMODALITYH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7SRCOFCOMMENT TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7SRCOFCOMMENTH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7VALUETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7VALUETYPEHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7VERSIONID TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7VERSIONIDHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7WHATSUBJECTFL TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_HL7WHATSUBJECTFL1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_IDENTIFIERTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_IDENTIFIERTYPEHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_IDEVENTTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_IDEVENTTYPEHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_IDEXCEPTYPEGROUP TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_IDEXCEPTYPEGROUP1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_IDTASKPROBCATEGO TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_IDTASKPROBCATEGO1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_IDTASKSTATUSTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_IDTASKSTATUSTYPE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_INCOMETESTSOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_INCOMETESTSOURCE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_INCOMETESTTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_INCOMETESTTYPEHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_INCOMETHRESHOLD TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_INCOMETHRESHOLDH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_INCOMETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_INCOMETYPEHISTOR TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_INCOMEVERIFSTATU TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_INCOMEVERIFSTATU1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_INSPLANTYPEHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_INSRPRTSRCHISTOR TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_INSTITUTION TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_INSTITUTIONCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_INSURANCEHOLDERT TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_INSURANCEHOLDERT1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_INSURANCEMAPPING TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_INSURANCEMAPPING1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_INSURANCEPLANTYP TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_INSURANCEREPORTS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_INSURANCETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_INSURANCETYPEHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_IVMCASEPRIORCRIT TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_IVMCASEPRIORCRIT1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_IVMDECISIONTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_IVMDECISIONTYPEH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_IVMMIGRATETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_IVMMIGRATETYPEHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_IVMUNIT TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_IVMUNITHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_LOCATIONTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_LOCATIONTYPEHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MARITALSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MARITALSTATUSHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MASMOVEMENTTRANS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MASMTTHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MEANSTESTSIGSTAT TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MEANSTESTSIGSTAT1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MEANSTESTSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MEANSTESTSTATUSH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MESSAGESTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MESSAGESTATUSHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MESSAGETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MESSAGETYPEHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MHDATASOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MHDATASOURCEHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MILHISTORYTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MILHISTORYTYPEHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MILITARYSVCCOMP TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MILITARYSVCCOMPH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MILITARYSVCQRYST TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MILITARYSVCQRYST1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MONETARYBENEFITT TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MONETARYBENEFITT1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MSDSCOUNTRY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MSDSCOUNTRYHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MSTSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MSTSTATUSHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MTNOTREQRSNTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_MTNOTREQRSNTYPEH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_NAMEDCONTINGENCY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_NAMEDCONTINGENCY1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_NAMETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_NAMETYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_NOSITEUPLOADREAS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_NOSITEUPLOADREAS1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_NPPESORGALIASTYP TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_NPPESORGALIASTYP1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_NPPESORGALTID TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_NPPESORGALTIDHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_NPPESORGALTRSN TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_NPPESORGALTRSNHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_NTRQUALIFIER TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_NTRQUALIFIERHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_NTRVERIFICATIONM TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_NTRVERIFICATNMTH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_OEFOIFSOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_OEFOIFSOURCEHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ORGPROVTAXONOMY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ORGPROVTAXONOMYH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_OTHERFEDERALAGEN TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_OTHERFEDERALAGEN1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PATIENTTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PATIENTTYPEHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PERIODOFSERVICE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PERIODOFSERVICEH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PERMANENTCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PERMANENTCODEHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONCATEGORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONCATEGORYHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONCLASS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONCLASSCHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONCLASSCLASS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONCLASSHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONCLASSPROVI TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONCLASSPTHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONCONTACTTYP TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONCONTACTTYP1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONMERGESTATU TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONMERGESTATU1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONRELATION TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PERSONRELATIONHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PHDATASRCTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PHDATASRCTYPEHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PHONECHANGESOURC TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PHONECHANGESOURC1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PHONECONTACTTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PHONECONTACTTYPE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PLACEOFADMISSION TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PLACEOFADMISSION1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PLANCATEGORYTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PLANCATEGORYTYPE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_POLICYHOLDERTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_POLICYHOLDERTYPE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_POWCASLOCNHISTOR TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_POWCASUALTYLOCAT TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_POWCONFINELOCNTY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_POWCONFINELOCNTY1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_POWDATASOURCETYP TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_POWDATASOURCETYP1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_POWDOCUMENTTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_POWDOCUMENTTYPEH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_POWPERIOD TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_POWPERIODHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PREFFACSRCDESIG TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PREFFACSRCDESIGH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PRIMCARETMPURPCO TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PRIMCARETMPURPCO1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PROCEDURECODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PROCEDURECODEHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PROGRAMOFSTUDY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PROGRAMOFSTUDYHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PSEUDOSSNREASON TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PSEUDOSSNREASONH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PTFDISCHARGECODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PTFDISCHARGECODE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PUBLICATIONTOPIC TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_PUBLICATIONTOPIC1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_RACE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_RACEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_RADIATIONEXPOSUR TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_RADIATNEXPSRMTHD TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_REGISTRYTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_REGISTRYTYPEHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_REJECTEDREMARKS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_REJECTEDREMARKSH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_RELATIONALCONJUN TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_RELATIONALOPERAT TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_RELATIONSHIP TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_RELATIONSHIPHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_RELATNLCONJUNCTN TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_RELATNLOPERATORH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_RELIGION TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_RELIGIONHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_RELTOVETINSURANC TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_RELTOVETINSURANC1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SEEDSTATUSCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SEEDSTATUSCODEHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SENSITIVITYCHANG TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SENSITIVITYCHNGS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SERVICE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SERVICEBRANCH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SERVICEBRANCHHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SERVICEDISCHARGE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SERVICEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SHADDOCUMENTTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SHADDOCUMENTTYPE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SIGNATUREINDTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SIGNATUREINDTYPE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SITEUPLOADSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SITEUPLOADSTATUS1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SPECIALFACTORMAP TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SPECIALFACTORMAP1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SPECIALOPERATION TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SPECIALOPERATION1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SPECIALTYSERVICE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SPECIALTYSERVICE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SPINALINJURYCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SPINALINJURYCODE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SSAMESSAGETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SSAMESSAGETYPEHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SSAVERIFCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SSAVERIFCODEHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SSNCHANGESOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SSNCHANGESOURCEH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SSNTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SSNTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SSNVERIFICATIONS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SSNVERIFSTATUSHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_STATCNTYXREF TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_STATE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_STATEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_STATISTICALAREA TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_STATISTICALAREAH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_STATISTICALAREAT TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_STATISTICALAREAT1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_SVCDSCHRGCDHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_TERMINATIONREASO TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_TERMINATIONREASO1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_TRANSACTIONTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_TRANSACTIONTYPEH TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_USERGROUPTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_USERGROUPTYPEHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_VBAQUERYSTATUSTY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_VBAQUERYSTATUSTY1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_YESNOCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_YESNOCODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ZIPASSIGNMENT TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ZIPCLASSIFICATIO TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ZIPCLASSIFICATIO1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ZIPCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ZIPCODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ZIPPLACE TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ZIPPLACEFACILITY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ZIPPLACEFACILITY1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ZIPPLACEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ZIPTOMSA TO SDS_PROXY;
GRANT SELECT ON SDSADM.MLOG$_STD_ZIPTOMSAHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ADDRESSCHANGESOU TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ADDRESSCHANGESOU1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ADDRESSDELIVERYF TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ADDRESSINVALIDRE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ADDRESSTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ADDRESSTYPEHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ADMINISTRATIVEEN TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ADRSDLVRYFLRCDHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ADRSINVALRSNHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_AFFECTEDEXTREMIT TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_AFFECTEDEXTREMIT1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_AGENCY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_AGENCYHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_AGENTORANGELOCAT TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_AGENTORANGELOCNH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ALLIEDCOUNTRY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ALLIEDCOUNTRYHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_APPLICATION TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_APPLICATIONHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ASSETTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ASSETTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ASSIGNINGAUTHORI TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ASSIGNINGAUTHORI1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_BENEFITSCOORDTYP TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_BENEFITSCOORDTYP1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_BILLINGTRANSTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_BILLINGTRANSTYPE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_CANCELDECLINEHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_CANCELDECLINEREA TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_CANCELDECLINESTT TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_CANCELDECLINESTT1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_CATADISABILITYEX TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_CATADISABILITYEX1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_CLINDETERTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_CLINDETERTYPEHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_CODESET TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_CODINGSYSTEM TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_CODINGSYSTEMHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_COLLECTIONHISTOR TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_COLLECTIONMETHOD TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_COMBATLOCATION TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_COMBATLOCATIONHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_COMBATPAYTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_COMBATPAYTYPEHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_COMBATSVCLOCATIO TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_COMBATSVCLOCATIO1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_COMBATSVCSOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_COMBATSVCSOURCEH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_CONDITIONCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_CONDITIONCODEHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_CONFADDRCATHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_CONFIDENTIALADDR TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_CORRESPONDENCETY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_CORRESPONDENCETY1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_COUNTRY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_COUNTRYHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_COUNTY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_COUNTYHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DATABASEVERSION TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DATACHANGESOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DATACHANGESOURCE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DATACOLLECTJOBTY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DATACOLLECTJOBTY1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DEATHNOTIFICATIO TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DEATHNOTIFICATIO1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DECORATIONDOCUME TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DECORATIONSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DECORATIONSTATUS1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DECORATIONTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DECORATIONTYPEHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DECORATNDOCTYPHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DEGREE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DEGREEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DELIVERYPREFTYP TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DELIVERYPREFTYPH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DELIVERYSRCTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DELIVERYSRCTYPEH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DESCRIPTORCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DESCRIPTORCODEHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DETAILEDINCFINDO TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DETAILEDINCFINDO1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DETAILEDINCOMETY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DETAILEDINCOMETY1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DIAGNOSISCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DIAGNOSISCODEHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DIAGNOSISCODSCH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DIAGNOSISCODSCHH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DIAGNOSISTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DIAGNOSISTYPEHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DISABILITYCONDIT TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DISABILITYCONDIT1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DISTRIBUTIONCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DISTRIBUTIONCODE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DISTRIBUTIONTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DISTRIBUTIONTYPE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DOCUMENTSOURCETY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_DOCUMENTSOURCETY1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_EGTPROCESSSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_EGTPROCESSSTATUS1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_EGTTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_EGTTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ELECTRONICPLANTY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ELECTRONICPLANTY1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ELIGDOCTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ELIGDOCTYPEHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ELIGIBILITYCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ELIGIBILITYCODEH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ELIGIBILITYCODET TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ELIGIBILITYCODET1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ELIGIBILITYFACTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ELIGIBILITYFACTO1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ELIGIBILITYPRIMA TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ELIGIBILITYSTATU TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ELIGIBILITYSTATU1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ELIGIBILITYVRSCT TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ELIGIBILITYVRSCT1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ELIGPRMRYDATASRC TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_EMAILADDRESSTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_EMAILADDRESSTYPE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_EMAILCHANGESOURC TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_EMAILCHANGESOURC1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_EMAIL_DOMAIN TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_EMAIL_DOMAINHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_EMERGENCYRESPONS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_EMERGENCYRESPONS1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_EMPLOYMENTSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_EMPLOYMENTSTATUS1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ENROLLMENTCATTYP TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ENROLLMENTCATTYP1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ENROLLMENTOVERRI TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ENROLLMENTOVRDER TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ENROLLMENTPRIORG TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ENROLLMENTPRIORG1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ENROLLMENTPRIORS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ENROLLMENTPRIORS1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ENROLLMENTSOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ENROLLMENTSOURCE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ENROLLMENTSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ENROLLMENTSTATUS1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ENTITLEMENTCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ENTITLEMENTCODEH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ETHCOLLMTHDHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ETHNICITY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ETHNICITYCOLLECT TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ETHNICITYHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_EVALUATIONMETHOD TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_EVALUATIONMETHOD1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_EXCLUSIONRSNTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_EXCLUSIONRSNTYPE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_EXPENSETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_EXPENSETYPEHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_EXTREMITYCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_EXTREMITYCODEHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_FACILITYTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_FACILITYTYPEHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_FEEBASISPRGRMHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_FEEBASISPROGRAM TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_FEEBASISTREATMEN TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_FEEBASISTRTMNTHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_FILIPINOVETERANP TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_FILIPINOVETPROOF TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_FINANCIALDOCUMTY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_FINANCIALDOCUMTY1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_FINANCIALMAPPING TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_FINANCIALMAPPING1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_FINANINFOSOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_FINANINFOSOURCEH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_FTITRANSSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_FTITRANSSTATUSHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_FTITRANSTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_FTITRANSTYPEHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_GENDER TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_GENDERHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_GMTTHRESHOLDS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HEALTHBENEFITPLA TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HEALTHBENEFITPLA1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HEALTHBENEFITTYP TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HEALTHBENEFITTYP1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL724ETHNICITYMA TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL724ETHNICITYMA1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL724MARITALSTAM TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL724MARITALSTAM1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL724RACEMAP TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL724RACEMAPHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7ACKCODEHISTOR TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7ACKNOWLEDGEME TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7ACKNOWLEDGEME1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7ACKTYPEHISTOR TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7ACTIONCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7ACTIONCODEHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7DATATYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7DATATYPEHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7EVENTTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7EVENTTYPEHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7FILELEVELEVEN TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7FILELEVELEVEN1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7MASTERFILEIDC TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7MASTERFILEIDC1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7MESSAGESTRUC TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7MESSAGESTRUCH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7MESSAGETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7MESSAGETYPEHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7OBSERVRESULTC TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7OBSERVRESULTC1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7PRIMARYKEYVAL TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7PRIMKEYVALTYP TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7PROCESSINGID TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7PROCESSINGMOD TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7PROCIDHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7PROCMODEHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7QRYRESPFMTCOD TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7QRYRESPFMTCOD1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7QRYRESPSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7QUANLIMREQHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7QUANTITYLIMIT TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7QUERYPRIORITY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7QUERYPRIORITY1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7QUERYRESPONSE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7QUERYRESULTS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7QUERYRESULTSH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7RECLEVERRRET TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7RECLEVERRRETH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7RECLEVEVCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7RECLEVEVCODEH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7RESPLEVCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7RESPLEVCODEHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7RESPMODALITY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7RESPMODALITYH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7SRCOFCOMMENT TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7SRCOFCOMMENTH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7VALUETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7VALUETYPEHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7VERSIONID TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7VERSIONIDHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7WHATSUBJECTFL TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_HL7WHATSUBJECTFL1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_IDENTIFIERTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_IDENTIFIERTYPEHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_IDEVENTTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_IDEVENTTYPEHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_IDEXCEPTYPEGROUP TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_IDEXCEPTYPEGROUP1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_IDTASKPROBCATEGO TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_IDTASKPROBCATEGO1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_IDTASKSTATUSTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_IDTASKSTATUSTYPE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_INCOMETESTSOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_INCOMETESTSOURCE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_INCOMETESTTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_INCOMETESTTYPEHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_INCOMETHRESHOLD TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_INCOMETHRESHOLDH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_INCOMETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_INCOMETYPEHISTOR TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_INCOMEVERIFSTATU TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_INCOMEVERIFSTATU1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_INSPLANTYPEHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_INSRPRTSRCHISTOR TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_INSTITUTION TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_INSTITUTIONCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_INSURANCEHOLDERT TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_INSURANCEHOLDERT1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_INSURANCEMAPPING TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_INSURANCEMAPPING1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_INSURANCEPLANTYP TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_INSURANCEREPORTS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_INSURANCETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_INSURANCETYPEHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_IVMCASEPRIORCRIT TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_IVMCASEPRIORCRIT1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_IVMDECISIONTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_IVMDECISIONTYPEH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_IVMMIGRATETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_IVMMIGRATETYPEHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_IVMUNIT TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_IVMUNITHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_LOCATIONTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_LOCATIONTYPEHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MARITALSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MARITALSTATUSHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MASMOVEMENTTRANS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MASMTTHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MEANSTESTSIGSTAT TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MEANSTESTSIGSTAT1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MEANSTESTSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MEANSTESTSTATUSH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MESSAGESTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MESSAGESTATUSHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MESSAGETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MESSAGETYPEHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MHDATASOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MHDATASOURCEHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MILHISTORYTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MILHISTORYTYPEHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MILITARYSVCCOMP TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MILITARYSVCCOMPH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MILITARYSVCQRYST TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MILITARYSVCQRYST1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MONETARYBENEFITT TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MONETARYBENEFITT1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MSDSCOUNTRY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MSDSCOUNTRYHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MSTSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MSTSTATUSHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MTNOTREQRSNTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_MTNOTREQRSNTYPEH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_NAMEDCONTINGENCY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_NAMEDCONTINGENCY1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_NAMETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_NAMETYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_NOSITEUPLOADREAS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_NOSITEUPLOADREAS1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_NPPESORGALIASTYP TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_NPPESORGALIASTYP1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_NPPESORGALTID TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_NPPESORGALTIDHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_NPPESORGALTRSN TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_NPPESORGALTRSNHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_NTRQUALIFIER TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_NTRQUALIFIERHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_NTRVERIFICATIONM TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_NTRVERIFICATNMTH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_OEFOIFSOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_OEFOIFSOURCEHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ORGPROVTAXONOMY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ORGPROVTAXONOMYH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_OTHERFEDERALAGEN TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_OTHERFEDERALAGEN1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PATIENTTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PATIENTTYPEHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PERIODOFSERVICE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PERIODOFSERVICEH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PERMANENTCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PERMANENTCODEHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PERSONCATEGORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PERSONCATEGORYHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PERSONCLASS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PERSONCLASSCHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PERSONCLASSCLASS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PERSONCLASSHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PERSONCLASSPROVI TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PERSONCLASSPTHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PERSONCONTACTTYP TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PERSONCONTACTTYP1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PERSONMERGESTATU TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PERSONMERGESTATU1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PERSONRELATION TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PERSONRELATIONHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PHDATASRCTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PHDATASRCTYPEHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PHONECHANGESOURC TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PHONECHANGESOURC1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PHONECONTACTTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PHONECONTACTTYPE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PLACEOFADMISSION TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PLACEOFADMISSION1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PLANCATEGORYTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PLANCATEGORYTYPE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_POLICYHOLDERTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_POLICYHOLDERTYPE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_POWCASLOCNHISTOR TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_POWCASUALTYLOCAT TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_POWCONFINELOCNTY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_POWCONFINELOCNTY1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_POWDATASOURCETYP TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_POWDATASOURCETYP1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_POWDOCUMENTTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_POWDOCUMENTTYPEH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_POWPERIOD TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_POWPERIODHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PREFFACSRCDESIG TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PREFFACSRCDESIGH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PRIMCARETMPURPCO TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PRIMCARETMPURPCO1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PROCEDURECODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PROCEDURECODEHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PROGRAMOFSTUDY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PROGRAMOFSTUDYHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PSEUDOSSNREASON TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PSEUDOSSNREASONH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PTFDISCHARGECODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PTFDISCHARGECODE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PUBLICATIONTOPIC TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_PUBLICATIONTOPIC1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_RACE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_RACEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_RADIATIONEXPOSUR TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_RADIATNEXPSRMTHD TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_REGISTRYTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_REGISTRYTYPEHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_REJECTEDREMARKS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_REJECTEDREMARKSH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_RELATIONALCONJUN TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_RELATIONALOPERAT TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_RELATIONSHIP TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_RELATIONSHIPHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_RELATNLCONJUNCTN TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_RELATNLOPERATORH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_RELIGION TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_RELIGIONHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_RELTOVETINSURANC TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_RELTOVETINSURANC1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SEEDSTATUSCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SEEDSTATUSCODEHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SENSITIVITYCHANG TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SENSITIVITYCHNGS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SERVICE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SERVICEBRANCH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SERVICEBRANCHHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SERVICEDISCHARGE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SERVICEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SHADDOCUMENTTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SHADDOCUMENTTYPE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SIGNATUREINDTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SIGNATUREINDTYPE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SITEUPLOADSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SITEUPLOADSTATUS1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SPECIALFACTORMAP TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SPECIALFACTORMAP1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SPECIALOPERATION TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SPECIALOPERATION1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SPECIALTYSERVICE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SPECIALTYSERVICE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SPINALINJURYCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SPINALINJURYCODE1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SSAMESSAGETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SSAMESSAGETYPEHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SSAVERIFCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SSAVERIFCODEHIST TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SSNCHANGESOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SSNCHANGESOURCEH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SSNTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SSNTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SSNVERIFICATIONS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SSNVERIFSTATUSHI TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_STATCNTYXREF TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_STATE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_STATEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_STATISTICALAREA TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_STATISTICALAREAH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_STATISTICALAREAT TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_STATISTICALAREAT1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_SVCDSCHRGCDHISTO TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_TERMINATIONREASO TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_TERMINATIONREASO1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_TRANSACTIONTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_TRANSACTIONTYPEH TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_USERGROUPTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_USERGROUPTYPEHIS TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_VBAQUERYSTATUSTY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_VBAQUERYSTATUSTY1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_YESNOCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_YESNOCODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ZIPASSIGNMENT TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ZIPCLASSIFICATIO TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ZIPCLASSIFICATIO1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ZIPCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ZIPCODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ZIPPLACE TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ZIPPLACEFACILITY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ZIPPLACEFACILITY1 TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ZIPPLACEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ZIPTOMSA TO SDS_PROXY;
GRANT SELECT ON SDSADM.RUPD$_STD_ZIPTOMSAHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ADDRESSCHANGESOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ADDRESSCHANGESOURCEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ADDRESSDELIVERYFAILURECODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ADDRESSINVALIDREASON TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ADDRESSTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ADDRESSTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ADMINISTRATIVEENTITY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ADRSDLVRYFLRCDHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ADRSINVALRSNHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_AFFECTEDEXTREMITY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_AFFECTEDEXTREMITYHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_AGENCY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_AGENCYHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_AGENTORANGELOCATION TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_AGENTORANGELOCNHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ALLIEDCOUNTRY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ALLIEDCOUNTRYHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_APPLICATION TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_APPLICATIONHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ASSETTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ASSETTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ASSIGNINGAUTHORITY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ASSIGNINGAUTHORITYHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_BENEFITSCOORDTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_BENEFITSCOORDTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_BILLINGTRANSTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_BILLINGTRANSTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_CANCELDECLINEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_CANCELDECLINEREASON TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_CANCELDECLINESTTYP TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_CANCELDECLINESTTYPHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_CATADISABILITYEXTCD TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_CATADISABILITYEXTCDHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_CLINDETERTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_CLINDETERTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_CODESET TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_CODINGSYSTEM TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_CODINGSYSTEMHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_COLLECTIONHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_COLLECTIONMETHOD TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_COMBATLOCATION TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_COMBATLOCATIONHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_COMBATPAYTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_COMBATPAYTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_COMBATSVCLOCATION TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_COMBATSVCLOCATIONHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_COMBATSVCSOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_COMBATSVCSOURCEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_CONDITIONCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_CONDITIONCODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_CONFADDRCATHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_CONFIDENTIALADDRESSCAT TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_CORRESPONDENCETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_CORRESPONDENCETYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_COUNTRY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_COUNTRYHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_COUNTY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_COUNTYHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DATABASEVERSION TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DATACHANGESOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DATACHANGESOURCEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DATACOLLECTJOBTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DATACOLLECTJOBTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DEATHNOTIFICATION TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DEATHNOTIFICATIONHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DECORATIONDOCUMENTTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DECORATIONSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DECORATIONSTATUSHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DECORATIONTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DECORATIONTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DECORATNDOCTYPHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DEGREE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DEGREEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DELIVERYPREFTYP TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DELIVERYPREFTYPHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DELIVERYSRCTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DELIVERYSRCTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DESCRIPTORCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DESCRIPTORCODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DETAILEDINCFINDOC TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DETAILEDINCFINDOCHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DETAILEDINCOMETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DETAILEDINCOMETYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DIAGNOSISCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DIAGNOSISCODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DIAGNOSISCODSCH TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DIAGNOSISCODSCHHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DIAGNOSISTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DIAGNOSISTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DISABILITYCONDITION TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DISABILITYCONDITIONHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DISTRIBUTIONCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DISTRIBUTIONCODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DISTRIBUTIONTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DISTRIBUTIONTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DOCUMENTSOURCETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_DOCUMENTSOURCETYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_EGTPROCESSSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_EGTPROCESSSTATUSHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_EGTTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_EGTTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ELECTRONICPLANTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ELECTRONICPLANTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ELIGDOCTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ELIGDOCTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ELIGIBILITYCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ELIGIBILITYCODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ELIGIBILITYCODETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ELIGIBILITYCODETYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ELIGIBILITYFACTOR TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ELIGIBILITYFACTORHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ELIGIBILITYPRIMARYDATASRC TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ELIGIBILITYSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ELIGIBILITYSTATUSHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ELIGIBILITYVRSCTYP TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ELIGIBILITYVRSCTYPHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ELIGPRMRYDATASRCHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_EMAILADDRESSTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_EMAILADDRESSTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_EMAILCHANGESOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_EMAILCHANGESOURCEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_EMAIL_DOMAIN TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_EMAIL_DOMAINHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_EMERGENCYRESPONSE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_EMERGENCYRESPONSEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_EMPLOYMENTSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_EMPLOYMENTSTATUSHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ENROLLMENTCATTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ENROLLMENTCATTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ENROLLMENTOVERRIDEREASON TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ENROLLMENTOVRDERSNHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ENROLLMENTPRIORGRP TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ENROLLMENTPRIORGRPHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ENROLLMENTPRIORSGRP TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ENROLLMENTPRIORSGRPHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ENROLLMENTSOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ENROLLMENTSOURCEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ENROLLMENTSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ENROLLMENTSTATUSHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ENTITLEMENTCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ENTITLEMENTCODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ETHCOLLMTHDHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ETHNICITY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ETHNICITYCOLLECTIONMETHOD TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ETHNICITYHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_EVALUATIONMETHOD TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_EVALUATIONMETHODHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_EXCLUSIONRSNTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_EXCLUSIONRSNTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_EXPENSETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_EXPENSETYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_EXTREMITYCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_EXTREMITYCODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_FACILITYTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_FACILITYTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_FEEBASISPRGRMHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_FEEBASISPROGRAM TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_FEEBASISTREATMENTCODETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_FEEBASISTRTMNTHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_FILIPINOVETERANPROOF TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_FILIPINOVETPROOFHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_FINANCIALDOCUMTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_FINANCIALDOCUMTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_FINANCIALMAPPING TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_FINANCIALMAPPINGHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_FINANINFOSOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_FINANINFOSOURCEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_FTITRANSSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_FTITRANSSTATUSHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_FTITRANSTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_FTITRANSTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_GENDER TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_GENDERHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_GMTTHRESHOLDS TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HEALTHBENEFITPLAN TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HEALTHBENEFITPLANHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HEALTHBENEFITTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HEALTHBENEFITTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL724ETHNICITYMAP TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL724ETHNICITYMAPHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL724MARITALSTAMAP TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL724MARITALSTAMAPHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL724RACEMAP TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL724RACEMAPHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7ACKCODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7ACKNOWLEDGEMENTCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7ACKNOWLEDGEMENTTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7ACKTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7ACTIONCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7ACTIONCODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7DATATYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7DATATYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7EVENTTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7EVENTTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7FILELEVELEVENT TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7FILELEVELEVENTHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7MASTERFILEIDCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7MASTERFILEIDCODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7MESSAGESTRUC TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7MESSAGESTRUCHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7MESSAGETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7MESSAGETYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7OBSERVRESULTCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7OBSERVRESULTCODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7PRIMARYKEYVALUETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7PRIMKEYVALTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7PROCESSINGID TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7PROCESSINGMODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7PROCIDHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7PROCMODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7QRYRESPFMTCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7QRYRESPFMTCODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7QRYRESPSTATUSHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7QUANLIMREQHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7QUANTITYLIMITEDREQUEST TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7QUERYPRIORITY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7QUERYPRIORITYHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7QUERYRESPONSESTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7QUERYRESULTS TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7QUERYRESULTSHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7RECLEVERRRET TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7RECLEVERRRETHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7RECLEVEVCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7RECLEVEVCODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7RESPLEVCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7RESPLEVCODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7RESPMODALITY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7RESPMODALITYHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7SRCOFCOMMENT TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7SRCOFCOMMENTHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7VALUETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7VALUETYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7VERSIONID TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7VERSIONIDHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7WHATSUBJECTFLTR TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_HL7WHATSUBJECTFLTRHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_IDENTIFIERTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_IDENTIFIERTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_IDEVENTTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_IDEVENTTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_IDEXCEPTYPEGROUP TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_IDEXCEPTYPEGROUPHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_IDTASKPROBCATEGORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_IDTASKPROBCATEGORYHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_IDTASKSTATUSTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_IDTASKSTATUSTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_INCOMETESTSOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_INCOMETESTSOURCEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_INCOMETESTTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_INCOMETESTTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_INCOMETHRESHOLD TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_INCOMETHRESHOLDHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_INCOMETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_INCOMETYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_INCOMEVERIFSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_INCOMEVERIFSTATUSHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_INSPLANTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_INSRPRTSRCHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_INSTITUTION TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_INSTITUTIONCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_INSURANCEHOLDERTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_INSURANCEHOLDERTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_INSURANCEMAPPING TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_INSURANCEMAPPINGHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_INSURANCEPLANTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_INSURANCEREPORTSOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_INSURANCETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_INSURANCETYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_IVMCASEPRIORCRIT TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_IVMCASEPRIORCRITHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_IVMDECISIONTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_IVMDECISIONTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_IVMMIGRATETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_IVMMIGRATETYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_IVMUNIT TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_IVMUNITHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_LOCATIONTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_LOCATIONTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MARITALSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MARITALSTATUSHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MASMOVEMENTTRANSACTIONTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MASMTTHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MEANSTESTSIGSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MEANSTESTSIGSTATUSHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MEANSTESTSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MEANSTESTSTATUSHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MESSAGESTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MESSAGESTATUSHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MESSAGETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MESSAGETYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MHDATASOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MHDATASOURCEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MILHISTORYTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MILHISTORYTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MILITARYSVCCOMP TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MILITARYSVCCOMPHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MILITARYSVCQRYSTAT TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MILITARYSVCQRYSTATHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MONETARYBENEFITTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MONETARYBENEFITTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MSDSCOUNTRY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MSDSCOUNTRYHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MSTSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MSTSTATUSHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MTNOTREQRSNTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_MTNOTREQRSNTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_NAMEDCONTINGENCY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_NAMEDCONTINGENCYHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_NAMETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_NAMETYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_NOSITEUPLOADREASON TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_NOSITEUPLOADREASONHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_NPPESORGALIASTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_NPPESORGALIASTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_NPPESORGALTID TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_NPPESORGALTIDHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_NPPESORGALTRSN TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_NPPESORGALTRSNHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_NTRQUALIFIER TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_NTRQUALIFIERHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_NTRVERIFICATIONMETHOD TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_NTRVERIFICATNMTHDHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_OEFOIFSOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_OEFOIFSOURCEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ORGPROVTAXONOMY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ORGPROVTAXONOMYHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_OTHERFEDERALAGENCY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_OTHERFEDERALAGENCYHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PATIENTTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PATIENTTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PERIODOFSERVICE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PERIODOFSERVICEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PERMANENTCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PERMANENTCODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PERSONCATEGORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PERSONCATEGORYHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PERSONCLASS TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PERSONCLASSCHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PERSONCLASSCLASSIFICATION TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PERSONCLASSHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PERSONCLASSPROVIDERTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PERSONCLASSPTHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PERSONCONTACTTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PERSONCONTACTTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PERSONMERGESTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PERSONMERGESTATUSHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PERSONRELATION TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PERSONRELATIONHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PHDATASRCTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PHDATASRCTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PHONECHANGESOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PHONECHANGESOURCEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PHONECONTACTTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PHONECONTACTTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PLACEOFADMISSION TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PLACEOFADMISSIONHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PLANCATEGORYTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PLANCATEGORYTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_POLICYHOLDERTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_POLICYHOLDERTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_POWCASLOCNHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_POWCASUALTYLOCATION TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_POWCONFINELOCNTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_POWCONFINELOCNTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_POWDATASOURCETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_POWDATASOURCETYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_POWDOCUMENTTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_POWDOCUMENTTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_POWPERIOD TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_POWPERIODHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PREFFACSRCDESIG TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PREFFACSRCDESIGHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PRIMCARETMPURPCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PRIMCARETMPURPCODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PROCEDURECODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PROCEDURECODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PROGRAMOFSTUDY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PROGRAMOFSTUDYHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PSEUDOSSNREASON TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PSEUDOSSNREASONHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PTFDISCHARGECODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PTFDISCHARGECODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PUBLICATIONTOPIC TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_PUBLICATIONTOPICHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_RACE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_RACEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_RADIATIONEXPOSUREMETHOD TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_RADIATNEXPSRMTHDHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_REGISTRYTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_REGISTRYTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_REJECTEDREMARKS TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_REJECTEDREMARKSHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_RELATIONALCONJUNCTION TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_RELATIONALOPERATOR TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_RELATIONSHIP TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_RELATIONSHIPHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_RELATNLCONJUNCTNHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_RELATNLOPERATORHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_RELIGION TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_RELIGIONHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_RELTOVETINSURANCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_RELTOVETINSURANCEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SEEDSTATUSCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SEEDSTATUSCODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SENSITIVITYCHANGESOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SENSITIVITYCHNGSRCHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SERVICE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SERVICEBRANCH TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SERVICEBRANCHHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SERVICEDISCHARGECODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SERVICEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SHADDOCUMENTTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SHADDOCUMENTTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SIGNATUREINDTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SIGNATUREINDTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SITEUPLOADSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SITEUPLOADSTATUSHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SPECIALFACTORMAP TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SPECIALFACTORMAPHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SPECIALOPERATION TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SPECIALOPERATIONHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SPECIALTYSERVICE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SPECIALTYSERVICEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SPINALINJURYCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SPINALINJURYCODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SSAMESSAGETYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SSAMESSAGETYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SSAVERIFCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SSAVERIFCODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SSNCHANGESOURCE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SSNCHANGESOURCEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SSNTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SSNTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SSNVERIFICATIONSTATUS TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SSNVERIFSTATUSHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_STATCNTYXREF TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_STATE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_STATEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_STATISTICALAREA TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_STATISTICALAREAHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_STATISTICALAREATYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_STATISTICALAREATYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_SVCDSCHRGCDHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_TERMINATIONREASON TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_TERMINATIONREASONHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_TRANSACTIONTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_TRANSACTIONTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_USERGROUPTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_USERGROUPTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_VBAQUERYSTATUSTYPE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_VBAQUERYSTATUSTYPEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_YESNOCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_YESNOCODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ZIPASSIGNMENT TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ZIPCLASSIFICATION TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ZIPCLASSIFICATIONHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ZIPCODE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ZIPCODEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ZIPPLACE TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ZIPPLACEFACILITY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ZIPPLACEFACILITYHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ZIPPLACEHISTORY TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ZIPTOMSA TO SDS_PROXY;
GRANT SELECT ON SDSADM.STD_ZIPTOMSAHISTORY TO SDS_PROXY;

-- System privileges granted to SDS_PROXY
GRANT ALTER SESSION TO SDS_PROXY;
GRANT CREATE SESSION TO SDS_PROXY;

-- Grantees of SDS_PROXY
GRANT SDS_PROXY TO AACDBA WITH ADMIN OPTION;
GRANT SDS_PROXY TO MVADMIN_PROXY;
GRANT SDS_PROXY TO SYSTEM;
DROP ROLE SDS_SELECT;

CREATE ROLE SDS_SELECT NOT IDENTIFIED;

-- Object privileges granted to SDS_SELECT
GRANT SELECT ON SDSADM.STD_ADDRESSCHANGESOURCE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ADDRESSCHANGESOURCEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ADDRESSDELIVERYFAILURECODE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ADDRESSINVALIDREASON TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ADDRESSTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ADDRESSTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ADMINISTRATIVEENTITY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ADRSDLVRYFLRCDHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ADRSINVALRSNHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_AFFECTEDEXTREMITY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_AFFECTEDEXTREMITYHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_AGENCY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_AGENCYHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_AGENTORANGELOCATION TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_AGENTORANGELOCNHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ALLIEDCOUNTRY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ALLIEDCOUNTRYHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_APPLICATION TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_APPLICATIONHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ASSETTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ASSETTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ASSIGNINGAUTHORITY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ASSIGNINGAUTHORITYHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_BENEFITSCOORDTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_BENEFITSCOORDTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_BILLINGTRANSTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_BILLINGTRANSTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_CANCELDECLINEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_CANCELDECLINEREASON TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_CANCELDECLINESTTYP TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_CANCELDECLINESTTYPHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_CATADISABILITYEXTCD TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_CATADISABILITYEXTCDHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_CLINDETERTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_CLINDETERTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_CODESET TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_CODINGSYSTEM TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_CODINGSYSTEMHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_COLLECTIONHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_COLLECTIONMETHOD TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_COMBATLOCATION TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_COMBATLOCATIONHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_COMBATPAYTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_COMBATPAYTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_COMBATSVCLOCATION TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_COMBATSVCLOCATIONHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_COMBATSVCSOURCE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_COMBATSVCSOURCEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_CONDITIONCODE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_CONDITIONCODEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_CONFADDRCATHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_CONFIDENTIALADDRESSCAT TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_CORRESPONDENCETYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_CORRESPONDENCETYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_COUNTRY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_COUNTRYHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_COUNTY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_COUNTYHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DATABASEVERSION TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DATACHANGESOURCE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DATACHANGESOURCEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DATACOLLECTJOBTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DATACOLLECTJOBTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DEATHNOTIFICATION TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DEATHNOTIFICATIONHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DECORATIONDOCUMENTTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DECORATIONSTATUS TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DECORATIONSTATUSHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DECORATIONTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DECORATIONTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DECORATNDOCTYPHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DEGREE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DEGREEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DELIVERYPREFTYP TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DELIVERYPREFTYPHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DELIVERYSRCTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DELIVERYSRCTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DESCRIPTORCODE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DESCRIPTORCODEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DETAILEDINCFINDOC TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DETAILEDINCFINDOCHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DETAILEDINCOMETYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DETAILEDINCOMETYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DIAGNOSISCODE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DIAGNOSISCODEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DIAGNOSISCODSCH TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DIAGNOSISCODSCHHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DIAGNOSISTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DIAGNOSISTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DISABILITYCONDITION TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DISABILITYCONDITIONHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DISTRIBUTIONCODE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DISTRIBUTIONCODEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DISTRIBUTIONTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DISTRIBUTIONTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DOCUMENTSOURCETYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_DOCUMENTSOURCETYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_EGTPROCESSSTATUS TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_EGTPROCESSSTATUSHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_EGTTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_EGTTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ELECTRONICPLANTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ELECTRONICPLANTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ELIGDOCTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ELIGDOCTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ELIGIBILITYCODE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ELIGIBILITYCODEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ELIGIBILITYCODETYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ELIGIBILITYCODETYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ELIGIBILITYFACTOR TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ELIGIBILITYFACTORHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ELIGIBILITYPRIMARYDATASRC TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ELIGIBILITYSTATUS TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ELIGIBILITYSTATUSHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ELIGIBILITYVRSCTYP TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ELIGIBILITYVRSCTYPHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ELIGPRMRYDATASRCHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_EMAILADDRESSTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_EMAILADDRESSTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_EMAILCHANGESOURCE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_EMAILCHANGESOURCEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_EMAIL_DOMAIN TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_EMAIL_DOMAINHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_EMERGENCYRESPONSE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_EMERGENCYRESPONSEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_EMPLOYMENTSTATUS TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_EMPLOYMENTSTATUSHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ENROLLMENTCATTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ENROLLMENTCATTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ENROLLMENTOVERRIDEREASON TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ENROLLMENTOVRDERSNHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ENROLLMENTPRIORGRP TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ENROLLMENTPRIORGRPHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ENROLLMENTPRIORSGRP TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ENROLLMENTPRIORSGRPHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ENROLLMENTSOURCE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ENROLLMENTSOURCEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ENROLLMENTSTATUS TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ENROLLMENTSTATUSHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ENTITLEMENTCODE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ENTITLEMENTCODEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ETHCOLLMTHDHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ETHNICITY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ETHNICITYCOLLECTIONMETHOD TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ETHNICITYHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_EVALUATIONMETHOD TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_EVALUATIONMETHODHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_EXCLUSIONRSNTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_EXCLUSIONRSNTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_EXPENSETYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_EXPENSETYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_EXTREMITYCODE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_EXTREMITYCODEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_FACILITYTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_FACILITYTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_FEEBASISPRGRMHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_FEEBASISPROGRAM TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_FEEBASISTREATMENTCODETYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_FEEBASISTRTMNTHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_FILIPINOVETERANPROOF TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_FILIPINOVETPROOFHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_FINANCIALDOCUMTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_FINANCIALDOCUMTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_FINANCIALMAPPING TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_FINANCIALMAPPINGHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_FINANINFOSOURCE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_FINANINFOSOURCEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_FTITRANSSTATUS TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_FTITRANSSTATUSHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_FTITRANSTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_FTITRANSTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_GENDER TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_GENDERHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_GMTTHRESHOLDS TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HEALTHBENEFITPLAN TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HEALTHBENEFITPLANHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HEALTHBENEFITTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HEALTHBENEFITTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL724ETHNICITYMAP TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL724ETHNICITYMAPHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL724MARITALSTAMAP TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL724MARITALSTAMAPHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL724RACEMAP TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL724RACEMAPHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7ACKCODEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7ACKNOWLEDGEMENTCODE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7ACKNOWLEDGEMENTTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7ACKTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7ACTIONCODE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7ACTIONCODEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7DATATYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7DATATYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7EVENTTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7EVENTTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7FILELEVELEVENT TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7FILELEVELEVENTHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7MASTERFILEIDCODE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7MASTERFILEIDCODEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7MESSAGESTRUC TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7MESSAGESTRUCHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7MESSAGETYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7MESSAGETYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7OBSERVRESULTCODE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7OBSERVRESULTCODEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7PRIMARYKEYVALUETYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7PRIMKEYVALTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7PROCESSINGID TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7PROCESSINGMODE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7PROCIDHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7PROCMODEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7QRYRESPFMTCODE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7QRYRESPFMTCODEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7QRYRESPSTATUSHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7QUANLIMREQHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7QUANTITYLIMITEDREQUEST TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7QUERYPRIORITY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7QUERYPRIORITYHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7QUERYRESPONSESTATUS TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7QUERYRESULTS TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7QUERYRESULTSHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7RECLEVERRRET TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7RECLEVERRRETHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7RECLEVEVCODE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7RECLEVEVCODEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7RESPLEVCODE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7RESPLEVCODEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7RESPMODALITY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7RESPMODALITYHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7SRCOFCOMMENT TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7SRCOFCOMMENTHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7VALUETYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7VALUETYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7VERSIONID TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7VERSIONIDHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7WHATSUBJECTFLTR TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_HL7WHATSUBJECTFLTRHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_IDENTIFIERTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_IDENTIFIERTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_IDEVENTTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_IDEVENTTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_IDEXCEPTYPEGROUP TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_IDEXCEPTYPEGROUPHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_IDTASKPROBCATEGORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_IDTASKPROBCATEGORYHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_IDTASKSTATUSTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_IDTASKSTATUSTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_INCOMETESTSOURCE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_INCOMETESTSOURCEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_INCOMETESTTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_INCOMETESTTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_INCOMETHRESHOLD TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_INCOMETHRESHOLDHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_INCOMETYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_INCOMETYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_INCOMEVERIFSTATUS TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_INCOMEVERIFSTATUSHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_INSPLANTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_INSRPRTSRCHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_INSTITUTION TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_INSTITUTIONCODE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_INSURANCEHOLDERTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_INSURANCEHOLDERTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_INSURANCEMAPPING TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_INSURANCEMAPPINGHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_INSURANCEPLANTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_INSURANCEREPORTSOURCE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_INSURANCETYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_INSURANCETYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_IVMCASEPRIORCRIT TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_IVMCASEPRIORCRITHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_IVMDECISIONTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_IVMDECISIONTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_IVMMIGRATETYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_IVMMIGRATETYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_IVMUNIT TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_IVMUNITHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_LOCATIONTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_LOCATIONTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MARITALSTATUS TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MARITALSTATUSHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MASMOVEMENTTRANSACTIONTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MASMTTHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MEANSTESTSIGSTATUS TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MEANSTESTSIGSTATUSHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MEANSTESTSTATUS TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MEANSTESTSTATUSHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MESSAGESTATUS TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MESSAGESTATUSHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MESSAGETYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MESSAGETYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MHDATASOURCE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MHDATASOURCEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MILHISTORYTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MILHISTORYTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MILITARYSVCCOMP TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MILITARYSVCCOMPHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MILITARYSVCQRYSTAT TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MILITARYSVCQRYSTATHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MONETARYBENEFITTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MONETARYBENEFITTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MSDSCOUNTRY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MSDSCOUNTRYHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MSTSTATUS TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MSTSTATUSHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MTNOTREQRSNTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_MTNOTREQRSNTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_NAMEDCONTINGENCY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_NAMEDCONTINGENCYHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_NAMETYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_NAMETYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_NOSITEUPLOADREASON TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_NOSITEUPLOADREASONHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_NPPESORGALIASTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_NPPESORGALIASTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_NPPESORGALTID TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_NPPESORGALTIDHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_NPPESORGALTRSN TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_NPPESORGALTRSNHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_NTRQUALIFIER TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_NTRQUALIFIERHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_NTRVERIFICATIONMETHOD TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_NTRVERIFICATNMTHDHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_OEFOIFSOURCE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_OEFOIFSOURCEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ORGPROVTAXONOMY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ORGPROVTAXONOMYHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_OTHERFEDERALAGENCY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_OTHERFEDERALAGENCYHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PATIENTTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PATIENTTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PERIODOFSERVICE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PERIODOFSERVICEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PERMANENTCODE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PERMANENTCODEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PERSONCATEGORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PERSONCATEGORYHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PERSONCLASS TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PERSONCLASSCHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PERSONCLASSCLASSIFICATION TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PERSONCLASSHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PERSONCLASSPROVIDERTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PERSONCLASSPTHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PERSONCONTACTTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PERSONCONTACTTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PERSONMERGESTATUS TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PERSONMERGESTATUSHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PERSONRELATION TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PERSONRELATIONHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PHDATASRCTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PHDATASRCTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PHONECHANGESOURCE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PHONECHANGESOURCEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PHONECONTACTTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PHONECONTACTTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PLACEOFADMISSION TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PLACEOFADMISSIONHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PLANCATEGORYTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PLANCATEGORYTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_POLICYHOLDERTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_POLICYHOLDERTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_POWCASLOCNHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_POWCASUALTYLOCATION TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_POWCONFINELOCNTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_POWCONFINELOCNTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_POWDATASOURCETYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_POWDATASOURCETYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_POWDOCUMENTTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_POWDOCUMENTTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_POWPERIOD TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_POWPERIODHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PREFFACSRCDESIG TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PREFFACSRCDESIGHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PRIMCARETMPURPCODE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PRIMCARETMPURPCODEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PROCEDURECODE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PROCEDURECODEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PROGRAMOFSTUDY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PROGRAMOFSTUDYHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PSEUDOSSNREASON TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PSEUDOSSNREASONHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PTFDISCHARGECODE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PTFDISCHARGECODEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PUBLICATIONTOPIC TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_PUBLICATIONTOPICHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_RACE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_RACEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_RADIATIONEXPOSUREMETHOD TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_RADIATNEXPSRMTHDHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_REGISTRYTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_REGISTRYTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_REJECTEDREMARKS TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_REJECTEDREMARKSHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_RELATIONALCONJUNCTION TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_RELATIONALOPERATOR TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_RELATIONSHIP TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_RELATIONSHIPHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_RELATNLCONJUNCTNHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_RELATNLOPERATORHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_RELIGION TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_RELIGIONHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_RELTOVETINSURANCE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_RELTOVETINSURANCEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SEEDSTATUSCODE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SEEDSTATUSCODEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SENSITIVITYCHANGESOURCE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SENSITIVITYCHNGSRCHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SERVICE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SERVICEBRANCH TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SERVICEBRANCHHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SERVICEDISCHARGECODE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SERVICEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SHADDOCUMENTTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SHADDOCUMENTTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SIGNATUREINDTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SIGNATUREINDTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SITEUPLOADSTATUS TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SITEUPLOADSTATUSHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SPECIALFACTORMAP TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SPECIALFACTORMAPHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SPECIALOPERATION TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SPECIALOPERATIONHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SPECIALTYSERVICE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SPECIALTYSERVICEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SPINALINJURYCODE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SPINALINJURYCODEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SSAMESSAGETYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SSAMESSAGETYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SSAVERIFCODE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SSAVERIFCODEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SSNCHANGESOURCE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SSNCHANGESOURCEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SSNTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SSNTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SSNVERIFICATIONSTATUS TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SSNVERIFSTATUSHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_STATCNTYXREF TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_STATE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_STATEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_STATISTICALAREA TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_STATISTICALAREAHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_STATISTICALAREATYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_STATISTICALAREATYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_SVCDSCHRGCDHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_TABLEMANAGER TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_TERMINATIONREASON TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_TERMINATIONREASONHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_TRANSACTIONTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_TRANSACTIONTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_USERGROUPTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_USERGROUPTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_VBAQUERYSTATUSTYPE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_VBAQUERYSTATUSTYPEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_YESNOCODE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_YESNOCODEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ZIPASSIGNMENT TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ZIPCLASSIFICATION TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ZIPCLASSIFICATIONHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ZIPCODE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ZIPCODEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ZIPPLACE TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ZIPPLACEFACILITY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ZIPPLACEFACILITYHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ZIPPLACEHISTORY TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ZIPTOMSA TO SDS_SELECT;
GRANT SELECT ON SDSADM.STD_ZIPTOMSAHISTORY TO SDS_SELECT;

-- System privileges granted to SDS_SELECT
GRANT ALTER SESSION TO SDS_SELECT;
GRANT CREATE SESSION TO SDS_SELECT;

-- Roles granted to SDS_SELECT
GRANT ADRREF_R TO SDS_SELECT;

-- Grantees of SDS_SELECT
GRANT SDS_SELECT TO AACDBA WITH ADMIN OPTION;
GRANT SDS_SELECT TO ADR;
GRANT SDS_SELECT TO ADREXT;
GRANT SDS_SELECT TO ADREXTUSR;
GRANT SDS_SELECT TO ADRMGT;
GRANT SDS_SELECT TO BIZFLOWUSR;
GRANT SDS_SELECT TO BO_USR;
GRANT SDS_SELECT TO CDWENROLLUSR;
GRANT SDS_SELECT TO EERPT;
GRANT SDS_SELECT TO EESRV;
GRANT SDS_SELECT TO EESRVUSR;
GRANT SDS_SELECT TO EEUSR;
GRANT SDS_SELECT TO FSCMB_USR;
GRANT SDS_SELECT TO HECUSR;
GRANT SDS_SELECT TO ISCOPE_ORCL;
GRANT SDS_SELECT TO LOBRUSR;
GRANT SDS_SELECT TO DNS   CASTER;
GRANT SDS_SELECT TO DNS   PARSOS;
GRANT SDS_SELECT TO DNS   PENNYR;
GRANT SDS_SELECT TO DNS   REYESJ;
GRANT SDS_SELECT TO PATS;
GRANT SDS_SELECT TO PATSRPTS;
GRANT SDS_SELECT TO PSIM;
GRANT SDS_SELECT TO PSIMUSR;
GRANT SDS_SELECT TO SDSUSR;
GRANT SDS_SELECT TO SYSTEM;
GRANT SDS_SELECT TO DNS  WASSOM;
GRANT SDS_SELECT TO DNS BARNAS;
GRANT SDS_SELECT TO DNS  ALTMI;
GRANT SDS_SELECT TO DNS  RAYD1;
GRANT SDS_SELECT TO DNS KAZMIM;
GRANT SDS_SELECT TO DNS MUHAMB;
GRANT SDS_SELECT TO DNS PASHAA;
GRANT SDS_SELECT TO DNS RYALIS;
GRANT SDS_SELECT TO DNS WIEGEL;
GRANT SDS_SELECT TO DNS  KARANP;
GRANT SDS_SELECT TO DNS  MORGAR;
GRANT SDS_SELECT TO DNS  ELLISM;
GRANT SDS_SELECT TO DNS  GREENW;
GRANT SDS_SELECT TO DNS  PERKIJ;
GRANT SDS_SELECT TO VAMQASCAMPOJ2;
GRANT SDS_SELECT TO VHA06MARTIK;
GRANT SDS_SELECT TO DNS   KENNEL;
GRANT SDS_SELECT TO DNS   HALLT;
GRANT SDS_SELECT TO DNS  JACOBR;
GRANT SDS_SELECT TO DNS  JOHNSB;
GRANT SDS_SELECT TO DNS   FIERRJ;
GRANT SDS_SELECT TO DNS   PARVAV;
GRANT SDS_SELECT TO DNS   ASAFOJ;
GRANT SDS_SELECT TO DNS   BOYETD;
GRANT SDS_SELECT TO DNS   CHAMPP;
GRANT SDS_SELECT TO DNS   CORNED;
GRANT SDS_SELECT TO DNS   GONZAS;
GRANT SDS_SELECT TO DNS   HORNEE;
GRANT SDS_SELECT TO DNS   HUNTEJ;
GRANT SDS_SELECT TO DNS   JACON;
GRANT SDS_SELECT TO DNS   JOHNSS;
GRANT SDS_SELECT TO DNS   PHIFEG;
GRANT SDS_SELECT TO DNS   SCOTTS;
GRANT SDS_SELECT TO DNS   SIMSB;
GRANT SDS_SELECT TO DNS   TIDWG;
GRANT SDS_SELECT TO DNS   VITENG;
GRANT SDS_SELECT TO DNS   WALLASH;
GRANT SDS_SELECT TO DNS   WILLSC;
GRANT SDS_SELECT TO DNS   BOYETJ;
GRANT SDS_SELECT TO DNS   GROOMA;
GRANT SDS_SELECT TO DNS   WHELEC;
GRANT SDS_SELECT TO DNS   WOODM;
GRANT SDS_SELECT TO DNS   FAULKJ;
GRANT SDS_SELECT TO DNS   INNISJ;
GRANT SDS_SELECT TO DNS   PURSCD;
GRANT SDS_SELECT TO DNS   SCHIEK;
GRANT SDS_SELECT TO DNS   SHEPPL;
GRANT SDS_SELECT TO DNS   SURVES;
GRANT SDS_SELECT TO DNS   ALLENM;
GRANT SDS_SELECT TO DNS   DOR;
GRANT SDS_SELECT TO DNS   FITZGR;
GRANT SDS_SELECT TO DNS   MIKHAA;
GRANT SDS_SELECT TO DNS   ARCHET;
GRANT SDS_SELECT TO DNS   ARNOLN;
GRANT SDS_SELECT TO DNS   HUANGC;
GRANT SDS_SELECT TO DNS   HOUGAD;
GRANT SDS_SELECT TO DNS   LINDSD;
GRANT SDS_SELECT TO DNS   ROLINL;
GRANT SDS_SELECT TO DNS   SHAHA;
GRANT SDS_SELECT TO DNS   SINGHM;
GRANT SDS_SELECT TO DNS   TUH;
GRANT SDS_SELECT TO DNS   WOODC;
GRANT SDS_SELECT TO DNS   CANINB;
GRANT SDS_SELECT TO DNS   CHEKMM;
GRANT SDS_SELECT TO DNS   CHINC;
GRANT SDS_SELECT TO DNS   KOGANI;
GRANT SDS_SELECT TO DNS   LOPEZD;
GRANT SDS_SELECT TO DNS   LOWRYB;
GRANT SDS_SELECT TO DNS   ROCHAD;
GRANT SDS_SELECT TO DNS   STALLP;
GRANT SDS_SELECT TO DNS   DHEERA;
GRANT SDS_SELECT TO       BATESL;
GRANT SDS_SELECT TO       BOHMEG;
GRANT SDS_SELECT TO       CHENY;
GRANT SDS_SELECT TO       EVERHS;
GRANT SDS_SELECT TO       HALLLI;
GRANT SDS_SELECT TO       HASANM;
GRANT SDS_SELECT TO       PRICEW;
GRANT SDS_SELECT TO       VENIGS;
GRANT SDS_SELECT TO DNS         ;
GRANT SDS_SELECT TO DNS   WILLIO;
GRANT SDS_SELECT TO DNS   REENT;
GRANT SDS_SELECT TO DNS   SAWEIM;
GRANT SDS_SELECT TO VIERSUSR;
GRANT SDS_SELECT TO VOA;
GRANT SDS_SELECT TO VOAUSR;
DROP ROLE PATS_READONLY;

CREATE ROLE PATS_READONLY NOT IDENTIFIED;

-- Object privileges granted to PATS_READONLY
GRANT SELECT ON PATS.BOILERPLATE_RESOLUTION_TEXT TO PATS_READONLY;
GRANT SELECT ON PATS.COMPS TO PATS_READONLY;
GRANT SELECT ON PATS.CONGRESSIONAL_CONTACT TO PATS_READONLY;
GRANT SELECT ON PATS.CONTACTING_ENTITY TO PATS_READONLY;
GRANT SELECT ON PATS.DMLOG TO PATS_READONLY;
GRANT SELECT ON PATS.FACILITY_SERVICE_OR_SECTION TO PATS_READONLY;
GRANT SELECT ON PATS.HOSPITAL_LOCATION TO PATS_READONLY;
GRANT SELECT ON PATS.ISSUE_CATEGORY TO PATS_READONLY;
GRANT SELECT ON PATS.ISSUE_CODE TO PATS_READONLY;
GRANT SELECT ON PATS.METHOD_OF_CONTACT TO PATS_READONLY;
GRANT SELECT ON PATS.NATIONAL_PATS_PARAMETERS TO PATS_READONLY;
GRANT SELECT ON PATS.NOTIFICATION_DETAIL TO PATS_READONLY;
GRANT SELECT ON PATS.NOTIFICATION_MASTER TO PATS_READONLY;
GRANT SELECT ON PATS.PATS_PATIENT TO PATS_READONLY;
GRANT SELECT ON PATS.PATS_PATIENT_RACE TO PATS_READONLY;
GRANT SELECT ON PATS.PATS_ROLLUP_NATL_DATA TO PATS_READONLY;
GRANT SELECT ON PATS.PATS_USER TO PATS_READONLY;
GRANT SELECT ON PATS.REPORT_OF_CONTACT TO PATS_READONLY;
GRANT SELECT ON PATS.ROC_CONTACTING_ENTITY TO PATS_READONLY;
GRANT SELECT ON PATS.ROC_ISSUE TO PATS_READONLY;
GRANT SELECT ON PATS.ROC_METHOD_OF_CONTACT TO PATS_READONLY;
GRANT SELECT ON PATS.ROC_PHONE_FAX TO PATS_READONLY;
GRANT SELECT ON PATS.TREATMENT_STATUS TO PATS_READONLY;
GRANT SELECT ON PATSRPTS.CONTACTING_ENTITY_VIEW TO PATS_READONLY;
GRANT SELECT ON PATSRPTS.ISSUE_CATEGORY_VIEW TO PATS_READONLY;
GRANT SELECT ON PATSRPTS.ISSUE_CODE_VIEW TO PATS_READONLY;
GRANT SELECT ON PATSRPTS.METHOD_OF_CONTACT_VIEW TO PATS_READONLY;
GRANT SELECT ON PATSRPTS.ROC_COMBO_DATA_VIEW TO PATS_READONLY;
GRANT SELECT ON PATSRPTS.ROC_CONTACTING_ENTITY_VIEW TO PATS_READONLY;
GRANT SELECT ON PATSRPTS.ROC_ISSUE_DATA_VIEW TO PATS_READONLY;
GRANT SELECT ON PATSRPTS.ROC_MAIN_DATA_VIEW TO PATS_READONLY;
GRANT SELECT ON PATSRPTS.ROC_METHOD_OF_CONTACT_VIEW TO PATS_READONLY;
GRANT SELECT ON PATSRPTS.ROC_NOTIFICATION_VIEW TO PATS_READONLY;
GRANT SELECT ON PATSRPTS.ROC_PHONE_DATA_VIEW TO PATS_READONLY;
GRANT SELECT ON PATSRPTS.TREATMENT_STATUS_VIEW TO PATS_READONLY;
GRANT SELECT ON PATSRPTS.USER_STATION_LIST_FOR_AD_HOC TO PATS_READONLY;

-- Grantees of PATS_READONLY
GRANT PATS_READONLY TO AACDBA WITH ADMIN OPTION;
DROP ROLE CSW_USR_ROLE;

CREATE ROLE CSW_USR_ROLE NOT IDENTIFIED;

-- Grantees of CSW_USR_ROLE
GRANT CSW_USR_ROLE TO AACDBA WITH ADMIN OPTION;
DROP ROLE TIER_KAAJEE_ROLE;

CREATE ROLE TIER_KAAJEE_ROLE NOT IDENTIFIED;

-- Object privileges granted to TIER_KAAJEE_ROLE
GRANT SELECT ON KAAJEE.GROUPMEMBERS TO TIER_KAAJEE_ROLE;
GRANT SELECT ON KAAJEE.PRINCIPALS TO TIER_KAAJEE_ROLE;

-- Grantees of TIER_KAAJEE_ROLE
GRANT TIER_KAAJEE_ROLE TO AACDBA WITH ADMIN OPTION;
DROP ROLE TIER_PATSRPTS_ROLE;

CREATE ROLE TIER_PATSRPTS_ROLE NOT IDENTIFIED;

-- Object privileges granted to TIER_PATSRPTS_ROLE
GRANT SELECT ON PATSRPTS.CONTACTING_ENTITY_VIEW TO TIER_PATSRPTS_ROLE;
GRANT SELECT ON PATSRPTS.ISSUE_CATEGORY_VIEW TO TIER_PATSRPTS_ROLE;
GRANT SELECT ON PATSRPTS.ISSUE_CODE_VIEW TO TIER_PATSRPTS_ROLE;
GRANT SELECT ON PATSRPTS.METHOD_OF_CONTACT_VIEW TO TIER_PATSRPTS_ROLE;
GRANT SELECT ON PATSRPTS.ROC_COMBO_DATA_VIEW TO TIER_PATSRPTS_ROLE;
GRANT SELECT ON PATSRPTS.ROC_CONTACTING_ENTITY_VIEW TO TIER_PATSRPTS_ROLE;
GRANT SELECT ON PATSRPTS.ROC_ISSUE_DATA_VIEW TO TIER_PATSRPTS_ROLE;
GRANT SELECT ON PATSRPTS.ROC_MAIN_DATA_VIEW TO TIER_PATSRPTS_ROLE;
GRANT SELECT ON PATSRPTS.ROC_METHOD_OF_CONTACT_VIEW TO TIER_PATSRPTS_ROLE;
GRANT SELECT ON PATSRPTS.ROC_NOTIFICATION_VIEW TO TIER_PATSRPTS_ROLE;
GRANT SELECT ON PATSRPTS.ROC_PHONE_DATA_VIEW TO TIER_PATSRPTS_ROLE;
GRANT SELECT ON PATSRPTS.TREATMENT_STATUS_VIEW TO TIER_PATSRPTS_ROLE;
GRANT SELECT ON PATSRPTS.USER_STATION_LIST_FOR_AD_HOC TO TIER_PATSRPTS_ROLE;

-- Grantees of TIER_PATSRPTS_ROLE
GRANT TIER_PATSRPTS_ROLE TO AACDBA WITH ADMIN OPTION;
DROP ROLE TIER_SDSADM_ROLE;

CREATE ROLE TIER_SDSADM_ROLE NOT IDENTIFIED;

-- Object privileges granted to TIER_SDSADM_ROLE
GRANT SELECT ON SDSADM.STD_ETHNICITY TO TIER_SDSADM_ROLE;

-- Grantees of TIER_SDSADM_ROLE
GRANT TIER_SDSADM_ROLE TO AACDBA WITH ADMIN OPTION;
GRANT TIER_SDSADM_ROLE TO PATSRPTS;
DROP ROLE TIER_VISTA_MIGRATE_ROLE;

CREATE ROLE TIER_VISTA_MIGRATE_ROLE NOT IDENTIFIED;

-- Grantees of TIER_VISTA_MIGRATE_ROLE
GRANT TIER_VISTA_MIGRATE_ROLE TO AACDBA WITH ADMIN OPTION;
DROP ROLE PATSUSER_ROLE;

CREATE ROLE PATSUSER_ROLE NOT IDENTIFIED;

-- Object privileges granted to PATSUSER_ROLE
GRANT EXECUTE ON PATS.PKG_BOILERPLATE_TEXT TO PATSUSER_ROLE;
GRANT EXECUTE ON PATS.PKG_COMP TO PATSUSER_ROLE;
GRANT EXECUTE ON PATS.PKG_CONGRESSIONAL_CONTACT TO PATSUSER_ROLE;
GRANT EXECUTE ON PATS.PKG_CONTACTING_ENTITY TO PATSUSER_ROLE;
GRANT EXECUTE ON PATS.PKG_EMPLOYEE TO PATSUSER_ROLE;
GRANT EXECUTE ON PATS.PKG_FACILITY_SERV_OR_SECT TO PATSUSER_ROLE;
GRANT EXECUTE ON PATS.PKG_HOSPITAL_LOCATION TO PATSUSER_ROLE;
GRANT EXECUTE ON PATS.PKG_ISSUE_CATEGORY TO PATSUSER_ROLE;
GRANT EXECUTE ON PATS.PKG_ISSUE_CODE TO PATSUSER_ROLE;
GRANT EXECUTE ON PATS.PKG_METHOD_OF_CONTACT TO PATSUSER_ROLE;
GRANT EXECUTE ON PATS.PKG_NATL_PATS_PARAMETERS TO PATSUSER_ROLE;
GRANT EXECUTE ON PATS.PKG_NOTIFICATION TO PATSUSER_ROLE;
GRANT EXECUTE ON PATS.PKG_PAD_LOCATION TO PATSUSER_ROLE;
GRANT EXECUTE ON PATS.PKG_PATS_PATIENT TO PATSUSER_ROLE;
GRANT EXECUTE ON PATS.PKG_PATS_USER TO PATSUSER_ROLE;
GRANT EXECUTE ON PATS.PKG_REPORT_OF_CONTACT TO PATSUSER_ROLE;
GRANT EXECUTE ON PATS.PKG_TREATMENT_STATUS TO PATSUSER_ROLE;
GRANT EXECUTE ON PATSRPTS.PKG_LIST TO PATSUSER_ROLE;
GRANT EXECUTE ON PATSRPTS.SET_AD_HOC_USER TO PATSUSER_ROLE;

-- Grantees of PATSUSER_ROLE
GRANT PATSUSER_ROLE TO AACDBA WITH ADMIN OPTION;
GRANT PATSUSER_ROLE TO PATSUSER;
DROP ROLE PATSHOST_ROLE;

CREATE ROLE PATSHOST_ROLE NOT IDENTIFIED;

-- Object privileges granted to PATSHOST_ROLE
GRANT DELETE, INSERT, SELECT, UPDATE ON PATS.DMLOG TO PATSHOST_ROLE;
GRANT EXECUTE ON PATS.ID_LIST TO PATSHOST_ROLE;
GRANT EXECUTE ON PATS.LONG_STRING_LIST TO PATSHOST_ROLE;
GRANT EXECUTE ON PATS.PKG_DELETE_LEGACY_DATA TO PATSHOST_ROLE;
GRANT EXECUTE ON PATS.PKG_LOAD_LEGACY_DATA TO PATSHOST_ROLE;
GRANT EXECUTE ON PATS.PKG_REPORT_OF_CONTACT TO PATSHOST_ROLE;
GRANT EXECUTE ON PATS.RETURN_STATION_LIST TO PATSHOST_ROLE;
GRANT EXECUTE ON PATS.STANDARD_NAME TO PATSHOST_ROLE;
GRANT EXECUTE ON PATS.STRING_LIST TO PATSHOST_ROLE;

-- Grantees of PATSHOST_ROLE
GRANT PATSHOST_ROLE TO AACDBA WITH ADMIN OPTION;
DROP ROLE TIER_PATS_ROLE;

CREATE ROLE TIER_PATS_ROLE NOT IDENTIFIED;

-- Object privileges granted to TIER_PATS_ROLE
GRANT SELECT ON PATS.BOILERPLATE_RESOLUTION_TEXT TO TIER_PATS_ROLE;
GRANT SELECT ON PATS.COMPS TO TIER_PATS_ROLE;
GRANT SELECT ON PATS.CONGRESSIONAL_CONTACT TO TIER_PATS_ROLE;
GRANT SELECT ON PATS.CONTACTING_ENTITY TO TIER_PATS_ROLE;
GRANT SELECT ON PATS.DMLOG TO TIER_PATS_ROLE;
GRANT SELECT ON PATS.FACILITY_SERVICE_OR_SECTION TO TIER_PATS_ROLE;
GRANT SELECT ON PATS.HOSPITAL_LOCATION TO TIER_PATS_ROLE;
GRANT SELECT ON PATS.ISSUE_CATEGORY TO TIER_PATS_ROLE;
GRANT SELECT ON PATS.ISSUE_CODE TO TIER_PATS_ROLE;
GRANT SELECT ON PATS.METHOD_OF_CONTACT TO TIER_PATS_ROLE;
GRANT SELECT ON PATS.NATIONAL_PATS_PARAMETERS TO TIER_PATS_ROLE;
GRANT SELECT ON PATS.NOTIFICATION_DETAIL TO TIER_PATS_ROLE;
GRANT SELECT ON PATS.NOTIFICATION_MASTER TO TIER_PATS_ROLE;
GRANT SELECT ON PATS.PATS_PATIENT TO TIER_PATS_ROLE;
GRANT SELECT ON PATS.PATS_PATIENT_RACE TO TIER_PATS_ROLE;
GRANT SELECT ON PATS.PATS_ROLLUP_NATL_DATA TO TIER_PATS_ROLE;
GRANT SELECT ON PATS.PATS_USER TO TIER_PATS_ROLE;
GRANT SELECT ON PATS.REPORT_OF_CONTACT TO TIER_PATS_ROLE;
GRANT SELECT ON PATS.ROC_CONTACTING_ENTITY TO TIER_PATS_ROLE;
GRANT SELECT ON PATS.ROC_ISSUE TO TIER_PATS_ROLE;
GRANT SELECT ON PATS.ROC_METHOD_OF_CONTACT TO TIER_PATS_ROLE;
GRANT SELECT ON PATS.ROC_PHONE_FAX TO TIER_PATS_ROLE;
GRANT SELECT ON PATS.TREATMENT_STATUS TO TIER_PATS_ROLE;
GRANT SELECT ON SDSADM.STD_ETHNICITY TO TIER_PATS_ROLE;

-- Grantees of TIER_PATS_ROLE
GRANT TIER_PATS_ROLE TO AACDBA WITH ADMIN OPTION;
DROP ROLE PATS_R;

CREATE ROLE PATS_R NOT IDENTIFIED;

-- Object privileges granted to PATS_R
GRANT SELECT ON PATS.BOILERPLATE_RESOLUTION_TEXT TO PATS_R;
GRANT SELECT ON PATS.COMPS TO PATS_R;
GRANT SELECT ON PATS.CONGRESSIONAL_CONTACT TO PATS_R;
GRANT SELECT ON PATS.CONTACTING_ENTITY TO PATS_R;
GRANT SELECT ON PATS.DMLOG TO PATS_R;
GRANT SELECT ON PATS.FACILITY_SERVICE_OR_SECTION TO PATS_R;
GRANT SELECT ON PATS.HOSPITAL_LOCATION TO PATS_R;
GRANT SELECT ON PATS.ISSUE_CATEGORY TO PATS_R;
GRANT SELECT ON PATS.ISSUE_CODE TO PATS_R;
GRANT SELECT ON PATS.METHOD_OF_CONTACT TO PATS_R;
GRANT SELECT ON PATS.NATIONAL_PATS_PARAMETERS TO PATS_R;
GRANT SELECT ON PATS.NOTIFICATION_DETAIL TO PATS_R;
GRANT SELECT ON PATS.NOTIFICATION_MASTER TO PATS_R;
GRANT SELECT ON PATS.PAD_LOCATION TO PATS_R;
GRANT SELECT ON PATS.PATS_PATIENT TO PATS_R;
GRANT SELECT ON PATS.PATS_PATIENT_RACE TO PATS_R;
GRANT SELECT ON PATS.PATS_ROLLUP_NATL_DATA TO PATS_R;
GRANT SELECT ON PATS.PATS_USER TO PATS_R;
GRANT SELECT ON PATS.REPORT_OF_CONTACT TO PATS_R;
GRANT SELECT ON PATS.ROC_CONTACTING_ENTITY TO PATS_R;
GRANT SELECT ON PATS.ROC_ISSUE TO PATS_R;
GRANT SELECT ON PATS.ROC_METHOD_OF_CONTACT TO PATS_R;
GRANT SELECT ON PATS.ROC_PHONE_FAX TO PATS_R;
GRANT SELECT ON PATS.TREATMENT_STATUS TO PATS_R;

-- Grantees of PATS_R
GRANT PATS_R TO AACDBA WITH ADMIN OPTION;
GRANT PATS_R TO DNS   CASTER;
GRANT PATS_R TO DNS   PARSOS;
GRANT PATS_R TO DNS   PENNYR;
GRANT PATS_R TO DNS   REYESJ;
GRANT PATS_R TO DNS   GROOMA;
GRANT PATS_R TO DNS   DOR;
GRANT PATS_R TO DNS   MIKHAA;
GRANT PATS_R TO DNS   HOUGAD;
GRANT PATS_R TO DNS   LINDSD;
GRANT PATS_R TO DNS   SINGHM;
GRANT PATS_R TO DNS   TUH;
GRANT PATS_R TO DNS   WOODC;
GRANT PATS_R TO DNS   CANINB;
GRANT PATS_R TO DNS   DHEERA;
GRANT PATS_R TO       EVERHS;
GRANT PATS_R TO       HALLLI;
DROP ROLE PATSRPTS_R;

CREATE ROLE PATSRPTS_R NOT IDENTIFIED;

-- Object privileges granted to PATSRPTS_R
GRANT SELECT ON PATSRPTS.CONTACTING_ENTITY_VIEW TO PATSRPTS_R;
GRANT SELECT ON PATSRPTS.ISSUE_CATEGORY_VIEW TO PATSRPTS_R;
GRANT SELECT ON PATSRPTS.ISSUE_CODE_VIEW TO PATSRPTS_R;
GRANT SELECT ON PATSRPTS.METHOD_OF_CONTACT_VIEW TO PATSRPTS_R;
GRANT SELECT ON PATSRPTS.ROC_COMBO_DATA_VIEW TO PATSRPTS_R;
GRANT SELECT ON PATSRPTS.ROC_CONTACTING_ENTITY_VIEW TO PATSRPTS_R;
GRANT SELECT ON PATSRPTS.ROC_ISSUE_DATA_VIEW TO PATSRPTS_R;
GRANT SELECT ON PATSRPTS.ROC_MAIN_DATA_VIEW TO PATSRPTS_R;
GRANT SELECT ON PATSRPTS.ROC_METHOD_OF_CONTACT_VIEW TO PATSRPTS_R;
GRANT SELECT ON PATSRPTS.ROC_NOTIFICATION_VIEW TO PATSRPTS_R;
GRANT SELECT ON PATSRPTS.ROC_PHONE_DATA_VIEW TO PATSRPTS_R;
GRANT SELECT ON PATSRPTS.TREATMENT_STATUS_VIEW TO PATSRPTS_R;
GRANT SELECT ON PATSRPTS.USER_STATION_LIST_FOR_AD_HOC TO PATSRPTS_R;

-- Grantees of PATSRPTS_R
GRANT PATSRPTS_R TO AACDBA WITH ADMIN OPTION;
GRANT PATSRPTS_R TO DNS   CASTER;
GRANT PATSRPTS_R TO DNS   PARSOS;
GRANT PATSRPTS_R TO DNS   PENNYR;
GRANT PATSRPTS_R TO DNS   REYESJ;
GRANT PATSRPTS_R TO DNS   DOR;
GRANT PATSRPTS_R TO DNS   MIKHAA;
GRANT PATSRPTS_R TO DNS   HOUGAD;
GRANT PATSRPTS_R TO DNS   LINDSD;
GRANT PATSRPTS_R TO DNS   SINGHM;
GRANT PATSRPTS_R TO DNS   TUH;
GRANT PATSRPTS_R TO DNS   WOODC;
GRANT PATSRPTS_R TO DNS   CANINB;
GRANT PATSRPTS_R TO DNS   DHEERA;
GRANT PATSRPTS_R TO       EVERHS;
GRANT PATSRPTS_R TO       HALLLI;
DROP ROLE PATS_RW;

CREATE ROLE PATS_RW NOT IDENTIFIED;

-- Object privileges granted to PATS_RW
GRANT DELETE, INSERT, SELECT, UPDATE ON PATS.BOILERPLATE_RESOLUTION_TEXT TO PATS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATS.COMPS TO PATS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATS.CONGRESSIONAL_CONTACT TO PATS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATS.CONTACTING_ENTITY TO PATS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATS.DMLOG TO PATS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATS.FACILITY_SERVICE_OR_SECTION TO PATS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATS.HOSPITAL_LOCATION TO PATS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATS.ISSUE_CATEGORY TO PATS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATS.ISSUE_CODE TO PATS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATS.METHOD_OF_CONTACT TO PATS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATS.NATIONAL_PATS_PARAMETERS TO PATS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATS.NOTIFICATION_DETAIL TO PATS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATS.NOTIFICATION_MASTER TO PATS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATS.PAD_LOCATION TO PATS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATS.PATS_PATIENT TO PATS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATS.PATS_PATIENT_RACE TO PATS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATS.PATS_ROLLUP_NATL_DATA TO PATS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATS.PATS_USER TO PATS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATS.REPORT_OF_CONTACT TO PATS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATS.ROC_CONTACTING_ENTITY TO PATS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATS.ROC_ISSUE TO PATS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATS.ROC_METHOD_OF_CONTACT TO PATS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATS.ROC_PHONE_FAX TO PATS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATS.TREATMENT_STATUS TO PATS_RW;

-- Grantees of PATS_RW
GRANT PATS_RW TO AACDBA WITH ADMIN OPTION;
DROP ROLE PATSRPTS_RW;

CREATE ROLE PATSRPTS_RW NOT IDENTIFIED;

-- Object privileges granted to PATSRPTS_RW
GRANT DELETE, INSERT, SELECT, UPDATE ON PATSRPTS.CONTACTING_ENTITY_VIEW TO PATSRPTS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATSRPTS.ISSUE_CATEGORY_VIEW TO PATSRPTS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATSRPTS.ISSUE_CODE_VIEW TO PATSRPTS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATSRPTS.METHOD_OF_CONTACT_VIEW TO PATSRPTS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATSRPTS.ROC_COMBO_DATA_VIEW TO PATSRPTS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATSRPTS.ROC_CONTACTING_ENTITY_VIEW TO PATSRPTS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATSRPTS.ROC_ISSUE_DATA_VIEW TO PATSRPTS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATSRPTS.ROC_MAIN_DATA_VIEW TO PATSRPTS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATSRPTS.ROC_METHOD_OF_CONTACT_VIEW TO PATSRPTS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATSRPTS.ROC_NOTIFICATION_VIEW TO PATSRPTS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATSRPTS.ROC_PHONE_DATA_VIEW TO PATSRPTS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATSRPTS.TREATMENT_STATUS_VIEW TO PATSRPTS_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON PATSRPTS.USER_STATION_LIST_FOR_AD_HOC TO PATSRPTS_RW;

-- Grantees of PATSRPTS_RW
GRANT PATSRPTS_RW TO AACDBA WITH ADMIN OPTION;
DROP ROLE PATS_ADMIN;

CREATE ROLE PATS_ADMIN NOT IDENTIFIED;

-- System privileges granted to PATS_ADMIN
GRANT ALTER SESSION TO PATS_ADMIN;
GRANT CREATE PROCEDURE TO PATS_ADMIN;
GRANT CREATE SEQUENCE TO PATS_ADMIN;
GRANT CREATE SESSION TO PATS_ADMIN;
GRANT CREATE SYNONYM TO PATS_ADMIN;
GRANT CREATE TABLE TO PATS_ADMIN;
GRANT CREATE TRIGGER TO PATS_ADMIN;
GRANT CREATE TYPE TO PATS_ADMIN;
GRANT CREATE VIEW TO PATS_ADMIN;

-- Roles granted to PATS_ADMIN
GRANT VA_SELECT_CATALOG_ROLE TO PATS_ADMIN;
GRANT RESOURCE TO PATS_ADMIN;

-- Grantees of PATS_ADMIN
GRANT PATS_ADMIN TO AACDBA WITH ADMIN OPTION;
GRANT PATS_ADMIN TO PATS;
GRANT PATS_ADMIN TO PATSRPTS;
DROP ROLE VSCCUSR_R;

CREATE ROLE VSCCUSR_R NOT IDENTIFIED;

-- Object privileges granted to VSCCUSR_R
GRANT SELECT ON PATS.PATS_ROLLUP_NATL_DATA TO VSCCUSR_R;
GRANT SELECT ON PATS.REPORT_OF_CONTACT TO VSCCUSR_R;

-- Grantees of VSCCUSR_R
GRANT VSCCUSR_R TO AACDBA WITH ADMIN OPTION;
DROP ROLE VETCHOICE_R;

CREATE ROLE VETCHOICE_R NOT IDENTIFIED;

-- Object privileges granted to VETCHOICE_R
GRANT SELECT ON VETCHOICE.AGGREGATE_H TO VETCHOICE_R;

-- Grantees of VETCHOICE_R
GRANT VETCHOICE_R TO AACDBA WITH ADMIN OPTION;
GRANT VETCHOICE_R TO ADR_R;
GRANT VETCHOICE_R TO EEUSR;
GRANT VETCHOICE_R TO DNS   ASAFOJ;
GRANT VETCHOICE_R TO DNS   GONZAS;
GRANT VETCHOICE_R TO DNS   HOUGAD;
DROP ROLE VETCHOICE_RW;

CREATE ROLE VETCHOICE_RW NOT IDENTIFIED;

-- Object privileges granted to VETCHOICE_RW
GRANT DELETE, INSERT, SELECT, UPDATE ON VETCHOICE.AGGREGATE_H TO VETCHOICE_RW;

-- Grantees of VETCHOICE_RW
GRANT VETCHOICE_RW TO AACDBA WITH ADMIN OPTION;
GRANT VETCHOICE_RW TO ADR_RW;
DROP ROLE VETCHOICE_ADMIN;

CREATE ROLE VETCHOICE_ADMIN NOT IDENTIFIED;

-- System privileges granted to VETCHOICE_ADMIN
GRANT ALTER SESSION TO VETCHOICE_ADMIN;
GRANT CREATE DATABASE LINK TO VETCHOICE_ADMIN;
GRANT CREATE MATERIALIZED VIEW TO VETCHOICE_ADMIN;
GRANT CREATE PROCEDURE TO VETCHOICE_ADMIN;
GRANT CREATE SEQUENCE TO VETCHOICE_ADMIN;
GRANT CREATE SESSION TO VETCHOICE_ADMIN;
GRANT CREATE SYNONYM TO VETCHOICE_ADMIN;
GRANT CREATE TABLE TO VETCHOICE_ADMIN;
GRANT CREATE TRIGGER TO VETCHOICE_ADMIN;
GRANT CREATE VIEW TO VETCHOICE_ADMIN;
GRANT QUERY REWRITE TO VETCHOICE_ADMIN;
GRANT SELECT ANY DICTIONARY TO VETCHOICE_ADMIN;

-- Grantees of VETCHOICE_ADMIN
GRANT VETCHOICE_ADMIN TO AACDBA WITH ADMIN OPTION;
GRANT VETCHOICE_ADMIN TO VETCHOICE;
DROP ROLE ES_R;

CREATE ROLE ES_R NOT IDENTIFIED;

-- Object privileges granted to ES_R
GRANT SELECT ON ADR.ACTIVATION TO ES_R;
GRANT SELECT ON ADR.ACTIVATION_H TO ES_R;
GRANT SELECT ON ADR.ADDRESS TO ES_R;
GRANT SELECT ON ADR.ADDRESS_H TO ES_R;
GRANT SELECT ON ADR.ADDR_CONFIDENTIAL_DTL TO ES_R;
GRANT SELECT ON ADR.ADDR_CONFIDENTIAL_DTL_H TO ES_R;
GRANT SELECT ON ADR.ADR_DB_VER TO ES_R;
GRANT SELECT ON ADR.APP_PARAMETER TO ES_R;
GRANT SELECT ON ADR.BATCH_REQUEST_FACILITY TO ES_R;
GRANT SELECT ON ADR.BATCH_REQUEST_FACILITY_H TO ES_R;
GRANT SELECT ON ADR.BATCH_REQUEST_PRIORITY_GROUP TO ES_R;
GRANT SELECT ON ADR.BATCH_REQUEST_PRIORITY_GROUP_H TO ES_R;
GRANT SELECT ON ADR.BENEFICIARY_MST TO ES_R;
GRANT SELECT ON ADR.BENEFICIARY_MST_H TO ES_R;
GRANT SELECT ON ADR.BENEFICIARY_NTR TO ES_R;
GRANT SELECT ON ADR.BENEFICIARY_NTR_H TO ES_R;
GRANT SELECT ON ADR.BENEFICIARY_SCI TO ES_R;
GRANT SELECT ON ADR.BENEFICIARY_SCI_H TO ES_R;
GRANT SELECT ON ADR.BENEFICIARY_TRAVEL TO ES_R;
GRANT SELECT ON ADR.BENEFICIARY_TRAVEL_H TO ES_R;
GRANT SELECT ON ADR.BENEFICIARY_VISIT_SUMMARY TO ES_R;
GRANT SELECT ON ADR.BENEFICIARY_VISIT_SUMMARY_H TO ES_R;
GRANT SELECT ON ADR.BROKER_SERVICE_ERROR TO ES_R;
GRANT SELECT ON ADR.BROKER_SERVICE_LOG TO ES_R;
GRANT SELECT ON ADR.BROKER_SERVICE_PAYLOAD TO ES_R;
GRANT SELECT ON ADR.CANCEL_DECLINE TO ES_R;
GRANT SELECT ON ADR.CANCEL_DECLINE_H TO ES_R;
GRANT SELECT ON ADR.CASSCERTIFIEDTYPE TO ES_R;
GRANT SELECT ON ADR.CATASTROPHIC_DISABILITY TO ES_R;
GRANT SELECT ON ADR.CATASTROPHIC_DISABILITY_H TO ES_R;
GRANT SELECT ON ADR.CAT_DSBLTY_CONDITION TO ES_R;
GRANT SELECT ON ADR.CAT_DSBLTY_CONDITION_H TO ES_R;
GRANT SELECT ON ADR.CAT_DSBLTY_DESCRIPTOR TO ES_R;
GRANT SELECT ON ADR.CAT_DSBLTY_DESCRIPTOR_H TO ES_R;
GRANT SELECT ON ADR.CAT_DSBLTY_DIAGNOSIS TO ES_R;
GRANT SELECT ON ADR.CAT_DSBLTY_DIAGNOSIS_H TO ES_R;
GRANT SELECT ON ADR.CAT_DSBLTY_PROCEDURE TO ES_R;
GRANT SELECT ON ADR.CAT_DSBLTY_PROCEDURE_H TO ES_R;
GRANT SELECT ON ADR.CL_VERIFICATION_METHOD TO ES_R;
GRANT SELECT ON ADR.CL_VERIFICATION_METHOD_H TO ES_R;
GRANT SELECT ON ADR.COMBAT_EPISODE TO ES_R;
GRANT SELECT ON ADR.COMBAT_EPISODE_H TO ES_R;
GRANT SELECT ON ADR.COMBAT_PAY TO ES_R;
GRANT SELECT ON ADR.COMBAT_PAY_H TO ES_R;
GRANT SELECT ON ADR.COM_AAC_ERROR_DETAIL TO ES_R;
GRANT SELECT ON ADR.COM_CANCELED_REQUEST TO ES_R;
GRANT SELECT ON ADR.COM_EMAIL_TEMPLATE TO ES_R;
GRANT SELECT ON ADR.COM_FORM_STATISTICS TO ES_R;
GRANT SELECT ON ADR.COM_HEC_REJECT_DETAIL TO ES_R;
GRANT SELECT ON ADR.COM_LETTER_TEMPLATE TO ES_R;
GRANT SELECT ON ADR.COM_MAILING TO ES_R;
GRANT SELECT ON ADR.COM_MAILING_STATUS_DETAIL TO ES_R;
GRANT SELECT ON ADR.COM_PRINT_CHECK TO ES_R;
GRANT SELECT ON ADR.COM_PRINT_REQUEST TO ES_R;
GRANT SELECT ON ADR.COM_TRANSMISSION_LOG TO ES_R;
GRANT SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY TO ES_R;
GRANT SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY_H TO ES_R;
GRANT SELECT ON ADR.CONFLICT_DETAIL TO ES_R;
GRANT SELECT ON ADR.CONFLICT_DETAIL_H TO ES_R;
GRANT SELECT ON ADR.CORRESPONDENCE TO ES_R;
GRANT SELECT ON ADR.CORRESPONDENCE_DOCUMENT TO ES_R;
GRANT SELECT ON ADR.CORRESPONDENCE_H TO ES_R;
GRANT SELECT ON ADR.CORRESPONDENCE_STATUS TO ES_R;
GRANT SELECT ON ADR.CORRESPONDENCE_TYPE TO ES_R;
GRANT SELECT ON ADR.DELIVERY_PREFERENCE TO ES_R;
GRANT SELECT ON ADR.DELIVERY_PREFERENCE_EMAIL TO ES_R;
GRANT SELECT ON ADR.DELIVERY_PREFERENCE_EMAIL_H TO ES_R;
GRANT SELECT ON ADR.DELIVERY_PREFERENCE_H TO ES_R;
GRANT SELECT ON ADR.DEPLOYMENT TO ES_R;
GRANT SELECT ON ADR.DEPLOYMENT_H TO ES_R;
GRANT SELECT ON ADR.EGT_SETTING TO ES_R;
GRANT SELECT ON ADR.EGT_SETTING_H TO ES_R;
GRANT SELECT ON ADR.EGT_SITE_STATISTICS TO ES_R;
GRANT SELECT ON ADR.EGT_SITE_STATISTICS_H TO ES_R;
GRANT SELECT ON ADR.EGT_STATISTICS TO ES_R;
GRANT SELECT ON ADR.EGT_STATISTICS_H TO ES_R;
GRANT SELECT ON ADR.ELIGIBILITY_DETERMINATION TO ES_R;
GRANT SELECT ON ADR.ELIGIBILITY_DETERMINATION_H TO ES_R;
GRANT SELECT ON ADR.ELIGIBILITY_STATUS_REASON TO ES_R;
GRANT SELECT ON ADR.ELIGIBILITY_VERIFICATION TO ES_R;
GRANT SELECT ON ADR.ELIGIBILITY_VERIFICATION_H TO ES_R;
GRANT SELECT ON ADR.EMAIL TO ES_R;
GRANT SELECT ON ADR.EMAIL_H TO ES_R;
GRANT SELECT ON ADR.EMERGENCY_RESPONSE TO ES_R;
GRANT SELECT ON ADR.EMERGENCY_RESPONSE_H TO ES_R;
GRANT SELECT ON ADR.EMPLOYMENT TO ES_R;
GRANT SELECT ON ADR.EMPLOYMENT_H TO ES_R;
GRANT SELECT ON ADR.ENROLLMENT_DETERMINATION TO ES_R;
GRANT SELECT ON ADR.ENROLLMENT_DETERMINATION_H TO ES_R;
GRANT SELECT ON ADR.ENROLLMENT_OVERRIDE TO ES_R;
GRANT SELECT ON ADR.ENROLLMENT_OVERRIDE_H TO ES_R;
GRANT SELECT ON ADR.FEE_BASIS TO ES_R;
GRANT SELECT ON ADR.FEE_BASIS_H TO ES_R;
GRANT SELECT ON ADR.FINANCIAL_ASSET_DETAIL TO ES_R;
GRANT SELECT ON ADR.FINANCIAL_ASSET_DETAIL_H TO ES_R;
GRANT SELECT ON ADR.FINANCIAL_DEBT_DETAIL TO ES_R;
GRANT SELECT ON ADR.FINANCIAL_DEBT_DETAIL_H TO ES_R;
GRANT SELECT ON ADR.FINANCIAL_EXPENSE_DETAIL TO ES_R;
GRANT SELECT ON ADR.FINANCIAL_EXPENSE_DETAIL_H TO ES_R;
GRANT SELECT ON ADR.FINANCIAL_INCOME_DETAIL TO ES_R;
GRANT SELECT ON ADR.FINANCIAL_INCOME_DETAIL_H TO ES_R;
GRANT SELECT ON ADR.FINANCIAL_STATEMENT TO ES_R;
GRANT SELECT ON ADR.FINANCIAL_STATEMENT_H TO ES_R;
GRANT SELECT ON ADR.GEOCODE_STAGE TO ES_R;
GRANT SELECT ON ADR.GEOCODE_STATION TO ES_R;
GRANT SELECT ON ADR.GEOCODE_TRANSMIT TO ES_R;
GRANT SELECT ON ADR.GEOCODE_TRANSMIT_ARCHIVE TO ES_R;
GRANT SELECT ON ADR.HANDBOOK_BATCH_REQUEST TO ES_R;
GRANT SELECT ON ADR.HANDBOOK_BATCH_REQUEST_H TO ES_R;
GRANT SELECT ON ADR.HANDBOOK_DOCUMENT TO ES_R;
GRANT SELECT ON ADR.HANDBOOK_MAIL_QUEUE TO ES_R;
GRANT SELECT ON ADR.HANDBOOK_MAIL_QUEUE_H TO ES_R;
GRANT SELECT ON ADR.HANDBOOK_MAIL_STATUS TO ES_R;
GRANT SELECT ON ADR.HANDBOOK_MAIL_STATUS_H TO ES_R;
GRANT SELECT ON ADR.HANDBOOK_REQUEST_VETERAN TO ES_R;
GRANT SELECT ON ADR.HANDBOOK_REQUEST_VETERAN_H TO ES_R;
GRANT SELECT ON ADR.HEALTH_BENEFITS_APPLICATION TO ES_R;
GRANT SELECT ON ADR.HEALTH_BENEFITS_APPLICATION_H TO ES_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN TO ES_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_DESC TO ES_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_DESC_H TO ES_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_DETAIL TO ES_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_DETAIL_H TO ES_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_H TO ES_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_NAME TO ES_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_NAME_H TO ES_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PROFILE TO ES_R;
GRANT SELECT ON ADR.HEALTH_BENEFIT_PROFILE_H TO ES_R;
GRANT SELECT ON ADR.HEALTH_CARE_PROVIDER TO ES_R;
GRANT SELECT ON ADR.HEALTH_CARE_PROVIDER_H TO ES_R;
GRANT SELECT ON ADR.HL7_ARCHIVE_TRANSACTION_LOG TO ES_R;
GRANT SELECT ON ADR.HL7_TRANSACTION_LOG TO ES_R;
GRANT SELECT ON ADR.HL7_TRANSACTION_LOG_SAVE TO ES_R;
GRANT SELECT ON ADR.INCOME_TEST TO ES_R;
GRANT SELECT ON ADR.INCOME_TEST_DETAIL TO ES_R;
GRANT SELECT ON ADR.INCOME_TEST_DETAIL_H TO ES_R;
GRANT SELECT ON ADR.INCOME_TEST_H TO ES_R;
GRANT SELECT ON ADR.INCOMPETENT_RULING TO ES_R;
GRANT SELECT ON ADR.INCOMPETENT_RULING_H TO ES_R;
GRANT SELECT ON ADR.INELIGIBLE_RULING TO ES_R;
GRANT SELECT ON ADR.INELIGIBLE_RULING_H TO ES_R;
GRANT SELECT ON ADR.INSURANCE TO ES_R;
GRANT SELECT ON ADR.INSURANCE_H TO ES_R;
GRANT SELECT ON ADR.IN_PROCESS_FINANCIALS TO ES_R;
GRANT SELECT ON ADR.IRS_TRANSMISSION_DATA TO ES_R;
GRANT SELECT ON ADR.IRS_TRANSMISSION_LOG TO ES_R;
GRANT SELECT ON ADR.IRS_TRANSMISSION_LOG_DETAIL TO ES_R;
GRANT SELECT ON ADR.IVM_MIGRATE TO ES_R;
GRANT SELECT ON ADR.IVM_MIGRATE_ARCHIVE TO ES_R;
GRANT SELECT ON ADR.IVM_MIGRATE_EXTRACT TO ES_R;
GRANT SELECT ON ADR.IVM_MIGRATE_EXTRACT_DETAIL TO ES_R;
GRANT SELECT ON ADR.IVM_MIGRATE_STATISTICS TO ES_R;
GRANT SELECT ON ADR.JOB_CONFIG TO ES_R;
GRANT SELECT ON ADR.JOB_RESULT TO ES_R;
GRANT SELECT ON ADR.MEC_PERIOD_LAST_HIST_NEW TO ES_R;
GRANT SELECT ON ADR.MEC_PERIOD_NEW TO ES_R;
GRANT SELECT ON ADR.MEDAL_OF_HONOR TO ES_R;
GRANT SELECT ON ADR.MEDAL_OF_HONOR_H TO ES_R;
GRANT SELECT ON ADR.MEDICAID_FACTOR TO ES_R;
GRANT SELECT ON ADR.MEDICAID_FACTOR_H TO ES_R;
GRANT SELECT ON ADR.MILITARY_SERVICE TO ES_R;
GRANT SELECT ON ADR.MILITARY_SERVICE_EPISODE TO ES_R;
GRANT SELECT ON ADR.MILITARY_SERVICE_EPISODE_H TO ES_R;
GRANT SELECT ON ADR.MILITARY_SERVICE_H TO ES_R;

-- Grantees of ES_R
GRANT ES_R TO AACDBA WITH ADMIN OPTION;
GRANT ES_R TO ADR WITH ADMIN OPTION;
GRANT ES_R TO ES_ADMIN;
GRANT ES_R TO ES_MAINT;
GRANT ES_R TO ES_OTHERS;
DROP ROLE KAAJEE_R;

CREATE ROLE KAAJEE_R NOT IDENTIFIED;

-- Object privileges granted to KAAJEE_R
GRANT SELECT ON KAAJEE.GROUPMEMBERS TO KAAJEE_R;
GRANT SELECT ON KAAJEE.PRINCIPALS TO KAAJEE_R;

-- Grantees of KAAJEE_R
GRANT KAAJEE_R TO AACDBA WITH ADMIN OPTION;
GRANT KAAJEE_R TO DNS   CASTER;
GRANT KAAJEE_R TO DNS   PARSOS;
GRANT KAAJEE_R TO DNS   PENNYR;
GRANT KAAJEE_R TO DNS   REYESJ;
GRANT KAAJEE_R TO DNS   MIKHAA;
GRANT KAAJEE_R TO DNS   HOUGAD;
GRANT KAAJEE_R TO DNS   SINGHM;
GRANT KAAJEE_R TO       EVERHS;
GRANT KAAJEE_R TO       HALLLI;
DROP ROLE KAAJEE_RW;

CREATE ROLE KAAJEE_RW NOT IDENTIFIED;

-- Object privileges granted to KAAJEE_RW
GRANT DELETE, INSERT, SELECT, UPDATE ON KAAJEE.GROUPMEMBERS TO KAAJEE_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON KAAJEE.PRINCIPALS TO KAAJEE_RW;

-- Grantees of KAAJEE_RW
GRANT KAAJEE_RW TO AACDBA WITH ADMIN OPTION;
DROP ROLE PATSROLLUP_R;

CREATE ROLE PATSROLLUP_R NOT IDENTIFIED;

-- Grantees of PATSROLLUP_R
GRANT PATSROLLUP_R TO AACDBA WITH ADMIN OPTION;
DROP ROLE PATSROLLUP_RW;

CREATE ROLE PATSROLLUP_RW NOT IDENTIFIED;

-- Grantees of PATSROLLUP_RW
GRANT PATSROLLUP_RW TO AACDBA WITH ADMIN OPTION;
DROP ROLE VANSOCSCAN_ROLE;

CREATE ROLE VANSOCSCAN_ROLE NOT IDENTIFIED;

-- Object privileges granted to VANSOCSCAN_ROLE
GRANT SELECT ON SYS.DBA_USERS TO VANSOCSCAN_ROLE;
GRANT SELECT ON SYS.PRODUCT_COMPONENT_VERSION TO VANSOCSCAN_ROLE;

-- System privileges granted to VANSOCSCAN_ROLE
GRANT CREATE SESSION TO VANSOCSCAN_ROLE;

-- Grantees of VANSOCSCAN_ROLE
GRANT VANSOCSCAN_ROLE TO AACDBA WITH ADMIN OPTION;
DROP ROLE CIS_SQA;

CREATE ROLE CIS_SQA NOT IDENTIFIED;

-- Roles granted to CIS_SQA
GRANT CIS_R TO CIS_SQA;

-- Grantees of CIS_SQA
GRANT CIS_SQA TO AACDBA WITH ADMIN OPTION;
DROP ROLE CIS_DEV;

CREATE ROLE CIS_DEV NOT IDENTIFIED;

-- Roles granted to CIS_DEV
GRANT CIS_R TO CIS_DEV;

-- Grantees of CIS_DEV
GRANT CIS_DEV TO AACDBA WITH ADMIN OPTION;
GRANT CIS_DEV TO DNS   GABRIA;
DROP ROLE CIS_MAINT;

CREATE ROLE CIS_MAINT NOT IDENTIFIED;

-- Roles granted to CIS_MAINT
GRANT CIS_R TO CIS_MAINT;

-- Grantees of CIS_MAINT
GRANT CIS_MAINT TO AACDBA WITH ADMIN OPTION;
DROP ROLE CIS_OTHERS;

CREATE ROLE CIS_OTHERS NOT IDENTIFIED;

-- Grantees of CIS_OTHERS
GRANT CIS_OTHERS TO AACDBA WITH ADMIN OPTION;
DROP ROLE ES_RW;

CREATE ROLE ES_RW NOT IDENTIFIED;

-- Object privileges granted to ES_RW
GRANT INSERT, SELECT ON ADR.ACTIVATION TO ES_RW;
GRANT INSERT, SELECT ON ADR.ACTIVATION_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.ADDRESS TO ES_RW;
GRANT INSERT, SELECT ON ADR.ADDRESS_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.ADDR_CONFIDENTIAL_DTL TO ES_RW;
GRANT INSERT, SELECT ON ADR.ADDR_CONFIDENTIAL_DTL_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.ADR_DB_VER TO ES_RW;
GRANT INSERT, SELECT ON ADR.APP_PARAMETER TO ES_RW;
GRANT INSERT, SELECT ON ADR.BATCH_REQUEST_FACILITY TO ES_RW;
GRANT INSERT, SELECT ON ADR.BATCH_REQUEST_FACILITY_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.BATCH_REQUEST_PRIORITY_GROUP TO ES_RW;
GRANT INSERT, SELECT ON ADR.BATCH_REQUEST_PRIORITY_GROUP_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.BENEFICIARY_MST TO ES_RW;
GRANT INSERT, SELECT ON ADR.BENEFICIARY_MST_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.BENEFICIARY_NTR TO ES_RW;
GRANT INSERT, SELECT ON ADR.BENEFICIARY_NTR_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.BENEFICIARY_SCI TO ES_RW;
GRANT INSERT, SELECT ON ADR.BENEFICIARY_SCI_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.BENEFICIARY_TRAVEL TO ES_RW;
GRANT INSERT, SELECT ON ADR.BENEFICIARY_TRAVEL_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.BENEFICIARY_VISIT_SUMMARY TO ES_RW;
GRANT INSERT, SELECT ON ADR.BENEFICIARY_VISIT_SUMMARY_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.BROKER_SERVICE_ERROR TO ES_RW;
GRANT INSERT, SELECT ON ADR.BROKER_SERVICE_LOG TO ES_RW;
GRANT INSERT, SELECT ON ADR.BROKER_SERVICE_PAYLOAD TO ES_RW;
GRANT INSERT, SELECT ON ADR.CANCEL_DECLINE TO ES_RW;
GRANT INSERT, SELECT ON ADR.CANCEL_DECLINE_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.CASSCERTIFIEDTYPE TO ES_RW;
GRANT INSERT, SELECT ON ADR.CATASTROPHIC_DISABILITY TO ES_RW;
GRANT INSERT, SELECT ON ADR.CATASTROPHIC_DISABILITY_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.CAT_DSBLTY_CONDITION TO ES_RW;
GRANT INSERT, SELECT ON ADR.CAT_DSBLTY_CONDITION_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.CAT_DSBLTY_DESCRIPTOR TO ES_RW;
GRANT INSERT, SELECT ON ADR.CAT_DSBLTY_DESCRIPTOR_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.CAT_DSBLTY_DIAGNOSIS TO ES_RW;
GRANT INSERT, SELECT ON ADR.CAT_DSBLTY_DIAGNOSIS_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.CAT_DSBLTY_PROCEDURE TO ES_RW;
GRANT INSERT, SELECT ON ADR.CAT_DSBLTY_PROCEDURE_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.CL_VERIFICATION_METHOD TO ES_RW;
GRANT INSERT, SELECT ON ADR.CL_VERIFICATION_METHOD_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.COMBAT_EPISODE TO ES_RW;
GRANT INSERT, SELECT ON ADR.COMBAT_EPISODE_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.COMBAT_PAY TO ES_RW;
GRANT INSERT, SELECT ON ADR.COMBAT_PAY_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.COM_AAC_ERROR_DETAIL TO ES_RW;
GRANT INSERT, SELECT ON ADR.COM_CANCELED_REQUEST TO ES_RW;
GRANT INSERT, SELECT ON ADR.COM_EMAIL_TEMPLATE TO ES_RW;
GRANT INSERT, SELECT ON ADR.COM_FORM_STATISTICS TO ES_RW;
GRANT INSERT, SELECT ON ADR.COM_HEC_REJECT_DETAIL TO ES_RW;
GRANT INSERT, SELECT ON ADR.COM_LETTER_TEMPLATE TO ES_RW;
GRANT INSERT, SELECT ON ADR.COM_MAILING TO ES_RW;
GRANT INSERT, SELECT ON ADR.COM_MAILING_STATUS_DETAIL TO ES_RW;
GRANT INSERT, SELECT ON ADR.COM_PRINT_CHECK TO ES_RW;
GRANT INSERT, SELECT ON ADR.COM_PRINT_REQUEST TO ES_RW;
GRANT INSERT, SELECT ON ADR.COM_TRANSMISSION_LOG TO ES_RW;
GRANT INSERT, SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY TO ES_RW;
GRANT INSERT, SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.CONFLICT_DETAIL TO ES_RW;
GRANT INSERT, SELECT ON ADR.CONFLICT_DETAIL_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.CORRESPONDENCE TO ES_RW;
GRANT INSERT, SELECT ON ADR.CORRESPONDENCE_DOCUMENT TO ES_RW;
GRANT INSERT, SELECT ON ADR.CORRESPONDENCE_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.CORRESPONDENCE_STATUS TO ES_RW;
GRANT INSERT, SELECT ON ADR.CORRESPONDENCE_TYPE TO ES_RW;
GRANT INSERT, SELECT ON ADR.DELIVERY_PREFERENCE TO ES_RW;
GRANT INSERT, SELECT ON ADR.DELIVERY_PREFERENCE_EMAIL TO ES_RW;
GRANT INSERT, SELECT ON ADR.DELIVERY_PREFERENCE_EMAIL_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.DELIVERY_PREFERENCE_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.DEPLOYMENT TO ES_RW;
GRANT INSERT, SELECT ON ADR.DEPLOYMENT_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.EGT_SETTING TO ES_RW;
GRANT INSERT, SELECT ON ADR.EGT_SETTING_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.EGT_SITE_STATISTICS TO ES_RW;
GRANT INSERT, SELECT ON ADR.EGT_SITE_STATISTICS_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.EGT_STATISTICS TO ES_RW;
GRANT INSERT, SELECT ON ADR.EGT_STATISTICS_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.ELIGIBILITY_DETERMINATION TO ES_RW;
GRANT INSERT, SELECT ON ADR.ELIGIBILITY_DETERMINATION_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.ELIGIBILITY_STATUS_REASON TO ES_RW;
GRANT INSERT, SELECT ON ADR.ELIGIBILITY_VERIFICATION TO ES_RW;
GRANT INSERT, SELECT ON ADR.ELIGIBILITY_VERIFICATION_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.EMAIL TO ES_RW;
GRANT INSERT, SELECT ON ADR.EMAIL_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.EMERGENCY_RESPONSE TO ES_RW;
GRANT INSERT, SELECT ON ADR.EMERGENCY_RESPONSE_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.EMPLOYMENT TO ES_RW;
GRANT INSERT, SELECT ON ADR.EMPLOYMENT_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.ENROLLMENT_DETERMINATION TO ES_RW;
GRANT INSERT, SELECT ON ADR.ENROLLMENT_DETERMINATION_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.ENROLLMENT_OVERRIDE TO ES_RW;
GRANT INSERT, SELECT ON ADR.ENROLLMENT_OVERRIDE_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.FEE_BASIS TO ES_RW;
GRANT INSERT, SELECT ON ADR.FEE_BASIS_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.FINANCIAL_ASSET_DETAIL TO ES_RW;
GRANT INSERT, SELECT ON ADR.FINANCIAL_ASSET_DETAIL_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.FINANCIAL_DEBT_DETAIL TO ES_RW;
GRANT INSERT, SELECT ON ADR.FINANCIAL_DEBT_DETAIL_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.FINANCIAL_EXPENSE_DETAIL TO ES_RW;
GRANT INSERT, SELECT ON ADR.FINANCIAL_EXPENSE_DETAIL_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.FINANCIAL_INCOME_DETAIL TO ES_RW;
GRANT INSERT, SELECT ON ADR.FINANCIAL_INCOME_DETAIL_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.FINANCIAL_STATEMENT TO ES_RW;
GRANT INSERT, SELECT ON ADR.FINANCIAL_STATEMENT_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.GEOCODE_STAGE TO ES_RW;
GRANT INSERT, SELECT ON ADR.GEOCODE_STATION TO ES_RW;
GRANT INSERT, SELECT ON ADR.GEOCODE_TRANSMIT TO ES_RW;
GRANT INSERT, SELECT ON ADR.GEOCODE_TRANSMIT_ARCHIVE TO ES_RW;
GRANT INSERT, SELECT ON ADR.HANDBOOK_BATCH_REQUEST TO ES_RW;
GRANT INSERT, SELECT ON ADR.HANDBOOK_BATCH_REQUEST_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.HANDBOOK_DOCUMENT TO ES_RW;
GRANT INSERT, SELECT ON ADR.HANDBOOK_MAIL_QUEUE TO ES_RW;
GRANT INSERT, SELECT ON ADR.HANDBOOK_MAIL_QUEUE_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.HANDBOOK_MAIL_STATUS TO ES_RW;
GRANT INSERT, SELECT ON ADR.HANDBOOK_MAIL_STATUS_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.HANDBOOK_REQUEST_VETERAN TO ES_RW;
GRANT INSERT, SELECT ON ADR.HANDBOOK_REQUEST_VETERAN_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.HEALTH_BENEFITS_APPLICATION TO ES_RW;
GRANT INSERT, SELECT ON ADR.HEALTH_BENEFITS_APPLICATION_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.HEALTH_BENEFIT_PLAN TO ES_RW;
GRANT INSERT, SELECT ON ADR.HEALTH_BENEFIT_PLAN_DESC TO ES_RW;
GRANT INSERT, SELECT ON ADR.HEALTH_BENEFIT_PLAN_DESC_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.HEALTH_BENEFIT_PLAN_DETAIL TO ES_RW;
GRANT INSERT, SELECT ON ADR.HEALTH_BENEFIT_PLAN_DETAIL_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.HEALTH_BENEFIT_PLAN_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.HEALTH_BENEFIT_PLAN_NAME TO ES_RW;
GRANT INSERT, SELECT ON ADR.HEALTH_BENEFIT_PLAN_NAME_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.HEALTH_BENEFIT_PROFILE TO ES_RW;
GRANT INSERT, SELECT ON ADR.HEALTH_BENEFIT_PROFILE_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.HEALTH_CARE_PROVIDER TO ES_RW;
GRANT INSERT, SELECT ON ADR.HEALTH_CARE_PROVIDER_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.HL7_ARCHIVE_TRANSACTION_LOG TO ES_RW;
GRANT INSERT, SELECT ON ADR.HL7_TRANSACTION_LOG TO ES_RW;
GRANT INSERT, SELECT ON ADR.HL7_TRANSACTION_LOG_SAVE TO ES_RW;
GRANT INSERT, SELECT ON ADR.INCOME_TEST TO ES_RW;
GRANT INSERT, SELECT ON ADR.INCOME_TEST_DETAIL TO ES_RW;
GRANT INSERT, SELECT ON ADR.INCOME_TEST_DETAIL_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.INCOME_TEST_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.INCOMPETENT_RULING TO ES_RW;
GRANT INSERT, SELECT ON ADR.INCOMPETENT_RULING_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.INELIGIBLE_RULING TO ES_RW;
GRANT INSERT, SELECT ON ADR.INELIGIBLE_RULING_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.INSURANCE TO ES_RW;
GRANT INSERT, SELECT ON ADR.INSURANCE_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.IN_PROCESS_FINANCIALS TO ES_RW;
GRANT INSERT, SELECT ON ADR.IRS_TRANSMISSION_DATA TO ES_RW;
GRANT INSERT, SELECT ON ADR.IRS_TRANSMISSION_LOG TO ES_RW;
GRANT INSERT, SELECT ON ADR.IRS_TRANSMISSION_LOG_DETAIL TO ES_RW;
GRANT INSERT, SELECT ON ADR.IVM_MIGRATE TO ES_RW;
GRANT INSERT, SELECT ON ADR.IVM_MIGRATE_ARCHIVE TO ES_RW;
GRANT INSERT, SELECT ON ADR.IVM_MIGRATE_EXTRACT TO ES_RW;
GRANT INSERT, SELECT ON ADR.IVM_MIGRATE_EXTRACT_DETAIL TO ES_RW;
GRANT INSERT, SELECT ON ADR.IVM_MIGRATE_STATISTICS TO ES_RW;
GRANT INSERT, SELECT ON ADR.JOB_CONFIG TO ES_RW;
GRANT INSERT, SELECT ON ADR.JOB_RESULT TO ES_RW;
GRANT INSERT, SELECT ON ADR.MEC_PERIOD_LAST_HIST_NEW TO ES_RW;
GRANT INSERT, SELECT ON ADR.MEC_PERIOD_NEW TO ES_RW;
GRANT INSERT, SELECT ON ADR.MEDAL_OF_HONOR TO ES_RW;
GRANT INSERT, SELECT ON ADR.MEDAL_OF_HONOR_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.MEDICAID_FACTOR TO ES_RW;
GRANT INSERT, SELECT ON ADR.MEDICAID_FACTOR_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.MILITARY_SERVICE TO ES_RW;
GRANT INSERT, SELECT ON ADR.MILITARY_SERVICE_EPISODE TO ES_RW;
GRANT INSERT, SELECT ON ADR.MILITARY_SERVICE_EPISODE_H TO ES_RW;
GRANT INSERT, SELECT ON ADR.MILITARY_SERVICE_H TO ES_RW;

-- Grantees of ES_RW
GRANT ES_RW TO AACDBA WITH ADMIN OPTION;
GRANT ES_RW TO ADR WITH ADMIN OPTION;
DROP ROLE ES_SQA;

CREATE ROLE ES_SQA NOT IDENTIFIED;

-- Grantees of ES_SQA
GRANT ES_SQA TO AACDBA WITH ADMIN OPTION;
GRANT ES_SQA TO ADR WITH ADMIN OPTION;
DROP ROLE ES_DEV;

CREATE ROLE ES_DEV NOT IDENTIFIED;

-- Grantees of ES_DEV
GRANT ES_DEV TO AACDBA WITH ADMIN OPTION;
GRANT ES_DEV TO ADR WITH ADMIN OPTION;
DROP ROLE ES_MAINT;

CREATE ROLE ES_MAINT NOT IDENTIFIED;

-- Roles granted to ES_MAINT
GRANT ES_R TO ES_MAINT;

-- Grantees of ES_MAINT
GRANT ES_MAINT TO AACDBA WITH ADMIN OPTION;
GRANT ES_MAINT TO ADR WITH ADMIN OPTION;
DROP ROLE ES_OTHERS;

CREATE ROLE ES_OTHERS NOT IDENTIFIED;

-- Roles granted to ES_OTHERS
GRANT ES_R TO ES_OTHERS;

-- Grantees of ES_OTHERS
GRANT ES_OTHERS TO AACDBA WITH ADMIN OPTION;
GRANT ES_OTHERS TO ADR WITH ADMIN OPTION;
DROP ROLE ES_ADMIN;

CREATE ROLE ES_ADMIN NOT IDENTIFIED;

-- Roles granted to ES_ADMIN
GRANT ES_R TO ES_ADMIN;

-- Grantees of ES_ADMIN
GRANT ES_ADMIN TO AACDBA WITH ADMIN OPTION;
GRANT ES_ADMIN TO ADR WITH ADMIN OPTION;
DROP ROLE ADRAAP_R;

CREATE ROLE ADRAAP_R NOT IDENTIFIED;

-- Object privileges granted to ADRAAP_R
GRANT SELECT ON ADRAAP.APPLICATION_IN_PROCESS TO ADRAAP_R;
GRANT SELECT ON ADRAAP.ENROLLMENT_APPLICATION TO ADRAAP_R;
GRANT SELECT ON ADRAAP.ENROLLMENT_APPLICATION_H TO ADRAAP_R;

-- Grantees of ADRAAP_R
GRANT ADRAAP_R TO AACDBA WITH ADMIN OPTION;
DROP ROLE ADRAAP_RW;

CREATE ROLE ADRAAP_RW NOT IDENTIFIED;

-- Object privileges granted to ADRAAP_RW
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRAAP.APPLICATION_IN_PROCESS TO ADRAAP_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRAAP.ENROLLMENT_APPLICATION TO ADRAAP_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADRAAP.ENROLLMENT_APPLICATION_H TO ADRAAP_RW;

-- Grantees of ADRAAP_RW
GRANT ADRAAP_RW TO AACDBA WITH ADMIN OPTION;
DROP ROLE VETCHOICEUSR_RW;

CREATE ROLE VETCHOICEUSR_RW NOT IDENTIFIED;

-- Object privileges granted to VETCHOICEUSR_RW
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ACTIVEAGG TO VETCHOICEUSR_RW;
GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ACTIVEAGG_TRACKER TO VETCHOICEUSR_RW;

-- Grantees of VETCHOICEUSR_RW
GRANT VETCHOICEUSR_RW TO AACDBA WITH ADMIN OPTION;
GRANT VETCHOICEUSR_RW TO VETCHOICEUSR;
DROP ROLE VETCHOICEUSR_R;

CREATE ROLE VETCHOICEUSR_R NOT IDENTIFIED;

-- Object privileges granted to VETCHOICEUSR_R
GRANT SELECT ON ADR.ACTIVEAGG TO VETCHOICEUSR_R;
GRANT SELECT ON ADR.ACTIVEAGG_TRACKER TO VETCHOICEUSR_R;

-- Grantees of VETCHOICEUSR_R
GRANT VETCHOICEUSR_R TO AACDBA WITH ADMIN OPTION;
